package software.amazon.awscdk.services.dms;

/**
 * A CloudFormation `AWS::DMS::Endpoint`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dms.*;
 * CfnEndpoint cfnEndpoint = CfnEndpoint.Builder.create(this, "MyCfnEndpoint")
 *         .endpointType("endpointType")
 *         .engineName("engineName")
 *         // the properties below are optional
 *         .certificateArn("certificateArn")
 *         .databaseName("databaseName")
 *         .docDbSettings(DocDbSettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .dynamoDbSettings(DynamoDbSettingsProperty.builder()
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .build())
 *         .elasticsearchSettings(ElasticsearchSettingsProperty.builder()
 *                 .endpointUri("endpointUri")
 *                 .errorRetryDuration(123)
 *                 .fullLoadErrorPercentage(123)
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .build())
 *         .endpointIdentifier("endpointIdentifier")
 *         .extraConnectionAttributes("extraConnectionAttributes")
 *         .ibmDb2Settings(IbmDb2SettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .kafkaSettings(KafkaSettingsProperty.builder()
 *                 .broker("broker")
 *                 .includeControlDetails(false)
 *                 .includeNullAndEmpty(false)
 *                 .includeTableAlterOperations(false)
 *                 .includeTransactionDetails(false)
 *                 .noHexPrefix(false)
 *                 .partitionIncludeSchemaTable(false)
 *                 .saslPassword("saslPassword")
 *                 .saslUserName("saslUserName")
 *                 .securityProtocol("securityProtocol")
 *                 .sslCaCertificateArn("sslCaCertificateArn")
 *                 .sslClientCertificateArn("sslClientCertificateArn")
 *                 .sslClientKeyArn("sslClientKeyArn")
 *                 .sslClientKeyPassword("sslClientKeyPassword")
 *                 .topic("topic")
 *                 .build())
 *         .kinesisSettings(KinesisSettingsProperty.builder()
 *                 .includeControlDetails(false)
 *                 .includeNullAndEmpty(false)
 *                 .includeTableAlterOperations(false)
 *                 .includeTransactionDetails(false)
 *                 .messageFormat("messageFormat")
 *                 .noHexPrefix(false)
 *                 .partitionIncludeSchemaTable(false)
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .streamArn("streamArn")
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .microsoftSqlServerSettings(MicrosoftSqlServerSettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .mongoDbSettings(MongoDbSettingsProperty.builder()
 *                 .authMechanism("authMechanism")
 *                 .authSource("authSource")
 *                 .authType("authType")
 *                 .databaseName("databaseName")
 *                 .docsToInvestigate("docsToInvestigate")
 *                 .extractDocId("extractDocId")
 *                 .nestingLevel("nestingLevel")
 *                 .password("password")
 *                 .port(123)
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .serverName("serverName")
 *                 .username("username")
 *                 .build())
 *         .mySqlSettings(MySqlSettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .neptuneSettings(NeptuneSettingsProperty.builder()
 *                 .errorRetryDuration(123)
 *                 .iamAuthEnabled(false)
 *                 .maxFileSize(123)
 *                 .maxRetryCount(123)
 *                 .s3BucketFolder("s3BucketFolder")
 *                 .s3BucketName("s3BucketName")
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .build())
 *         .oracleSettings(OracleSettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerOracleAsmAccessRoleArn("secretsManagerOracleAsmAccessRoleArn")
 *                 .secretsManagerOracleAsmSecretId("secretsManagerOracleAsmSecretId")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .password("password")
 *         .port(123)
 *         .postgreSqlSettings(PostgreSqlSettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .redisSettings(RedisSettingsProperty.builder()
 *                 .authPassword("authPassword")
 *                 .authType("authType")
 *                 .authUserName("authUserName")
 *                 .port(123)
 *                 .serverName("serverName")
 *                 .sslCaCertificateArn("sslCaCertificateArn")
 *                 .sslSecurityProtocol("sslSecurityProtocol")
 *                 .build())
 *         .redshiftSettings(RedshiftSettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .resourceIdentifier("resourceIdentifier")
 *         .s3Settings(S3SettingsProperty.builder()
 *                 .bucketFolder("bucketFolder")
 *                 .bucketName("bucketName")
 *                 .compressionType("compressionType")
 *                 .csvDelimiter("csvDelimiter")
 *                 .csvRowDelimiter("csvRowDelimiter")
 *                 .externalTableDefinition("externalTableDefinition")
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .build())
 *         .serverName("serverName")
 *         .sslMode("sslMode")
 *         .sybaseSettings(SybaseSettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .username("username")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.46.0 (build cd08c55)", date = "2021-11-23T14:40:37.976Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint")
public class CfnEndpoint extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dms.CfnEndpoint.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::DMS::Endpoint`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEndpoint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dms.CfnEndpointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrExternalId() {
        return software.amazon.jsii.Kernel.get(this, "attrExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DMS::Endpoint.CertificateArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
        return software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DMS::Endpoint.CertificateArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "certificateArn", value);
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::DMS::Endpoint.DatabaseName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DMS::Endpoint.DatabaseName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseName", value);
    }

    /**
     * `AWS::DMS::Endpoint.DocDbSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDocDbSettings() {
        return software.amazon.jsii.Kernel.get(this, "docDbSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.DocDbSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "docDbSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.DocDbSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.DocDbSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "docDbSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.DynamoDbSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbSettings() {
        return software.amazon.jsii.Kernel.get(this, "dynamoDbSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.DynamoDbSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDynamoDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dynamoDbSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.DynamoDbSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDynamoDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.DynamoDbSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "dynamoDbSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.ElasticsearchSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchSettings() {
        return software.amazon.jsii.Kernel.get(this, "elasticsearchSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.ElasticsearchSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticsearchSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "elasticsearchSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.ElasticsearchSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticsearchSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.ElasticsearchSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "elasticsearchSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.EndpointIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "endpointIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DMS::Endpoint.EndpointIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointIdentifier", value);
    }

    /**
     * `AWS::DMS::Endpoint.EndpointType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEndpointType() {
        return software.amazon.jsii.Kernel.get(this, "endpointType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DMS::Endpoint.EndpointType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointType", java.util.Objects.requireNonNull(value, "endpointType is required"));
    }

    /**
     * `AWS::DMS::Endpoint.EngineName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEngineName() {
        return software.amazon.jsii.Kernel.get(this, "engineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DMS::Endpoint.EngineName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineName", java.util.Objects.requireNonNull(value, "engineName is required"));
    }

    /**
     * `AWS::DMS::Endpoint.ExtraConnectionAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExtraConnectionAttributes() {
        return software.amazon.jsii.Kernel.get(this, "extraConnectionAttributes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DMS::Endpoint.ExtraConnectionAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExtraConnectionAttributes(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "extraConnectionAttributes", value);
    }

    /**
     * `AWS::DMS::Endpoint.IbmDb2Settings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIbmDb2Settings() {
        return software.amazon.jsii.Kernel.get(this, "ibmDb2Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.IbmDb2Settings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIbmDb2Settings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ibmDb2Settings", value);
    }

    /**
     * `AWS::DMS::Endpoint.IbmDb2Settings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIbmDb2Settings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.IbmDb2SettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "ibmDb2Settings", value);
    }

    /**
     * `AWS::DMS::Endpoint.KafkaSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKafkaSettings() {
        return software.amazon.jsii.Kernel.get(this, "kafkaSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.KafkaSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKafkaSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kafkaSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.KafkaSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKafkaSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.KafkaSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "kafkaSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.KinesisSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKinesisSettings() {
        return software.amazon.jsii.Kernel.get(this, "kinesisSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.KinesisSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kinesisSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.KinesisSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.KinesisSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "kinesisSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.KmsKeyId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DMS::Endpoint.KmsKeyId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * `AWS::DMS::Endpoint.MicrosoftSqlServerSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMicrosoftSqlServerSettings() {
        return software.amazon.jsii.Kernel.get(this, "microsoftSqlServerSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.MicrosoftSqlServerSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMicrosoftSqlServerSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "microsoftSqlServerSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.MicrosoftSqlServerSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMicrosoftSqlServerSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.MicrosoftSqlServerSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "microsoftSqlServerSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.MongoDbSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMongoDbSettings() {
        return software.amazon.jsii.Kernel.get(this, "mongoDbSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.MongoDbSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMongoDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mongoDbSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.MongoDbSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMongoDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.MongoDbSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "mongoDbSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.MySqlSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMySqlSettings() {
        return software.amazon.jsii.Kernel.get(this, "mySqlSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.MySqlSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMySqlSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mySqlSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.MySqlSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMySqlSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.MySqlSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "mySqlSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.NeptuneSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNeptuneSettings() {
        return software.amazon.jsii.Kernel.get(this, "neptuneSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.NeptuneSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNeptuneSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "neptuneSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.NeptuneSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNeptuneSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.NeptuneSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "neptuneSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.OracleSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOracleSettings() {
        return software.amazon.jsii.Kernel.get(this, "oracleSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.OracleSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOracleSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "oracleSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.OracleSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOracleSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.OracleSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "oracleSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.Password`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
        return software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DMS::Endpoint.Password`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPassword(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "password", value);
    }

    /**
     * `AWS::DMS::Endpoint.Port`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::DMS::Endpoint.Port`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "port", value);
    }

    /**
     * `AWS::DMS::Endpoint.PostgreSqlSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPostgreSqlSettings() {
        return software.amazon.jsii.Kernel.get(this, "postgreSqlSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.PostgreSqlSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPostgreSqlSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "postgreSqlSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.PostgreSqlSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPostgreSqlSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.PostgreSqlSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "postgreSqlSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.RedisSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRedisSettings() {
        return software.amazon.jsii.Kernel.get(this, "redisSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.RedisSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedisSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "redisSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.RedisSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedisSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.RedisSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "redisSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.RedshiftSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftSettings() {
        return software.amazon.jsii.Kernel.get(this, "redshiftSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.RedshiftSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedshiftSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "redshiftSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.RedshiftSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedshiftSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.RedshiftSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "redshiftSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.ResourceIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResourceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "resourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DMS::Endpoint.ResourceIdentifier`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceIdentifier", value);
    }

    /**
     * `AWS::DMS::Endpoint.S3Settings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getS3Settings() {
        return software.amazon.jsii.Kernel.get(this, "s3Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.S3Settings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3Settings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "s3Settings", value);
    }

    /**
     * `AWS::DMS::Endpoint.S3Settings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3Settings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.S3SettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "s3Settings", value);
    }

    /**
     * `AWS::DMS::Endpoint.ServerName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServerName() {
        return software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DMS::Endpoint.ServerName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serverName", value);
    }

    /**
     * `AWS::DMS::Endpoint.SslMode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSslMode() {
        return software.amazon.jsii.Kernel.get(this, "sslMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DMS::Endpoint.SslMode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSslMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sslMode", value);
    }

    /**
     * `AWS::DMS::Endpoint.SybaseSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSybaseSettings() {
        return software.amazon.jsii.Kernel.get(this, "sybaseSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.SybaseSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSybaseSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sybaseSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.SybaseSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSybaseSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.SybaseSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "sybaseSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * `AWS::DMS::Endpoint.Username`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
        return software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DMS::Endpoint.Username`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUsername(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "username", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * DocDbSettingsProperty docDbSettingsProperty = DocDbSettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint.DocDbSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DocDbSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocDbSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpoint.DocDbSettingsProperty.SecretsManagerAccessRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * `CfnEndpoint.DocDbSettingsProperty.SecretsManagerSecretId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocDbSettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link DocDbSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn `CfnEndpoint.DocDbSettingsProperty.SecretsManagerAccessRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link DocDbSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId `CfnEndpoint.DocDbSettingsProperty.SecretsManagerSecretId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocDbSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocDbSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocDbSettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-dms.CfnEndpoint.DocDbSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocDbSettingsProperty.Jsii$Proxy that = (DocDbSettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * DynamoDbSettingsProperty dynamoDbSettingsProperty = DynamoDbSettingsProperty.builder()
     *         .serviceAccessRoleArn("serviceAccessRoleArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint.DynamoDbSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DynamoDbSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamoDbSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpoint.DynamoDbSettingsProperty.ServiceAccessRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamoDbSettingsProperty> {
            java.lang.String serviceAccessRoleArn;

            /**
             * Sets the value of {@link DynamoDbSettingsProperty#getServiceAccessRoleArn}
             * @param serviceAccessRoleArn `CfnEndpoint.DynamoDbSettingsProperty.ServiceAccessRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDbSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamoDbSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDbSettingsProperty {
            private final java.lang.String serviceAccessRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
            }

            @Override
            public final java.lang.String getServiceAccessRoleArn() {
                return this.serviceAccessRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getServiceAccessRoleArn() != null) {
                    data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-dms.CfnEndpoint.DynamoDbSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamoDbSettingsProperty.Jsii$Proxy that = (DynamoDbSettingsProperty.Jsii$Proxy) o;

                return this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.equals(that.serviceAccessRoleArn) : that.serviceAccessRoleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * ElasticsearchSettingsProperty elasticsearchSettingsProperty = ElasticsearchSettingsProperty.builder()
     *         .endpointUri("endpointUri")
     *         .errorRetryDuration(123)
     *         .fullLoadErrorPercentage(123)
     *         .serviceAccessRoleArn("serviceAccessRoleArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint.ElasticsearchSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticsearchSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticsearchSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpoint.ElasticsearchSettingsProperty.EndpointUri`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndpointUri() {
            return null;
        }

        /**
         * `CfnEndpoint.ElasticsearchSettingsProperty.ErrorRetryDuration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getErrorRetryDuration() {
            return null;
        }

        /**
         * `CfnEndpoint.ElasticsearchSettingsProperty.FullLoadErrorPercentage`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFullLoadErrorPercentage() {
            return null;
        }

        /**
         * `CfnEndpoint.ElasticsearchSettingsProperty.ServiceAccessRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElasticsearchSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticsearchSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticsearchSettingsProperty> {
            java.lang.String endpointUri;
            java.lang.Number errorRetryDuration;
            java.lang.Number fullLoadErrorPercentage;
            java.lang.String serviceAccessRoleArn;

            /**
             * Sets the value of {@link ElasticsearchSettingsProperty#getEndpointUri}
             * @param endpointUri `CfnEndpoint.ElasticsearchSettingsProperty.EndpointUri`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointUri(java.lang.String endpointUri) {
                this.endpointUri = endpointUri;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchSettingsProperty#getErrorRetryDuration}
             * @param errorRetryDuration `CfnEndpoint.ElasticsearchSettingsProperty.ErrorRetryDuration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorRetryDuration(java.lang.Number errorRetryDuration) {
                this.errorRetryDuration = errorRetryDuration;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchSettingsProperty#getFullLoadErrorPercentage}
             * @param fullLoadErrorPercentage `CfnEndpoint.ElasticsearchSettingsProperty.FullLoadErrorPercentage`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fullLoadErrorPercentage(java.lang.Number fullLoadErrorPercentage) {
                this.fullLoadErrorPercentage = fullLoadErrorPercentage;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchSettingsProperty#getServiceAccessRoleArn}
             * @param serviceAccessRoleArn `CfnEndpoint.ElasticsearchSettingsProperty.ServiceAccessRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticsearchSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticsearchSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticsearchSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticsearchSettingsProperty {
            private final java.lang.String endpointUri;
            private final java.lang.Number errorRetryDuration;
            private final java.lang.Number fullLoadErrorPercentage;
            private final java.lang.String serviceAccessRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpointUri = software.amazon.jsii.Kernel.get(this, "endpointUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorRetryDuration = software.amazon.jsii.Kernel.get(this, "errorRetryDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fullLoadErrorPercentage = software.amazon.jsii.Kernel.get(this, "fullLoadErrorPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpointUri = builder.endpointUri;
                this.errorRetryDuration = builder.errorRetryDuration;
                this.fullLoadErrorPercentage = builder.fullLoadErrorPercentage;
                this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
            }

            @Override
            public final java.lang.String getEndpointUri() {
                return this.endpointUri;
            }

            @Override
            public final java.lang.Number getErrorRetryDuration() {
                return this.errorRetryDuration;
            }

            @Override
            public final java.lang.Number getFullLoadErrorPercentage() {
                return this.fullLoadErrorPercentage;
            }

            @Override
            public final java.lang.String getServiceAccessRoleArn() {
                return this.serviceAccessRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEndpointUri() != null) {
                    data.set("endpointUri", om.valueToTree(this.getEndpointUri()));
                }
                if (this.getErrorRetryDuration() != null) {
                    data.set("errorRetryDuration", om.valueToTree(this.getErrorRetryDuration()));
                }
                if (this.getFullLoadErrorPercentage() != null) {
                    data.set("fullLoadErrorPercentage", om.valueToTree(this.getFullLoadErrorPercentage()));
                }
                if (this.getServiceAccessRoleArn() != null) {
                    data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-dms.CfnEndpoint.ElasticsearchSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticsearchSettingsProperty.Jsii$Proxy that = (ElasticsearchSettingsProperty.Jsii$Proxy) o;

                if (this.endpointUri != null ? !this.endpointUri.equals(that.endpointUri) : that.endpointUri != null) return false;
                if (this.errorRetryDuration != null ? !this.errorRetryDuration.equals(that.errorRetryDuration) : that.errorRetryDuration != null) return false;
                if (this.fullLoadErrorPercentage != null ? !this.fullLoadErrorPercentage.equals(that.fullLoadErrorPercentage) : that.fullLoadErrorPercentage != null) return false;
                return this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.equals(that.serviceAccessRoleArn) : that.serviceAccessRoleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endpointUri != null ? this.endpointUri.hashCode() : 0;
                result = 31 * result + (this.errorRetryDuration != null ? this.errorRetryDuration.hashCode() : 0);
                result = 31 * result + (this.fullLoadErrorPercentage != null ? this.fullLoadErrorPercentage.hashCode() : 0);
                result = 31 * result + (this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * IbmDb2SettingsProperty ibmDb2SettingsProperty = IbmDb2SettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint.IbmDb2SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(IbmDb2SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IbmDb2SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpoint.IbmDb2SettingsProperty.SecretsManagerAccessRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * `CfnEndpoint.IbmDb2SettingsProperty.SecretsManagerSecretId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IbmDb2SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IbmDb2SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IbmDb2SettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link IbmDb2SettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn `CfnEndpoint.IbmDb2SettingsProperty.SecretsManagerAccessRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link IbmDb2SettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId `CfnEndpoint.IbmDb2SettingsProperty.SecretsManagerSecretId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IbmDb2SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IbmDb2SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IbmDb2SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IbmDb2SettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-dms.CfnEndpoint.IbmDb2SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IbmDb2SettingsProperty.Jsii$Proxy that = (IbmDb2SettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * KafkaSettingsProperty kafkaSettingsProperty = KafkaSettingsProperty.builder()
     *         .broker("broker")
     *         .includeControlDetails(false)
     *         .includeNullAndEmpty(false)
     *         .includeTableAlterOperations(false)
     *         .includeTransactionDetails(false)
     *         .noHexPrefix(false)
     *         .partitionIncludeSchemaTable(false)
     *         .saslPassword("saslPassword")
     *         .saslUserName("saslUserName")
     *         .securityProtocol("securityProtocol")
     *         .sslCaCertificateArn("sslCaCertificateArn")
     *         .sslClientCertificateArn("sslClientCertificateArn")
     *         .sslClientKeyArn("sslClientKeyArn")
     *         .sslClientKeyPassword("sslClientKeyPassword")
     *         .topic("topic")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint.KafkaSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(KafkaSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KafkaSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpoint.KafkaSettingsProperty.Broker`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBroker() {
            return null;
        }

        /**
         * `CfnEndpoint.KafkaSettingsProperty.IncludeControlDetails`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeControlDetails() {
            return null;
        }

        /**
         * `CfnEndpoint.KafkaSettingsProperty.IncludeNullAndEmpty`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeNullAndEmpty() {
            return null;
        }

        /**
         * `CfnEndpoint.KafkaSettingsProperty.IncludeTableAlterOperations`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeTableAlterOperations() {
            return null;
        }

        /**
         * `CfnEndpoint.KafkaSettingsProperty.IncludeTransactionDetails`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeTransactionDetails() {
            return null;
        }

        /**
         * `CfnEndpoint.KafkaSettingsProperty.NoHexPrefix`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoHexPrefix() {
            return null;
        }

        /**
         * `CfnEndpoint.KafkaSettingsProperty.PartitionIncludeSchemaTable`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPartitionIncludeSchemaTable() {
            return null;
        }

        /**
         * `CfnEndpoint.KafkaSettingsProperty.SaslPassword`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSaslPassword() {
            return null;
        }

        /**
         * `CfnEndpoint.KafkaSettingsProperty.SaslUserName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSaslUserName() {
            return null;
        }

        /**
         * `CfnEndpoint.KafkaSettingsProperty.SecurityProtocol`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecurityProtocol() {
            return null;
        }

        /**
         * `CfnEndpoint.KafkaSettingsProperty.SslCaCertificateArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslCaCertificateArn() {
            return null;
        }

        /**
         * `CfnEndpoint.KafkaSettingsProperty.SslClientCertificateArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslClientCertificateArn() {
            return null;
        }

        /**
         * `CfnEndpoint.KafkaSettingsProperty.SslClientKeyArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslClientKeyArn() {
            return null;
        }

        /**
         * `CfnEndpoint.KafkaSettingsProperty.SslClientKeyPassword`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslClientKeyPassword() {
            return null;
        }

        /**
         * `CfnEndpoint.KafkaSettingsProperty.Topic`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTopic() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KafkaSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KafkaSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KafkaSettingsProperty> {
            java.lang.String broker;
            java.lang.Object includeControlDetails;
            java.lang.Object includeNullAndEmpty;
            java.lang.Object includeTableAlterOperations;
            java.lang.Object includeTransactionDetails;
            java.lang.Object noHexPrefix;
            java.lang.Object partitionIncludeSchemaTable;
            java.lang.String saslPassword;
            java.lang.String saslUserName;
            java.lang.String securityProtocol;
            java.lang.String sslCaCertificateArn;
            java.lang.String sslClientCertificateArn;
            java.lang.String sslClientKeyArn;
            java.lang.String sslClientKeyPassword;
            java.lang.String topic;

            /**
             * Sets the value of {@link KafkaSettingsProperty#getBroker}
             * @param broker `CfnEndpoint.KafkaSettingsProperty.Broker`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder broker(java.lang.String broker) {
                this.broker = broker;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeControlDetails}
             * @param includeControlDetails `CfnEndpoint.KafkaSettingsProperty.IncludeControlDetails`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeControlDetails(java.lang.Boolean includeControlDetails) {
                this.includeControlDetails = includeControlDetails;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeControlDetails}
             * @param includeControlDetails `CfnEndpoint.KafkaSettingsProperty.IncludeControlDetails`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeControlDetails(software.amazon.awscdk.core.IResolvable includeControlDetails) {
                this.includeControlDetails = includeControlDetails;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeNullAndEmpty}
             * @param includeNullAndEmpty `CfnEndpoint.KafkaSettingsProperty.IncludeNullAndEmpty`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeNullAndEmpty(java.lang.Boolean includeNullAndEmpty) {
                this.includeNullAndEmpty = includeNullAndEmpty;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeNullAndEmpty}
             * @param includeNullAndEmpty `CfnEndpoint.KafkaSettingsProperty.IncludeNullAndEmpty`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeNullAndEmpty(software.amazon.awscdk.core.IResolvable includeNullAndEmpty) {
                this.includeNullAndEmpty = includeNullAndEmpty;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeTableAlterOperations}
             * @param includeTableAlterOperations `CfnEndpoint.KafkaSettingsProperty.IncludeTableAlterOperations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTableAlterOperations(java.lang.Boolean includeTableAlterOperations) {
                this.includeTableAlterOperations = includeTableAlterOperations;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeTableAlterOperations}
             * @param includeTableAlterOperations `CfnEndpoint.KafkaSettingsProperty.IncludeTableAlterOperations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTableAlterOperations(software.amazon.awscdk.core.IResolvable includeTableAlterOperations) {
                this.includeTableAlterOperations = includeTableAlterOperations;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeTransactionDetails}
             * @param includeTransactionDetails `CfnEndpoint.KafkaSettingsProperty.IncludeTransactionDetails`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTransactionDetails(java.lang.Boolean includeTransactionDetails) {
                this.includeTransactionDetails = includeTransactionDetails;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeTransactionDetails}
             * @param includeTransactionDetails `CfnEndpoint.KafkaSettingsProperty.IncludeTransactionDetails`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTransactionDetails(software.amazon.awscdk.core.IResolvable includeTransactionDetails) {
                this.includeTransactionDetails = includeTransactionDetails;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getNoHexPrefix}
             * @param noHexPrefix `CfnEndpoint.KafkaSettingsProperty.NoHexPrefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noHexPrefix(java.lang.Boolean noHexPrefix) {
                this.noHexPrefix = noHexPrefix;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getNoHexPrefix}
             * @param noHexPrefix `CfnEndpoint.KafkaSettingsProperty.NoHexPrefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noHexPrefix(software.amazon.awscdk.core.IResolvable noHexPrefix) {
                this.noHexPrefix = noHexPrefix;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getPartitionIncludeSchemaTable}
             * @param partitionIncludeSchemaTable `CfnEndpoint.KafkaSettingsProperty.PartitionIncludeSchemaTable`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionIncludeSchemaTable(java.lang.Boolean partitionIncludeSchemaTable) {
                this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getPartitionIncludeSchemaTable}
             * @param partitionIncludeSchemaTable `CfnEndpoint.KafkaSettingsProperty.PartitionIncludeSchemaTable`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionIncludeSchemaTable(software.amazon.awscdk.core.IResolvable partitionIncludeSchemaTable) {
                this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSaslPassword}
             * @param saslPassword `CfnEndpoint.KafkaSettingsProperty.SaslPassword`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder saslPassword(java.lang.String saslPassword) {
                this.saslPassword = saslPassword;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSaslUserName}
             * @param saslUserName `CfnEndpoint.KafkaSettingsProperty.SaslUserName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder saslUserName(java.lang.String saslUserName) {
                this.saslUserName = saslUserName;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSecurityProtocol}
             * @param securityProtocol `CfnEndpoint.KafkaSettingsProperty.SecurityProtocol`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityProtocol(java.lang.String securityProtocol) {
                this.securityProtocol = securityProtocol;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSslCaCertificateArn}
             * @param sslCaCertificateArn `CfnEndpoint.KafkaSettingsProperty.SslCaCertificateArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslCaCertificateArn(java.lang.String sslCaCertificateArn) {
                this.sslCaCertificateArn = sslCaCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSslClientCertificateArn}
             * @param sslClientCertificateArn `CfnEndpoint.KafkaSettingsProperty.SslClientCertificateArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslClientCertificateArn(java.lang.String sslClientCertificateArn) {
                this.sslClientCertificateArn = sslClientCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSslClientKeyArn}
             * @param sslClientKeyArn `CfnEndpoint.KafkaSettingsProperty.SslClientKeyArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslClientKeyArn(java.lang.String sslClientKeyArn) {
                this.sslClientKeyArn = sslClientKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSslClientKeyPassword}
             * @param sslClientKeyPassword `CfnEndpoint.KafkaSettingsProperty.SslClientKeyPassword`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslClientKeyPassword(java.lang.String sslClientKeyPassword) {
                this.sslClientKeyPassword = sslClientKeyPassword;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getTopic}
             * @param topic `CfnEndpoint.KafkaSettingsProperty.Topic`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topic(java.lang.String topic) {
                this.topic = topic;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KafkaSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KafkaSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KafkaSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KafkaSettingsProperty {
            private final java.lang.String broker;
            private final java.lang.Object includeControlDetails;
            private final java.lang.Object includeNullAndEmpty;
            private final java.lang.Object includeTableAlterOperations;
            private final java.lang.Object includeTransactionDetails;
            private final java.lang.Object noHexPrefix;
            private final java.lang.Object partitionIncludeSchemaTable;
            private final java.lang.String saslPassword;
            private final java.lang.String saslUserName;
            private final java.lang.String securityProtocol;
            private final java.lang.String sslCaCertificateArn;
            private final java.lang.String sslClientCertificateArn;
            private final java.lang.String sslClientKeyArn;
            private final java.lang.String sslClientKeyPassword;
            private final java.lang.String topic;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.broker = software.amazon.jsii.Kernel.get(this, "broker", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeControlDetails = software.amazon.jsii.Kernel.get(this, "includeControlDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeNullAndEmpty = software.amazon.jsii.Kernel.get(this, "includeNullAndEmpty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeTableAlterOperations = software.amazon.jsii.Kernel.get(this, "includeTableAlterOperations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeTransactionDetails = software.amazon.jsii.Kernel.get(this, "includeTransactionDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noHexPrefix = software.amazon.jsii.Kernel.get(this, "noHexPrefix", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.partitionIncludeSchemaTable = software.amazon.jsii.Kernel.get(this, "partitionIncludeSchemaTable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.saslPassword = software.amazon.jsii.Kernel.get(this, "saslPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.saslUserName = software.amazon.jsii.Kernel.get(this, "saslUserName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityProtocol = software.amazon.jsii.Kernel.get(this, "securityProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslCaCertificateArn = software.amazon.jsii.Kernel.get(this, "sslCaCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslClientCertificateArn = software.amazon.jsii.Kernel.get(this, "sslClientCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslClientKeyArn = software.amazon.jsii.Kernel.get(this, "sslClientKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslClientKeyPassword = software.amazon.jsii.Kernel.get(this, "sslClientKeyPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.broker = builder.broker;
                this.includeControlDetails = builder.includeControlDetails;
                this.includeNullAndEmpty = builder.includeNullAndEmpty;
                this.includeTableAlterOperations = builder.includeTableAlterOperations;
                this.includeTransactionDetails = builder.includeTransactionDetails;
                this.noHexPrefix = builder.noHexPrefix;
                this.partitionIncludeSchemaTable = builder.partitionIncludeSchemaTable;
                this.saslPassword = builder.saslPassword;
                this.saslUserName = builder.saslUserName;
                this.securityProtocol = builder.securityProtocol;
                this.sslCaCertificateArn = builder.sslCaCertificateArn;
                this.sslClientCertificateArn = builder.sslClientCertificateArn;
                this.sslClientKeyArn = builder.sslClientKeyArn;
                this.sslClientKeyPassword = builder.sslClientKeyPassword;
                this.topic = builder.topic;
            }

            @Override
            public final java.lang.String getBroker() {
                return this.broker;
            }

            @Override
            public final java.lang.Object getIncludeControlDetails() {
                return this.includeControlDetails;
            }

            @Override
            public final java.lang.Object getIncludeNullAndEmpty() {
                return this.includeNullAndEmpty;
            }

            @Override
            public final java.lang.Object getIncludeTableAlterOperations() {
                return this.includeTableAlterOperations;
            }

            @Override
            public final java.lang.Object getIncludeTransactionDetails() {
                return this.includeTransactionDetails;
            }

            @Override
            public final java.lang.Object getNoHexPrefix() {
                return this.noHexPrefix;
            }

            @Override
            public final java.lang.Object getPartitionIncludeSchemaTable() {
                return this.partitionIncludeSchemaTable;
            }

            @Override
            public final java.lang.String getSaslPassword() {
                return this.saslPassword;
            }

            @Override
            public final java.lang.String getSaslUserName() {
                return this.saslUserName;
            }

            @Override
            public final java.lang.String getSecurityProtocol() {
                return this.securityProtocol;
            }

            @Override
            public final java.lang.String getSslCaCertificateArn() {
                return this.sslCaCertificateArn;
            }

            @Override
            public final java.lang.String getSslClientCertificateArn() {
                return this.sslClientCertificateArn;
            }

            @Override
            public final java.lang.String getSslClientKeyArn() {
                return this.sslClientKeyArn;
            }

            @Override
            public final java.lang.String getSslClientKeyPassword() {
                return this.sslClientKeyPassword;
            }

            @Override
            public final java.lang.String getTopic() {
                return this.topic;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBroker() != null) {
                    data.set("broker", om.valueToTree(this.getBroker()));
                }
                if (this.getIncludeControlDetails() != null) {
                    data.set("includeControlDetails", om.valueToTree(this.getIncludeControlDetails()));
                }
                if (this.getIncludeNullAndEmpty() != null) {
                    data.set("includeNullAndEmpty", om.valueToTree(this.getIncludeNullAndEmpty()));
                }
                if (this.getIncludeTableAlterOperations() != null) {
                    data.set("includeTableAlterOperations", om.valueToTree(this.getIncludeTableAlterOperations()));
                }
                if (this.getIncludeTransactionDetails() != null) {
                    data.set("includeTransactionDetails", om.valueToTree(this.getIncludeTransactionDetails()));
                }
                if (this.getNoHexPrefix() != null) {
                    data.set("noHexPrefix", om.valueToTree(this.getNoHexPrefix()));
                }
                if (this.getPartitionIncludeSchemaTable() != null) {
                    data.set("partitionIncludeSchemaTable", om.valueToTree(this.getPartitionIncludeSchemaTable()));
                }
                if (this.getSaslPassword() != null) {
                    data.set("saslPassword", om.valueToTree(this.getSaslPassword()));
                }
                if (this.getSaslUserName() != null) {
                    data.set("saslUserName", om.valueToTree(this.getSaslUserName()));
                }
                if (this.getSecurityProtocol() != null) {
                    data.set("securityProtocol", om.valueToTree(this.getSecurityProtocol()));
                }
                if (this.getSslCaCertificateArn() != null) {
                    data.set("sslCaCertificateArn", om.valueToTree(this.getSslCaCertificateArn()));
                }
                if (this.getSslClientCertificateArn() != null) {
                    data.set("sslClientCertificateArn", om.valueToTree(this.getSslClientCertificateArn()));
                }
                if (this.getSslClientKeyArn() != null) {
                    data.set("sslClientKeyArn", om.valueToTree(this.getSslClientKeyArn()));
                }
                if (this.getSslClientKeyPassword() != null) {
                    data.set("sslClientKeyPassword", om.valueToTree(this.getSslClientKeyPassword()));
                }
                if (this.getTopic() != null) {
                    data.set("topic", om.valueToTree(this.getTopic()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-dms.CfnEndpoint.KafkaSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KafkaSettingsProperty.Jsii$Proxy that = (KafkaSettingsProperty.Jsii$Proxy) o;

                if (this.broker != null ? !this.broker.equals(that.broker) : that.broker != null) return false;
                if (this.includeControlDetails != null ? !this.includeControlDetails.equals(that.includeControlDetails) : that.includeControlDetails != null) return false;
                if (this.includeNullAndEmpty != null ? !this.includeNullAndEmpty.equals(that.includeNullAndEmpty) : that.includeNullAndEmpty != null) return false;
                if (this.includeTableAlterOperations != null ? !this.includeTableAlterOperations.equals(that.includeTableAlterOperations) : that.includeTableAlterOperations != null) return false;
                if (this.includeTransactionDetails != null ? !this.includeTransactionDetails.equals(that.includeTransactionDetails) : that.includeTransactionDetails != null) return false;
                if (this.noHexPrefix != null ? !this.noHexPrefix.equals(that.noHexPrefix) : that.noHexPrefix != null) return false;
                if (this.partitionIncludeSchemaTable != null ? !this.partitionIncludeSchemaTable.equals(that.partitionIncludeSchemaTable) : that.partitionIncludeSchemaTable != null) return false;
                if (this.saslPassword != null ? !this.saslPassword.equals(that.saslPassword) : that.saslPassword != null) return false;
                if (this.saslUserName != null ? !this.saslUserName.equals(that.saslUserName) : that.saslUserName != null) return false;
                if (this.securityProtocol != null ? !this.securityProtocol.equals(that.securityProtocol) : that.securityProtocol != null) return false;
                if (this.sslCaCertificateArn != null ? !this.sslCaCertificateArn.equals(that.sslCaCertificateArn) : that.sslCaCertificateArn != null) return false;
                if (this.sslClientCertificateArn != null ? !this.sslClientCertificateArn.equals(that.sslClientCertificateArn) : that.sslClientCertificateArn != null) return false;
                if (this.sslClientKeyArn != null ? !this.sslClientKeyArn.equals(that.sslClientKeyArn) : that.sslClientKeyArn != null) return false;
                if (this.sslClientKeyPassword != null ? !this.sslClientKeyPassword.equals(that.sslClientKeyPassword) : that.sslClientKeyPassword != null) return false;
                return this.topic != null ? this.topic.equals(that.topic) : that.topic == null;
            }

            @Override
            public final int hashCode() {
                int result = this.broker != null ? this.broker.hashCode() : 0;
                result = 31 * result + (this.includeControlDetails != null ? this.includeControlDetails.hashCode() : 0);
                result = 31 * result + (this.includeNullAndEmpty != null ? this.includeNullAndEmpty.hashCode() : 0);
                result = 31 * result + (this.includeTableAlterOperations != null ? this.includeTableAlterOperations.hashCode() : 0);
                result = 31 * result + (this.includeTransactionDetails != null ? this.includeTransactionDetails.hashCode() : 0);
                result = 31 * result + (this.noHexPrefix != null ? this.noHexPrefix.hashCode() : 0);
                result = 31 * result + (this.partitionIncludeSchemaTable != null ? this.partitionIncludeSchemaTable.hashCode() : 0);
                result = 31 * result + (this.saslPassword != null ? this.saslPassword.hashCode() : 0);
                result = 31 * result + (this.saslUserName != null ? this.saslUserName.hashCode() : 0);
                result = 31 * result + (this.securityProtocol != null ? this.securityProtocol.hashCode() : 0);
                result = 31 * result + (this.sslCaCertificateArn != null ? this.sslCaCertificateArn.hashCode() : 0);
                result = 31 * result + (this.sslClientCertificateArn != null ? this.sslClientCertificateArn.hashCode() : 0);
                result = 31 * result + (this.sslClientKeyArn != null ? this.sslClientKeyArn.hashCode() : 0);
                result = 31 * result + (this.sslClientKeyPassword != null ? this.sslClientKeyPassword.hashCode() : 0);
                result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * KinesisSettingsProperty kinesisSettingsProperty = KinesisSettingsProperty.builder()
     *         .includeControlDetails(false)
     *         .includeNullAndEmpty(false)
     *         .includeTableAlterOperations(false)
     *         .includeTransactionDetails(false)
     *         .messageFormat("messageFormat")
     *         .noHexPrefix(false)
     *         .partitionIncludeSchemaTable(false)
     *         .serviceAccessRoleArn("serviceAccessRoleArn")
     *         .streamArn("streamArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint.KinesisSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpoint.KinesisSettingsProperty.IncludeControlDetails`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeControlDetails() {
            return null;
        }

        /**
         * `CfnEndpoint.KinesisSettingsProperty.IncludeNullAndEmpty`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeNullAndEmpty() {
            return null;
        }

        /**
         * `CfnEndpoint.KinesisSettingsProperty.IncludeTableAlterOperations`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeTableAlterOperations() {
            return null;
        }

        /**
         * `CfnEndpoint.KinesisSettingsProperty.IncludeTransactionDetails`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeTransactionDetails() {
            return null;
        }

        /**
         * `CfnEndpoint.KinesisSettingsProperty.MessageFormat`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageFormat() {
            return null;
        }

        /**
         * `CfnEndpoint.KinesisSettingsProperty.NoHexPrefix`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoHexPrefix() {
            return null;
        }

        /**
         * `CfnEndpoint.KinesisSettingsProperty.PartitionIncludeSchemaTable`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPartitionIncludeSchemaTable() {
            return null;
        }

        /**
         * `CfnEndpoint.KinesisSettingsProperty.ServiceAccessRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessRoleArn() {
            return null;
        }

        /**
         * `CfnEndpoint.KinesisSettingsProperty.StreamArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KinesisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisSettingsProperty> {
            java.lang.Object includeControlDetails;
            java.lang.Object includeNullAndEmpty;
            java.lang.Object includeTableAlterOperations;
            java.lang.Object includeTransactionDetails;
            java.lang.String messageFormat;
            java.lang.Object noHexPrefix;
            java.lang.Object partitionIncludeSchemaTable;
            java.lang.String serviceAccessRoleArn;
            java.lang.String streamArn;

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeControlDetails}
             * @param includeControlDetails `CfnEndpoint.KinesisSettingsProperty.IncludeControlDetails`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeControlDetails(java.lang.Boolean includeControlDetails) {
                this.includeControlDetails = includeControlDetails;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeControlDetails}
             * @param includeControlDetails `CfnEndpoint.KinesisSettingsProperty.IncludeControlDetails`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeControlDetails(software.amazon.awscdk.core.IResolvable includeControlDetails) {
                this.includeControlDetails = includeControlDetails;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeNullAndEmpty}
             * @param includeNullAndEmpty `CfnEndpoint.KinesisSettingsProperty.IncludeNullAndEmpty`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeNullAndEmpty(java.lang.Boolean includeNullAndEmpty) {
                this.includeNullAndEmpty = includeNullAndEmpty;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeNullAndEmpty}
             * @param includeNullAndEmpty `CfnEndpoint.KinesisSettingsProperty.IncludeNullAndEmpty`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeNullAndEmpty(software.amazon.awscdk.core.IResolvable includeNullAndEmpty) {
                this.includeNullAndEmpty = includeNullAndEmpty;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeTableAlterOperations}
             * @param includeTableAlterOperations `CfnEndpoint.KinesisSettingsProperty.IncludeTableAlterOperations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTableAlterOperations(java.lang.Boolean includeTableAlterOperations) {
                this.includeTableAlterOperations = includeTableAlterOperations;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeTableAlterOperations}
             * @param includeTableAlterOperations `CfnEndpoint.KinesisSettingsProperty.IncludeTableAlterOperations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTableAlterOperations(software.amazon.awscdk.core.IResolvable includeTableAlterOperations) {
                this.includeTableAlterOperations = includeTableAlterOperations;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeTransactionDetails}
             * @param includeTransactionDetails `CfnEndpoint.KinesisSettingsProperty.IncludeTransactionDetails`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTransactionDetails(java.lang.Boolean includeTransactionDetails) {
                this.includeTransactionDetails = includeTransactionDetails;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeTransactionDetails}
             * @param includeTransactionDetails `CfnEndpoint.KinesisSettingsProperty.IncludeTransactionDetails`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTransactionDetails(software.amazon.awscdk.core.IResolvable includeTransactionDetails) {
                this.includeTransactionDetails = includeTransactionDetails;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getMessageFormat}
             * @param messageFormat `CfnEndpoint.KinesisSettingsProperty.MessageFormat`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageFormat(java.lang.String messageFormat) {
                this.messageFormat = messageFormat;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getNoHexPrefix}
             * @param noHexPrefix `CfnEndpoint.KinesisSettingsProperty.NoHexPrefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noHexPrefix(java.lang.Boolean noHexPrefix) {
                this.noHexPrefix = noHexPrefix;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getNoHexPrefix}
             * @param noHexPrefix `CfnEndpoint.KinesisSettingsProperty.NoHexPrefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noHexPrefix(software.amazon.awscdk.core.IResolvable noHexPrefix) {
                this.noHexPrefix = noHexPrefix;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getPartitionIncludeSchemaTable}
             * @param partitionIncludeSchemaTable `CfnEndpoint.KinesisSettingsProperty.PartitionIncludeSchemaTable`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionIncludeSchemaTable(java.lang.Boolean partitionIncludeSchemaTable) {
                this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getPartitionIncludeSchemaTable}
             * @param partitionIncludeSchemaTable `CfnEndpoint.KinesisSettingsProperty.PartitionIncludeSchemaTable`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionIncludeSchemaTable(software.amazon.awscdk.core.IResolvable partitionIncludeSchemaTable) {
                this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getServiceAccessRoleArn}
             * @param serviceAccessRoleArn `CfnEndpoint.KinesisSettingsProperty.ServiceAccessRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getStreamArn}
             * @param streamArn `CfnEndpoint.KinesisSettingsProperty.StreamArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamArn(java.lang.String streamArn) {
                this.streamArn = streamArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisSettingsProperty {
            private final java.lang.Object includeControlDetails;
            private final java.lang.Object includeNullAndEmpty;
            private final java.lang.Object includeTableAlterOperations;
            private final java.lang.Object includeTransactionDetails;
            private final java.lang.String messageFormat;
            private final java.lang.Object noHexPrefix;
            private final java.lang.Object partitionIncludeSchemaTable;
            private final java.lang.String serviceAccessRoleArn;
            private final java.lang.String streamArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includeControlDetails = software.amazon.jsii.Kernel.get(this, "includeControlDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeNullAndEmpty = software.amazon.jsii.Kernel.get(this, "includeNullAndEmpty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeTableAlterOperations = software.amazon.jsii.Kernel.get(this, "includeTableAlterOperations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeTransactionDetails = software.amazon.jsii.Kernel.get(this, "includeTransactionDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.messageFormat = software.amazon.jsii.Kernel.get(this, "messageFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.noHexPrefix = software.amazon.jsii.Kernel.get(this, "noHexPrefix", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.partitionIncludeSchemaTable = software.amazon.jsii.Kernel.get(this, "partitionIncludeSchemaTable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.streamArn = software.amazon.jsii.Kernel.get(this, "streamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includeControlDetails = builder.includeControlDetails;
                this.includeNullAndEmpty = builder.includeNullAndEmpty;
                this.includeTableAlterOperations = builder.includeTableAlterOperations;
                this.includeTransactionDetails = builder.includeTransactionDetails;
                this.messageFormat = builder.messageFormat;
                this.noHexPrefix = builder.noHexPrefix;
                this.partitionIncludeSchemaTable = builder.partitionIncludeSchemaTable;
                this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
                this.streamArn = builder.streamArn;
            }

            @Override
            public final java.lang.Object getIncludeControlDetails() {
                return this.includeControlDetails;
            }

            @Override
            public final java.lang.Object getIncludeNullAndEmpty() {
                return this.includeNullAndEmpty;
            }

            @Override
            public final java.lang.Object getIncludeTableAlterOperations() {
                return this.includeTableAlterOperations;
            }

            @Override
            public final java.lang.Object getIncludeTransactionDetails() {
                return this.includeTransactionDetails;
            }

            @Override
            public final java.lang.String getMessageFormat() {
                return this.messageFormat;
            }

            @Override
            public final java.lang.Object getNoHexPrefix() {
                return this.noHexPrefix;
            }

            @Override
            public final java.lang.Object getPartitionIncludeSchemaTable() {
                return this.partitionIncludeSchemaTable;
            }

            @Override
            public final java.lang.String getServiceAccessRoleArn() {
                return this.serviceAccessRoleArn;
            }

            @Override
            public final java.lang.String getStreamArn() {
                return this.streamArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludeControlDetails() != null) {
                    data.set("includeControlDetails", om.valueToTree(this.getIncludeControlDetails()));
                }
                if (this.getIncludeNullAndEmpty() != null) {
                    data.set("includeNullAndEmpty", om.valueToTree(this.getIncludeNullAndEmpty()));
                }
                if (this.getIncludeTableAlterOperations() != null) {
                    data.set("includeTableAlterOperations", om.valueToTree(this.getIncludeTableAlterOperations()));
                }
                if (this.getIncludeTransactionDetails() != null) {
                    data.set("includeTransactionDetails", om.valueToTree(this.getIncludeTransactionDetails()));
                }
                if (this.getMessageFormat() != null) {
                    data.set("messageFormat", om.valueToTree(this.getMessageFormat()));
                }
                if (this.getNoHexPrefix() != null) {
                    data.set("noHexPrefix", om.valueToTree(this.getNoHexPrefix()));
                }
                if (this.getPartitionIncludeSchemaTable() != null) {
                    data.set("partitionIncludeSchemaTable", om.valueToTree(this.getPartitionIncludeSchemaTable()));
                }
                if (this.getServiceAccessRoleArn() != null) {
                    data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
                }
                if (this.getStreamArn() != null) {
                    data.set("streamArn", om.valueToTree(this.getStreamArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-dms.CfnEndpoint.KinesisSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisSettingsProperty.Jsii$Proxy that = (KinesisSettingsProperty.Jsii$Proxy) o;

                if (this.includeControlDetails != null ? !this.includeControlDetails.equals(that.includeControlDetails) : that.includeControlDetails != null) return false;
                if (this.includeNullAndEmpty != null ? !this.includeNullAndEmpty.equals(that.includeNullAndEmpty) : that.includeNullAndEmpty != null) return false;
                if (this.includeTableAlterOperations != null ? !this.includeTableAlterOperations.equals(that.includeTableAlterOperations) : that.includeTableAlterOperations != null) return false;
                if (this.includeTransactionDetails != null ? !this.includeTransactionDetails.equals(that.includeTransactionDetails) : that.includeTransactionDetails != null) return false;
                if (this.messageFormat != null ? !this.messageFormat.equals(that.messageFormat) : that.messageFormat != null) return false;
                if (this.noHexPrefix != null ? !this.noHexPrefix.equals(that.noHexPrefix) : that.noHexPrefix != null) return false;
                if (this.partitionIncludeSchemaTable != null ? !this.partitionIncludeSchemaTable.equals(that.partitionIncludeSchemaTable) : that.partitionIncludeSchemaTable != null) return false;
                if (this.serviceAccessRoleArn != null ? !this.serviceAccessRoleArn.equals(that.serviceAccessRoleArn) : that.serviceAccessRoleArn != null) return false;
                return this.streamArn != null ? this.streamArn.equals(that.streamArn) : that.streamArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includeControlDetails != null ? this.includeControlDetails.hashCode() : 0;
                result = 31 * result + (this.includeNullAndEmpty != null ? this.includeNullAndEmpty.hashCode() : 0);
                result = 31 * result + (this.includeTableAlterOperations != null ? this.includeTableAlterOperations.hashCode() : 0);
                result = 31 * result + (this.includeTransactionDetails != null ? this.includeTransactionDetails.hashCode() : 0);
                result = 31 * result + (this.messageFormat != null ? this.messageFormat.hashCode() : 0);
                result = 31 * result + (this.noHexPrefix != null ? this.noHexPrefix.hashCode() : 0);
                result = 31 * result + (this.partitionIncludeSchemaTable != null ? this.partitionIncludeSchemaTable.hashCode() : 0);
                result = 31 * result + (this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.streamArn != null ? this.streamArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * MicrosoftSqlServerSettingsProperty microsoftSqlServerSettingsProperty = MicrosoftSqlServerSettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint.MicrosoftSqlServerSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MicrosoftSqlServerSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MicrosoftSqlServerSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpoint.MicrosoftSqlServerSettingsProperty.SecretsManagerAccessRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * `CfnEndpoint.MicrosoftSqlServerSettingsProperty.SecretsManagerSecretId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MicrosoftSqlServerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MicrosoftSqlServerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MicrosoftSqlServerSettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn `CfnEndpoint.MicrosoftSqlServerSettingsProperty.SecretsManagerAccessRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId `CfnEndpoint.MicrosoftSqlServerSettingsProperty.SecretsManagerSecretId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MicrosoftSqlServerSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MicrosoftSqlServerSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MicrosoftSqlServerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MicrosoftSqlServerSettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-dms.CfnEndpoint.MicrosoftSqlServerSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MicrosoftSqlServerSettingsProperty.Jsii$Proxy that = (MicrosoftSqlServerSettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * MongoDbSettingsProperty mongoDbSettingsProperty = MongoDbSettingsProperty.builder()
     *         .authMechanism("authMechanism")
     *         .authSource("authSource")
     *         .authType("authType")
     *         .databaseName("databaseName")
     *         .docsToInvestigate("docsToInvestigate")
     *         .extractDocId("extractDocId")
     *         .nestingLevel("nestingLevel")
     *         .password("password")
     *         .port(123)
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .serverName("serverName")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint.MongoDbSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MongoDbSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MongoDbSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpoint.MongoDbSettingsProperty.AuthMechanism`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthMechanism() {
            return null;
        }

        /**
         * `CfnEndpoint.MongoDbSettingsProperty.AuthSource`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthSource() {
            return null;
        }

        /**
         * `CfnEndpoint.MongoDbSettingsProperty.AuthType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthType() {
            return null;
        }

        /**
         * `CfnEndpoint.MongoDbSettingsProperty.DatabaseName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * `CfnEndpoint.MongoDbSettingsProperty.DocsToInvestigate`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocsToInvestigate() {
            return null;
        }

        /**
         * `CfnEndpoint.MongoDbSettingsProperty.ExtractDocId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExtractDocId() {
            return null;
        }

        /**
         * `CfnEndpoint.MongoDbSettingsProperty.NestingLevel`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNestingLevel() {
            return null;
        }

        /**
         * `CfnEndpoint.MongoDbSettingsProperty.Password`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * `CfnEndpoint.MongoDbSettingsProperty.Port`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * `CfnEndpoint.MongoDbSettingsProperty.SecretsManagerAccessRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * `CfnEndpoint.MongoDbSettingsProperty.SecretsManagerSecretId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * `CfnEndpoint.MongoDbSettingsProperty.ServerName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerName() {
            return null;
        }

        /**
         * `CfnEndpoint.MongoDbSettingsProperty.Username`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MongoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MongoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MongoDbSettingsProperty> {
            java.lang.String authMechanism;
            java.lang.String authSource;
            java.lang.String authType;
            java.lang.String databaseName;
            java.lang.String docsToInvestigate;
            java.lang.String extractDocId;
            java.lang.String nestingLevel;
            java.lang.String password;
            java.lang.Number port;
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;
            java.lang.String serverName;
            java.lang.String username;

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getAuthMechanism}
             * @param authMechanism `CfnEndpoint.MongoDbSettingsProperty.AuthMechanism`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authMechanism(java.lang.String authMechanism) {
                this.authMechanism = authMechanism;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getAuthSource}
             * @param authSource `CfnEndpoint.MongoDbSettingsProperty.AuthSource`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authSource(java.lang.String authSource) {
                this.authSource = authSource;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getAuthType}
             * @param authType `CfnEndpoint.MongoDbSettingsProperty.AuthType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authType(java.lang.String authType) {
                this.authType = authType;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getDatabaseName}
             * @param databaseName `CfnEndpoint.MongoDbSettingsProperty.DatabaseName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getDocsToInvestigate}
             * @param docsToInvestigate `CfnEndpoint.MongoDbSettingsProperty.DocsToInvestigate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder docsToInvestigate(java.lang.String docsToInvestigate) {
                this.docsToInvestigate = docsToInvestigate;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getExtractDocId}
             * @param extractDocId `CfnEndpoint.MongoDbSettingsProperty.ExtractDocId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extractDocId(java.lang.String extractDocId) {
                this.extractDocId = extractDocId;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getNestingLevel}
             * @param nestingLevel `CfnEndpoint.MongoDbSettingsProperty.NestingLevel`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nestingLevel(java.lang.String nestingLevel) {
                this.nestingLevel = nestingLevel;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getPassword}
             * @param password `CfnEndpoint.MongoDbSettingsProperty.Password`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getPort}
             * @param port `CfnEndpoint.MongoDbSettingsProperty.Port`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn `CfnEndpoint.MongoDbSettingsProperty.SecretsManagerAccessRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId `CfnEndpoint.MongoDbSettingsProperty.SecretsManagerSecretId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getServerName}
             * @param serverName `CfnEndpoint.MongoDbSettingsProperty.ServerName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getUsername}
             * @param username `CfnEndpoint.MongoDbSettingsProperty.Username`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MongoDbSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MongoDbSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MongoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MongoDbSettingsProperty {
            private final java.lang.String authMechanism;
            private final java.lang.String authSource;
            private final java.lang.String authType;
            private final java.lang.String databaseName;
            private final java.lang.String docsToInvestigate;
            private final java.lang.String extractDocId;
            private final java.lang.String nestingLevel;
            private final java.lang.String password;
            private final java.lang.Number port;
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;
            private final java.lang.String serverName;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authMechanism = software.amazon.jsii.Kernel.get(this, "authMechanism", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authSource = software.amazon.jsii.Kernel.get(this, "authSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.docsToInvestigate = software.amazon.jsii.Kernel.get(this, "docsToInvestigate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.extractDocId = software.amazon.jsii.Kernel.get(this, "extractDocId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nestingLevel = software.amazon.jsii.Kernel.get(this, "nestingLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authMechanism = builder.authMechanism;
                this.authSource = builder.authSource;
                this.authType = builder.authType;
                this.databaseName = builder.databaseName;
                this.docsToInvestigate = builder.docsToInvestigate;
                this.extractDocId = builder.extractDocId;
                this.nestingLevel = builder.nestingLevel;
                this.password = builder.password;
                this.port = builder.port;
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
                this.serverName = builder.serverName;
                this.username = builder.username;
            }

            @Override
            public final java.lang.String getAuthMechanism() {
                return this.authMechanism;
            }

            @Override
            public final java.lang.String getAuthSource() {
                return this.authSource;
            }

            @Override
            public final java.lang.String getAuthType() {
                return this.authType;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getDocsToInvestigate() {
                return this.docsToInvestigate;
            }

            @Override
            public final java.lang.String getExtractDocId() {
                return this.extractDocId;
            }

            @Override
            public final java.lang.String getNestingLevel() {
                return this.nestingLevel;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthMechanism() != null) {
                    data.set("authMechanism", om.valueToTree(this.getAuthMechanism()));
                }
                if (this.getAuthSource() != null) {
                    data.set("authSource", om.valueToTree(this.getAuthSource()));
                }
                if (this.getAuthType() != null) {
                    data.set("authType", om.valueToTree(this.getAuthType()));
                }
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getDocsToInvestigate() != null) {
                    data.set("docsToInvestigate", om.valueToTree(this.getDocsToInvestigate()));
                }
                if (this.getExtractDocId() != null) {
                    data.set("extractDocId", om.valueToTree(this.getExtractDocId()));
                }
                if (this.getNestingLevel() != null) {
                    data.set("nestingLevel", om.valueToTree(this.getNestingLevel()));
                }
                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }
                if (this.getServerName() != null) {
                    data.set("serverName", om.valueToTree(this.getServerName()));
                }
                if (this.getUsername() != null) {
                    data.set("username", om.valueToTree(this.getUsername()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-dms.CfnEndpoint.MongoDbSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MongoDbSettingsProperty.Jsii$Proxy that = (MongoDbSettingsProperty.Jsii$Proxy) o;

                if (this.authMechanism != null ? !this.authMechanism.equals(that.authMechanism) : that.authMechanism != null) return false;
                if (this.authSource != null ? !this.authSource.equals(that.authSource) : that.authSource != null) return false;
                if (this.authType != null ? !this.authType.equals(that.authType) : that.authType != null) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                if (this.docsToInvestigate != null ? !this.docsToInvestigate.equals(that.docsToInvestigate) : that.docsToInvestigate != null) return false;
                if (this.extractDocId != null ? !this.extractDocId.equals(that.extractDocId) : that.extractDocId != null) return false;
                if (this.nestingLevel != null ? !this.nestingLevel.equals(that.nestingLevel) : that.nestingLevel != null) return false;
                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                if (this.secretsManagerSecretId != null ? !this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId != null) return false;
                if (this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null) return false;
                return this.username != null ? this.username.equals(that.username) : that.username == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authMechanism != null ? this.authMechanism.hashCode() : 0;
                result = 31 * result + (this.authSource != null ? this.authSource.hashCode() : 0);
                result = 31 * result + (this.authType != null ? this.authType.hashCode() : 0);
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.docsToInvestigate != null ? this.docsToInvestigate.hashCode() : 0);
                result = 31 * result + (this.extractDocId != null ? this.extractDocId.hashCode() : 0);
                result = 31 * result + (this.nestingLevel != null ? this.nestingLevel.hashCode() : 0);
                result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                result = 31 * result + (this.serverName != null ? this.serverName.hashCode() : 0);
                result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * MySqlSettingsProperty mySqlSettingsProperty = MySqlSettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint.MySqlSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MySqlSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MySqlSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpoint.MySqlSettingsProperty.SecretsManagerAccessRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * `CfnEndpoint.MySqlSettingsProperty.SecretsManagerSecretId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MySqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MySqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MySqlSettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link MySqlSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn `CfnEndpoint.MySqlSettingsProperty.SecretsManagerAccessRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link MySqlSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId `CfnEndpoint.MySqlSettingsProperty.SecretsManagerSecretId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MySqlSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MySqlSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MySqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MySqlSettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-dms.CfnEndpoint.MySqlSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MySqlSettingsProperty.Jsii$Proxy that = (MySqlSettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * NeptuneSettingsProperty neptuneSettingsProperty = NeptuneSettingsProperty.builder()
     *         .errorRetryDuration(123)
     *         .iamAuthEnabled(false)
     *         .maxFileSize(123)
     *         .maxRetryCount(123)
     *         .s3BucketFolder("s3BucketFolder")
     *         .s3BucketName("s3BucketName")
     *         .serviceAccessRoleArn("serviceAccessRoleArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint.NeptuneSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(NeptuneSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NeptuneSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpoint.NeptuneSettingsProperty.ErrorRetryDuration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getErrorRetryDuration() {
            return null;
        }

        /**
         * `CfnEndpoint.NeptuneSettingsProperty.IamAuthEnabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIamAuthEnabled() {
            return null;
        }

        /**
         * `CfnEndpoint.NeptuneSettingsProperty.MaxFileSize`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxFileSize() {
            return null;
        }

        /**
         * `CfnEndpoint.NeptuneSettingsProperty.MaxRetryCount`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxRetryCount() {
            return null;
        }

        /**
         * `CfnEndpoint.NeptuneSettingsProperty.S3BucketFolder`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketFolder() {
            return null;
        }

        /**
         * `CfnEndpoint.NeptuneSettingsProperty.S3BucketName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketName() {
            return null;
        }

        /**
         * `CfnEndpoint.NeptuneSettingsProperty.ServiceAccessRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NeptuneSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NeptuneSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NeptuneSettingsProperty> {
            java.lang.Number errorRetryDuration;
            java.lang.Object iamAuthEnabled;
            java.lang.Number maxFileSize;
            java.lang.Number maxRetryCount;
            java.lang.String s3BucketFolder;
            java.lang.String s3BucketName;
            java.lang.String serviceAccessRoleArn;

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getErrorRetryDuration}
             * @param errorRetryDuration `CfnEndpoint.NeptuneSettingsProperty.ErrorRetryDuration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorRetryDuration(java.lang.Number errorRetryDuration) {
                this.errorRetryDuration = errorRetryDuration;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getIamAuthEnabled}
             * @param iamAuthEnabled `CfnEndpoint.NeptuneSettingsProperty.IamAuthEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamAuthEnabled(java.lang.Boolean iamAuthEnabled) {
                this.iamAuthEnabled = iamAuthEnabled;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getIamAuthEnabled}
             * @param iamAuthEnabled `CfnEndpoint.NeptuneSettingsProperty.IamAuthEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamAuthEnabled(software.amazon.awscdk.core.IResolvable iamAuthEnabled) {
                this.iamAuthEnabled = iamAuthEnabled;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getMaxFileSize}
             * @param maxFileSize `CfnEndpoint.NeptuneSettingsProperty.MaxFileSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxFileSize(java.lang.Number maxFileSize) {
                this.maxFileSize = maxFileSize;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getMaxRetryCount}
             * @param maxRetryCount `CfnEndpoint.NeptuneSettingsProperty.MaxRetryCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRetryCount(java.lang.Number maxRetryCount) {
                this.maxRetryCount = maxRetryCount;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getS3BucketFolder}
             * @param s3BucketFolder `CfnEndpoint.NeptuneSettingsProperty.S3BucketFolder`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketFolder(java.lang.String s3BucketFolder) {
                this.s3BucketFolder = s3BucketFolder;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getS3BucketName}
             * @param s3BucketName `CfnEndpoint.NeptuneSettingsProperty.S3BucketName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getServiceAccessRoleArn}
             * @param serviceAccessRoleArn `CfnEndpoint.NeptuneSettingsProperty.ServiceAccessRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NeptuneSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NeptuneSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NeptuneSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NeptuneSettingsProperty {
            private final java.lang.Number errorRetryDuration;
            private final java.lang.Object iamAuthEnabled;
            private final java.lang.Number maxFileSize;
            private final java.lang.Number maxRetryCount;
            private final java.lang.String s3BucketFolder;
            private final java.lang.String s3BucketName;
            private final java.lang.String serviceAccessRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.errorRetryDuration = software.amazon.jsii.Kernel.get(this, "errorRetryDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.iamAuthEnabled = software.amazon.jsii.Kernel.get(this, "iamAuthEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxFileSize = software.amazon.jsii.Kernel.get(this, "maxFileSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxRetryCount = software.amazon.jsii.Kernel.get(this, "maxRetryCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.s3BucketFolder = software.amazon.jsii.Kernel.get(this, "s3BucketFolder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.errorRetryDuration = builder.errorRetryDuration;
                this.iamAuthEnabled = builder.iamAuthEnabled;
                this.maxFileSize = builder.maxFileSize;
                this.maxRetryCount = builder.maxRetryCount;
                this.s3BucketFolder = builder.s3BucketFolder;
                this.s3BucketName = builder.s3BucketName;
                this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
            }

            @Override
            public final java.lang.Number getErrorRetryDuration() {
                return this.errorRetryDuration;
            }

            @Override
            public final java.lang.Object getIamAuthEnabled() {
                return this.iamAuthEnabled;
            }

            @Override
            public final java.lang.Number getMaxFileSize() {
                return this.maxFileSize;
            }

            @Override
            public final java.lang.Number getMaxRetryCount() {
                return this.maxRetryCount;
            }

            @Override
            public final java.lang.String getS3BucketFolder() {
                return this.s3BucketFolder;
            }

            @Override
            public final java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            public final java.lang.String getServiceAccessRoleArn() {
                return this.serviceAccessRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getErrorRetryDuration() != null) {
                    data.set("errorRetryDuration", om.valueToTree(this.getErrorRetryDuration()));
                }
                if (this.getIamAuthEnabled() != null) {
                    data.set("iamAuthEnabled", om.valueToTree(this.getIamAuthEnabled()));
                }
                if (this.getMaxFileSize() != null) {
                    data.set("maxFileSize", om.valueToTree(this.getMaxFileSize()));
                }
                if (this.getMaxRetryCount() != null) {
                    data.set("maxRetryCount", om.valueToTree(this.getMaxRetryCount()));
                }
                if (this.getS3BucketFolder() != null) {
                    data.set("s3BucketFolder", om.valueToTree(this.getS3BucketFolder()));
                }
                if (this.getS3BucketName() != null) {
                    data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
                }
                if (this.getServiceAccessRoleArn() != null) {
                    data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-dms.CfnEndpoint.NeptuneSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NeptuneSettingsProperty.Jsii$Proxy that = (NeptuneSettingsProperty.Jsii$Proxy) o;

                if (this.errorRetryDuration != null ? !this.errorRetryDuration.equals(that.errorRetryDuration) : that.errorRetryDuration != null) return false;
                if (this.iamAuthEnabled != null ? !this.iamAuthEnabled.equals(that.iamAuthEnabled) : that.iamAuthEnabled != null) return false;
                if (this.maxFileSize != null ? !this.maxFileSize.equals(that.maxFileSize) : that.maxFileSize != null) return false;
                if (this.maxRetryCount != null ? !this.maxRetryCount.equals(that.maxRetryCount) : that.maxRetryCount != null) return false;
                if (this.s3BucketFolder != null ? !this.s3BucketFolder.equals(that.s3BucketFolder) : that.s3BucketFolder != null) return false;
                if (this.s3BucketName != null ? !this.s3BucketName.equals(that.s3BucketName) : that.s3BucketName != null) return false;
                return this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.equals(that.serviceAccessRoleArn) : that.serviceAccessRoleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.errorRetryDuration != null ? this.errorRetryDuration.hashCode() : 0;
                result = 31 * result + (this.iamAuthEnabled != null ? this.iamAuthEnabled.hashCode() : 0);
                result = 31 * result + (this.maxFileSize != null ? this.maxFileSize.hashCode() : 0);
                result = 31 * result + (this.maxRetryCount != null ? this.maxRetryCount.hashCode() : 0);
                result = 31 * result + (this.s3BucketFolder != null ? this.s3BucketFolder.hashCode() : 0);
                result = 31 * result + (this.s3BucketName != null ? this.s3BucketName.hashCode() : 0);
                result = 31 * result + (this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * OracleSettingsProperty oracleSettingsProperty = OracleSettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerOracleAsmAccessRoleArn("secretsManagerOracleAsmAccessRoleArn")
     *         .secretsManagerOracleAsmSecretId("secretsManagerOracleAsmSecretId")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint.OracleSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(OracleSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OracleSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpoint.OracleSettingsProperty.SecretsManagerAccessRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * `CfnEndpoint.OracleSettingsProperty.SecretsManagerOracleAsmAccessRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerOracleAsmAccessRoleArn() {
            return null;
        }

        /**
         * `CfnEndpoint.OracleSettingsProperty.SecretsManagerOracleAsmSecretId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerOracleAsmSecretId() {
            return null;
        }

        /**
         * `CfnEndpoint.OracleSettingsProperty.SecretsManagerSecretId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OracleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OracleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OracleSettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerOracleAsmAccessRoleArn;
            java.lang.String secretsManagerOracleAsmSecretId;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn `CfnEndpoint.OracleSettingsProperty.SecretsManagerAccessRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecretsManagerOracleAsmAccessRoleArn}
             * @param secretsManagerOracleAsmAccessRoleArn `CfnEndpoint.OracleSettingsProperty.SecretsManagerOracleAsmAccessRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerOracleAsmAccessRoleArn(java.lang.String secretsManagerOracleAsmAccessRoleArn) {
                this.secretsManagerOracleAsmAccessRoleArn = secretsManagerOracleAsmAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecretsManagerOracleAsmSecretId}
             * @param secretsManagerOracleAsmSecretId `CfnEndpoint.OracleSettingsProperty.SecretsManagerOracleAsmSecretId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerOracleAsmSecretId(java.lang.String secretsManagerOracleAsmSecretId) {
                this.secretsManagerOracleAsmSecretId = secretsManagerOracleAsmSecretId;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId `CfnEndpoint.OracleSettingsProperty.SecretsManagerSecretId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OracleSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OracleSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OracleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OracleSettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerOracleAsmAccessRoleArn;
            private final java.lang.String secretsManagerOracleAsmSecretId;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerOracleAsmAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerOracleAsmAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerOracleAsmSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerOracleAsmSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerOracleAsmAccessRoleArn = builder.secretsManagerOracleAsmAccessRoleArn;
                this.secretsManagerOracleAsmSecretId = builder.secretsManagerOracleAsmSecretId;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerOracleAsmAccessRoleArn() {
                return this.secretsManagerOracleAsmAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerOracleAsmSecretId() {
                return this.secretsManagerOracleAsmSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerOracleAsmAccessRoleArn() != null) {
                    data.set("secretsManagerOracleAsmAccessRoleArn", om.valueToTree(this.getSecretsManagerOracleAsmAccessRoleArn()));
                }
                if (this.getSecretsManagerOracleAsmSecretId() != null) {
                    data.set("secretsManagerOracleAsmSecretId", om.valueToTree(this.getSecretsManagerOracleAsmSecretId()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-dms.CfnEndpoint.OracleSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OracleSettingsProperty.Jsii$Proxy that = (OracleSettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                if (this.secretsManagerOracleAsmAccessRoleArn != null ? !this.secretsManagerOracleAsmAccessRoleArn.equals(that.secretsManagerOracleAsmAccessRoleArn) : that.secretsManagerOracleAsmAccessRoleArn != null) return false;
                if (this.secretsManagerOracleAsmSecretId != null ? !this.secretsManagerOracleAsmSecretId.equals(that.secretsManagerOracleAsmSecretId) : that.secretsManagerOracleAsmSecretId != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerOracleAsmAccessRoleArn != null ? this.secretsManagerOracleAsmAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerOracleAsmSecretId != null ? this.secretsManagerOracleAsmSecretId.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * PostgreSqlSettingsProperty postgreSqlSettingsProperty = PostgreSqlSettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint.PostgreSqlSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(PostgreSqlSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PostgreSqlSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpoint.PostgreSqlSettingsProperty.SecretsManagerAccessRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * `CfnEndpoint.PostgreSqlSettingsProperty.SecretsManagerSecretId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PostgreSqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PostgreSqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PostgreSqlSettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn `CfnEndpoint.PostgreSqlSettingsProperty.SecretsManagerAccessRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId `CfnEndpoint.PostgreSqlSettingsProperty.SecretsManagerSecretId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PostgreSqlSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PostgreSqlSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PostgreSqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PostgreSqlSettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-dms.CfnEndpoint.PostgreSqlSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PostgreSqlSettingsProperty.Jsii$Proxy that = (PostgreSqlSettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * RedisSettingsProperty redisSettingsProperty = RedisSettingsProperty.builder()
     *         .authPassword("authPassword")
     *         .authType("authType")
     *         .authUserName("authUserName")
     *         .port(123)
     *         .serverName("serverName")
     *         .sslCaCertificateArn("sslCaCertificateArn")
     *         .sslSecurityProtocol("sslSecurityProtocol")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint.RedisSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(RedisSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedisSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpoint.RedisSettingsProperty.AuthPassword`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthPassword() {
            return null;
        }

        /**
         * `CfnEndpoint.RedisSettingsProperty.AuthType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthType() {
            return null;
        }

        /**
         * `CfnEndpoint.RedisSettingsProperty.AuthUserName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthUserName() {
            return null;
        }

        /**
         * `CfnEndpoint.RedisSettingsProperty.Port`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * `CfnEndpoint.RedisSettingsProperty.ServerName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerName() {
            return null;
        }

        /**
         * `CfnEndpoint.RedisSettingsProperty.SslCaCertificateArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslCaCertificateArn() {
            return null;
        }

        /**
         * `CfnEndpoint.RedisSettingsProperty.SslSecurityProtocol`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslSecurityProtocol() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedisSettingsProperty> {
            java.lang.String authPassword;
            java.lang.String authType;
            java.lang.String authUserName;
            java.lang.Number port;
            java.lang.String serverName;
            java.lang.String sslCaCertificateArn;
            java.lang.String sslSecurityProtocol;

            /**
             * Sets the value of {@link RedisSettingsProperty#getAuthPassword}
             * @param authPassword `CfnEndpoint.RedisSettingsProperty.AuthPassword`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authPassword(java.lang.String authPassword) {
                this.authPassword = authPassword;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getAuthType}
             * @param authType `CfnEndpoint.RedisSettingsProperty.AuthType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authType(java.lang.String authType) {
                this.authType = authType;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getAuthUserName}
             * @param authUserName `CfnEndpoint.RedisSettingsProperty.AuthUserName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authUserName(java.lang.String authUserName) {
                this.authUserName = authUserName;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getPort}
             * @param port `CfnEndpoint.RedisSettingsProperty.Port`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getServerName}
             * @param serverName `CfnEndpoint.RedisSettingsProperty.ServerName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getSslCaCertificateArn}
             * @param sslCaCertificateArn `CfnEndpoint.RedisSettingsProperty.SslCaCertificateArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslCaCertificateArn(java.lang.String sslCaCertificateArn) {
                this.sslCaCertificateArn = sslCaCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getSslSecurityProtocol}
             * @param sslSecurityProtocol `CfnEndpoint.RedisSettingsProperty.SslSecurityProtocol`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslSecurityProtocol(java.lang.String sslSecurityProtocol) {
                this.sslSecurityProtocol = sslSecurityProtocol;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedisSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedisSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedisSettingsProperty {
            private final java.lang.String authPassword;
            private final java.lang.String authType;
            private final java.lang.String authUserName;
            private final java.lang.Number port;
            private final java.lang.String serverName;
            private final java.lang.String sslCaCertificateArn;
            private final java.lang.String sslSecurityProtocol;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authPassword = software.amazon.jsii.Kernel.get(this, "authPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authUserName = software.amazon.jsii.Kernel.get(this, "authUserName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslCaCertificateArn = software.amazon.jsii.Kernel.get(this, "sslCaCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslSecurityProtocol = software.amazon.jsii.Kernel.get(this, "sslSecurityProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authPassword = builder.authPassword;
                this.authType = builder.authType;
                this.authUserName = builder.authUserName;
                this.port = builder.port;
                this.serverName = builder.serverName;
                this.sslCaCertificateArn = builder.sslCaCertificateArn;
                this.sslSecurityProtocol = builder.sslSecurityProtocol;
            }

            @Override
            public final java.lang.String getAuthPassword() {
                return this.authPassword;
            }

            @Override
            public final java.lang.String getAuthType() {
                return this.authType;
            }

            @Override
            public final java.lang.String getAuthUserName() {
                return this.authUserName;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            public final java.lang.String getSslCaCertificateArn() {
                return this.sslCaCertificateArn;
            }

            @Override
            public final java.lang.String getSslSecurityProtocol() {
                return this.sslSecurityProtocol;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthPassword() != null) {
                    data.set("authPassword", om.valueToTree(this.getAuthPassword()));
                }
                if (this.getAuthType() != null) {
                    data.set("authType", om.valueToTree(this.getAuthType()));
                }
                if (this.getAuthUserName() != null) {
                    data.set("authUserName", om.valueToTree(this.getAuthUserName()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getServerName() != null) {
                    data.set("serverName", om.valueToTree(this.getServerName()));
                }
                if (this.getSslCaCertificateArn() != null) {
                    data.set("sslCaCertificateArn", om.valueToTree(this.getSslCaCertificateArn()));
                }
                if (this.getSslSecurityProtocol() != null) {
                    data.set("sslSecurityProtocol", om.valueToTree(this.getSslSecurityProtocol()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-dms.CfnEndpoint.RedisSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedisSettingsProperty.Jsii$Proxy that = (RedisSettingsProperty.Jsii$Proxy) o;

                if (this.authPassword != null ? !this.authPassword.equals(that.authPassword) : that.authPassword != null) return false;
                if (this.authType != null ? !this.authType.equals(that.authType) : that.authType != null) return false;
                if (this.authUserName != null ? !this.authUserName.equals(that.authUserName) : that.authUserName != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null) return false;
                if (this.sslCaCertificateArn != null ? !this.sslCaCertificateArn.equals(that.sslCaCertificateArn) : that.sslCaCertificateArn != null) return false;
                return this.sslSecurityProtocol != null ? this.sslSecurityProtocol.equals(that.sslSecurityProtocol) : that.sslSecurityProtocol == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authPassword != null ? this.authPassword.hashCode() : 0;
                result = 31 * result + (this.authType != null ? this.authType.hashCode() : 0);
                result = 31 * result + (this.authUserName != null ? this.authUserName.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.serverName != null ? this.serverName.hashCode() : 0);
                result = 31 * result + (this.sslCaCertificateArn != null ? this.sslCaCertificateArn.hashCode() : 0);
                result = 31 * result + (this.sslSecurityProtocol != null ? this.sslSecurityProtocol.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * RedshiftSettingsProperty redshiftSettingsProperty = RedshiftSettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint.RedshiftSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpoint.RedshiftSettingsProperty.SecretsManagerAccessRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * `CfnEndpoint.RedshiftSettingsProperty.SecretsManagerSecretId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftSettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn `CfnEndpoint.RedshiftSettingsProperty.SecretsManagerAccessRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId `CfnEndpoint.RedshiftSettingsProperty.SecretsManagerSecretId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftSettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-dms.CfnEndpoint.RedshiftSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftSettingsProperty.Jsii$Proxy that = (RedshiftSettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * S3SettingsProperty s3SettingsProperty = S3SettingsProperty.builder()
     *         .bucketFolder("bucketFolder")
     *         .bucketName("bucketName")
     *         .compressionType("compressionType")
     *         .csvDelimiter("csvDelimiter")
     *         .csvRowDelimiter("csvRowDelimiter")
     *         .externalTableDefinition("externalTableDefinition")
     *         .serviceAccessRoleArn("serviceAccessRoleArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint.S3SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(S3SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpoint.S3SettingsProperty.BucketFolder`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketFolder() {
            return null;
        }

        /**
         * `CfnEndpoint.S3SettingsProperty.BucketName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
            return null;
        }

        /**
         * `CfnEndpoint.S3SettingsProperty.CompressionType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompressionType() {
            return null;
        }

        /**
         * `CfnEndpoint.S3SettingsProperty.CsvDelimiter`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCsvDelimiter() {
            return null;
        }

        /**
         * `CfnEndpoint.S3SettingsProperty.CsvRowDelimiter`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCsvRowDelimiter() {
            return null;
        }

        /**
         * `CfnEndpoint.S3SettingsProperty.ExternalTableDefinition`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalTableDefinition() {
            return null;
        }

        /**
         * `CfnEndpoint.S3SettingsProperty.ServiceAccessRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3SettingsProperty> {
            java.lang.String bucketFolder;
            java.lang.String bucketName;
            java.lang.String compressionType;
            java.lang.String csvDelimiter;
            java.lang.String csvRowDelimiter;
            java.lang.String externalTableDefinition;
            java.lang.String serviceAccessRoleArn;

            /**
             * Sets the value of {@link S3SettingsProperty#getBucketFolder}
             * @param bucketFolder `CfnEndpoint.S3SettingsProperty.BucketFolder`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketFolder(java.lang.String bucketFolder) {
                this.bucketFolder = bucketFolder;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getBucketName}
             * @param bucketName `CfnEndpoint.S3SettingsProperty.BucketName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCompressionType}
             * @param compressionType `CfnEndpoint.S3SettingsProperty.CompressionType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compressionType(java.lang.String compressionType) {
                this.compressionType = compressionType;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCsvDelimiter}
             * @param csvDelimiter `CfnEndpoint.S3SettingsProperty.CsvDelimiter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvDelimiter(java.lang.String csvDelimiter) {
                this.csvDelimiter = csvDelimiter;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCsvRowDelimiter}
             * @param csvRowDelimiter `CfnEndpoint.S3SettingsProperty.CsvRowDelimiter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvRowDelimiter(java.lang.String csvRowDelimiter) {
                this.csvRowDelimiter = csvRowDelimiter;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getExternalTableDefinition}
             * @param externalTableDefinition `CfnEndpoint.S3SettingsProperty.ExternalTableDefinition`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalTableDefinition(java.lang.String externalTableDefinition) {
                this.externalTableDefinition = externalTableDefinition;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getServiceAccessRoleArn}
             * @param serviceAccessRoleArn `CfnEndpoint.S3SettingsProperty.ServiceAccessRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3SettingsProperty {
            private final java.lang.String bucketFolder;
            private final java.lang.String bucketName;
            private final java.lang.String compressionType;
            private final java.lang.String csvDelimiter;
            private final java.lang.String csvRowDelimiter;
            private final java.lang.String externalTableDefinition;
            private final java.lang.String serviceAccessRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketFolder = software.amazon.jsii.Kernel.get(this, "bucketFolder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.compressionType = software.amazon.jsii.Kernel.get(this, "compressionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.csvDelimiter = software.amazon.jsii.Kernel.get(this, "csvDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.csvRowDelimiter = software.amazon.jsii.Kernel.get(this, "csvRowDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalTableDefinition = software.amazon.jsii.Kernel.get(this, "externalTableDefinition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketFolder = builder.bucketFolder;
                this.bucketName = builder.bucketName;
                this.compressionType = builder.compressionType;
                this.csvDelimiter = builder.csvDelimiter;
                this.csvRowDelimiter = builder.csvRowDelimiter;
                this.externalTableDefinition = builder.externalTableDefinition;
                this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
            }

            @Override
            public final java.lang.String getBucketFolder() {
                return this.bucketFolder;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getCompressionType() {
                return this.compressionType;
            }

            @Override
            public final java.lang.String getCsvDelimiter() {
                return this.csvDelimiter;
            }

            @Override
            public final java.lang.String getCsvRowDelimiter() {
                return this.csvRowDelimiter;
            }

            @Override
            public final java.lang.String getExternalTableDefinition() {
                return this.externalTableDefinition;
            }

            @Override
            public final java.lang.String getServiceAccessRoleArn() {
                return this.serviceAccessRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucketFolder() != null) {
                    data.set("bucketFolder", om.valueToTree(this.getBucketFolder()));
                }
                if (this.getBucketName() != null) {
                    data.set("bucketName", om.valueToTree(this.getBucketName()));
                }
                if (this.getCompressionType() != null) {
                    data.set("compressionType", om.valueToTree(this.getCompressionType()));
                }
                if (this.getCsvDelimiter() != null) {
                    data.set("csvDelimiter", om.valueToTree(this.getCsvDelimiter()));
                }
                if (this.getCsvRowDelimiter() != null) {
                    data.set("csvRowDelimiter", om.valueToTree(this.getCsvRowDelimiter()));
                }
                if (this.getExternalTableDefinition() != null) {
                    data.set("externalTableDefinition", om.valueToTree(this.getExternalTableDefinition()));
                }
                if (this.getServiceAccessRoleArn() != null) {
                    data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-dms.CfnEndpoint.S3SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3SettingsProperty.Jsii$Proxy that = (S3SettingsProperty.Jsii$Proxy) o;

                if (this.bucketFolder != null ? !this.bucketFolder.equals(that.bucketFolder) : that.bucketFolder != null) return false;
                if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) return false;
                if (this.compressionType != null ? !this.compressionType.equals(that.compressionType) : that.compressionType != null) return false;
                if (this.csvDelimiter != null ? !this.csvDelimiter.equals(that.csvDelimiter) : that.csvDelimiter != null) return false;
                if (this.csvRowDelimiter != null ? !this.csvRowDelimiter.equals(that.csvRowDelimiter) : that.csvRowDelimiter != null) return false;
                if (this.externalTableDefinition != null ? !this.externalTableDefinition.equals(that.externalTableDefinition) : that.externalTableDefinition != null) return false;
                return this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.equals(that.serviceAccessRoleArn) : that.serviceAccessRoleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketFolder != null ? this.bucketFolder.hashCode() : 0;
                result = 31 * result + (this.bucketName != null ? this.bucketName.hashCode() : 0);
                result = 31 * result + (this.compressionType != null ? this.compressionType.hashCode() : 0);
                result = 31 * result + (this.csvDelimiter != null ? this.csvDelimiter.hashCode() : 0);
                result = 31 * result + (this.csvRowDelimiter != null ? this.csvRowDelimiter.hashCode() : 0);
                result = 31 * result + (this.externalTableDefinition != null ? this.externalTableDefinition.hashCode() : 0);
                result = 31 * result + (this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * SybaseSettingsProperty sybaseSettingsProperty = SybaseSettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dms.$Module.class, fqn = "@aws-cdk/aws-dms.CfnEndpoint.SybaseSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SybaseSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SybaseSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEndpoint.SybaseSettingsProperty.SecretsManagerAccessRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * `CfnEndpoint.SybaseSettingsProperty.SecretsManagerSecretId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SybaseSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SybaseSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SybaseSettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link SybaseSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn `CfnEndpoint.SybaseSettingsProperty.SecretsManagerAccessRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link SybaseSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId `CfnEndpoint.SybaseSettingsProperty.SecretsManagerSecretId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SybaseSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SybaseSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SybaseSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SybaseSettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-dms.CfnEndpoint.SybaseSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SybaseSettingsProperty.Jsii$Proxy that = (SybaseSettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dms.CfnEndpoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.dms.CfnEndpoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.dms.CfnEndpointProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.dms.CfnEndpointProps.Builder();
        }

        /**
         * `AWS::DMS::Endpoint.CertificateArn`.
         * <p>
         * @return {@code this}
         * @param certificateArn `AWS::DMS::Endpoint.CertificateArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateArn(final java.lang.String certificateArn) {
            this.props.certificateArn(certificateArn);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.DatabaseName`.
         * <p>
         * @return {@code this}
         * @param databaseName `AWS::DMS::Endpoint.DatabaseName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.DocDbSettings`.
         * <p>
         * @return {@code this}
         * @param docDbSettings `AWS::DMS::Endpoint.DocDbSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder docDbSettings(final software.amazon.awscdk.core.IResolvable docDbSettings) {
            this.props.docDbSettings(docDbSettings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.DocDbSettings`.
         * <p>
         * @return {@code this}
         * @param docDbSettings `AWS::DMS::Endpoint.DocDbSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder docDbSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.DocDbSettingsProperty docDbSettings) {
            this.props.docDbSettings(docDbSettings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.DynamoDbSettings`.
         * <p>
         * @return {@code this}
         * @param dynamoDbSettings `AWS::DMS::Endpoint.DynamoDbSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dynamoDbSettings(final software.amazon.awscdk.core.IResolvable dynamoDbSettings) {
            this.props.dynamoDbSettings(dynamoDbSettings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.DynamoDbSettings`.
         * <p>
         * @return {@code this}
         * @param dynamoDbSettings `AWS::DMS::Endpoint.DynamoDbSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dynamoDbSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.DynamoDbSettingsProperty dynamoDbSettings) {
            this.props.dynamoDbSettings(dynamoDbSettings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.ElasticsearchSettings`.
         * <p>
         * @return {@code this}
         * @param elasticsearchSettings `AWS::DMS::Endpoint.ElasticsearchSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchSettings(final software.amazon.awscdk.core.IResolvable elasticsearchSettings) {
            this.props.elasticsearchSettings(elasticsearchSettings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.ElasticsearchSettings`.
         * <p>
         * @return {@code this}
         * @param elasticsearchSettings `AWS::DMS::Endpoint.ElasticsearchSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.ElasticsearchSettingsProperty elasticsearchSettings) {
            this.props.elasticsearchSettings(elasticsearchSettings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.EndpointIdentifier`.
         * <p>
         * @return {@code this}
         * @param endpointIdentifier `AWS::DMS::Endpoint.EndpointIdentifier`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointIdentifier(final java.lang.String endpointIdentifier) {
            this.props.endpointIdentifier(endpointIdentifier);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.EndpointType`.
         * <p>
         * @return {@code this}
         * @param endpointType `AWS::DMS::Endpoint.EndpointType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointType(final java.lang.String endpointType) {
            this.props.endpointType(endpointType);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.EngineName`.
         * <p>
         * @return {@code this}
         * @param engineName `AWS::DMS::Endpoint.EngineName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineName(final java.lang.String engineName) {
            this.props.engineName(engineName);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.ExtraConnectionAttributes`.
         * <p>
         * @return {@code this}
         * @param extraConnectionAttributes `AWS::DMS::Endpoint.ExtraConnectionAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraConnectionAttributes(final java.lang.String extraConnectionAttributes) {
            this.props.extraConnectionAttributes(extraConnectionAttributes);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.IbmDb2Settings`.
         * <p>
         * @return {@code this}
         * @param ibmDb2Settings `AWS::DMS::Endpoint.IbmDb2Settings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ibmDb2Settings(final software.amazon.awscdk.core.IResolvable ibmDb2Settings) {
            this.props.ibmDb2Settings(ibmDb2Settings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.IbmDb2Settings`.
         * <p>
         * @return {@code this}
         * @param ibmDb2Settings `AWS::DMS::Endpoint.IbmDb2Settings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ibmDb2Settings(final software.amazon.awscdk.services.dms.CfnEndpoint.IbmDb2SettingsProperty ibmDb2Settings) {
            this.props.ibmDb2Settings(ibmDb2Settings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.KafkaSettings`.
         * <p>
         * @return {@code this}
         * @param kafkaSettings `AWS::DMS::Endpoint.KafkaSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaSettings(final software.amazon.awscdk.core.IResolvable kafkaSettings) {
            this.props.kafkaSettings(kafkaSettings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.KafkaSettings`.
         * <p>
         * @return {@code this}
         * @param kafkaSettings `AWS::DMS::Endpoint.KafkaSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.KafkaSettingsProperty kafkaSettings) {
            this.props.kafkaSettings(kafkaSettings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.KinesisSettings`.
         * <p>
         * @return {@code this}
         * @param kinesisSettings `AWS::DMS::Endpoint.KinesisSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisSettings(final software.amazon.awscdk.core.IResolvable kinesisSettings) {
            this.props.kinesisSettings(kinesisSettings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.KinesisSettings`.
         * <p>
         * @return {@code this}
         * @param kinesisSettings `AWS::DMS::Endpoint.KinesisSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.KinesisSettingsProperty kinesisSettings) {
            this.props.kinesisSettings(kinesisSettings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.KmsKeyId`.
         * <p>
         * @return {@code this}
         * @param kmsKeyId `AWS::DMS::Endpoint.KmsKeyId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.MicrosoftSqlServerSettings`.
         * <p>
         * @return {@code this}
         * @param microsoftSqlServerSettings `AWS::DMS::Endpoint.MicrosoftSqlServerSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder microsoftSqlServerSettings(final software.amazon.awscdk.core.IResolvable microsoftSqlServerSettings) {
            this.props.microsoftSqlServerSettings(microsoftSqlServerSettings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.MicrosoftSqlServerSettings`.
         * <p>
         * @return {@code this}
         * @param microsoftSqlServerSettings `AWS::DMS::Endpoint.MicrosoftSqlServerSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder microsoftSqlServerSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.MicrosoftSqlServerSettingsProperty microsoftSqlServerSettings) {
            this.props.microsoftSqlServerSettings(microsoftSqlServerSettings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.MongoDbSettings`.
         * <p>
         * @return {@code this}
         * @param mongoDbSettings `AWS::DMS::Endpoint.MongoDbSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mongoDbSettings(final software.amazon.awscdk.core.IResolvable mongoDbSettings) {
            this.props.mongoDbSettings(mongoDbSettings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.MongoDbSettings`.
         * <p>
         * @return {@code this}
         * @param mongoDbSettings `AWS::DMS::Endpoint.MongoDbSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mongoDbSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.MongoDbSettingsProperty mongoDbSettings) {
            this.props.mongoDbSettings(mongoDbSettings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.MySqlSettings`.
         * <p>
         * @return {@code this}
         * @param mySqlSettings `AWS::DMS::Endpoint.MySqlSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mySqlSettings(final software.amazon.awscdk.core.IResolvable mySqlSettings) {
            this.props.mySqlSettings(mySqlSettings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.MySqlSettings`.
         * <p>
         * @return {@code this}
         * @param mySqlSettings `AWS::DMS::Endpoint.MySqlSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mySqlSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.MySqlSettingsProperty mySqlSettings) {
            this.props.mySqlSettings(mySqlSettings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.NeptuneSettings`.
         * <p>
         * @return {@code this}
         * @param neptuneSettings `AWS::DMS::Endpoint.NeptuneSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder neptuneSettings(final software.amazon.awscdk.core.IResolvable neptuneSettings) {
            this.props.neptuneSettings(neptuneSettings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.NeptuneSettings`.
         * <p>
         * @return {@code this}
         * @param neptuneSettings `AWS::DMS::Endpoint.NeptuneSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder neptuneSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.NeptuneSettingsProperty neptuneSettings) {
            this.props.neptuneSettings(neptuneSettings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.OracleSettings`.
         * <p>
         * @return {@code this}
         * @param oracleSettings `AWS::DMS::Endpoint.OracleSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oracleSettings(final software.amazon.awscdk.core.IResolvable oracleSettings) {
            this.props.oracleSettings(oracleSettings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.OracleSettings`.
         * <p>
         * @return {@code this}
         * @param oracleSettings `AWS::DMS::Endpoint.OracleSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oracleSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.OracleSettingsProperty oracleSettings) {
            this.props.oracleSettings(oracleSettings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.Password`.
         * <p>
         * @return {@code this}
         * @param password `AWS::DMS::Endpoint.Password`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(final java.lang.String password) {
            this.props.password(password);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.Port`.
         * <p>
         * @return {@code this}
         * @param port `AWS::DMS::Endpoint.Port`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.PostgreSqlSettings`.
         * <p>
         * @return {@code this}
         * @param postgreSqlSettings `AWS::DMS::Endpoint.PostgreSqlSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postgreSqlSettings(final software.amazon.awscdk.core.IResolvable postgreSqlSettings) {
            this.props.postgreSqlSettings(postgreSqlSettings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.PostgreSqlSettings`.
         * <p>
         * @return {@code this}
         * @param postgreSqlSettings `AWS::DMS::Endpoint.PostgreSqlSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postgreSqlSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.PostgreSqlSettingsProperty postgreSqlSettings) {
            this.props.postgreSqlSettings(postgreSqlSettings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.RedisSettings`.
         * <p>
         * @return {@code this}
         * @param redisSettings `AWS::DMS::Endpoint.RedisSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redisSettings(final software.amazon.awscdk.core.IResolvable redisSettings) {
            this.props.redisSettings(redisSettings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.RedisSettings`.
         * <p>
         * @return {@code this}
         * @param redisSettings `AWS::DMS::Endpoint.RedisSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redisSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.RedisSettingsProperty redisSettings) {
            this.props.redisSettings(redisSettings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.RedshiftSettings`.
         * <p>
         * @return {@code this}
         * @param redshiftSettings `AWS::DMS::Endpoint.RedshiftSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redshiftSettings(final software.amazon.awscdk.core.IResolvable redshiftSettings) {
            this.props.redshiftSettings(redshiftSettings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.RedshiftSettings`.
         * <p>
         * @return {@code this}
         * @param redshiftSettings `AWS::DMS::Endpoint.RedshiftSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redshiftSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.RedshiftSettingsProperty redshiftSettings) {
            this.props.redshiftSettings(redshiftSettings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.ResourceIdentifier`.
         * <p>
         * @return {@code this}
         * @param resourceIdentifier `AWS::DMS::Endpoint.ResourceIdentifier`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceIdentifier(final java.lang.String resourceIdentifier) {
            this.props.resourceIdentifier(resourceIdentifier);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.S3Settings`.
         * <p>
         * @return {@code this}
         * @param s3Settings `AWS::DMS::Endpoint.S3Settings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Settings(final software.amazon.awscdk.core.IResolvable s3Settings) {
            this.props.s3Settings(s3Settings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.S3Settings`.
         * <p>
         * @return {@code this}
         * @param s3Settings `AWS::DMS::Endpoint.S3Settings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Settings(final software.amazon.awscdk.services.dms.CfnEndpoint.S3SettingsProperty s3Settings) {
            this.props.s3Settings(s3Settings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.ServerName`.
         * <p>
         * @return {@code this}
         * @param serverName `AWS::DMS::Endpoint.ServerName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverName(final java.lang.String serverName) {
            this.props.serverName(serverName);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.SslMode`.
         * <p>
         * @return {@code this}
         * @param sslMode `AWS::DMS::Endpoint.SslMode`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslMode(final java.lang.String sslMode) {
            this.props.sslMode(sslMode);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.SybaseSettings`.
         * <p>
         * @return {@code this}
         * @param sybaseSettings `AWS::DMS::Endpoint.SybaseSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sybaseSettings(final software.amazon.awscdk.core.IResolvable sybaseSettings) {
            this.props.sybaseSettings(sybaseSettings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.SybaseSettings`.
         * <p>
         * @return {@code this}
         * @param sybaseSettings `AWS::DMS::Endpoint.SybaseSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sybaseSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.SybaseSettingsProperty sybaseSettings) {
            this.props.sybaseSettings(sybaseSettings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::DMS::Endpoint.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.Username`.
         * <p>
         * @return {@code this}
         * @param username `AWS::DMS::Endpoint.Username`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder username(final java.lang.String username) {
            this.props.username(username);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.dms.CfnEndpoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.dms.CfnEndpoint build() {
            return new software.amazon.awscdk.services.dms.CfnEndpoint(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
