package software.amazon.awscdk.services.dynamodb.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.6 (build 04cb6bb)", date = "2018-09-27T21:45:17.679Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.cloudformation.TableResource")
public class TableResource extends software.amazon.awscdk.Resource {
    protected TableResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::DynamoDB::Table``.
     * @param parent the ``cdk.Construct`` this ``TableResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``TableResource``
     */
    public TableResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.dynamodb.cloudformation.TableResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(properties).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.dynamodb.cloudformation.TableResourceProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.dynamodb.cloudformation.TableResourceProps.class);
    }

    /**
     * @cloudformation_attribute Arn
     */
    public java.lang.String getTableArn() {
        return this.jsiiGet("tableArn", java.lang.String.class);
    }

    public java.lang.String getTableName() {
        return this.jsiiGet("tableName", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute StreamArn
     */
    public java.lang.String getTableStreamArn() {
        return this.jsiiGet("tableStreamArn", java.lang.String.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html
     */
    public static interface AttributeDefinitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.AttributeDefinitionProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
         */
        java.lang.Object getAttributeName();
        /**
         * ``TableResource.AttributeDefinitionProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
         */
        void setAttributeName(final java.lang.String value);
        /**
         * ``TableResource.AttributeDefinitionProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
         */
        void setAttributeName(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``TableResource.AttributeDefinitionProperty.AttributeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
         */
        java.lang.Object getAttributeType();
        /**
         * ``TableResource.AttributeDefinitionProperty.AttributeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
         */
        void setAttributeType(final java.lang.String value);
        /**
         * ``TableResource.AttributeDefinitionProperty.AttributeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
         */
        void setAttributeType(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link AttributeDefinitionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AttributeDefinitionProperty}
         */
        final class Builder {
            private java.lang.Object _attributeName;
            private java.lang.Object _attributeType;

            /**
             * Sets the value of AttributeName
             * @param value ``TableResource.AttributeDefinitionProperty.AttributeName``
             * @return {@code this}
             */
            public Builder withAttributeName(final java.lang.String value) {
                this._attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                return this;
            }
            /**
             * Sets the value of AttributeName
             * @param value ``TableResource.AttributeDefinitionProperty.AttributeName``
             * @return {@code this}
             */
            public Builder withAttributeName(final software.amazon.awscdk.CloudFormationToken value) {
                this._attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                return this;
            }
            /**
             * Sets the value of AttributeType
             * @param value ``TableResource.AttributeDefinitionProperty.AttributeType``
             * @return {@code this}
             */
            public Builder withAttributeType(final java.lang.String value) {
                this._attributeType = java.util.Objects.requireNonNull(value, "attributeType is required");
                return this;
            }
            /**
             * Sets the value of AttributeType
             * @param value ``TableResource.AttributeDefinitionProperty.AttributeType``
             * @return {@code this}
             */
            public Builder withAttributeType(final software.amazon.awscdk.CloudFormationToken value) {
                this._attributeType = java.util.Objects.requireNonNull(value, "attributeType is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributeDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AttributeDefinitionProperty build() {
                return new AttributeDefinitionProperty() {
                    private java.lang.Object $attributeName = java.util.Objects.requireNonNull(_attributeName, "attributeName is required");
                    private java.lang.Object $attributeType = java.util.Objects.requireNonNull(_attributeType, "attributeType is required");

                    @Override
                    public java.lang.Object getAttributeName() {
                        return this.$attributeName;
                    }

                    @Override
                    public void setAttributeName(final java.lang.String value) {
                        this.$attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                    }

                    @Override
                    public void setAttributeName(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                    }

                    @Override
                    public java.lang.Object getAttributeType() {
                        return this.$attributeType;
                    }

                    @Override
                    public void setAttributeType(final java.lang.String value) {
                        this.$attributeType = java.util.Objects.requireNonNull(value, "attributeType is required");
                    }

                    @Override
                    public void setAttributeType(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$attributeType = java.util.Objects.requireNonNull(value, "attributeType is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.AttributeDefinitionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``TableResource.AttributeDefinitionProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
             */
            @Override
            public java.lang.Object getAttributeName() {
                return this.jsiiGet("attributeName", java.lang.Object.class);
            }

            /**
             * ``TableResource.AttributeDefinitionProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
             */
            @Override
            public void setAttributeName(final java.lang.String value) {
                this.jsiiSet("attributeName", java.util.Objects.requireNonNull(value, "attributeName is required"));
            }

            /**
             * ``TableResource.AttributeDefinitionProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
             */
            @Override
            public void setAttributeName(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("attributeName", java.util.Objects.requireNonNull(value, "attributeName is required"));
            }

            /**
             * ``TableResource.AttributeDefinitionProperty.AttributeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
             */
            @Override
            public java.lang.Object getAttributeType() {
                return this.jsiiGet("attributeType", java.lang.Object.class);
            }

            /**
             * ``TableResource.AttributeDefinitionProperty.AttributeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
             */
            @Override
            public void setAttributeType(final java.lang.String value) {
                this.jsiiSet("attributeType", java.util.Objects.requireNonNull(value, "attributeType is required"));
            }

            /**
             * ``TableResource.AttributeDefinitionProperty.AttributeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
             */
            @Override
            public void setAttributeType(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("attributeType", java.util.Objects.requireNonNull(value, "attributeType is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html
     */
    public static interface GlobalSecondaryIndexProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.IndexName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
         */
        java.lang.Object getIndexName();
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.IndexName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
         */
        void setIndexName(final java.lang.String value);
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.IndexName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
         */
        void setIndexName(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
         */
        java.lang.Object getKeySchema();
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
         */
        void setKeySchema(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
         */
        void setKeySchema(final java.util.List<java.lang.Object> value);
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
         */
        java.lang.Object getProjection();
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
         */
        void setProjection(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
         */
        void setProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value);
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
         */
        java.lang.Object getProvisionedThroughput();
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
         */
        void setProvisionedThroughput(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
         */
        void setProvisionedThroughput(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProvisionedThroughputProperty value);

        /**
         * @return a {@link Builder} of {@link GlobalSecondaryIndexProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link GlobalSecondaryIndexProperty}
         */
        final class Builder {
            private java.lang.Object _indexName;
            private java.lang.Object _keySchema;
            private java.lang.Object _projection;
            private java.lang.Object _provisionedThroughput;

            /**
             * Sets the value of IndexName
             * @param value ``TableResource.GlobalSecondaryIndexProperty.IndexName``
             * @return {@code this}
             */
            public Builder withIndexName(final java.lang.String value) {
                this._indexName = java.util.Objects.requireNonNull(value, "indexName is required");
                return this;
            }
            /**
             * Sets the value of IndexName
             * @param value ``TableResource.GlobalSecondaryIndexProperty.IndexName``
             * @return {@code this}
             */
            public Builder withIndexName(final software.amazon.awscdk.CloudFormationToken value) {
                this._indexName = java.util.Objects.requireNonNull(value, "indexName is required");
                return this;
            }
            /**
             * Sets the value of KeySchema
             * @param value ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
             * @return {@code this}
             */
            public Builder withKeySchema(final software.amazon.awscdk.CloudFormationToken value) {
                this._keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                return this;
            }
            /**
             * Sets the value of KeySchema
             * @param value ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
             * @return {@code this}
             */
            public Builder withKeySchema(final java.util.List<java.lang.Object> value) {
                this._keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                return this;
            }
            /**
             * Sets the value of Projection
             * @param value ``TableResource.GlobalSecondaryIndexProperty.Projection``
             * @return {@code this}
             */
            public Builder withProjection(final software.amazon.awscdk.CloudFormationToken value) {
                this._projection = java.util.Objects.requireNonNull(value, "projection is required");
                return this;
            }
            /**
             * Sets the value of Projection
             * @param value ``TableResource.GlobalSecondaryIndexProperty.Projection``
             * @return {@code this}
             */
            public Builder withProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value) {
                this._projection = java.util.Objects.requireNonNull(value, "projection is required");
                return this;
            }
            /**
             * Sets the value of ProvisionedThroughput
             * @param value ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
             * @return {@code this}
             */
            public Builder withProvisionedThroughput(final software.amazon.awscdk.CloudFormationToken value) {
                this._provisionedThroughput = java.util.Objects.requireNonNull(value, "provisionedThroughput is required");
                return this;
            }
            /**
             * Sets the value of ProvisionedThroughput
             * @param value ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
             * @return {@code this}
             */
            public Builder withProvisionedThroughput(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProvisionedThroughputProperty value) {
                this._provisionedThroughput = java.util.Objects.requireNonNull(value, "provisionedThroughput is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlobalSecondaryIndexProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public GlobalSecondaryIndexProperty build() {
                return new GlobalSecondaryIndexProperty() {
                    private java.lang.Object $indexName = java.util.Objects.requireNonNull(_indexName, "indexName is required");
                    private java.lang.Object $keySchema = java.util.Objects.requireNonNull(_keySchema, "keySchema is required");
                    private java.lang.Object $projection = java.util.Objects.requireNonNull(_projection, "projection is required");
                    private java.lang.Object $provisionedThroughput = java.util.Objects.requireNonNull(_provisionedThroughput, "provisionedThroughput is required");

                    @Override
                    public java.lang.Object getIndexName() {
                        return this.$indexName;
                    }

                    @Override
                    public void setIndexName(final java.lang.String value) {
                        this.$indexName = java.util.Objects.requireNonNull(value, "indexName is required");
                    }

                    @Override
                    public void setIndexName(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$indexName = java.util.Objects.requireNonNull(value, "indexName is required");
                    }

                    @Override
                    public java.lang.Object getKeySchema() {
                        return this.$keySchema;
                    }

                    @Override
                    public void setKeySchema(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                    }

                    @Override
                    public void setKeySchema(final java.util.List<java.lang.Object> value) {
                        this.$keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                    }

                    @Override
                    public java.lang.Object getProjection() {
                        return this.$projection;
                    }

                    @Override
                    public void setProjection(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$projection = java.util.Objects.requireNonNull(value, "projection is required");
                    }

                    @Override
                    public void setProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value) {
                        this.$projection = java.util.Objects.requireNonNull(value, "projection is required");
                    }

                    @Override
                    public java.lang.Object getProvisionedThroughput() {
                        return this.$provisionedThroughput;
                    }

                    @Override
                    public void setProvisionedThroughput(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$provisionedThroughput = java.util.Objects.requireNonNull(value, "provisionedThroughput is required");
                    }

                    @Override
                    public void setProvisionedThroughput(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProvisionedThroughputProperty value) {
                        this.$provisionedThroughput = java.util.Objects.requireNonNull(value, "provisionedThroughput is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.GlobalSecondaryIndexProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``TableResource.GlobalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
             */
            @Override
            public java.lang.Object getIndexName() {
                return this.jsiiGet("indexName", java.lang.Object.class);
            }

            /**
             * ``TableResource.GlobalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
             */
            @Override
            public void setIndexName(final java.lang.String value) {
                this.jsiiSet("indexName", java.util.Objects.requireNonNull(value, "indexName is required"));
            }

            /**
             * ``TableResource.GlobalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
             */
            @Override
            public void setIndexName(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("indexName", java.util.Objects.requireNonNull(value, "indexName is required"));
            }

            /**
             * ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
             */
            @Override
            public java.lang.Object getKeySchema() {
                return this.jsiiGet("keySchema", java.lang.Object.class);
            }

            /**
             * ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
             */
            @Override
            public void setKeySchema(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
            }

            /**
             * ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
             */
            @Override
            public void setKeySchema(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
            }

            /**
             * ``TableResource.GlobalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
             */
            @Override
            public java.lang.Object getProjection() {
                return this.jsiiGet("projection", java.lang.Object.class);
            }

            /**
             * ``TableResource.GlobalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
             */
            @Override
            public void setProjection(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("projection", java.util.Objects.requireNonNull(value, "projection is required"));
            }

            /**
             * ``TableResource.GlobalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
             */
            @Override
            public void setProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value) {
                this.jsiiSet("projection", java.util.Objects.requireNonNull(value, "projection is required"));
            }

            /**
             * ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
             */
            @Override
            public java.lang.Object getProvisionedThroughput() {
                return this.jsiiGet("provisionedThroughput", java.lang.Object.class);
            }

            /**
             * ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
             */
            @Override
            public void setProvisionedThroughput(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("provisionedThroughput", java.util.Objects.requireNonNull(value, "provisionedThroughput is required"));
            }

            /**
             * ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
             */
            @Override
            public void setProvisionedThroughput(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProvisionedThroughputProperty value) {
                this.jsiiSet("provisionedThroughput", java.util.Objects.requireNonNull(value, "provisionedThroughput is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html
     */
    public static interface KeySchemaProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.KeySchemaProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
         */
        java.lang.Object getAttributeName();
        /**
         * ``TableResource.KeySchemaProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
         */
        void setAttributeName(final java.lang.String value);
        /**
         * ``TableResource.KeySchemaProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
         */
        void setAttributeName(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``TableResource.KeySchemaProperty.KeyType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
         */
        java.lang.Object getKeyType();
        /**
         * ``TableResource.KeySchemaProperty.KeyType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
         */
        void setKeyType(final java.lang.String value);
        /**
         * ``TableResource.KeySchemaProperty.KeyType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
         */
        void setKeyType(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link KeySchemaProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link KeySchemaProperty}
         */
        final class Builder {
            private java.lang.Object _attributeName;
            private java.lang.Object _keyType;

            /**
             * Sets the value of AttributeName
             * @param value ``TableResource.KeySchemaProperty.AttributeName``
             * @return {@code this}
             */
            public Builder withAttributeName(final java.lang.String value) {
                this._attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                return this;
            }
            /**
             * Sets the value of AttributeName
             * @param value ``TableResource.KeySchemaProperty.AttributeName``
             * @return {@code this}
             */
            public Builder withAttributeName(final software.amazon.awscdk.CloudFormationToken value) {
                this._attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                return this;
            }
            /**
             * Sets the value of KeyType
             * @param value ``TableResource.KeySchemaProperty.KeyType``
             * @return {@code this}
             */
            public Builder withKeyType(final java.lang.String value) {
                this._keyType = java.util.Objects.requireNonNull(value, "keyType is required");
                return this;
            }
            /**
             * Sets the value of KeyType
             * @param value ``TableResource.KeySchemaProperty.KeyType``
             * @return {@code this}
             */
            public Builder withKeyType(final software.amazon.awscdk.CloudFormationToken value) {
                this._keyType = java.util.Objects.requireNonNull(value, "keyType is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeySchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public KeySchemaProperty build() {
                return new KeySchemaProperty() {
                    private java.lang.Object $attributeName = java.util.Objects.requireNonNull(_attributeName, "attributeName is required");
                    private java.lang.Object $keyType = java.util.Objects.requireNonNull(_keyType, "keyType is required");

                    @Override
                    public java.lang.Object getAttributeName() {
                        return this.$attributeName;
                    }

                    @Override
                    public void setAttributeName(final java.lang.String value) {
                        this.$attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                    }

                    @Override
                    public void setAttributeName(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                    }

                    @Override
                    public java.lang.Object getKeyType() {
                        return this.$keyType;
                    }

                    @Override
                    public void setKeyType(final java.lang.String value) {
                        this.$keyType = java.util.Objects.requireNonNull(value, "keyType is required");
                    }

                    @Override
                    public void setKeyType(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$keyType = java.util.Objects.requireNonNull(value, "keyType is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.KeySchemaProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``TableResource.KeySchemaProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
             */
            @Override
            public java.lang.Object getAttributeName() {
                return this.jsiiGet("attributeName", java.lang.Object.class);
            }

            /**
             * ``TableResource.KeySchemaProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
             */
            @Override
            public void setAttributeName(final java.lang.String value) {
                this.jsiiSet("attributeName", java.util.Objects.requireNonNull(value, "attributeName is required"));
            }

            /**
             * ``TableResource.KeySchemaProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
             */
            @Override
            public void setAttributeName(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("attributeName", java.util.Objects.requireNonNull(value, "attributeName is required"));
            }

            /**
             * ``TableResource.KeySchemaProperty.KeyType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
             */
            @Override
            public java.lang.Object getKeyType() {
                return this.jsiiGet("keyType", java.lang.Object.class);
            }

            /**
             * ``TableResource.KeySchemaProperty.KeyType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
             */
            @Override
            public void setKeyType(final java.lang.String value) {
                this.jsiiSet("keyType", java.util.Objects.requireNonNull(value, "keyType is required"));
            }

            /**
             * ``TableResource.KeySchemaProperty.KeyType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
             */
            @Override
            public void setKeyType(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("keyType", java.util.Objects.requireNonNull(value, "keyType is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html
     */
    public static interface LocalSecondaryIndexProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.LocalSecondaryIndexProperty.IndexName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
         */
        java.lang.Object getIndexName();
        /**
         * ``TableResource.LocalSecondaryIndexProperty.IndexName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
         */
        void setIndexName(final java.lang.String value);
        /**
         * ``TableResource.LocalSecondaryIndexProperty.IndexName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
         */
        void setIndexName(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``TableResource.LocalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
         */
        java.lang.Object getKeySchema();
        /**
         * ``TableResource.LocalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
         */
        void setKeySchema(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``TableResource.LocalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
         */
        void setKeySchema(final java.util.List<java.lang.Object> value);
        /**
         * ``TableResource.LocalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
         */
        java.lang.Object getProjection();
        /**
         * ``TableResource.LocalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
         */
        void setProjection(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``TableResource.LocalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
         */
        void setProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value);

        /**
         * @return a {@link Builder} of {@link LocalSecondaryIndexProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LocalSecondaryIndexProperty}
         */
        final class Builder {
            private java.lang.Object _indexName;
            private java.lang.Object _keySchema;
            private java.lang.Object _projection;

            /**
             * Sets the value of IndexName
             * @param value ``TableResource.LocalSecondaryIndexProperty.IndexName``
             * @return {@code this}
             */
            public Builder withIndexName(final java.lang.String value) {
                this._indexName = java.util.Objects.requireNonNull(value, "indexName is required");
                return this;
            }
            /**
             * Sets the value of IndexName
             * @param value ``TableResource.LocalSecondaryIndexProperty.IndexName``
             * @return {@code this}
             */
            public Builder withIndexName(final software.amazon.awscdk.CloudFormationToken value) {
                this._indexName = java.util.Objects.requireNonNull(value, "indexName is required");
                return this;
            }
            /**
             * Sets the value of KeySchema
             * @param value ``TableResource.LocalSecondaryIndexProperty.KeySchema``
             * @return {@code this}
             */
            public Builder withKeySchema(final software.amazon.awscdk.CloudFormationToken value) {
                this._keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                return this;
            }
            /**
             * Sets the value of KeySchema
             * @param value ``TableResource.LocalSecondaryIndexProperty.KeySchema``
             * @return {@code this}
             */
            public Builder withKeySchema(final java.util.List<java.lang.Object> value) {
                this._keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                return this;
            }
            /**
             * Sets the value of Projection
             * @param value ``TableResource.LocalSecondaryIndexProperty.Projection``
             * @return {@code this}
             */
            public Builder withProjection(final software.amazon.awscdk.CloudFormationToken value) {
                this._projection = java.util.Objects.requireNonNull(value, "projection is required");
                return this;
            }
            /**
             * Sets the value of Projection
             * @param value ``TableResource.LocalSecondaryIndexProperty.Projection``
             * @return {@code this}
             */
            public Builder withProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value) {
                this._projection = java.util.Objects.requireNonNull(value, "projection is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocalSecondaryIndexProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LocalSecondaryIndexProperty build() {
                return new LocalSecondaryIndexProperty() {
                    private java.lang.Object $indexName = java.util.Objects.requireNonNull(_indexName, "indexName is required");
                    private java.lang.Object $keySchema = java.util.Objects.requireNonNull(_keySchema, "keySchema is required");
                    private java.lang.Object $projection = java.util.Objects.requireNonNull(_projection, "projection is required");

                    @Override
                    public java.lang.Object getIndexName() {
                        return this.$indexName;
                    }

                    @Override
                    public void setIndexName(final java.lang.String value) {
                        this.$indexName = java.util.Objects.requireNonNull(value, "indexName is required");
                    }

                    @Override
                    public void setIndexName(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$indexName = java.util.Objects.requireNonNull(value, "indexName is required");
                    }

                    @Override
                    public java.lang.Object getKeySchema() {
                        return this.$keySchema;
                    }

                    @Override
                    public void setKeySchema(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                    }

                    @Override
                    public void setKeySchema(final java.util.List<java.lang.Object> value) {
                        this.$keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                    }

                    @Override
                    public java.lang.Object getProjection() {
                        return this.$projection;
                    }

                    @Override
                    public void setProjection(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$projection = java.util.Objects.requireNonNull(value, "projection is required");
                    }

                    @Override
                    public void setProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value) {
                        this.$projection = java.util.Objects.requireNonNull(value, "projection is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.LocalSecondaryIndexProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``TableResource.LocalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
             */
            @Override
            public java.lang.Object getIndexName() {
                return this.jsiiGet("indexName", java.lang.Object.class);
            }

            /**
             * ``TableResource.LocalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
             */
            @Override
            public void setIndexName(final java.lang.String value) {
                this.jsiiSet("indexName", java.util.Objects.requireNonNull(value, "indexName is required"));
            }

            /**
             * ``TableResource.LocalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
             */
            @Override
            public void setIndexName(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("indexName", java.util.Objects.requireNonNull(value, "indexName is required"));
            }

            /**
             * ``TableResource.LocalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
             */
            @Override
            public java.lang.Object getKeySchema() {
                return this.jsiiGet("keySchema", java.lang.Object.class);
            }

            /**
             * ``TableResource.LocalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
             */
            @Override
            public void setKeySchema(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
            }

            /**
             * ``TableResource.LocalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
             */
            @Override
            public void setKeySchema(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
            }

            /**
             * ``TableResource.LocalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
             */
            @Override
            public java.lang.Object getProjection() {
                return this.jsiiGet("projection", java.lang.Object.class);
            }

            /**
             * ``TableResource.LocalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
             */
            @Override
            public void setProjection(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("projection", java.util.Objects.requireNonNull(value, "projection is required"));
            }

            /**
             * ``TableResource.LocalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
             */
            @Override
            public void setProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value) {
                this.jsiiSet("projection", java.util.Objects.requireNonNull(value, "projection is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html
     */
    public static interface PointInTimeRecoverySpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
         */
        java.lang.Object getPointInTimeRecoveryEnabled();
        /**
         * ``TableResource.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
         */
        void setPointInTimeRecoveryEnabled(final java.lang.Boolean value);
        /**
         * ``TableResource.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
         */
        void setPointInTimeRecoveryEnabled(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link PointInTimeRecoverySpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PointInTimeRecoverySpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _pointInTimeRecoveryEnabled;

            /**
             * Sets the value of PointInTimeRecoveryEnabled
             * @param value ``TableResource.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
             * @return {@code this}
             */
            public Builder withPointInTimeRecoveryEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._pointInTimeRecoveryEnabled = value;
                return this;
            }
            /**
             * Sets the value of PointInTimeRecoveryEnabled
             * @param value ``TableResource.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
             * @return {@code this}
             */
            public Builder withPointInTimeRecoveryEnabled(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._pointInTimeRecoveryEnabled = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PointInTimeRecoverySpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PointInTimeRecoverySpecificationProperty build() {
                return new PointInTimeRecoverySpecificationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $pointInTimeRecoveryEnabled = _pointInTimeRecoveryEnabled;

                    @Override
                    public java.lang.Object getPointInTimeRecoveryEnabled() {
                        return this.$pointInTimeRecoveryEnabled;
                    }

                    @Override
                    public void setPointInTimeRecoveryEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$pointInTimeRecoveryEnabled = value;
                    }

                    @Override
                    public void setPointInTimeRecoveryEnabled(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$pointInTimeRecoveryEnabled = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.PointInTimeRecoverySpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``TableResource.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPointInTimeRecoveryEnabled() {
                return this.jsiiGet("pointInTimeRecoveryEnabled", java.lang.Object.class);
            }

            /**
             * ``TableResource.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
             */
            @Override
            public void setPointInTimeRecoveryEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("pointInTimeRecoveryEnabled", value);
            }

            /**
             * ``TableResource.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
             */
            @Override
            public void setPointInTimeRecoveryEnabled(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("pointInTimeRecoveryEnabled", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html
     */
    public static interface ProjectionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.ProjectionProperty.NonKeyAttributes``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
         */
        java.lang.Object getNonKeyAttributes();
        /**
         * ``TableResource.ProjectionProperty.NonKeyAttributes``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
         */
        void setNonKeyAttributes(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``TableResource.ProjectionProperty.NonKeyAttributes``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
         */
        void setNonKeyAttributes(final java.util.List<java.lang.Object> value);
        /**
         * ``TableResource.ProjectionProperty.ProjectionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
         */
        java.lang.Object getProjectionType();
        /**
         * ``TableResource.ProjectionProperty.ProjectionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
         */
        void setProjectionType(final java.lang.String value);
        /**
         * ``TableResource.ProjectionProperty.ProjectionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
         */
        void setProjectionType(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link ProjectionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ProjectionProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _nonKeyAttributes;
            @javax.annotation.Nullable
            private java.lang.Object _projectionType;

            /**
             * Sets the value of NonKeyAttributes
             * @param value ``TableResource.ProjectionProperty.NonKeyAttributes``
             * @return {@code this}
             */
            public Builder withNonKeyAttributes(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._nonKeyAttributes = value;
                return this;
            }
            /**
             * Sets the value of NonKeyAttributes
             * @param value ``TableResource.ProjectionProperty.NonKeyAttributes``
             * @return {@code this}
             */
            public Builder withNonKeyAttributes(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._nonKeyAttributes = value;
                return this;
            }
            /**
             * Sets the value of ProjectionType
             * @param value ``TableResource.ProjectionProperty.ProjectionType``
             * @return {@code this}
             */
            public Builder withProjectionType(@javax.annotation.Nullable final java.lang.String value) {
                this._projectionType = value;
                return this;
            }
            /**
             * Sets the value of ProjectionType
             * @param value ``TableResource.ProjectionProperty.ProjectionType``
             * @return {@code this}
             */
            public Builder withProjectionType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._projectionType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ProjectionProperty build() {
                return new ProjectionProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $nonKeyAttributes = _nonKeyAttributes;
                    @javax.annotation.Nullable
                    private java.lang.Object $projectionType = _projectionType;

                    @Override
                    public java.lang.Object getNonKeyAttributes() {
                        return this.$nonKeyAttributes;
                    }

                    @Override
                    public void setNonKeyAttributes(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$nonKeyAttributes = value;
                    }

                    @Override
                    public void setNonKeyAttributes(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$nonKeyAttributes = value;
                    }

                    @Override
                    public java.lang.Object getProjectionType() {
                        return this.$projectionType;
                    }

                    @Override
                    public void setProjectionType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$projectionType = value;
                    }

                    @Override
                    public void setProjectionType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$projectionType = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``TableResource.ProjectionProperty.NonKeyAttributes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNonKeyAttributes() {
                return this.jsiiGet("nonKeyAttributes", java.lang.Object.class);
            }

            /**
             * ``TableResource.ProjectionProperty.NonKeyAttributes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
             */
            @Override
            public void setNonKeyAttributes(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("nonKeyAttributes", value);
            }

            /**
             * ``TableResource.ProjectionProperty.NonKeyAttributes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
             */
            @Override
            public void setNonKeyAttributes(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("nonKeyAttributes", value);
            }

            /**
             * ``TableResource.ProjectionProperty.ProjectionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getProjectionType() {
                return this.jsiiGet("projectionType", java.lang.Object.class);
            }

            /**
             * ``TableResource.ProjectionProperty.ProjectionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
             */
            @Override
            public void setProjectionType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("projectionType", value);
            }

            /**
             * ``TableResource.ProjectionProperty.ProjectionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
             */
            @Override
            public void setProjectionType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("projectionType", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     */
    public static interface ProvisionedThroughputProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
         */
        java.lang.Object getReadCapacityUnits();
        /**
         * ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
         */
        void setReadCapacityUnits(final java.lang.Number value);
        /**
         * ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
         */
        void setReadCapacityUnits(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
         */
        java.lang.Object getWriteCapacityUnits();
        /**
         * ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
         */
        void setWriteCapacityUnits(final java.lang.Number value);
        /**
         * ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
         */
        void setWriteCapacityUnits(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link ProvisionedThroughputProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ProvisionedThroughputProperty}
         */
        final class Builder {
            private java.lang.Object _readCapacityUnits;
            private java.lang.Object _writeCapacityUnits;

            /**
             * Sets the value of ReadCapacityUnits
             * @param value ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
             * @return {@code this}
             */
            public Builder withReadCapacityUnits(final java.lang.Number value) {
                this._readCapacityUnits = java.util.Objects.requireNonNull(value, "readCapacityUnits is required");
                return this;
            }
            /**
             * Sets the value of ReadCapacityUnits
             * @param value ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
             * @return {@code this}
             */
            public Builder withReadCapacityUnits(final software.amazon.awscdk.CloudFormationToken value) {
                this._readCapacityUnits = java.util.Objects.requireNonNull(value, "readCapacityUnits is required");
                return this;
            }
            /**
             * Sets the value of WriteCapacityUnits
             * @param value ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
             * @return {@code this}
             */
            public Builder withWriteCapacityUnits(final java.lang.Number value) {
                this._writeCapacityUnits = java.util.Objects.requireNonNull(value, "writeCapacityUnits is required");
                return this;
            }
            /**
             * Sets the value of WriteCapacityUnits
             * @param value ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
             * @return {@code this}
             */
            public Builder withWriteCapacityUnits(final software.amazon.awscdk.CloudFormationToken value) {
                this._writeCapacityUnits = java.util.Objects.requireNonNull(value, "writeCapacityUnits is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisionedThroughputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ProvisionedThroughputProperty build() {
                return new ProvisionedThroughputProperty() {
                    private java.lang.Object $readCapacityUnits = java.util.Objects.requireNonNull(_readCapacityUnits, "readCapacityUnits is required");
                    private java.lang.Object $writeCapacityUnits = java.util.Objects.requireNonNull(_writeCapacityUnits, "writeCapacityUnits is required");

                    @Override
                    public java.lang.Object getReadCapacityUnits() {
                        return this.$readCapacityUnits;
                    }

                    @Override
                    public void setReadCapacityUnits(final java.lang.Number value) {
                        this.$readCapacityUnits = java.util.Objects.requireNonNull(value, "readCapacityUnits is required");
                    }

                    @Override
                    public void setReadCapacityUnits(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$readCapacityUnits = java.util.Objects.requireNonNull(value, "readCapacityUnits is required");
                    }

                    @Override
                    public java.lang.Object getWriteCapacityUnits() {
                        return this.$writeCapacityUnits;
                    }

                    @Override
                    public void setWriteCapacityUnits(final java.lang.Number value) {
                        this.$writeCapacityUnits = java.util.Objects.requireNonNull(value, "writeCapacityUnits is required");
                    }

                    @Override
                    public void setWriteCapacityUnits(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$writeCapacityUnits = java.util.Objects.requireNonNull(value, "writeCapacityUnits is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProvisionedThroughputProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
             */
            @Override
            public java.lang.Object getReadCapacityUnits() {
                return this.jsiiGet("readCapacityUnits", java.lang.Object.class);
            }

            /**
             * ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
             */
            @Override
            public void setReadCapacityUnits(final java.lang.Number value) {
                this.jsiiSet("readCapacityUnits", java.util.Objects.requireNonNull(value, "readCapacityUnits is required"));
            }

            /**
             * ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
             */
            @Override
            public void setReadCapacityUnits(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("readCapacityUnits", java.util.Objects.requireNonNull(value, "readCapacityUnits is required"));
            }

            /**
             * ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
             */
            @Override
            public java.lang.Object getWriteCapacityUnits() {
                return this.jsiiGet("writeCapacityUnits", java.lang.Object.class);
            }

            /**
             * ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
             */
            @Override
            public void setWriteCapacityUnits(final java.lang.Number value) {
                this.jsiiSet("writeCapacityUnits", java.util.Objects.requireNonNull(value, "writeCapacityUnits is required"));
            }

            /**
             * ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
             */
            @Override
            public void setWriteCapacityUnits(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("writeCapacityUnits", java.util.Objects.requireNonNull(value, "writeCapacityUnits is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html
     */
    public static interface SSESpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.SSESpecificationProperty.SSEEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
         */
        java.lang.Object getSseEnabled();
        /**
         * ``TableResource.SSESpecificationProperty.SSEEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
         */
        void setSseEnabled(final java.lang.Boolean value);
        /**
         * ``TableResource.SSESpecificationProperty.SSEEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
         */
        void setSseEnabled(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link SSESpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SSESpecificationProperty}
         */
        final class Builder {
            private java.lang.Object _sseEnabled;

            /**
             * Sets the value of SseEnabled
             * @param value ``TableResource.SSESpecificationProperty.SSEEnabled``
             * @return {@code this}
             */
            public Builder withSseEnabled(final java.lang.Boolean value) {
                this._sseEnabled = java.util.Objects.requireNonNull(value, "sseEnabled is required");
                return this;
            }
            /**
             * Sets the value of SseEnabled
             * @param value ``TableResource.SSESpecificationProperty.SSEEnabled``
             * @return {@code this}
             */
            public Builder withSseEnabled(final software.amazon.awscdk.CloudFormationToken value) {
                this._sseEnabled = java.util.Objects.requireNonNull(value, "sseEnabled is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SSESpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SSESpecificationProperty build() {
                return new SSESpecificationProperty() {
                    private java.lang.Object $sseEnabled = java.util.Objects.requireNonNull(_sseEnabled, "sseEnabled is required");

                    @Override
                    public java.lang.Object getSseEnabled() {
                        return this.$sseEnabled;
                    }

                    @Override
                    public void setSseEnabled(final java.lang.Boolean value) {
                        this.$sseEnabled = java.util.Objects.requireNonNull(value, "sseEnabled is required");
                    }

                    @Override
                    public void setSseEnabled(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$sseEnabled = java.util.Objects.requireNonNull(value, "sseEnabled is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.SSESpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``TableResource.SSESpecificationProperty.SSEEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
             */
            @Override
            public java.lang.Object getSseEnabled() {
                return this.jsiiGet("sseEnabled", java.lang.Object.class);
            }

            /**
             * ``TableResource.SSESpecificationProperty.SSEEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
             */
            @Override
            public void setSseEnabled(final java.lang.Boolean value) {
                this.jsiiSet("sseEnabled", java.util.Objects.requireNonNull(value, "sseEnabled is required"));
            }

            /**
             * ``TableResource.SSESpecificationProperty.SSEEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
             */
            @Override
            public void setSseEnabled(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("sseEnabled", java.util.Objects.requireNonNull(value, "sseEnabled is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html
     */
    public static interface StreamSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.StreamSpecificationProperty.StreamViewType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
         */
        java.lang.Object getStreamViewType();
        /**
         * ``TableResource.StreamSpecificationProperty.StreamViewType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
         */
        void setStreamViewType(final java.lang.String value);
        /**
         * ``TableResource.StreamSpecificationProperty.StreamViewType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
         */
        void setStreamViewType(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link StreamSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link StreamSpecificationProperty}
         */
        final class Builder {
            private java.lang.Object _streamViewType;

            /**
             * Sets the value of StreamViewType
             * @param value ``TableResource.StreamSpecificationProperty.StreamViewType``
             * @return {@code this}
             */
            public Builder withStreamViewType(final java.lang.String value) {
                this._streamViewType = java.util.Objects.requireNonNull(value, "streamViewType is required");
                return this;
            }
            /**
             * Sets the value of StreamViewType
             * @param value ``TableResource.StreamSpecificationProperty.StreamViewType``
             * @return {@code this}
             */
            public Builder withStreamViewType(final software.amazon.awscdk.CloudFormationToken value) {
                this._streamViewType = java.util.Objects.requireNonNull(value, "streamViewType is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public StreamSpecificationProperty build() {
                return new StreamSpecificationProperty() {
                    private java.lang.Object $streamViewType = java.util.Objects.requireNonNull(_streamViewType, "streamViewType is required");

                    @Override
                    public java.lang.Object getStreamViewType() {
                        return this.$streamViewType;
                    }

                    @Override
                    public void setStreamViewType(final java.lang.String value) {
                        this.$streamViewType = java.util.Objects.requireNonNull(value, "streamViewType is required");
                    }

                    @Override
                    public void setStreamViewType(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$streamViewType = java.util.Objects.requireNonNull(value, "streamViewType is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.StreamSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``TableResource.StreamSpecificationProperty.StreamViewType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
             */
            @Override
            public java.lang.Object getStreamViewType() {
                return this.jsiiGet("streamViewType", java.lang.Object.class);
            }

            /**
             * ``TableResource.StreamSpecificationProperty.StreamViewType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
             */
            @Override
            public void setStreamViewType(final java.lang.String value) {
                this.jsiiSet("streamViewType", java.util.Objects.requireNonNull(value, "streamViewType is required"));
            }

            /**
             * ``TableResource.StreamSpecificationProperty.StreamViewType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
             */
            @Override
            public void setStreamViewType(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("streamViewType", java.util.Objects.requireNonNull(value, "streamViewType is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html
     */
    public static interface TimeToLiveSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
         */
        java.lang.Object getAttributeName();
        /**
         * ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
         */
        void setAttributeName(final java.lang.String value);
        /**
         * ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
         */
        void setAttributeName(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``TableResource.TimeToLiveSpecificationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``TableResource.TimeToLiveSpecificationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``TableResource.TimeToLiveSpecificationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
         */
        void setEnabled(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link TimeToLiveSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TimeToLiveSpecificationProperty}
         */
        final class Builder {
            private java.lang.Object _attributeName;
            private java.lang.Object _enabled;

            /**
             * Sets the value of AttributeName
             * @param value ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
             * @return {@code this}
             */
            public Builder withAttributeName(final java.lang.String value) {
                this._attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                return this;
            }
            /**
             * Sets the value of AttributeName
             * @param value ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
             * @return {@code this}
             */
            public Builder withAttributeName(final software.amazon.awscdk.CloudFormationToken value) {
                this._attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``TableResource.TimeToLiveSpecificationProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(final java.lang.Boolean value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``TableResource.TimeToLiveSpecificationProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(final software.amazon.awscdk.CloudFormationToken value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeToLiveSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TimeToLiveSpecificationProperty build() {
                return new TimeToLiveSpecificationProperty() {
                    private java.lang.Object $attributeName = java.util.Objects.requireNonNull(_attributeName, "attributeName is required");
                    private java.lang.Object $enabled = java.util.Objects.requireNonNull(_enabled, "enabled is required");

                    @Override
                    public java.lang.Object getAttributeName() {
                        return this.$attributeName;
                    }

                    @Override
                    public void setAttributeName(final java.lang.String value) {
                        this.$attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                    }

                    @Override
                    public void setAttributeName(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(final java.lang.Boolean value) {
                        this.$enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                    }

                    @Override
                    public void setEnabled(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.TimeToLiveSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
             */
            @Override
            public java.lang.Object getAttributeName() {
                return this.jsiiGet("attributeName", java.lang.Object.class);
            }

            /**
             * ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
             */
            @Override
            public void setAttributeName(final java.lang.String value) {
                this.jsiiSet("attributeName", java.util.Objects.requireNonNull(value, "attributeName is required"));
            }

            /**
             * ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
             */
            @Override
            public void setAttributeName(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("attributeName", java.util.Objects.requireNonNull(value, "attributeName is required"));
            }

            /**
             * ``TableResource.TimeToLiveSpecificationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
             */
            @Override
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * ``TableResource.TimeToLiveSpecificationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
             */
            @Override
            public void setEnabled(final java.lang.Boolean value) {
                this.jsiiSet("enabled", java.util.Objects.requireNonNull(value, "enabled is required"));
            }

            /**
             * ``TableResource.TimeToLiveSpecificationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
             */
            @Override
            public void setEnabled(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("enabled", java.util.Objects.requireNonNull(value, "enabled is required"));
            }
        }
    }
}
