/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.jsii.JsiiSerializable;

public interface AutoScalingProps
extends JsiiSerializable {
    public Number getMaxCapacity();

    public void setMaxCapacity(Number var1);

    public Number getMinCapacity();

    public void setMinCapacity(Number var1);

    public Number getScaleInCooldown();

    public void setScaleInCooldown(Number var1);

    public Number getScaleOutCooldown();

    public void setScaleOutCooldown(Number var1);

    public Number getTargetValue();

    public void setTargetValue(Number var1);

    public String getScalingPolicyName();

    public void setScalingPolicyName(String var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Number _maxCapacity;
        private Number _minCapacity;
        private Number _scaleInCooldown;
        private Number _scaleOutCooldown;
        private Number _targetValue;
        @Nullable
        private String _scalingPolicyName;

        public Builder withMaxCapacity(Number value) {
            this._maxCapacity = Objects.requireNonNull(value, "maxCapacity is required");
            return this;
        }

        public Builder withMinCapacity(Number value) {
            this._minCapacity = Objects.requireNonNull(value, "minCapacity is required");
            return this;
        }

        public Builder withScaleInCooldown(Number value) {
            this._scaleInCooldown = Objects.requireNonNull(value, "scaleInCooldown is required");
            return this;
        }

        public Builder withScaleOutCooldown(Number value) {
            this._scaleOutCooldown = Objects.requireNonNull(value, "scaleOutCooldown is required");
            return this;
        }

        public Builder withTargetValue(Number value) {
            this._targetValue = Objects.requireNonNull(value, "targetValue is required");
            return this;
        }

        public Builder withScalingPolicyName(@Nullable String value) {
            this._scalingPolicyName = value;
            return this;
        }

        public AutoScalingProps build() {
            return new AutoScalingProps(){
                private Number $maxCapacity;
                private Number $minCapacity;
                private Number $scaleInCooldown;
                private Number $scaleOutCooldown;
                private Number $targetValue;
                @Nullable
                private String $scalingPolicyName;
                {
                    this.$maxCapacity = Objects.requireNonNull(_maxCapacity, "maxCapacity is required");
                    this.$minCapacity = Objects.requireNonNull(_minCapacity, "minCapacity is required");
                    this.$scaleInCooldown = Objects.requireNonNull(_scaleInCooldown, "scaleInCooldown is required");
                    this.$scaleOutCooldown = Objects.requireNonNull(_scaleOutCooldown, "scaleOutCooldown is required");
                    this.$targetValue = Objects.requireNonNull(_targetValue, "targetValue is required");
                    this.$scalingPolicyName = _scalingPolicyName;
                }

                @Override
                public Number getMaxCapacity() {
                    return this.$maxCapacity;
                }

                @Override
                public void setMaxCapacity(Number value) {
                    this.$maxCapacity = Objects.requireNonNull(value, "maxCapacity is required");
                }

                @Override
                public Number getMinCapacity() {
                    return this.$minCapacity;
                }

                @Override
                public void setMinCapacity(Number value) {
                    this.$minCapacity = Objects.requireNonNull(value, "minCapacity is required");
                }

                @Override
                public Number getScaleInCooldown() {
                    return this.$scaleInCooldown;
                }

                @Override
                public void setScaleInCooldown(Number value) {
                    this.$scaleInCooldown = Objects.requireNonNull(value, "scaleInCooldown is required");
                }

                @Override
                public Number getScaleOutCooldown() {
                    return this.$scaleOutCooldown;
                }

                @Override
                public void setScaleOutCooldown(Number value) {
                    this.$scaleOutCooldown = Objects.requireNonNull(value, "scaleOutCooldown is required");
                }

                @Override
                public Number getTargetValue() {
                    return this.$targetValue;
                }

                @Override
                public void setTargetValue(Number value) {
                    this.$targetValue = Objects.requireNonNull(value, "targetValue is required");
                }

                @Override
                public String getScalingPolicyName() {
                    return this.$scalingPolicyName;
                }

                @Override
                public void setScalingPolicyName(@Nullable String value) {
                    this.$scalingPolicyName = value;
                }
            };
        }
    }
}

