package software.amazon.awscdk.services.dynamodb;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.8 (build 100f5ad)", date = "2018-10-26T17:56:37.913Z")
public interface GlobalSecondaryIndexProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.dynamodb.SecondaryIndexProps {
    /**
     * The attribute of a partition key for the global secondary index.
     */
    software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey();
    /**
     * The attribute of a partition key for the global secondary index.
     */
    void setPartitionKey(final software.amazon.awscdk.services.dynamodb.Attribute value);
    /**
     * The read capacity for the global secondary index.
     * @default 5
     */
    java.lang.Number getReadCapacity();
    /**
     * The read capacity for the global secondary index.
     * @default 5
     */
    void setReadCapacity(final java.lang.Number value);
    /**
     * The attribute of a sort key for the global secondary index.
     * @default undefined
     */
    software.amazon.awscdk.services.dynamodb.Attribute getSortKey();
    /**
     * The attribute of a sort key for the global secondary index.
     * @default undefined
     */
    void setSortKey(final software.amazon.awscdk.services.dynamodb.Attribute value);
    /**
     * The write capacity for the global secondary index.
     * @default 5
     */
    java.lang.Number getWriteCapacity();
    /**
     * The write capacity for the global secondary index.
     * @default 5
     */
    void setWriteCapacity(final java.lang.Number value);

    /**
     * @return a {@link Builder} of {@link GlobalSecondaryIndexProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link GlobalSecondaryIndexProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.dynamodb.Attribute _partitionKey;
        @javax.annotation.Nullable
        private java.lang.Number _readCapacity;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.dynamodb.Attribute _sortKey;
        @javax.annotation.Nullable
        private java.lang.Number _writeCapacity;
        private java.lang.String _indexName;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _nonKeyAttributes;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.dynamodb.ProjectionType _projectionType;

        /**
         * Sets the value of PartitionKey
         * @param value The attribute of a partition key for the global secondary index.
         * @return {@code this}
         */
        public Builder withPartitionKey(final software.amazon.awscdk.services.dynamodb.Attribute value) {
            this._partitionKey = java.util.Objects.requireNonNull(value, "partitionKey is required");
            return this;
        }
        /**
         * Sets the value of ReadCapacity
         * @param value The read capacity for the global secondary index.
         * @return {@code this}
         */
        public Builder withReadCapacity(@javax.annotation.Nullable final java.lang.Number value) {
            this._readCapacity = value;
            return this;
        }
        /**
         * Sets the value of SortKey
         * @param value The attribute of a sort key for the global secondary index.
         * @return {@code this}
         */
        public Builder withSortKey(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.Attribute value) {
            this._sortKey = value;
            return this;
        }
        /**
         * Sets the value of WriteCapacity
         * @param value The write capacity for the global secondary index.
         * @return {@code this}
         */
        public Builder withWriteCapacity(@javax.annotation.Nullable final java.lang.Number value) {
            this._writeCapacity = value;
            return this;
        }
        /**
         * Sets the value of IndexName
         * @param value The name of the secondary index.
         * @return {@code this}
         */
        public Builder withIndexName(final java.lang.String value) {
            this._indexName = java.util.Objects.requireNonNull(value, "indexName is required");
            return this;
        }
        /**
         * Sets the value of NonKeyAttributes
         * @param value The non-key attributes that are projected into the secondary index.
         * @return {@code this}
         */
        public Builder withNonKeyAttributes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._nonKeyAttributes = value;
            return this;
        }
        /**
         * Sets the value of ProjectionType
         * @param value The set of attributes that are projected into the secondary index.
         * @return {@code this}
         */
        public Builder withProjectionType(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.ProjectionType value) {
            this._projectionType = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GlobalSecondaryIndexProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public GlobalSecondaryIndexProps build() {
            return new GlobalSecondaryIndexProps() {
                private software.amazon.awscdk.services.dynamodb.Attribute $partitionKey = java.util.Objects.requireNonNull(_partitionKey, "partitionKey is required");
                @javax.annotation.Nullable
                private java.lang.Number $readCapacity = _readCapacity;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.dynamodb.Attribute $sortKey = _sortKey;
                @javax.annotation.Nullable
                private java.lang.Number $writeCapacity = _writeCapacity;
                private java.lang.String $indexName = java.util.Objects.requireNonNull(_indexName, "indexName is required");
                @javax.annotation.Nullable
                private java.util.List<java.lang.String> $nonKeyAttributes = _nonKeyAttributes;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.dynamodb.ProjectionType $projectionType = _projectionType;

                @Override
                public software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey() {
                    return this.$partitionKey;
                }

                @Override
                public void setPartitionKey(final software.amazon.awscdk.services.dynamodb.Attribute value) {
                    this.$partitionKey = java.util.Objects.requireNonNull(value, "partitionKey is required");
                }

                @Override
                public java.lang.Number getReadCapacity() {
                    return this.$readCapacity;
                }

                @Override
                public void setReadCapacity(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$readCapacity = value;
                }

                @Override
                public software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
                    return this.$sortKey;
                }

                @Override
                public void setSortKey(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.Attribute value) {
                    this.$sortKey = value;
                }

                @Override
                public java.lang.Number getWriteCapacity() {
                    return this.$writeCapacity;
                }

                @Override
                public void setWriteCapacity(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$writeCapacity = value;
                }

                @Override
                public java.lang.String getIndexName() {
                    return this.$indexName;
                }

                @Override
                public void setIndexName(final java.lang.String value) {
                    this.$indexName = java.util.Objects.requireNonNull(value, "indexName is required");
                }

                @Override
                public java.util.List<java.lang.String> getNonKeyAttributes() {
                    return this.$nonKeyAttributes;
                }

                @Override
                public void setNonKeyAttributes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                    this.$nonKeyAttributes = value;
                }

                @Override
                public software.amazon.awscdk.services.dynamodb.ProjectionType getProjectionType() {
                    return this.$projectionType;
                }

                @Override
                public void setProjectionType(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.ProjectionType value) {
                    this.$projectionType = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The attribute of a partition key for the global secondary index.
         */
        @Override
        public software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey() {
            return this.jsiiGet("partitionKey", software.amazon.awscdk.services.dynamodb.Attribute.class);
        }

        /**
         * The attribute of a partition key for the global secondary index.
         */
        @Override
        public void setPartitionKey(final software.amazon.awscdk.services.dynamodb.Attribute value) {
            this.jsiiSet("partitionKey", java.util.Objects.requireNonNull(value, "partitionKey is required"));
        }

        /**
         * The read capacity for the global secondary index.
         * @default 5
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getReadCapacity() {
            return this.jsiiGet("readCapacity", java.lang.Number.class);
        }

        /**
         * The read capacity for the global secondary index.
         * @default 5
         */
        @Override
        public void setReadCapacity(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("readCapacity", value);
        }

        /**
         * The attribute of a sort key for the global secondary index.
         * @default undefined
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
            return this.jsiiGet("sortKey", software.amazon.awscdk.services.dynamodb.Attribute.class);
        }

        /**
         * The attribute of a sort key for the global secondary index.
         * @default undefined
         */
        @Override
        public void setSortKey(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.Attribute value) {
            this.jsiiSet("sortKey", value);
        }

        /**
         * The write capacity for the global secondary index.
         * @default 5
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getWriteCapacity() {
            return this.jsiiGet("writeCapacity", java.lang.Number.class);
        }

        /**
         * The write capacity for the global secondary index.
         * @default 5
         */
        @Override
        public void setWriteCapacity(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("writeCapacity", value);
        }

        /**
         * The name of the secondary index.
         */
        @Override
        public java.lang.String getIndexName() {
            return this.jsiiGet("indexName", java.lang.String.class);
        }

        /**
         * The name of the secondary index.
         */
        @Override
        public void setIndexName(final java.lang.String value) {
            this.jsiiSet("indexName", java.util.Objects.requireNonNull(value, "indexName is required"));
        }

        /**
         * The non-key attributes that are projected into the secondary index.
         * @default undefined
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getNonKeyAttributes() {
            return this.jsiiGet("nonKeyAttributes", java.util.List.class);
        }

        /**
         * The non-key attributes that are projected into the secondary index.
         * @default undefined
         */
        @Override
        public void setNonKeyAttributes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("nonKeyAttributes", value);
        }

        /**
         * The set of attributes that are projected into the secondary index.
         * @default ALL
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.dynamodb.ProjectionType getProjectionType() {
            return this.jsiiGet("projectionType", software.amazon.awscdk.services.dynamodb.ProjectionType.class);
        }

        /**
         * The set of attributes that are projected into the secondary index.
         * @default ALL
         */
        @Override
        public void setProjectionType(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.ProjectionType value) {
            this.jsiiSet("projectionType", value);
        }
    }
}
