package software.amazon.awscdk.services.dynamodb;

/**
 * When an item in the table is modified, StreamViewType determines what information
 * is written to the stream for this table. Valid values for StreamViewType are:
 * @link https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_StreamSpecification.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.12 (build 82990c5)", date = "2018-12-13T10:26:21.941Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.StreamViewType")
public enum StreamViewType {
    /**
     * The entire item, as it appears after it was modified, is written to the stream.
     */
    NewImage,
    /**
     * The entire item, as it appeared before it was modified, is written to the stream.
     */
    OldImage,
    /**
     * Both the new and the old item images of the item are written to the stream.
     */
    NewAndOldImages,
    /**
     * Only the key attributes of the modified item are written to the stream.
     */
    KeysOnly,
}
