package software.amazon.awscdk.services.dynamodb;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.13 (build 311bf88)", date = "2019-01-11T10:49:54.192Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.CfnTable")
public class CfnTable extends software.amazon.awscdk.Resource {
    protected CfnTable(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dynamodb.CfnTable.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::DynamoDB::Table``.
     * @param scope scope in which this resource is defined
     * @param id scoped id of the resource
     * @param props resource properties
     */
    public CfnTable(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.dynamodb.CfnTableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.dynamodb.CfnTableProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.dynamodb.CfnTableProps.class);
    }

    /**
     * @cloudformation_attribute Arn
     */
    public java.lang.String getTableArn() {
        return this.jsiiGet("tableArn", java.lang.String.class);
    }

    public java.lang.String getTableName() {
        return this.jsiiGet("tableName", java.lang.String.class);
    }

    /**
     * @cloudformation_attribute StreamArn
     */
    public java.lang.String getTableStreamArn() {
        return this.jsiiGet("tableStreamArn", java.lang.String.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html
     */
    public static interface AttributeDefinitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnTable.AttributeDefinitionProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
         */
        java.lang.String getAttributeName();
        /**
         * ``CfnTable.AttributeDefinitionProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
         */
        void setAttributeName(final java.lang.String value);
        /**
         * ``CfnTable.AttributeDefinitionProperty.AttributeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
         */
        java.lang.String getAttributeType();
        /**
         * ``CfnTable.AttributeDefinitionProperty.AttributeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
         */
        void setAttributeType(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link AttributeDefinitionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AttributeDefinitionProperty}
         */
        final class Builder {
            private java.lang.String _attributeName;
            private java.lang.String _attributeType;

            /**
             * Sets the value of AttributeName
             * @param value ``CfnTable.AttributeDefinitionProperty.AttributeName``
             * @return {@code this}
             */
            public Builder withAttributeName(final java.lang.String value) {
                this._attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                return this;
            }
            /**
             * Sets the value of AttributeType
             * @param value ``CfnTable.AttributeDefinitionProperty.AttributeType``
             * @return {@code this}
             */
            public Builder withAttributeType(final java.lang.String value) {
                this._attributeType = java.util.Objects.requireNonNull(value, "attributeType is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributeDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AttributeDefinitionProperty build() {
                return new AttributeDefinitionProperty() {
                    private java.lang.String $attributeName = java.util.Objects.requireNonNull(_attributeName, "attributeName is required");
                    private java.lang.String $attributeType = java.util.Objects.requireNonNull(_attributeType, "attributeType is required");

                    @Override
                    public java.lang.String getAttributeName() {
                        return this.$attributeName;
                    }

                    @Override
                    public void setAttributeName(final java.lang.String value) {
                        this.$attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                    }

                    @Override
                    public java.lang.String getAttributeType() {
                        return this.$attributeType;
                    }

                    @Override
                    public void setAttributeType(final java.lang.String value) {
                        this.$attributeType = java.util.Objects.requireNonNull(value, "attributeType is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.AttributeDefinitionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnTable.AttributeDefinitionProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
             */
            @Override
            public java.lang.String getAttributeName() {
                return this.jsiiGet("attributeName", java.lang.String.class);
            }

            /**
             * ``CfnTable.AttributeDefinitionProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
             */
            @Override
            public void setAttributeName(final java.lang.String value) {
                this.jsiiSet("attributeName", java.util.Objects.requireNonNull(value, "attributeName is required"));
            }

            /**
             * ``CfnTable.AttributeDefinitionProperty.AttributeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
             */
            @Override
            public java.lang.String getAttributeType() {
                return this.jsiiGet("attributeType", java.lang.String.class);
            }

            /**
             * ``CfnTable.AttributeDefinitionProperty.AttributeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
             */
            @Override
            public void setAttributeType(final java.lang.String value) {
                this.jsiiSet("attributeType", java.util.Objects.requireNonNull(value, "attributeType is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html
     */
    public static interface GlobalSecondaryIndexProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnTable.GlobalSecondaryIndexProperty.IndexName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
         */
        java.lang.String getIndexName();
        /**
         * ``CfnTable.GlobalSecondaryIndexProperty.IndexName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
         */
        void setIndexName(final java.lang.String value);
        /**
         * ``CfnTable.GlobalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
         */
        java.lang.Object getKeySchema();
        /**
         * ``CfnTable.GlobalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
         */
        void setKeySchema(final software.amazon.awscdk.Token value);
        /**
         * ``CfnTable.GlobalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
         */
        void setKeySchema(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnTable.GlobalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
         */
        java.lang.Object getProjection();
        /**
         * ``CfnTable.GlobalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
         */
        void setProjection(final software.amazon.awscdk.Token value);
        /**
         * ``CfnTable.GlobalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
         */
        void setProjection(final software.amazon.awscdk.services.dynamodb.CfnTable.ProjectionProperty value);
        /**
         * ``CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
         */
        java.lang.Object getProvisionedThroughput();
        /**
         * ``CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
         */
        void setProvisionedThroughput(final software.amazon.awscdk.Token value);
        /**
         * ``CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
         */
        void setProvisionedThroughput(final software.amazon.awscdk.services.dynamodb.CfnTable.ProvisionedThroughputProperty value);

        /**
         * @return a {@link Builder} of {@link GlobalSecondaryIndexProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link GlobalSecondaryIndexProperty}
         */
        final class Builder {
            private java.lang.String _indexName;
            private java.lang.Object _keySchema;
            private java.lang.Object _projection;
            @javax.annotation.Nullable
            private java.lang.Object _provisionedThroughput;

            /**
             * Sets the value of IndexName
             * @param value ``CfnTable.GlobalSecondaryIndexProperty.IndexName``
             * @return {@code this}
             */
            public Builder withIndexName(final java.lang.String value) {
                this._indexName = java.util.Objects.requireNonNull(value, "indexName is required");
                return this;
            }
            /**
             * Sets the value of KeySchema
             * @param value ``CfnTable.GlobalSecondaryIndexProperty.KeySchema``
             * @return {@code this}
             */
            public Builder withKeySchema(final software.amazon.awscdk.Token value) {
                this._keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                return this;
            }
            /**
             * Sets the value of KeySchema
             * @param value ``CfnTable.GlobalSecondaryIndexProperty.KeySchema``
             * @return {@code this}
             */
            public Builder withKeySchema(final java.util.List<java.lang.Object> value) {
                this._keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                return this;
            }
            /**
             * Sets the value of Projection
             * @param value ``CfnTable.GlobalSecondaryIndexProperty.Projection``
             * @return {@code this}
             */
            public Builder withProjection(final software.amazon.awscdk.Token value) {
                this._projection = java.util.Objects.requireNonNull(value, "projection is required");
                return this;
            }
            /**
             * Sets the value of Projection
             * @param value ``CfnTable.GlobalSecondaryIndexProperty.Projection``
             * @return {@code this}
             */
            public Builder withProjection(final software.amazon.awscdk.services.dynamodb.CfnTable.ProjectionProperty value) {
                this._projection = java.util.Objects.requireNonNull(value, "projection is required");
                return this;
            }
            /**
             * Sets the value of ProvisionedThroughput
             * @param value ``CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput``
             * @return {@code this}
             */
            public Builder withProvisionedThroughput(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._provisionedThroughput = value;
                return this;
            }
            /**
             * Sets the value of ProvisionedThroughput
             * @param value ``CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput``
             * @return {@code this}
             */
            public Builder withProvisionedThroughput(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.CfnTable.ProvisionedThroughputProperty value) {
                this._provisionedThroughput = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlobalSecondaryIndexProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public GlobalSecondaryIndexProperty build() {
                return new GlobalSecondaryIndexProperty() {
                    private java.lang.String $indexName = java.util.Objects.requireNonNull(_indexName, "indexName is required");
                    private java.lang.Object $keySchema = java.util.Objects.requireNonNull(_keySchema, "keySchema is required");
                    private java.lang.Object $projection = java.util.Objects.requireNonNull(_projection, "projection is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $provisionedThroughput = _provisionedThroughput;

                    @Override
                    public java.lang.String getIndexName() {
                        return this.$indexName;
                    }

                    @Override
                    public void setIndexName(final java.lang.String value) {
                        this.$indexName = java.util.Objects.requireNonNull(value, "indexName is required");
                    }

                    @Override
                    public java.lang.Object getKeySchema() {
                        return this.$keySchema;
                    }

                    @Override
                    public void setKeySchema(final software.amazon.awscdk.Token value) {
                        this.$keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                    }

                    @Override
                    public void setKeySchema(final java.util.List<java.lang.Object> value) {
                        this.$keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                    }

                    @Override
                    public java.lang.Object getProjection() {
                        return this.$projection;
                    }

                    @Override
                    public void setProjection(final software.amazon.awscdk.Token value) {
                        this.$projection = java.util.Objects.requireNonNull(value, "projection is required");
                    }

                    @Override
                    public void setProjection(final software.amazon.awscdk.services.dynamodb.CfnTable.ProjectionProperty value) {
                        this.$projection = java.util.Objects.requireNonNull(value, "projection is required");
                    }

                    @Override
                    public java.lang.Object getProvisionedThroughput() {
                        return this.$provisionedThroughput;
                    }

                    @Override
                    public void setProvisionedThroughput(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$provisionedThroughput = value;
                    }

                    @Override
                    public void setProvisionedThroughput(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.CfnTable.ProvisionedThroughputProperty value) {
                        this.$provisionedThroughput = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.GlobalSecondaryIndexProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnTable.GlobalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
             */
            @Override
            public java.lang.String getIndexName() {
                return this.jsiiGet("indexName", java.lang.String.class);
            }

            /**
             * ``CfnTable.GlobalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
             */
            @Override
            public void setIndexName(final java.lang.String value) {
                this.jsiiSet("indexName", java.util.Objects.requireNonNull(value, "indexName is required"));
            }

            /**
             * ``CfnTable.GlobalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
             */
            @Override
            public java.lang.Object getKeySchema() {
                return this.jsiiGet("keySchema", java.lang.Object.class);
            }

            /**
             * ``CfnTable.GlobalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
             */
            @Override
            public void setKeySchema(final software.amazon.awscdk.Token value) {
                this.jsiiSet("keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
            }

            /**
             * ``CfnTable.GlobalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
             */
            @Override
            public void setKeySchema(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
            }

            /**
             * ``CfnTable.GlobalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
             */
            @Override
            public java.lang.Object getProjection() {
                return this.jsiiGet("projection", java.lang.Object.class);
            }

            /**
             * ``CfnTable.GlobalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
             */
            @Override
            public void setProjection(final software.amazon.awscdk.Token value) {
                this.jsiiSet("projection", java.util.Objects.requireNonNull(value, "projection is required"));
            }

            /**
             * ``CfnTable.GlobalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
             */
            @Override
            public void setProjection(final software.amazon.awscdk.services.dynamodb.CfnTable.ProjectionProperty value) {
                this.jsiiSet("projection", java.util.Objects.requireNonNull(value, "projection is required"));
            }

            /**
             * ``CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getProvisionedThroughput() {
                return this.jsiiGet("provisionedThroughput", java.lang.Object.class);
            }

            /**
             * ``CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
             */
            @Override
            public void setProvisionedThroughput(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("provisionedThroughput", value);
            }

            /**
             * ``CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
             */
            @Override
            public void setProvisionedThroughput(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.CfnTable.ProvisionedThroughputProperty value) {
                this.jsiiSet("provisionedThroughput", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html
     */
    public static interface KeySchemaProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnTable.KeySchemaProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
         */
        java.lang.String getAttributeName();
        /**
         * ``CfnTable.KeySchemaProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
         */
        void setAttributeName(final java.lang.String value);
        /**
         * ``CfnTable.KeySchemaProperty.KeyType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
         */
        java.lang.String getKeyType();
        /**
         * ``CfnTable.KeySchemaProperty.KeyType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
         */
        void setKeyType(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link KeySchemaProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link KeySchemaProperty}
         */
        final class Builder {
            private java.lang.String _attributeName;
            private java.lang.String _keyType;

            /**
             * Sets the value of AttributeName
             * @param value ``CfnTable.KeySchemaProperty.AttributeName``
             * @return {@code this}
             */
            public Builder withAttributeName(final java.lang.String value) {
                this._attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                return this;
            }
            /**
             * Sets the value of KeyType
             * @param value ``CfnTable.KeySchemaProperty.KeyType``
             * @return {@code this}
             */
            public Builder withKeyType(final java.lang.String value) {
                this._keyType = java.util.Objects.requireNonNull(value, "keyType is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeySchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public KeySchemaProperty build() {
                return new KeySchemaProperty() {
                    private java.lang.String $attributeName = java.util.Objects.requireNonNull(_attributeName, "attributeName is required");
                    private java.lang.String $keyType = java.util.Objects.requireNonNull(_keyType, "keyType is required");

                    @Override
                    public java.lang.String getAttributeName() {
                        return this.$attributeName;
                    }

                    @Override
                    public void setAttributeName(final java.lang.String value) {
                        this.$attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                    }

                    @Override
                    public java.lang.String getKeyType() {
                        return this.$keyType;
                    }

                    @Override
                    public void setKeyType(final java.lang.String value) {
                        this.$keyType = java.util.Objects.requireNonNull(value, "keyType is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.KeySchemaProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnTable.KeySchemaProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
             */
            @Override
            public java.lang.String getAttributeName() {
                return this.jsiiGet("attributeName", java.lang.String.class);
            }

            /**
             * ``CfnTable.KeySchemaProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
             */
            @Override
            public void setAttributeName(final java.lang.String value) {
                this.jsiiSet("attributeName", java.util.Objects.requireNonNull(value, "attributeName is required"));
            }

            /**
             * ``CfnTable.KeySchemaProperty.KeyType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
             */
            @Override
            public java.lang.String getKeyType() {
                return this.jsiiGet("keyType", java.lang.String.class);
            }

            /**
             * ``CfnTable.KeySchemaProperty.KeyType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
             */
            @Override
            public void setKeyType(final java.lang.String value) {
                this.jsiiSet("keyType", java.util.Objects.requireNonNull(value, "keyType is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html
     */
    public static interface LocalSecondaryIndexProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnTable.LocalSecondaryIndexProperty.IndexName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
         */
        java.lang.String getIndexName();
        /**
         * ``CfnTable.LocalSecondaryIndexProperty.IndexName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
         */
        void setIndexName(final java.lang.String value);
        /**
         * ``CfnTable.LocalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
         */
        java.lang.Object getKeySchema();
        /**
         * ``CfnTable.LocalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
         */
        void setKeySchema(final software.amazon.awscdk.Token value);
        /**
         * ``CfnTable.LocalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
         */
        void setKeySchema(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnTable.LocalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
         */
        java.lang.Object getProjection();
        /**
         * ``CfnTable.LocalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
         */
        void setProjection(final software.amazon.awscdk.Token value);
        /**
         * ``CfnTable.LocalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
         */
        void setProjection(final software.amazon.awscdk.services.dynamodb.CfnTable.ProjectionProperty value);

        /**
         * @return a {@link Builder} of {@link LocalSecondaryIndexProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LocalSecondaryIndexProperty}
         */
        final class Builder {
            private java.lang.String _indexName;
            private java.lang.Object _keySchema;
            private java.lang.Object _projection;

            /**
             * Sets the value of IndexName
             * @param value ``CfnTable.LocalSecondaryIndexProperty.IndexName``
             * @return {@code this}
             */
            public Builder withIndexName(final java.lang.String value) {
                this._indexName = java.util.Objects.requireNonNull(value, "indexName is required");
                return this;
            }
            /**
             * Sets the value of KeySchema
             * @param value ``CfnTable.LocalSecondaryIndexProperty.KeySchema``
             * @return {@code this}
             */
            public Builder withKeySchema(final software.amazon.awscdk.Token value) {
                this._keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                return this;
            }
            /**
             * Sets the value of KeySchema
             * @param value ``CfnTable.LocalSecondaryIndexProperty.KeySchema``
             * @return {@code this}
             */
            public Builder withKeySchema(final java.util.List<java.lang.Object> value) {
                this._keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                return this;
            }
            /**
             * Sets the value of Projection
             * @param value ``CfnTable.LocalSecondaryIndexProperty.Projection``
             * @return {@code this}
             */
            public Builder withProjection(final software.amazon.awscdk.Token value) {
                this._projection = java.util.Objects.requireNonNull(value, "projection is required");
                return this;
            }
            /**
             * Sets the value of Projection
             * @param value ``CfnTable.LocalSecondaryIndexProperty.Projection``
             * @return {@code this}
             */
            public Builder withProjection(final software.amazon.awscdk.services.dynamodb.CfnTable.ProjectionProperty value) {
                this._projection = java.util.Objects.requireNonNull(value, "projection is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocalSecondaryIndexProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LocalSecondaryIndexProperty build() {
                return new LocalSecondaryIndexProperty() {
                    private java.lang.String $indexName = java.util.Objects.requireNonNull(_indexName, "indexName is required");
                    private java.lang.Object $keySchema = java.util.Objects.requireNonNull(_keySchema, "keySchema is required");
                    private java.lang.Object $projection = java.util.Objects.requireNonNull(_projection, "projection is required");

                    @Override
                    public java.lang.String getIndexName() {
                        return this.$indexName;
                    }

                    @Override
                    public void setIndexName(final java.lang.String value) {
                        this.$indexName = java.util.Objects.requireNonNull(value, "indexName is required");
                    }

                    @Override
                    public java.lang.Object getKeySchema() {
                        return this.$keySchema;
                    }

                    @Override
                    public void setKeySchema(final software.amazon.awscdk.Token value) {
                        this.$keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                    }

                    @Override
                    public void setKeySchema(final java.util.List<java.lang.Object> value) {
                        this.$keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                    }

                    @Override
                    public java.lang.Object getProjection() {
                        return this.$projection;
                    }

                    @Override
                    public void setProjection(final software.amazon.awscdk.Token value) {
                        this.$projection = java.util.Objects.requireNonNull(value, "projection is required");
                    }

                    @Override
                    public void setProjection(final software.amazon.awscdk.services.dynamodb.CfnTable.ProjectionProperty value) {
                        this.$projection = java.util.Objects.requireNonNull(value, "projection is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.LocalSecondaryIndexProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnTable.LocalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
             */
            @Override
            public java.lang.String getIndexName() {
                return this.jsiiGet("indexName", java.lang.String.class);
            }

            /**
             * ``CfnTable.LocalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
             */
            @Override
            public void setIndexName(final java.lang.String value) {
                this.jsiiSet("indexName", java.util.Objects.requireNonNull(value, "indexName is required"));
            }

            /**
             * ``CfnTable.LocalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
             */
            @Override
            public java.lang.Object getKeySchema() {
                return this.jsiiGet("keySchema", java.lang.Object.class);
            }

            /**
             * ``CfnTable.LocalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
             */
            @Override
            public void setKeySchema(final software.amazon.awscdk.Token value) {
                this.jsiiSet("keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
            }

            /**
             * ``CfnTable.LocalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
             */
            @Override
            public void setKeySchema(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
            }

            /**
             * ``CfnTable.LocalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
             */
            @Override
            public java.lang.Object getProjection() {
                return this.jsiiGet("projection", java.lang.Object.class);
            }

            /**
             * ``CfnTable.LocalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
             */
            @Override
            public void setProjection(final software.amazon.awscdk.Token value) {
                this.jsiiSet("projection", java.util.Objects.requireNonNull(value, "projection is required"));
            }

            /**
             * ``CfnTable.LocalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
             */
            @Override
            public void setProjection(final software.amazon.awscdk.services.dynamodb.CfnTable.ProjectionProperty value) {
                this.jsiiSet("projection", java.util.Objects.requireNonNull(value, "projection is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html
     */
    public static interface PointInTimeRecoverySpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
         */
        java.lang.Object getPointInTimeRecoveryEnabled();
        /**
         * ``CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
         */
        void setPointInTimeRecoveryEnabled(final java.lang.Boolean value);
        /**
         * ``CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
         */
        void setPointInTimeRecoveryEnabled(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link PointInTimeRecoverySpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PointInTimeRecoverySpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _pointInTimeRecoveryEnabled;

            /**
             * Sets the value of PointInTimeRecoveryEnabled
             * @param value ``CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
             * @return {@code this}
             */
            public Builder withPointInTimeRecoveryEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._pointInTimeRecoveryEnabled = value;
                return this;
            }
            /**
             * Sets the value of PointInTimeRecoveryEnabled
             * @param value ``CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
             * @return {@code this}
             */
            public Builder withPointInTimeRecoveryEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._pointInTimeRecoveryEnabled = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PointInTimeRecoverySpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PointInTimeRecoverySpecificationProperty build() {
                return new PointInTimeRecoverySpecificationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $pointInTimeRecoveryEnabled = _pointInTimeRecoveryEnabled;

                    @Override
                    public java.lang.Object getPointInTimeRecoveryEnabled() {
                        return this.$pointInTimeRecoveryEnabled;
                    }

                    @Override
                    public void setPointInTimeRecoveryEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$pointInTimeRecoveryEnabled = value;
                    }

                    @Override
                    public void setPointInTimeRecoveryEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$pointInTimeRecoveryEnabled = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.PointInTimeRecoverySpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPointInTimeRecoveryEnabled() {
                return this.jsiiGet("pointInTimeRecoveryEnabled", java.lang.Object.class);
            }

            /**
             * ``CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
             */
            @Override
            public void setPointInTimeRecoveryEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("pointInTimeRecoveryEnabled", value);
            }

            /**
             * ``CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
             */
            @Override
            public void setPointInTimeRecoveryEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("pointInTimeRecoveryEnabled", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html
     */
    public static interface ProjectionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnTable.ProjectionProperty.NonKeyAttributes``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
         */
        java.lang.Object getNonKeyAttributes();
        /**
         * ``CfnTable.ProjectionProperty.NonKeyAttributes``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
         */
        void setNonKeyAttributes(final software.amazon.awscdk.Token value);
        /**
         * ``CfnTable.ProjectionProperty.NonKeyAttributes``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
         */
        void setNonKeyAttributes(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnTable.ProjectionProperty.ProjectionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
         */
        java.lang.String getProjectionType();
        /**
         * ``CfnTable.ProjectionProperty.ProjectionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
         */
        void setProjectionType(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link ProjectionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ProjectionProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _nonKeyAttributes;
            @javax.annotation.Nullable
            private java.lang.String _projectionType;

            /**
             * Sets the value of NonKeyAttributes
             * @param value ``CfnTable.ProjectionProperty.NonKeyAttributes``
             * @return {@code this}
             */
            public Builder withNonKeyAttributes(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._nonKeyAttributes = value;
                return this;
            }
            /**
             * Sets the value of NonKeyAttributes
             * @param value ``CfnTable.ProjectionProperty.NonKeyAttributes``
             * @return {@code this}
             */
            public Builder withNonKeyAttributes(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._nonKeyAttributes = value;
                return this;
            }
            /**
             * Sets the value of ProjectionType
             * @param value ``CfnTable.ProjectionProperty.ProjectionType``
             * @return {@code this}
             */
            public Builder withProjectionType(@javax.annotation.Nullable final java.lang.String value) {
                this._projectionType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ProjectionProperty build() {
                return new ProjectionProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $nonKeyAttributes = _nonKeyAttributes;
                    @javax.annotation.Nullable
                    private java.lang.String $projectionType = _projectionType;

                    @Override
                    public java.lang.Object getNonKeyAttributes() {
                        return this.$nonKeyAttributes;
                    }

                    @Override
                    public void setNonKeyAttributes(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$nonKeyAttributes = value;
                    }

                    @Override
                    public void setNonKeyAttributes(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$nonKeyAttributes = value;
                    }

                    @Override
                    public java.lang.String getProjectionType() {
                        return this.$projectionType;
                    }

                    @Override
                    public void setProjectionType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$projectionType = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.ProjectionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnTable.ProjectionProperty.NonKeyAttributes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNonKeyAttributes() {
                return this.jsiiGet("nonKeyAttributes", java.lang.Object.class);
            }

            /**
             * ``CfnTable.ProjectionProperty.NonKeyAttributes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
             */
            @Override
            public void setNonKeyAttributes(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("nonKeyAttributes", value);
            }

            /**
             * ``CfnTable.ProjectionProperty.NonKeyAttributes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
             */
            @Override
            public void setNonKeyAttributes(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("nonKeyAttributes", value);
            }

            /**
             * ``CfnTable.ProjectionProperty.ProjectionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getProjectionType() {
                return this.jsiiGet("projectionType", java.lang.String.class);
            }

            /**
             * ``CfnTable.ProjectionProperty.ProjectionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
             */
            @Override
            public void setProjectionType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("projectionType", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     */
    public static interface ProvisionedThroughputProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
         */
        java.lang.Object getReadCapacityUnits();
        /**
         * ``CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
         */
        void setReadCapacityUnits(final java.lang.Number value);
        /**
         * ``CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
         */
        void setReadCapacityUnits(final software.amazon.awscdk.Token value);
        /**
         * ``CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
         */
        java.lang.Object getWriteCapacityUnits();
        /**
         * ``CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
         */
        void setWriteCapacityUnits(final java.lang.Number value);
        /**
         * ``CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
         */
        void setWriteCapacityUnits(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link ProvisionedThroughputProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ProvisionedThroughputProperty}
         */
        final class Builder {
            private java.lang.Object _readCapacityUnits;
            private java.lang.Object _writeCapacityUnits;

            /**
             * Sets the value of ReadCapacityUnits
             * @param value ``CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits``
             * @return {@code this}
             */
            public Builder withReadCapacityUnits(final java.lang.Number value) {
                this._readCapacityUnits = java.util.Objects.requireNonNull(value, "readCapacityUnits is required");
                return this;
            }
            /**
             * Sets the value of ReadCapacityUnits
             * @param value ``CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits``
             * @return {@code this}
             */
            public Builder withReadCapacityUnits(final software.amazon.awscdk.Token value) {
                this._readCapacityUnits = java.util.Objects.requireNonNull(value, "readCapacityUnits is required");
                return this;
            }
            /**
             * Sets the value of WriteCapacityUnits
             * @param value ``CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits``
             * @return {@code this}
             */
            public Builder withWriteCapacityUnits(final java.lang.Number value) {
                this._writeCapacityUnits = java.util.Objects.requireNonNull(value, "writeCapacityUnits is required");
                return this;
            }
            /**
             * Sets the value of WriteCapacityUnits
             * @param value ``CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits``
             * @return {@code this}
             */
            public Builder withWriteCapacityUnits(final software.amazon.awscdk.Token value) {
                this._writeCapacityUnits = java.util.Objects.requireNonNull(value, "writeCapacityUnits is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisionedThroughputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ProvisionedThroughputProperty build() {
                return new ProvisionedThroughputProperty() {
                    private java.lang.Object $readCapacityUnits = java.util.Objects.requireNonNull(_readCapacityUnits, "readCapacityUnits is required");
                    private java.lang.Object $writeCapacityUnits = java.util.Objects.requireNonNull(_writeCapacityUnits, "writeCapacityUnits is required");

                    @Override
                    public java.lang.Object getReadCapacityUnits() {
                        return this.$readCapacityUnits;
                    }

                    @Override
                    public void setReadCapacityUnits(final java.lang.Number value) {
                        this.$readCapacityUnits = java.util.Objects.requireNonNull(value, "readCapacityUnits is required");
                    }

                    @Override
                    public void setReadCapacityUnits(final software.amazon.awscdk.Token value) {
                        this.$readCapacityUnits = java.util.Objects.requireNonNull(value, "readCapacityUnits is required");
                    }

                    @Override
                    public java.lang.Object getWriteCapacityUnits() {
                        return this.$writeCapacityUnits;
                    }

                    @Override
                    public void setWriteCapacityUnits(final java.lang.Number value) {
                        this.$writeCapacityUnits = java.util.Objects.requireNonNull(value, "writeCapacityUnits is required");
                    }

                    @Override
                    public void setWriteCapacityUnits(final software.amazon.awscdk.Token value) {
                        this.$writeCapacityUnits = java.util.Objects.requireNonNull(value, "writeCapacityUnits is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.ProvisionedThroughputProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
             */
            @Override
            public java.lang.Object getReadCapacityUnits() {
                return this.jsiiGet("readCapacityUnits", java.lang.Object.class);
            }

            /**
             * ``CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
             */
            @Override
            public void setReadCapacityUnits(final java.lang.Number value) {
                this.jsiiSet("readCapacityUnits", java.util.Objects.requireNonNull(value, "readCapacityUnits is required"));
            }

            /**
             * ``CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
             */
            @Override
            public void setReadCapacityUnits(final software.amazon.awscdk.Token value) {
                this.jsiiSet("readCapacityUnits", java.util.Objects.requireNonNull(value, "readCapacityUnits is required"));
            }

            /**
             * ``CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
             */
            @Override
            public java.lang.Object getWriteCapacityUnits() {
                return this.jsiiGet("writeCapacityUnits", java.lang.Object.class);
            }

            /**
             * ``CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
             */
            @Override
            public void setWriteCapacityUnits(final java.lang.Number value) {
                this.jsiiSet("writeCapacityUnits", java.util.Objects.requireNonNull(value, "writeCapacityUnits is required"));
            }

            /**
             * ``CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
             */
            @Override
            public void setWriteCapacityUnits(final software.amazon.awscdk.Token value) {
                this.jsiiSet("writeCapacityUnits", java.util.Objects.requireNonNull(value, "writeCapacityUnits is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html
     */
    public static interface SSESpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnTable.SSESpecificationProperty.SSEEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
         */
        java.lang.Object getSseEnabled();
        /**
         * ``CfnTable.SSESpecificationProperty.SSEEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
         */
        void setSseEnabled(final java.lang.Boolean value);
        /**
         * ``CfnTable.SSESpecificationProperty.SSEEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
         */
        void setSseEnabled(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link SSESpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SSESpecificationProperty}
         */
        final class Builder {
            private java.lang.Object _sseEnabled;

            /**
             * Sets the value of SseEnabled
             * @param value ``CfnTable.SSESpecificationProperty.SSEEnabled``
             * @return {@code this}
             */
            public Builder withSseEnabled(final java.lang.Boolean value) {
                this._sseEnabled = java.util.Objects.requireNonNull(value, "sseEnabled is required");
                return this;
            }
            /**
             * Sets the value of SseEnabled
             * @param value ``CfnTable.SSESpecificationProperty.SSEEnabled``
             * @return {@code this}
             */
            public Builder withSseEnabled(final software.amazon.awscdk.Token value) {
                this._sseEnabled = java.util.Objects.requireNonNull(value, "sseEnabled is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SSESpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SSESpecificationProperty build() {
                return new SSESpecificationProperty() {
                    private java.lang.Object $sseEnabled = java.util.Objects.requireNonNull(_sseEnabled, "sseEnabled is required");

                    @Override
                    public java.lang.Object getSseEnabled() {
                        return this.$sseEnabled;
                    }

                    @Override
                    public void setSseEnabled(final java.lang.Boolean value) {
                        this.$sseEnabled = java.util.Objects.requireNonNull(value, "sseEnabled is required");
                    }

                    @Override
                    public void setSseEnabled(final software.amazon.awscdk.Token value) {
                        this.$sseEnabled = java.util.Objects.requireNonNull(value, "sseEnabled is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.SSESpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnTable.SSESpecificationProperty.SSEEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
             */
            @Override
            public java.lang.Object getSseEnabled() {
                return this.jsiiGet("sseEnabled", java.lang.Object.class);
            }

            /**
             * ``CfnTable.SSESpecificationProperty.SSEEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
             */
            @Override
            public void setSseEnabled(final java.lang.Boolean value) {
                this.jsiiSet("sseEnabled", java.util.Objects.requireNonNull(value, "sseEnabled is required"));
            }

            /**
             * ``CfnTable.SSESpecificationProperty.SSEEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
             */
            @Override
            public void setSseEnabled(final software.amazon.awscdk.Token value) {
                this.jsiiSet("sseEnabled", java.util.Objects.requireNonNull(value, "sseEnabled is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html
     */
    public static interface StreamSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnTable.StreamSpecificationProperty.StreamViewType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
         */
        java.lang.String getStreamViewType();
        /**
         * ``CfnTable.StreamSpecificationProperty.StreamViewType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
         */
        void setStreamViewType(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link StreamSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link StreamSpecificationProperty}
         */
        final class Builder {
            private java.lang.String _streamViewType;

            /**
             * Sets the value of StreamViewType
             * @param value ``CfnTable.StreamSpecificationProperty.StreamViewType``
             * @return {@code this}
             */
            public Builder withStreamViewType(final java.lang.String value) {
                this._streamViewType = java.util.Objects.requireNonNull(value, "streamViewType is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public StreamSpecificationProperty build() {
                return new StreamSpecificationProperty() {
                    private java.lang.String $streamViewType = java.util.Objects.requireNonNull(_streamViewType, "streamViewType is required");

                    @Override
                    public java.lang.String getStreamViewType() {
                        return this.$streamViewType;
                    }

                    @Override
                    public void setStreamViewType(final java.lang.String value) {
                        this.$streamViewType = java.util.Objects.requireNonNull(value, "streamViewType is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.StreamSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnTable.StreamSpecificationProperty.StreamViewType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
             */
            @Override
            public java.lang.String getStreamViewType() {
                return this.jsiiGet("streamViewType", java.lang.String.class);
            }

            /**
             * ``CfnTable.StreamSpecificationProperty.StreamViewType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
             */
            @Override
            public void setStreamViewType(final java.lang.String value) {
                this.jsiiSet("streamViewType", java.util.Objects.requireNonNull(value, "streamViewType is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html
     */
    public static interface TimeToLiveSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnTable.TimeToLiveSpecificationProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
         */
        java.lang.String getAttributeName();
        /**
         * ``CfnTable.TimeToLiveSpecificationProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
         */
        void setAttributeName(final java.lang.String value);
        /**
         * ``CfnTable.TimeToLiveSpecificationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``CfnTable.TimeToLiveSpecificationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``CfnTable.TimeToLiveSpecificationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link TimeToLiveSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TimeToLiveSpecificationProperty}
         */
        final class Builder {
            private java.lang.String _attributeName;
            private java.lang.Object _enabled;

            /**
             * Sets the value of AttributeName
             * @param value ``CfnTable.TimeToLiveSpecificationProperty.AttributeName``
             * @return {@code this}
             */
            public Builder withAttributeName(final java.lang.String value) {
                this._attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``CfnTable.TimeToLiveSpecificationProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(final java.lang.Boolean value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``CfnTable.TimeToLiveSpecificationProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(final software.amazon.awscdk.Token value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeToLiveSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TimeToLiveSpecificationProperty build() {
                return new TimeToLiveSpecificationProperty() {
                    private java.lang.String $attributeName = java.util.Objects.requireNonNull(_attributeName, "attributeName is required");
                    private java.lang.Object $enabled = java.util.Objects.requireNonNull(_enabled, "enabled is required");

                    @Override
                    public java.lang.String getAttributeName() {
                        return this.$attributeName;
                    }

                    @Override
                    public void setAttributeName(final java.lang.String value) {
                        this.$attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(final java.lang.Boolean value) {
                        this.$enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                    }

                    @Override
                    public void setEnabled(final software.amazon.awscdk.Token value) {
                        this.$enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.TimeToLiveSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnTable.TimeToLiveSpecificationProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
             */
            @Override
            public java.lang.String getAttributeName() {
                return this.jsiiGet("attributeName", java.lang.String.class);
            }

            /**
             * ``CfnTable.TimeToLiveSpecificationProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
             */
            @Override
            public void setAttributeName(final java.lang.String value) {
                this.jsiiSet("attributeName", java.util.Objects.requireNonNull(value, "attributeName is required"));
            }

            /**
             * ``CfnTable.TimeToLiveSpecificationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
             */
            @Override
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * ``CfnTable.TimeToLiveSpecificationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
             */
            @Override
            public void setEnabled(final java.lang.Boolean value) {
                this.jsiiSet("enabled", java.util.Objects.requireNonNull(value, "enabled is required"));
            }

            /**
             * ``CfnTable.TimeToLiveSpecificationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
             */
            @Override
            public void setEnabled(final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", java.util.Objects.requireNonNull(value, "enabled is required"));
            }
        }
    }
}
