package software.amazon.awscdk.services.dynamodb;

/**
 * Provides a DynamoDB table.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.13 (build 311bf88)", date = "2019-01-11T10:49:54.206Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.Table")
public class Table extends software.amazon.awscdk.Construct {
    protected Table(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Table(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.TableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(props)).toArray());
    }
    public Table(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))).toArray());
    }

    /**
     * Add a global secondary index of table.
     * @param props the property of global secondary index
     */
    public void addGlobalSecondaryIndex(final software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexProps props) {
        this.jsiiCall("addGlobalSecondaryIndex", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required")).toArray());
    }

    /**
     * Add a local secondary index of table.
     * @param props the property of local secondary index
     */
    public void addLocalSecondaryIndex(final software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps props) {
        this.jsiiCall("addLocalSecondaryIndex", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required")).toArray());
    }

    /**
     * Add a partition key of table.
     * @return a reference to this object so that method calls can be chained together
     * @param attribute the partition key attribute of table
     */
    public software.amazon.awscdk.services.dynamodb.Table addPartitionKey(final software.amazon.awscdk.services.dynamodb.Attribute attribute) {
        return this.jsiiCall("addPartitionKey", software.amazon.awscdk.services.dynamodb.Table.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(attribute, "attribute is required")).toArray());
    }

    /**
     * Add a sort key of table.
     * @return a reference to this object so that method calls can be chained together
     * @param attribute the sort key of table
     */
    public software.amazon.awscdk.services.dynamodb.Table addSortKey(final software.amazon.awscdk.services.dynamodb.Attribute attribute) {
        return this.jsiiCall("addSortKey", software.amazon.awscdk.services.dynamodb.Table.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(attribute, "attribute is required")).toArray());
    }

    /**
     * Enable read capacity scaling for the given GSI
     * @return An object to configure additional AutoScaling settings for this attribute
     */
    public software.amazon.awscdk.services.dynamodb.IScalableTableAttribute autoScaleGlobalSecondaryIndexReadCapacity(final java.lang.String indexName, final software.amazon.awscdk.services.dynamodb.EnableScalingProps props) {
        return this.jsiiCall("autoScaleGlobalSecondaryIndexReadCapacity", software.amazon.awscdk.services.dynamodb.IScalableTableAttribute.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(indexName, "indexName is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Enable write capacity scaling for the given GSI
     * @return An object to configure additional AutoScaling settings for this attribute
     */
    public software.amazon.awscdk.services.dynamodb.IScalableTableAttribute autoScaleGlobalSecondaryIndexWriteCapacity(final java.lang.String indexName, final software.amazon.awscdk.services.dynamodb.EnableScalingProps props) {
        return this.jsiiCall("autoScaleGlobalSecondaryIndexWriteCapacity", software.amazon.awscdk.services.dynamodb.IScalableTableAttribute.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(indexName, "indexName is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Enable read capacity scaling for this table
     * @return An object to configure additional AutoScaling settings
     */
    public software.amazon.awscdk.services.dynamodb.IScalableTableAttribute autoScaleReadCapacity(final software.amazon.awscdk.services.dynamodb.EnableScalingProps props) {
        return this.jsiiCall("autoScaleReadCapacity", software.amazon.awscdk.services.dynamodb.IScalableTableAttribute.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required")).toArray());
    }

    /**
     * Enable write capacity scaling for this table
     * @return An object to configure additional AutoScaling settings for this attribute
     */
    public software.amazon.awscdk.services.dynamodb.IScalableTableAttribute autoScaleWriteCapacity(final software.amazon.awscdk.services.dynamodb.EnableScalingProps props) {
        return this.jsiiCall("autoScaleWriteCapacity", software.amazon.awscdk.services.dynamodb.IScalableTableAttribute.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required")).toArray());
    }

    /**
     * Adds an IAM policy statement associated with this table to an IAM
     * principal's policy.
     * @param principal The principal (no-op if undefined)
     * @param actions The set of actions to allow (i.e. "dynamodb:PutItem", "dynamodb:GetItem", ...)
     */
    public void grant(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal principal, final java.lang.String... actions) {
        this.jsiiCall("grant", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(principal), java.util.Arrays.stream(java.util.Objects.requireNonNull(actions, "actions is required"))).toArray());
    }

    /**
     * Permits all DynamoDB operations ("dynamodb:*") to an IAM principal.
     * @param principal The principal to grant access to
     */
    public void grantFullAccess(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal principal) {
        this.jsiiCall("grantFullAccess", Void.class, java.util.stream.Stream.of(principal).toArray());
    }

    /**
     * Permits all DynamoDB operations ("dynamodb:*") to an IAM principal.
     */
    public void grantFullAccess() {
        this.jsiiCall("grantFullAccess", Void.class);
    }

    /**
     * Permits an IAM principal all data read operations from this table:
     * BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan.
     * @param principal The principal to grant access to
     */
    public void grantReadData(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal principal) {
        this.jsiiCall("grantReadData", Void.class, java.util.stream.Stream.of(principal).toArray());
    }

    /**
     * Permits an IAM principal all data read operations from this table:
     * BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan.
     */
    public void grantReadData() {
        this.jsiiCall("grantReadData", Void.class);
    }

    /**
     * Permits an IAM principal to all data read/write operations to this table.
     * BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan,
     * BatchWriteItem, PutItem, UpdateItem, DeleteItem
     * @param principal The principal to grant access to
     */
    public void grantReadWriteData(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal principal) {
        this.jsiiCall("grantReadWriteData", Void.class, java.util.stream.Stream.of(principal).toArray());
    }

    /**
     * Permits an IAM principal to all data read/write operations to this table.
     * BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan,
     * BatchWriteItem, PutItem, UpdateItem, DeleteItem
     */
    public void grantReadWriteData() {
        this.jsiiCall("grantReadWriteData", Void.class);
    }

    /**
     * Permits an IAM principal all data write operations to this table:
     * BatchWriteItem, PutItem, UpdateItem, DeleteItem.
     * @param principal The principal to grant access to
     */
    public void grantWriteData(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal principal) {
        this.jsiiCall("grantWriteData", Void.class, java.util.stream.Stream.of(principal).toArray());
    }

    /**
     * Permits an IAM principal all data write operations to this table:
     * BatchWriteItem, PutItem, UpdateItem, DeleteItem.
     */
    public void grantWriteData() {
        this.jsiiCall("grantWriteData", Void.class);
    }

    /**
     * Validate the table construct.
     * @return an array of validation error message
     */
    @Override
    protected java.util.List<java.lang.String> validate() {
        return this.jsiiCall("validate", java.util.List.class);
    }

    public java.lang.String getTableArn() {
        return this.jsiiGet("tableArn", java.lang.String.class);
    }

    public java.lang.String getTableName() {
        return this.jsiiGet("tableName", java.lang.String.class);
    }

    public java.lang.String getTableStreamArn() {
        return this.jsiiGet("tableStreamArn", java.lang.String.class);
    }
}
