package software.amazon.awscdk.services.dynamodb;

/**
 * Properties for enabling DynamoDB utilization tracking
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-05T00:11:04.456Z")
public interface UtilizationScalingProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.applicationautoscaling.BaseTargetTrackingProps {
    /**
     * Target utilization percentage for the attribute
     */
    java.lang.Number getTargetUtilizationPercent();
    /**
     * Target utilization percentage for the attribute
     */
    void setTargetUtilizationPercent(final java.lang.Number value);

    /**
     * @return a {@link Builder} of {@link UtilizationScalingProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link UtilizationScalingProps}
     */
    final class Builder {
        private java.lang.Number _targetUtilizationPercent;
        @javax.annotation.Nullable
        private java.lang.Boolean _disableScaleIn;
        @javax.annotation.Nullable
        private java.lang.String _policyName;
        @javax.annotation.Nullable
        private java.lang.Number _scaleInCooldownSec;
        @javax.annotation.Nullable
        private java.lang.Number _scaleOutCooldownSec;

        /**
         * Sets the value of TargetUtilizationPercent
         * @param value Target utilization percentage for the attribute
         * @return {@code this}
         */
        public Builder withTargetUtilizationPercent(final java.lang.Number value) {
            this._targetUtilizationPercent = java.util.Objects.requireNonNull(value, "targetUtilizationPercent is required");
            return this;
        }
        /**
         * Sets the value of DisableScaleIn
         * @param value Indicates whether scale in by the target tracking policy is disabled.

If the value is true, scale in is disabled and the target tracking policy
won't remove capacity from the scalable resource. Otherwise, scale in is
enabled and the target tracking policy can remove capacity from the
scalable resource.
         * @return {@code this}
         */
        public Builder withDisableScaleIn(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._disableScaleIn = value;
            return this;
        }
        /**
         * Sets the value of PolicyName
         * @param value A name for the scaling policy
         * @return {@code this}
         */
        public Builder withPolicyName(@javax.annotation.Nullable final java.lang.String value) {
            this._policyName = value;
            return this;
        }
        /**
         * Sets the value of ScaleInCooldownSec
         * @param value Period after a scale in activity completes before another scale in activity can start.
         * @return {@code this}
         */
        public Builder withScaleInCooldownSec(@javax.annotation.Nullable final java.lang.Number value) {
            this._scaleInCooldownSec = value;
            return this;
        }
        /**
         * Sets the value of ScaleOutCooldownSec
         * @param value Period after a scale out activity completes before another scale out activity can start.
         * @return {@code this}
         */
        public Builder withScaleOutCooldownSec(@javax.annotation.Nullable final java.lang.Number value) {
            this._scaleOutCooldownSec = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UtilizationScalingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public UtilizationScalingProps build() {
            return new UtilizationScalingProps() {
                private java.lang.Number $targetUtilizationPercent = java.util.Objects.requireNonNull(_targetUtilizationPercent, "targetUtilizationPercent is required");
                @javax.annotation.Nullable
                private java.lang.Boolean $disableScaleIn = _disableScaleIn;
                @javax.annotation.Nullable
                private java.lang.String $policyName = _policyName;
                @javax.annotation.Nullable
                private java.lang.Number $scaleInCooldownSec = _scaleInCooldownSec;
                @javax.annotation.Nullable
                private java.lang.Number $scaleOutCooldownSec = _scaleOutCooldownSec;

                @Override
                public java.lang.Number getTargetUtilizationPercent() {
                    return this.$targetUtilizationPercent;
                }

                @Override
                public void setTargetUtilizationPercent(final java.lang.Number value) {
                    this.$targetUtilizationPercent = java.util.Objects.requireNonNull(value, "targetUtilizationPercent is required");
                }

                @Override
                public java.lang.Boolean getDisableScaleIn() {
                    return this.$disableScaleIn;
                }

                @Override
                public void setDisableScaleIn(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$disableScaleIn = value;
                }

                @Override
                public java.lang.String getPolicyName() {
                    return this.$policyName;
                }

                @Override
                public void setPolicyName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$policyName = value;
                }

                @Override
                public java.lang.Number getScaleInCooldownSec() {
                    return this.$scaleInCooldownSec;
                }

                @Override
                public void setScaleInCooldownSec(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$scaleInCooldownSec = value;
                }

                @Override
                public java.lang.Number getScaleOutCooldownSec() {
                    return this.$scaleOutCooldownSec;
                }

                @Override
                public void setScaleOutCooldownSec(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$scaleOutCooldownSec = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.UtilizationScalingProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Target utilization percentage for the attribute
         */
        @Override
        public java.lang.Number getTargetUtilizationPercent() {
            return this.jsiiGet("targetUtilizationPercent", java.lang.Number.class);
        }

        /**
         * Target utilization percentage for the attribute
         */
        @Override
        public void setTargetUtilizationPercent(final java.lang.Number value) {
            this.jsiiSet("targetUtilizationPercent", java.util.Objects.requireNonNull(value, "targetUtilizationPercent is required"));
        }

        /**
         * Indicates whether scale in by the target tracking policy is disabled.
         * 
         * If the value is true, scale in is disabled and the target tracking policy
         * won't remove capacity from the scalable resource. Otherwise, scale in is
         * enabled and the target tracking policy can remove capacity from the
         * scalable resource.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getDisableScaleIn() {
            return this.jsiiGet("disableScaleIn", java.lang.Boolean.class);
        }

        /**
         * Indicates whether scale in by the target tracking policy is disabled.
         * 
         * If the value is true, scale in is disabled and the target tracking policy
         * won't remove capacity from the scalable resource. Otherwise, scale in is
         * enabled and the target tracking policy can remove capacity from the
         * scalable resource.
         * @default false
         */
        @Override
        public void setDisableScaleIn(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("disableScaleIn", value);
        }

        /**
         * A name for the scaling policy
         * @default Automatically generated name
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPolicyName() {
            return this.jsiiGet("policyName", java.lang.String.class);
        }

        /**
         * A name for the scaling policy
         * @default Automatically generated name
         */
        @Override
        public void setPolicyName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("policyName", value);
        }

        /**
         * Period after a scale in activity completes before another scale in activity can start.
         * @default No scale in cooldown
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getScaleInCooldownSec() {
            return this.jsiiGet("scaleInCooldownSec", java.lang.Number.class);
        }

        /**
         * Period after a scale in activity completes before another scale in activity can start.
         * @default No scale in cooldown
         */
        @Override
        public void setScaleInCooldownSec(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("scaleInCooldownSec", value);
        }

        /**
         * Period after a scale out activity completes before another scale out activity can start.
         * @default No scale out cooldown
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getScaleOutCooldownSec() {
            return this.jsiiGet("scaleOutCooldownSec", java.lang.Number.class);
        }

        /**
         * Period after a scale out activity completes before another scale out activity can start.
         * @default No scale out cooldown
         */
        @Override
        public void setScaleOutCooldownSec(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("scaleOutCooldownSec", value);
        }
    }
}
