package software.amazon.awscdk.services.dynamodb;

/**
 * @cloudformationResource AWS::DynamoDB::Table
 * A CloudFormation `AWS::DynamoDB::Table`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-04-04T15:06:48.466Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.CfnTable")
public class CfnTable extends software.amazon.awscdk.CfnResource {
    protected CfnTable(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dynamodb.CfnTable.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::DynamoDB::Table`.
     * @param scope - scope in which this resource is defined
     * @param id - scoped id of the resource
     * @param props - resource properties
     */
    public CfnTable(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.dynamodb.CfnTableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.dynamodb.CfnTableProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.dynamodb.CfnTableProps.class);
    }

    /**
     * @cloudformationAttribute Arn
     */
    public java.lang.String getTableArn() {
        return this.jsiiGet("tableArn", java.lang.String.class);
    }

    public java.lang.String getTableName() {
        return this.jsiiGet("tableName", java.lang.String.class);
    }

    /**
     * @cloudformationAttribute StreamArn
     */
    public java.lang.String getTableStreamArn() {
        return this.jsiiGet("tableStreamArn", java.lang.String.class);
    }

    /**
     * The `TagManager` handles setting, removing and formatting tags
     * 
     * Tags should be managed either passing them as properties during
     * initiation or by calling methods on this object. If both techniques are
     * used only the tags from the TagManager will be used. `Tag` (aspect)
     * will use the manager.
     */
    public software.amazon.awscdk.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.TagManager.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html
     */
    public static interface AttributeDefinitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnTable.AttributeDefinitionProperty.AttributeName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
         */
        java.lang.String getAttributeName();
        /**
         * `CfnTable.AttributeDefinitionProperty.AttributeType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
         */
        java.lang.String getAttributeType();

        /**
         * @return a {@link Builder} of {@link AttributeDefinitionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AttributeDefinitionProperty}
         */
        final class Builder {
            private java.lang.String _attributeName;
            private java.lang.String _attributeType;

            /**
             * Sets the value of AttributeName
             * @param value `CfnTable.AttributeDefinitionProperty.AttributeName`
             * @return {@code this}
             */
            public Builder withAttributeName(final java.lang.String value) {
                this._attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                return this;
            }
            /**
             * Sets the value of AttributeType
             * @param value `CfnTable.AttributeDefinitionProperty.AttributeType`
             * @return {@code this}
             */
            public Builder withAttributeType(final java.lang.String value) {
                this._attributeType = java.util.Objects.requireNonNull(value, "attributeType is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributeDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AttributeDefinitionProperty build() {
                return new AttributeDefinitionProperty() {
                    private final java.lang.String $attributeName = java.util.Objects.requireNonNull(_attributeName, "attributeName is required");
                    private final java.lang.String $attributeType = java.util.Objects.requireNonNull(_attributeType, "attributeType is required");

                    @Override
                    public java.lang.String getAttributeName() {
                        return this.$attributeName;
                    }

                    @Override
                    public java.lang.String getAttributeType() {
                        return this.$attributeType;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("attributeName", om.valueToTree(this.getAttributeName()));
                        obj.set("attributeType", om.valueToTree(this.getAttributeType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.AttributeDefinitionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnTable.AttributeDefinitionProperty.AttributeName`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
             */
            @Override
            public java.lang.String getAttributeName() {
                return this.jsiiGet("attributeName", java.lang.String.class);
            }

            /**
             * `CfnTable.AttributeDefinitionProperty.AttributeType`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
             */
            @Override
            public java.lang.String getAttributeType() {
                return this.jsiiGet("attributeType", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html
     */
    public static interface GlobalSecondaryIndexProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.IndexName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
         */
        java.lang.String getIndexName();
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.KeySchema`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
         */
        java.lang.Object getKeySchema();
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.Projection`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
         */
        java.lang.Object getProjection();
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
         */
        java.lang.Object getProvisionedThroughput();

        /**
         * @return a {@link Builder} of {@link GlobalSecondaryIndexProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link GlobalSecondaryIndexProperty}
         */
        final class Builder {
            private java.lang.String _indexName;
            private java.lang.Object _keySchema;
            private java.lang.Object _projection;
            @javax.annotation.Nullable
            private java.lang.Object _provisionedThroughput;

            /**
             * Sets the value of IndexName
             * @param value `CfnTable.GlobalSecondaryIndexProperty.IndexName`
             * @return {@code this}
             */
            public Builder withIndexName(final java.lang.String value) {
                this._indexName = java.util.Objects.requireNonNull(value, "indexName is required");
                return this;
            }
            /**
             * Sets the value of KeySchema
             * @param value `CfnTable.GlobalSecondaryIndexProperty.KeySchema`
             * @return {@code this}
             */
            public Builder withKeySchema(final software.amazon.awscdk.Token value) {
                this._keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                return this;
            }
            /**
             * Sets the value of KeySchema
             * @param value `CfnTable.GlobalSecondaryIndexProperty.KeySchema`
             * @return {@code this}
             */
            public Builder withKeySchema(final java.util.List<java.lang.Object> value) {
                this._keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                return this;
            }
            /**
             * Sets the value of Projection
             * @param value `CfnTable.GlobalSecondaryIndexProperty.Projection`
             * @return {@code this}
             */
            public Builder withProjection(final software.amazon.awscdk.Token value) {
                this._projection = java.util.Objects.requireNonNull(value, "projection is required");
                return this;
            }
            /**
             * Sets the value of Projection
             * @param value `CfnTable.GlobalSecondaryIndexProperty.Projection`
             * @return {@code this}
             */
            public Builder withProjection(final software.amazon.awscdk.services.dynamodb.CfnTable.ProjectionProperty value) {
                this._projection = java.util.Objects.requireNonNull(value, "projection is required");
                return this;
            }
            /**
             * Sets the value of ProvisionedThroughput
             * @param value `CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput`
             * @return {@code this}
             */
            public Builder withProvisionedThroughput(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._provisionedThroughput = value;
                return this;
            }
            /**
             * Sets the value of ProvisionedThroughput
             * @param value `CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput`
             * @return {@code this}
             */
            public Builder withProvisionedThroughput(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.CfnTable.ProvisionedThroughputProperty value) {
                this._provisionedThroughput = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlobalSecondaryIndexProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public GlobalSecondaryIndexProperty build() {
                return new GlobalSecondaryIndexProperty() {
                    private final java.lang.String $indexName = java.util.Objects.requireNonNull(_indexName, "indexName is required");
                    private final java.lang.Object $keySchema = java.util.Objects.requireNonNull(_keySchema, "keySchema is required");
                    private final java.lang.Object $projection = java.util.Objects.requireNonNull(_projection, "projection is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $provisionedThroughput = _provisionedThroughput;

                    @Override
                    public java.lang.String getIndexName() {
                        return this.$indexName;
                    }

                    @Override
                    public java.lang.Object getKeySchema() {
                        return this.$keySchema;
                    }

                    @Override
                    public java.lang.Object getProjection() {
                        return this.$projection;
                    }

                    @Override
                    public java.lang.Object getProvisionedThroughput() {
                        return this.$provisionedThroughput;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("indexName", om.valueToTree(this.getIndexName()));
                        obj.set("keySchema", om.valueToTree(this.getKeySchema()));
                        obj.set("projection", om.valueToTree(this.getProjection()));
                        obj.set("provisionedThroughput", om.valueToTree(this.getProvisionedThroughput()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.GlobalSecondaryIndexProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnTable.GlobalSecondaryIndexProperty.IndexName`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
             */
            @Override
            public java.lang.String getIndexName() {
                return this.jsiiGet("indexName", java.lang.String.class);
            }

            /**
             * `CfnTable.GlobalSecondaryIndexProperty.KeySchema`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
             */
            @Override
            public java.lang.Object getKeySchema() {
                return this.jsiiGet("keySchema", java.lang.Object.class);
            }

            /**
             * `CfnTable.GlobalSecondaryIndexProperty.Projection`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
             */
            @Override
            public java.lang.Object getProjection() {
                return this.jsiiGet("projection", java.lang.Object.class);
            }

            /**
             * `CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getProvisionedThroughput() {
                return this.jsiiGet("provisionedThroughput", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html
     */
    public static interface KeySchemaProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnTable.KeySchemaProperty.AttributeName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
         */
        java.lang.String getAttributeName();
        /**
         * `CfnTable.KeySchemaProperty.KeyType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
         */
        java.lang.String getKeyType();

        /**
         * @return a {@link Builder} of {@link KeySchemaProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link KeySchemaProperty}
         */
        final class Builder {
            private java.lang.String _attributeName;
            private java.lang.String _keyType;

            /**
             * Sets the value of AttributeName
             * @param value `CfnTable.KeySchemaProperty.AttributeName`
             * @return {@code this}
             */
            public Builder withAttributeName(final java.lang.String value) {
                this._attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                return this;
            }
            /**
             * Sets the value of KeyType
             * @param value `CfnTable.KeySchemaProperty.KeyType`
             * @return {@code this}
             */
            public Builder withKeyType(final java.lang.String value) {
                this._keyType = java.util.Objects.requireNonNull(value, "keyType is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeySchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public KeySchemaProperty build() {
                return new KeySchemaProperty() {
                    private final java.lang.String $attributeName = java.util.Objects.requireNonNull(_attributeName, "attributeName is required");
                    private final java.lang.String $keyType = java.util.Objects.requireNonNull(_keyType, "keyType is required");

                    @Override
                    public java.lang.String getAttributeName() {
                        return this.$attributeName;
                    }

                    @Override
                    public java.lang.String getKeyType() {
                        return this.$keyType;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("attributeName", om.valueToTree(this.getAttributeName()));
                        obj.set("keyType", om.valueToTree(this.getKeyType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.KeySchemaProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnTable.KeySchemaProperty.AttributeName`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
             */
            @Override
            public java.lang.String getAttributeName() {
                return this.jsiiGet("attributeName", java.lang.String.class);
            }

            /**
             * `CfnTable.KeySchemaProperty.KeyType`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
             */
            @Override
            public java.lang.String getKeyType() {
                return this.jsiiGet("keyType", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html
     */
    public static interface LocalSecondaryIndexProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnTable.LocalSecondaryIndexProperty.IndexName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
         */
        java.lang.String getIndexName();
        /**
         * `CfnTable.LocalSecondaryIndexProperty.KeySchema`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
         */
        java.lang.Object getKeySchema();
        /**
         * `CfnTable.LocalSecondaryIndexProperty.Projection`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
         */
        java.lang.Object getProjection();

        /**
         * @return a {@link Builder} of {@link LocalSecondaryIndexProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LocalSecondaryIndexProperty}
         */
        final class Builder {
            private java.lang.String _indexName;
            private java.lang.Object _keySchema;
            private java.lang.Object _projection;

            /**
             * Sets the value of IndexName
             * @param value `CfnTable.LocalSecondaryIndexProperty.IndexName`
             * @return {@code this}
             */
            public Builder withIndexName(final java.lang.String value) {
                this._indexName = java.util.Objects.requireNonNull(value, "indexName is required");
                return this;
            }
            /**
             * Sets the value of KeySchema
             * @param value `CfnTable.LocalSecondaryIndexProperty.KeySchema`
             * @return {@code this}
             */
            public Builder withKeySchema(final software.amazon.awscdk.Token value) {
                this._keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                return this;
            }
            /**
             * Sets the value of KeySchema
             * @param value `CfnTable.LocalSecondaryIndexProperty.KeySchema`
             * @return {@code this}
             */
            public Builder withKeySchema(final java.util.List<java.lang.Object> value) {
                this._keySchema = java.util.Objects.requireNonNull(value, "keySchema is required");
                return this;
            }
            /**
             * Sets the value of Projection
             * @param value `CfnTable.LocalSecondaryIndexProperty.Projection`
             * @return {@code this}
             */
            public Builder withProjection(final software.amazon.awscdk.Token value) {
                this._projection = java.util.Objects.requireNonNull(value, "projection is required");
                return this;
            }
            /**
             * Sets the value of Projection
             * @param value `CfnTable.LocalSecondaryIndexProperty.Projection`
             * @return {@code this}
             */
            public Builder withProjection(final software.amazon.awscdk.services.dynamodb.CfnTable.ProjectionProperty value) {
                this._projection = java.util.Objects.requireNonNull(value, "projection is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocalSecondaryIndexProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LocalSecondaryIndexProperty build() {
                return new LocalSecondaryIndexProperty() {
                    private final java.lang.String $indexName = java.util.Objects.requireNonNull(_indexName, "indexName is required");
                    private final java.lang.Object $keySchema = java.util.Objects.requireNonNull(_keySchema, "keySchema is required");
                    private final java.lang.Object $projection = java.util.Objects.requireNonNull(_projection, "projection is required");

                    @Override
                    public java.lang.String getIndexName() {
                        return this.$indexName;
                    }

                    @Override
                    public java.lang.Object getKeySchema() {
                        return this.$keySchema;
                    }

                    @Override
                    public java.lang.Object getProjection() {
                        return this.$projection;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("indexName", om.valueToTree(this.getIndexName()));
                        obj.set("keySchema", om.valueToTree(this.getKeySchema()));
                        obj.set("projection", om.valueToTree(this.getProjection()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.LocalSecondaryIndexProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnTable.LocalSecondaryIndexProperty.IndexName`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
             */
            @Override
            public java.lang.String getIndexName() {
                return this.jsiiGet("indexName", java.lang.String.class);
            }

            /**
             * `CfnTable.LocalSecondaryIndexProperty.KeySchema`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
             */
            @Override
            public java.lang.Object getKeySchema() {
                return this.jsiiGet("keySchema", java.lang.Object.class);
            }

            /**
             * `CfnTable.LocalSecondaryIndexProperty.Projection`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
             */
            @Override
            public java.lang.Object getProjection() {
                return this.jsiiGet("projection", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html
     */
    public static interface PointInTimeRecoverySpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
         */
        java.lang.Object getPointInTimeRecoveryEnabled();

        /**
         * @return a {@link Builder} of {@link PointInTimeRecoverySpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PointInTimeRecoverySpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _pointInTimeRecoveryEnabled;

            /**
             * Sets the value of PointInTimeRecoveryEnabled
             * @param value `CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled`
             * @return {@code this}
             */
            public Builder withPointInTimeRecoveryEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._pointInTimeRecoveryEnabled = value;
                return this;
            }
            /**
             * Sets the value of PointInTimeRecoveryEnabled
             * @param value `CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled`
             * @return {@code this}
             */
            public Builder withPointInTimeRecoveryEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._pointInTimeRecoveryEnabled = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PointInTimeRecoverySpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PointInTimeRecoverySpecificationProperty build() {
                return new PointInTimeRecoverySpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $pointInTimeRecoveryEnabled = _pointInTimeRecoveryEnabled;

                    @Override
                    public java.lang.Object getPointInTimeRecoveryEnabled() {
                        return this.$pointInTimeRecoveryEnabled;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("pointInTimeRecoveryEnabled", om.valueToTree(this.getPointInTimeRecoveryEnabled()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.PointInTimeRecoverySpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPointInTimeRecoveryEnabled() {
                return this.jsiiGet("pointInTimeRecoveryEnabled", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html
     */
    public static interface ProjectionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnTable.ProjectionProperty.NonKeyAttributes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
         */
        java.util.List<java.lang.String> getNonKeyAttributes();
        /**
         * `CfnTable.ProjectionProperty.ProjectionType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
         */
        java.lang.String getProjectionType();

        /**
         * @return a {@link Builder} of {@link ProjectionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ProjectionProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _nonKeyAttributes;
            @javax.annotation.Nullable
            private java.lang.String _projectionType;

            /**
             * Sets the value of NonKeyAttributes
             * @param value `CfnTable.ProjectionProperty.NonKeyAttributes`
             * @return {@code this}
             */
            public Builder withNonKeyAttributes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._nonKeyAttributes = value;
                return this;
            }
            /**
             * Sets the value of ProjectionType
             * @param value `CfnTable.ProjectionProperty.ProjectionType`
             * @return {@code this}
             */
            public Builder withProjectionType(@javax.annotation.Nullable final java.lang.String value) {
                this._projectionType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ProjectionProperty build() {
                return new ProjectionProperty() {
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $nonKeyAttributes = _nonKeyAttributes;
                    @javax.annotation.Nullable
                    private final java.lang.String $projectionType = _projectionType;

                    @Override
                    public java.util.List<java.lang.String> getNonKeyAttributes() {
                        return this.$nonKeyAttributes;
                    }

                    @Override
                    public java.lang.String getProjectionType() {
                        return this.$projectionType;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("nonKeyAttributes", om.valueToTree(this.getNonKeyAttributes()));
                        obj.set("projectionType", om.valueToTree(this.getProjectionType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.ProjectionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnTable.ProjectionProperty.NonKeyAttributes`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getNonKeyAttributes() {
                return this.jsiiGet("nonKeyAttributes", java.util.List.class);
            }

            /**
             * `CfnTable.ProjectionProperty.ProjectionType`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getProjectionType() {
                return this.jsiiGet("projectionType", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     */
    public static interface ProvisionedThroughputProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
         */
        java.lang.Object getReadCapacityUnits();
        /**
         * `CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
         */
        java.lang.Object getWriteCapacityUnits();

        /**
         * @return a {@link Builder} of {@link ProvisionedThroughputProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ProvisionedThroughputProperty}
         */
        final class Builder {
            private java.lang.Object _readCapacityUnits;
            private java.lang.Object _writeCapacityUnits;

            /**
             * Sets the value of ReadCapacityUnits
             * @param value `CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits`
             * @return {@code this}
             */
            public Builder withReadCapacityUnits(final java.lang.Number value) {
                this._readCapacityUnits = java.util.Objects.requireNonNull(value, "readCapacityUnits is required");
                return this;
            }
            /**
             * Sets the value of ReadCapacityUnits
             * @param value `CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits`
             * @return {@code this}
             */
            public Builder withReadCapacityUnits(final software.amazon.awscdk.Token value) {
                this._readCapacityUnits = java.util.Objects.requireNonNull(value, "readCapacityUnits is required");
                return this;
            }
            /**
             * Sets the value of WriteCapacityUnits
             * @param value `CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits`
             * @return {@code this}
             */
            public Builder withWriteCapacityUnits(final java.lang.Number value) {
                this._writeCapacityUnits = java.util.Objects.requireNonNull(value, "writeCapacityUnits is required");
                return this;
            }
            /**
             * Sets the value of WriteCapacityUnits
             * @param value `CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits`
             * @return {@code this}
             */
            public Builder withWriteCapacityUnits(final software.amazon.awscdk.Token value) {
                this._writeCapacityUnits = java.util.Objects.requireNonNull(value, "writeCapacityUnits is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisionedThroughputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ProvisionedThroughputProperty build() {
                return new ProvisionedThroughputProperty() {
                    private final java.lang.Object $readCapacityUnits = java.util.Objects.requireNonNull(_readCapacityUnits, "readCapacityUnits is required");
                    private final java.lang.Object $writeCapacityUnits = java.util.Objects.requireNonNull(_writeCapacityUnits, "writeCapacityUnits is required");

                    @Override
                    public java.lang.Object getReadCapacityUnits() {
                        return this.$readCapacityUnits;
                    }

                    @Override
                    public java.lang.Object getWriteCapacityUnits() {
                        return this.$writeCapacityUnits;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("readCapacityUnits", om.valueToTree(this.getReadCapacityUnits()));
                        obj.set("writeCapacityUnits", om.valueToTree(this.getWriteCapacityUnits()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.ProvisionedThroughputProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
             */
            @Override
            public java.lang.Object getReadCapacityUnits() {
                return this.jsiiGet("readCapacityUnits", java.lang.Object.class);
            }

            /**
             * `CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
             */
            @Override
            public java.lang.Object getWriteCapacityUnits() {
                return this.jsiiGet("writeCapacityUnits", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html
     */
    public static interface SSESpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnTable.SSESpecificationProperty.SSEEnabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
         */
        java.lang.Object getSseEnabled();

        /**
         * @return a {@link Builder} of {@link SSESpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SSESpecificationProperty}
         */
        final class Builder {
            private java.lang.Object _sseEnabled;

            /**
             * Sets the value of SseEnabled
             * @param value `CfnTable.SSESpecificationProperty.SSEEnabled`
             * @return {@code this}
             */
            public Builder withSseEnabled(final java.lang.Boolean value) {
                this._sseEnabled = java.util.Objects.requireNonNull(value, "sseEnabled is required");
                return this;
            }
            /**
             * Sets the value of SseEnabled
             * @param value `CfnTable.SSESpecificationProperty.SSEEnabled`
             * @return {@code this}
             */
            public Builder withSseEnabled(final software.amazon.awscdk.Token value) {
                this._sseEnabled = java.util.Objects.requireNonNull(value, "sseEnabled is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SSESpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SSESpecificationProperty build() {
                return new SSESpecificationProperty() {
                    private final java.lang.Object $sseEnabled = java.util.Objects.requireNonNull(_sseEnabled, "sseEnabled is required");

                    @Override
                    public java.lang.Object getSseEnabled() {
                        return this.$sseEnabled;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("sseEnabled", om.valueToTree(this.getSseEnabled()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.SSESpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnTable.SSESpecificationProperty.SSEEnabled`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
             */
            @Override
            public java.lang.Object getSseEnabled() {
                return this.jsiiGet("sseEnabled", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html
     */
    public static interface StreamSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnTable.StreamSpecificationProperty.StreamViewType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
         */
        java.lang.String getStreamViewType();

        /**
         * @return a {@link Builder} of {@link StreamSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link StreamSpecificationProperty}
         */
        final class Builder {
            private java.lang.String _streamViewType;

            /**
             * Sets the value of StreamViewType
             * @param value `CfnTable.StreamSpecificationProperty.StreamViewType`
             * @return {@code this}
             */
            public Builder withStreamViewType(final java.lang.String value) {
                this._streamViewType = java.util.Objects.requireNonNull(value, "streamViewType is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public StreamSpecificationProperty build() {
                return new StreamSpecificationProperty() {
                    private final java.lang.String $streamViewType = java.util.Objects.requireNonNull(_streamViewType, "streamViewType is required");

                    @Override
                    public java.lang.String getStreamViewType() {
                        return this.$streamViewType;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("streamViewType", om.valueToTree(this.getStreamViewType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.StreamSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnTable.StreamSpecificationProperty.StreamViewType`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
             */
            @Override
            public java.lang.String getStreamViewType() {
                return this.jsiiGet("streamViewType", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html
     */
    public static interface TimeToLiveSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnTable.TimeToLiveSpecificationProperty.AttributeName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
         */
        java.lang.String getAttributeName();
        /**
         * `CfnTable.TimeToLiveSpecificationProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
         */
        java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link TimeToLiveSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TimeToLiveSpecificationProperty}
         */
        final class Builder {
            private java.lang.String _attributeName;
            private java.lang.Object _enabled;

            /**
             * Sets the value of AttributeName
             * @param value `CfnTable.TimeToLiveSpecificationProperty.AttributeName`
             * @return {@code this}
             */
            public Builder withAttributeName(final java.lang.String value) {
                this._attributeName = java.util.Objects.requireNonNull(value, "attributeName is required");
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnTable.TimeToLiveSpecificationProperty.Enabled`
             * @return {@code this}
             */
            public Builder withEnabled(final java.lang.Boolean value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnTable.TimeToLiveSpecificationProperty.Enabled`
             * @return {@code this}
             */
            public Builder withEnabled(final software.amazon.awscdk.Token value) {
                this._enabled = java.util.Objects.requireNonNull(value, "enabled is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeToLiveSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TimeToLiveSpecificationProperty build() {
                return new TimeToLiveSpecificationProperty() {
                    private final java.lang.String $attributeName = java.util.Objects.requireNonNull(_attributeName, "attributeName is required");
                    private final java.lang.Object $enabled = java.util.Objects.requireNonNull(_enabled, "enabled is required");

                    @Override
                    public java.lang.String getAttributeName() {
                        return this.$attributeName;
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("attributeName", om.valueToTree(this.getAttributeName()));
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.CfnTable.TimeToLiveSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnTable.TimeToLiveSpecificationProperty.AttributeName`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
             */
            @Override
            public java.lang.String getAttributeName() {
                return this.jsiiGet("attributeName", java.lang.String.class);
            }

            /**
             * `CfnTable.TimeToLiveSpecificationProperty.Enabled`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
             */
            @Override
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
        }
    }
}
