/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.dynamodb.;
import software.amazon.awscdk.services.dynamodb.EnableScalingProps;
import software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexProps;
import software.amazon.awscdk.services.dynamodb.IScalableTableAttribute;
import software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps;
import software.amazon.awscdk.services.dynamodb.TableProps;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-dynamodb.Table")
public class Table
extends Resource {
    protected Table(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public Table(Construct scope, String id, TableProps props) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public static Grant grantListStreams(IGrantable grantee) {
        return (Grant)JsiiObject.jsiiStaticCall(Table.class, (String)"grantListStreams", Grant.class, (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    public void addGlobalSecondaryIndex(GlobalSecondaryIndexProps props) {
        this.jsiiCall("addGlobalSecondaryIndex", Void.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public void addLocalSecondaryIndex(LocalSecondaryIndexProps props) {
        this.jsiiCall("addLocalSecondaryIndex", Void.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public IScalableTableAttribute autoScaleGlobalSecondaryIndexReadCapacity(String indexName, EnableScalingProps props) {
        return (IScalableTableAttribute)this.jsiiCall("autoScaleGlobalSecondaryIndexReadCapacity", IScalableTableAttribute.class, new Object[]{Objects.requireNonNull(indexName, "indexName is required"), Objects.requireNonNull(props, "props is required")});
    }

    public IScalableTableAttribute autoScaleGlobalSecondaryIndexWriteCapacity(String indexName, EnableScalingProps props) {
        return (IScalableTableAttribute)this.jsiiCall("autoScaleGlobalSecondaryIndexWriteCapacity", IScalableTableAttribute.class, new Object[]{Objects.requireNonNull(indexName, "indexName is required"), Objects.requireNonNull(props, "props is required")});
    }

    public IScalableTableAttribute autoScaleReadCapacity(EnableScalingProps props) {
        return (IScalableTableAttribute)this.jsiiCall("autoScaleReadCapacity", IScalableTableAttribute.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public IScalableTableAttribute autoScaleWriteCapacity(EnableScalingProps props) {
        return (IScalableTableAttribute)this.jsiiCall("autoScaleWriteCapacity", IScalableTableAttribute.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public Grant grant(IGrantable grantee, String ... actions) {
        return (Grant)this.jsiiCall("grant", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    public Grant grantFullAccess(IGrantable grantee) {
        return (Grant)this.jsiiCall("grantFullAccess", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    public Grant grantReadData(IGrantable grantee) {
        return (Grant)this.jsiiCall("grantReadData", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    public Grant grantReadWriteData(IGrantable grantee) {
        return (Grant)this.jsiiCall("grantReadWriteData", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    public Grant grantStream(IGrantable grantee, String ... actions) {
        return (Grant)this.jsiiCall("grantStream", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    public Grant grantStreamRead(IGrantable grantee) {
        return (Grant)this.jsiiCall("grantStreamRead", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    public Grant grantWriteData(IGrantable grantee) {
        return (Grant)this.jsiiCall("grantWriteData", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    protected List<String> validate() {
        return (List)this.jsiiCall("validate", List.class, new Object[0]);
    }

    public String getTableArn() {
        return (String)this.jsiiGet("tableArn", String.class);
    }

    public String getTableName() {
        return (String)this.jsiiGet("tableName", String.class);
    }

    public String getTableStreamArn() {
        return (String)this.jsiiGet("tableStreamArn", String.class);
    }
}

