/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.dynamodb.Attribute;
import software.amazon.awscdk.services.dynamodb.BillingMode;
import software.amazon.awscdk.services.dynamodb.StreamViewType;
import software.amazon.awscdk.services.dynamodb.TableOptions;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface TableProps
extends JsiiSerializable,
TableOptions {
    public String getTableName();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private String _tableName;
        private Attribute _partitionKey;
        @Nullable
        private BillingMode _billingMode;
        @Nullable
        private Boolean _pitrEnabled;
        @Nullable
        private Number _readCapacity;
        @Nullable
        private Attribute _sortKey;
        @Nullable
        private Boolean _sseEnabled;
        @Nullable
        private StreamViewType _streamSpecification;
        @Nullable
        private String _ttlAttributeName;
        @Nullable
        private Number _writeCapacity;

        public Builder withTableName(@Nullable String value) {
            this._tableName = value;
            return this;
        }

        public Builder withPartitionKey(Attribute value) {
            this._partitionKey = Objects.requireNonNull(value, "partitionKey is required");
            return this;
        }

        public Builder withBillingMode(@Nullable BillingMode value) {
            this._billingMode = value;
            return this;
        }

        public Builder withPitrEnabled(@Nullable Boolean value) {
            this._pitrEnabled = value;
            return this;
        }

        public Builder withReadCapacity(@Nullable Number value) {
            this._readCapacity = value;
            return this;
        }

        public Builder withSortKey(@Nullable Attribute value) {
            this._sortKey = value;
            return this;
        }

        public Builder withSseEnabled(@Nullable Boolean value) {
            this._sseEnabled = value;
            return this;
        }

        public Builder withStreamSpecification(@Nullable StreamViewType value) {
            this._streamSpecification = value;
            return this;
        }

        public Builder withTtlAttributeName(@Nullable String value) {
            this._ttlAttributeName = value;
            return this;
        }

        public Builder withWriteCapacity(@Nullable Number value) {
            this._writeCapacity = value;
            return this;
        }

        public TableProps build() {
            return new TableProps(){
                @Nullable
                private final String $tableName;
                private final Attribute $partitionKey;
                @Nullable
                private final BillingMode $billingMode;
                @Nullable
                private final Boolean $pitrEnabled;
                @Nullable
                private final Number $readCapacity;
                @Nullable
                private final Attribute $sortKey;
                @Nullable
                private final Boolean $sseEnabled;
                @Nullable
                private final StreamViewType $streamSpecification;
                @Nullable
                private final String $ttlAttributeName;
                @Nullable
                private final Number $writeCapacity;
                {
                    this.$tableName = _tableName;
                    this.$partitionKey = Objects.requireNonNull(_partitionKey, "partitionKey is required");
                    this.$billingMode = _billingMode;
                    this.$pitrEnabled = _pitrEnabled;
                    this.$readCapacity = _readCapacity;
                    this.$sortKey = _sortKey;
                    this.$sseEnabled = _sseEnabled;
                    this.$streamSpecification = _streamSpecification;
                    this.$ttlAttributeName = _ttlAttributeName;
                    this.$writeCapacity = _writeCapacity;
                }

                @Override
                public String getTableName() {
                    return this.$tableName;
                }

                @Override
                public Attribute getPartitionKey() {
                    return this.$partitionKey;
                }

                @Override
                public BillingMode getBillingMode() {
                    return this.$billingMode;
                }

                @Override
                public Boolean getPitrEnabled() {
                    return this.$pitrEnabled;
                }

                @Override
                public Number getReadCapacity() {
                    return this.$readCapacity;
                }

                @Override
                public Attribute getSortKey() {
                    return this.$sortKey;
                }

                @Override
                public Boolean getSseEnabled() {
                    return this.$sseEnabled;
                }

                @Override
                public StreamViewType getStreamSpecification() {
                    return this.$streamSpecification;
                }

                @Override
                public String getTtlAttributeName() {
                    return this.$ttlAttributeName;
                }

                @Override
                public Number getWriteCapacity() {
                    return this.$writeCapacity;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("tableName", om.valueToTree((Object)this.getTableName()));
                    obj.set("partitionKey", om.valueToTree((Object)this.getPartitionKey()));
                    obj.set("billingMode", om.valueToTree((Object)this.getBillingMode()));
                    obj.set("pitrEnabled", om.valueToTree((Object)this.getPitrEnabled()));
                    obj.set("readCapacity", om.valueToTree((Object)this.getReadCapacity()));
                    obj.set("sortKey", om.valueToTree((Object)this.getSortKey()));
                    obj.set("sseEnabled", om.valueToTree((Object)this.getSseEnabled()));
                    obj.set("streamSpecification", om.valueToTree((Object)this.getStreamSpecification()));
                    obj.set("ttlAttributeName", om.valueToTree((Object)this.getTtlAttributeName()));
                    obj.set("writeCapacity", om.valueToTree((Object)this.getWriteCapacity()));
                    return obj;
                }
            };
        }
    }
}

