package software.amazon.awscdk.services.dynamodb;

/**
 * When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
 * 
 * Valid values for StreamViewType are:
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-06T20:53:02.888Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.StreamViewType")
public enum StreamViewType {
    /**
     * The entire item, as it appears after it was modified, is written to the stream.
     */
    NewImage,
    /**
     * The entire item, as it appeared before it was modified, is written to the stream.
     */
    OldImage,
    /**
     * Both the new and the old item images of the item are written to the stream.
     */
    NewAndOldImages,
    /**
     * Only the key attributes of the modified item are written to the stream.
     */
    KeysOnly,
}
