/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.dynamodb.Attribute;
import software.amazon.awscdk.services.dynamodb.ProjectionType;
import software.amazon.awscdk.services.dynamodb.SecondaryIndexProps;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface GlobalSecondaryIndexProps
extends JsiiSerializable,
SecondaryIndexProps {
    public Attribute getPartitionKey();

    public Number getReadCapacity();

    public Attribute getSortKey();

    public Number getWriteCapacity();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Attribute _partitionKey;
        @Nullable
        private Number _readCapacity;
        @Nullable
        private Attribute _sortKey;
        @Nullable
        private Number _writeCapacity;
        private String _indexName;
        @Nullable
        private List<String> _nonKeyAttributes;
        @Nullable
        private ProjectionType _projectionType;

        public Builder withPartitionKey(Attribute value) {
            this._partitionKey = Objects.requireNonNull(value, "partitionKey is required");
            return this;
        }

        public Builder withReadCapacity(@Nullable Number value) {
            this._readCapacity = value;
            return this;
        }

        public Builder withSortKey(@Nullable Attribute value) {
            this._sortKey = value;
            return this;
        }

        public Builder withWriteCapacity(@Nullable Number value) {
            this._writeCapacity = value;
            return this;
        }

        public Builder withIndexName(String value) {
            this._indexName = Objects.requireNonNull(value, "indexName is required");
            return this;
        }

        public Builder withNonKeyAttributes(@Nullable List<String> value) {
            this._nonKeyAttributes = value;
            return this;
        }

        public Builder withProjectionType(@Nullable ProjectionType value) {
            this._projectionType = value;
            return this;
        }

        public GlobalSecondaryIndexProps build() {
            return new GlobalSecondaryIndexProps(){
                private final Attribute $partitionKey;
                @Nullable
                private final Number $readCapacity;
                @Nullable
                private final Attribute $sortKey;
                @Nullable
                private final Number $writeCapacity;
                private final String $indexName;
                @Nullable
                private final List<String> $nonKeyAttributes;
                @Nullable
                private final ProjectionType $projectionType;
                {
                    this.$partitionKey = Objects.requireNonNull(_partitionKey, "partitionKey is required");
                    this.$readCapacity = _readCapacity;
                    this.$sortKey = _sortKey;
                    this.$writeCapacity = _writeCapacity;
                    this.$indexName = Objects.requireNonNull(_indexName, "indexName is required");
                    this.$nonKeyAttributes = _nonKeyAttributes;
                    this.$projectionType = _projectionType;
                }

                @Override
                public Attribute getPartitionKey() {
                    return this.$partitionKey;
                }

                @Override
                public Number getReadCapacity() {
                    return this.$readCapacity;
                }

                @Override
                public Attribute getSortKey() {
                    return this.$sortKey;
                }

                @Override
                public Number getWriteCapacity() {
                    return this.$writeCapacity;
                }

                @Override
                public String getIndexName() {
                    return this.$indexName;
                }

                @Override
                public List<String> getNonKeyAttributes() {
                    return this.$nonKeyAttributes;
                }

                @Override
                public ProjectionType getProjectionType() {
                    return this.$projectionType;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("partitionKey", om.valueToTree((Object)this.getPartitionKey()));
                    obj.set("readCapacity", om.valueToTree((Object)this.getReadCapacity()));
                    obj.set("sortKey", om.valueToTree((Object)this.getSortKey()));
                    obj.set("writeCapacity", om.valueToTree((Object)this.getWriteCapacity()));
                    obj.set("indexName", om.valueToTree((Object)this.getIndexName()));
                    obj.set("nonKeyAttributes", om.valueToTree(this.getNonKeyAttributes()));
                    obj.set("projectionType", om.valueToTree((Object)this.getProjectionType()));
                    return obj;
                }
            };
        }
    }
}

