package software.amazon.awscdk.services.dynamodb;

/**
 * When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
 * 
 * Valid values for StreamViewType are:
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:03:48.487Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.StreamViewType")
public enum StreamViewType {
    /**
     * The entire item, as it appears after it was modified, is written to the stream.
     */
    NewImage,
    /**
     * The entire item, as it appeared before it was modified, is written to the stream.
     */
    OldImage,
    /**
     * Both the new and the old item images of the item are written to the stream.
     */
    NewAndOldImages,
    /**
     * Only the key attributes of the modified item are written to the stream.
     */
    KeysOnly,
}
