package software.amazon.awscdk.services.dynamodb;

@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:03:48.489Z")
public interface TableProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.dynamodb.TableOptions {
    /**
     * Enforces a particular physical table name.
     * 
     * Default: <generated>
     */
    java.lang.String getTableName();

    /**
     * @return a {@link Builder} of {@link TableProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link TableProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _tableName;
        private software.amazon.awscdk.services.dynamodb.Attribute _partitionKey;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.dynamodb.BillingMode _billingMode;
        @javax.annotation.Nullable
        private java.lang.Boolean _pitrEnabled;
        @javax.annotation.Nullable
        private java.lang.Number _readCapacity;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.dynamodb.Attribute _sortKey;
        @javax.annotation.Nullable
        private java.lang.Boolean _sseEnabled;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.dynamodb.StreamViewType _streamSpecification;
        @javax.annotation.Nullable
        private java.lang.String _ttlAttributeName;
        @javax.annotation.Nullable
        private java.lang.Number _writeCapacity;

        /**
         * Sets the value of TableName
         * @param value Enforces a particular physical table name.
         * @return {@code this}
         */
        public Builder withTableName(@javax.annotation.Nullable final java.lang.String value) {
            this._tableName = value;
            return this;
        }
        /**
         * Sets the value of PartitionKey
         * @param value Partition key attribute definition.
         * @return {@code this}
         */
        public Builder withPartitionKey(final software.amazon.awscdk.services.dynamodb.Attribute value) {
            this._partitionKey = java.util.Objects.requireNonNull(value, "partitionKey is required");
            return this;
        }
        /**
         * Sets the value of BillingMode
         * @param value Specify how you are charged for read and write throughput and how you manage capacity.
         * @return {@code this}
         */
        public Builder withBillingMode(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.BillingMode value) {
            this._billingMode = value;
            return this;
        }
        /**
         * Sets the value of PitrEnabled
         * @param value Whether point-in-time recovery is enabled.
         * @return {@code this}
         */
        public Builder withPitrEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._pitrEnabled = value;
            return this;
        }
        /**
         * Sets the value of ReadCapacity
         * @param value The read capacity for the table.
         * @return {@code this}
         */
        public Builder withReadCapacity(@javax.annotation.Nullable final java.lang.Number value) {
            this._readCapacity = value;
            return this;
        }
        /**
         * Sets the value of SortKey
         * @param value Table sort key attribute definition.
         * @return {@code this}
         */
        public Builder withSortKey(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.Attribute value) {
            this._sortKey = value;
            return this;
        }
        /**
         * Sets the value of SseEnabled
         * @param value Whether server-side encryption with an AWS managed customer master key is enabled.
         * @return {@code this}
         */
        public Builder withSseEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._sseEnabled = value;
            return this;
        }
        /**
         * Sets the value of StreamSpecification
         * @param value When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
         * @return {@code this}
         */
        public Builder withStreamSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.StreamViewType value) {
            this._streamSpecification = value;
            return this;
        }
        /**
         * Sets the value of TtlAttributeName
         * @param value The name of TTL attribute.
         * @return {@code this}
         */
        public Builder withTtlAttributeName(@javax.annotation.Nullable final java.lang.String value) {
            this._ttlAttributeName = value;
            return this;
        }
        /**
         * Sets the value of WriteCapacity
         * @param value The write capacity for the table.
         * @return {@code this}
         */
        public Builder withWriteCapacity(@javax.annotation.Nullable final java.lang.Number value) {
            this._writeCapacity = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public TableProps build() {
            return new TableProps() {
                @javax.annotation.Nullable
                private final java.lang.String $tableName = _tableName;
                private final software.amazon.awscdk.services.dynamodb.Attribute $partitionKey = java.util.Objects.requireNonNull(_partitionKey, "partitionKey is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.dynamodb.BillingMode $billingMode = _billingMode;
                @javax.annotation.Nullable
                private final java.lang.Boolean $pitrEnabled = _pitrEnabled;
                @javax.annotation.Nullable
                private final java.lang.Number $readCapacity = _readCapacity;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.dynamodb.Attribute $sortKey = _sortKey;
                @javax.annotation.Nullable
                private final java.lang.Boolean $sseEnabled = _sseEnabled;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.dynamodb.StreamViewType $streamSpecification = _streamSpecification;
                @javax.annotation.Nullable
                private final java.lang.String $ttlAttributeName = _ttlAttributeName;
                @javax.annotation.Nullable
                private final java.lang.Number $writeCapacity = _writeCapacity;

                @Override
                public java.lang.String getTableName() {
                    return this.$tableName;
                }

                @Override
                public software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey() {
                    return this.$partitionKey;
                }

                @Override
                public software.amazon.awscdk.services.dynamodb.BillingMode getBillingMode() {
                    return this.$billingMode;
                }

                @Override
                public java.lang.Boolean getPitrEnabled() {
                    return this.$pitrEnabled;
                }

                @Override
                public java.lang.Number getReadCapacity() {
                    return this.$readCapacity;
                }

                @Override
                public software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
                    return this.$sortKey;
                }

                @Override
                public java.lang.Boolean getSseEnabled() {
                    return this.$sseEnabled;
                }

                @Override
                public software.amazon.awscdk.services.dynamodb.StreamViewType getStreamSpecification() {
                    return this.$streamSpecification;
                }

                @Override
                public java.lang.String getTtlAttributeName() {
                    return this.$ttlAttributeName;
                }

                @Override
                public java.lang.Number getWriteCapacity() {
                    return this.$writeCapacity;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("tableName", om.valueToTree(this.getTableName()));
                    obj.set("partitionKey", om.valueToTree(this.getPartitionKey()));
                    obj.set("billingMode", om.valueToTree(this.getBillingMode()));
                    obj.set("pitrEnabled", om.valueToTree(this.getPitrEnabled()));
                    obj.set("readCapacity", om.valueToTree(this.getReadCapacity()));
                    obj.set("sortKey", om.valueToTree(this.getSortKey()));
                    obj.set("sseEnabled", om.valueToTree(this.getSseEnabled()));
                    obj.set("streamSpecification", om.valueToTree(this.getStreamSpecification()));
                    obj.set("ttlAttributeName", om.valueToTree(this.getTtlAttributeName()));
                    obj.set("writeCapacity", om.valueToTree(this.getWriteCapacity()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.TableProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Enforces a particular physical table name.
         * 
         * Default: <generated>
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getTableName() {
            return this.jsiiGet("tableName", java.lang.String.class);
        }

        /**
         * Partition key attribute definition.
         */
        @Override
        public software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey() {
            return this.jsiiGet("partitionKey", software.amazon.awscdk.services.dynamodb.Attribute.class);
        }

        /**
         * Specify how you are charged for read and write throughput and how you manage capacity.
         * 
         * Default: Provisioned
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.dynamodb.BillingMode getBillingMode() {
            return this.jsiiGet("billingMode", software.amazon.awscdk.services.dynamodb.BillingMode.class);
        }

        /**
         * Whether point-in-time recovery is enabled.
         * 
         * Default: undefined, point-in-time recovery is disabled
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getPitrEnabled() {
            return this.jsiiGet("pitrEnabled", java.lang.Boolean.class);
        }

        /**
         * The read capacity for the table.
         * 
         * Careful if you add Global Secondary Indexes, as
         * those will share the table's provisioned throughput.
         * 
         * Can only be provided if billingMode is Provisioned.
         * 
         * Default: 5
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getReadCapacity() {
            return this.jsiiGet("readCapacity", java.lang.Number.class);
        }

        /**
         * Table sort key attribute definition.
         * 
         * Default: no sort key
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
            return this.jsiiGet("sortKey", software.amazon.awscdk.services.dynamodb.Attribute.class);
        }

        /**
         * Whether server-side encryption with an AWS managed customer master key is enabled.
         * 
         * Default: undefined, server-side encryption is enabled with an AWS owned customer master key
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getSseEnabled() {
            return this.jsiiGet("sseEnabled", java.lang.Boolean.class);
        }

        /**
         * When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
         * 
         * Valid values for StreamViewType are:
         * 
         * Default: undefined, streams are disabled
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.dynamodb.StreamViewType getStreamSpecification() {
            return this.jsiiGet("streamSpecification", software.amazon.awscdk.services.dynamodb.StreamViewType.class);
        }

        /**
         * The name of TTL attribute.
         * 
         * Default: undefined, TTL is disabled
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getTtlAttributeName() {
            return this.jsiiGet("ttlAttributeName", java.lang.String.class);
        }

        /**
         * The write capacity for the table.
         * 
         * Careful if you add Global Secondary Indexes, as
         * those will share the table's provisioned throughput.
         * 
         * Can only be provided if billingMode is Provisioned.
         * 
         * Default: 5
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getWriteCapacity() {
            return this.jsiiGet("writeCapacity", java.lang.Number.class);
        }
    }
}
