package software.amazon.awscdk.services.dynamodb;

/**
 * Properties for enabling DynamoDB utilization tracking.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.2 (build 27d16c2)", date = "2019-06-10T11:06:07.759Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface UtilizationScalingProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.applicationautoscaling.BaseTargetTrackingProps {
    /**
     * Target utilization percentage for the attribute.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getTargetUtilizationPercent();

    /**
     * @return a {@link Builder} of {@link UtilizationScalingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link UtilizationScalingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private java.lang.Number _targetUtilizationPercent;
        @javax.annotation.Nullable
        private java.lang.Boolean _disableScaleIn;
        @javax.annotation.Nullable
        private java.lang.String _policyName;
        @javax.annotation.Nullable
        private java.lang.Number _scaleInCooldownSec;
        @javax.annotation.Nullable
        private java.lang.Number _scaleOutCooldownSec;

        /**
         * Sets the value of TargetUtilizationPercent
         * @param value Target utilization percentage for the attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withTargetUtilizationPercent(final java.lang.Number value) {
            this._targetUtilizationPercent = java.util.Objects.requireNonNull(value, "targetUtilizationPercent is required");
            return this;
        }
        /**
         * Sets the value of DisableScaleIn
         * @param value Indicates whether scale in by the target tracking policy is disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDisableScaleIn(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._disableScaleIn = value;
            return this;
        }
        /**
         * Sets the value of PolicyName
         * @param value A name for the scaling policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withPolicyName(@javax.annotation.Nullable final java.lang.String value) {
            this._policyName = value;
            return this;
        }
        /**
         * Sets the value of ScaleInCooldownSec
         * @param value Period after a scale in activity completes before another scale in activity can start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withScaleInCooldownSec(@javax.annotation.Nullable final java.lang.Number value) {
            this._scaleInCooldownSec = value;
            return this;
        }
        /**
         * Sets the value of ScaleOutCooldownSec
         * @param value Period after a scale out activity completes before another scale out activity can start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withScaleOutCooldownSec(@javax.annotation.Nullable final java.lang.Number value) {
            this._scaleOutCooldownSec = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UtilizationScalingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public UtilizationScalingProps build() {
            return new UtilizationScalingProps() {
                private final java.lang.Number $targetUtilizationPercent = java.util.Objects.requireNonNull(_targetUtilizationPercent, "targetUtilizationPercent is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $disableScaleIn = _disableScaleIn;
                @javax.annotation.Nullable
                private final java.lang.String $policyName = _policyName;
                @javax.annotation.Nullable
                private final java.lang.Number $scaleInCooldownSec = _scaleInCooldownSec;
                @javax.annotation.Nullable
                private final java.lang.Number $scaleOutCooldownSec = _scaleOutCooldownSec;

                @Override
                public java.lang.Number getTargetUtilizationPercent() {
                    return this.$targetUtilizationPercent;
                }

                @Override
                public java.lang.Boolean getDisableScaleIn() {
                    return this.$disableScaleIn;
                }

                @Override
                public java.lang.String getPolicyName() {
                    return this.$policyName;
                }

                @Override
                public java.lang.Number getScaleInCooldownSec() {
                    return this.$scaleInCooldownSec;
                }

                @Override
                public java.lang.Number getScaleOutCooldownSec() {
                    return this.$scaleOutCooldownSec;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("targetUtilizationPercent", om.valueToTree(this.getTargetUtilizationPercent()));
                    if (this.getDisableScaleIn() != null) {
                        obj.set("disableScaleIn", om.valueToTree(this.getDisableScaleIn()));
                    }
                    if (this.getPolicyName() != null) {
                        obj.set("policyName", om.valueToTree(this.getPolicyName()));
                    }
                    if (this.getScaleInCooldownSec() != null) {
                        obj.set("scaleInCooldownSec", om.valueToTree(this.getScaleInCooldownSec()));
                    }
                    if (this.getScaleOutCooldownSec() != null) {
                        obj.set("scaleOutCooldownSec", om.valueToTree(this.getScaleOutCooldownSec()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.UtilizationScalingProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Target utilization percentage for the attribute.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.Number getTargetUtilizationPercent() {
            return this.jsiiGet("targetUtilizationPercent", java.lang.Number.class);
        }

        /**
         * Indicates whether scale in by the target tracking policy is disabled.
         * 
         * If the value is true, scale in is disabled and the target tracking policy
         * won't remove capacity from the scalable resource. Otherwise, scale in is
         * enabled and the target tracking policy can remove capacity from the
         * scalable resource.
         * 
         * Default: false
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getDisableScaleIn() {
            return this.jsiiGet("disableScaleIn", java.lang.Boolean.class);
        }

        /**
         * A name for the scaling policy.
         * 
         * Default: - Automatically generated name.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getPolicyName() {
            return this.jsiiGet("policyName", java.lang.String.class);
        }

        /**
         * Period after a scale in activity completes before another scale in activity can start.
         * 
         * Default: - No scale in cooldown.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getScaleInCooldownSec() {
            return this.jsiiGet("scaleInCooldownSec", java.lang.Number.class);
        }

        /**
         * Period after a scale out activity completes before another scale out activity can start.
         * 
         * Default: - No scale out cooldown.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getScaleOutCooldownSec() {
            return this.jsiiGet("scaleOutCooldownSec", java.lang.Number.class);
        }
    }
}
