/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.dynamodb.CfnTable;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnTableProps
extends JsiiSerializable {
    public Object getKeySchema();

    public Object getAttributeDefinitions();

    public String getBillingMode();

    public Object getGlobalSecondaryIndexes();

    public Object getLocalSecondaryIndexes();

    public Object getPointInTimeRecoverySpecification();

    public Object getProvisionedThroughput();

    public Object getSseSpecification();

    public Object getStreamSpecification();

    public String getTableName();

    public List<CfnTag> getTags();

    public Object getTimeToLiveSpecification();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Object _keySchema;
        @Nullable
        private Object _attributeDefinitions;
        @Nullable
        private String _billingMode;
        @Nullable
        private Object _globalSecondaryIndexes;
        @Nullable
        private Object _localSecondaryIndexes;
        @Nullable
        private Object _pointInTimeRecoverySpecification;
        @Nullable
        private Object _provisionedThroughput;
        @Nullable
        private Object _sseSpecification;
        @Nullable
        private Object _streamSpecification;
        @Nullable
        private String _tableName;
        @Nullable
        private List<CfnTag> _tags;
        @Nullable
        private Object _timeToLiveSpecification;

        public Builder withKeySchema(Token value) {
            this._keySchema = Objects.requireNonNull(value, "keySchema is required");
            return this;
        }

        public Builder withKeySchema(List<Object> value) {
            this._keySchema = Objects.requireNonNull(value, "keySchema is required");
            return this;
        }

        public Builder withAttributeDefinitions(@Nullable Token value) {
            this._attributeDefinitions = value;
            return this;
        }

        public Builder withAttributeDefinitions(@Nullable List<Object> value) {
            this._attributeDefinitions = value;
            return this;
        }

        public Builder withBillingMode(@Nullable String value) {
            this._billingMode = value;
            return this;
        }

        public Builder withGlobalSecondaryIndexes(@Nullable Token value) {
            this._globalSecondaryIndexes = value;
            return this;
        }

        public Builder withGlobalSecondaryIndexes(@Nullable List<Object> value) {
            this._globalSecondaryIndexes = value;
            return this;
        }

        public Builder withLocalSecondaryIndexes(@Nullable Token value) {
            this._localSecondaryIndexes = value;
            return this;
        }

        public Builder withLocalSecondaryIndexes(@Nullable List<Object> value) {
            this._localSecondaryIndexes = value;
            return this;
        }

        public Builder withPointInTimeRecoverySpecification(@Nullable Token value) {
            this._pointInTimeRecoverySpecification = value;
            return this;
        }

        public Builder withPointInTimeRecoverySpecification(@Nullable CfnTable.PointInTimeRecoverySpecificationProperty value) {
            this._pointInTimeRecoverySpecification = value;
            return this;
        }

        public Builder withProvisionedThroughput(@Nullable Token value) {
            this._provisionedThroughput = value;
            return this;
        }

        public Builder withProvisionedThroughput(@Nullable CfnTable.ProvisionedThroughputProperty value) {
            this._provisionedThroughput = value;
            return this;
        }

        public Builder withSseSpecification(@Nullable Token value) {
            this._sseSpecification = value;
            return this;
        }

        public Builder withSseSpecification(@Nullable CfnTable.SSESpecificationProperty value) {
            this._sseSpecification = value;
            return this;
        }

        public Builder withStreamSpecification(@Nullable Token value) {
            this._streamSpecification = value;
            return this;
        }

        public Builder withStreamSpecification(@Nullable CfnTable.StreamSpecificationProperty value) {
            this._streamSpecification = value;
            return this;
        }

        public Builder withTableName(@Nullable String value) {
            this._tableName = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public Builder withTimeToLiveSpecification(@Nullable Token value) {
            this._timeToLiveSpecification = value;
            return this;
        }

        public Builder withTimeToLiveSpecification(@Nullable CfnTable.TimeToLiveSpecificationProperty value) {
            this._timeToLiveSpecification = value;
            return this;
        }

        public CfnTableProps build() {
            return new CfnTableProps(){
                private final Object $keySchema;
                @Nullable
                private final Object $attributeDefinitions;
                @Nullable
                private final String $billingMode;
                @Nullable
                private final Object $globalSecondaryIndexes;
                @Nullable
                private final Object $localSecondaryIndexes;
                @Nullable
                private final Object $pointInTimeRecoverySpecification;
                @Nullable
                private final Object $provisionedThroughput;
                @Nullable
                private final Object $sseSpecification;
                @Nullable
                private final Object $streamSpecification;
                @Nullable
                private final String $tableName;
                @Nullable
                private final List<CfnTag> $tags;
                @Nullable
                private final Object $timeToLiveSpecification;
                {
                    this.$keySchema = Objects.requireNonNull(_keySchema, "keySchema is required");
                    this.$attributeDefinitions = _attributeDefinitions;
                    this.$billingMode = _billingMode;
                    this.$globalSecondaryIndexes = _globalSecondaryIndexes;
                    this.$localSecondaryIndexes = _localSecondaryIndexes;
                    this.$pointInTimeRecoverySpecification = _pointInTimeRecoverySpecification;
                    this.$provisionedThroughput = _provisionedThroughput;
                    this.$sseSpecification = _sseSpecification;
                    this.$streamSpecification = _streamSpecification;
                    this.$tableName = _tableName;
                    this.$tags = _tags;
                    this.$timeToLiveSpecification = _timeToLiveSpecification;
                }

                @Override
                public Object getKeySchema() {
                    return this.$keySchema;
                }

                @Override
                public Object getAttributeDefinitions() {
                    return this.$attributeDefinitions;
                }

                @Override
                public String getBillingMode() {
                    return this.$billingMode;
                }

                @Override
                public Object getGlobalSecondaryIndexes() {
                    return this.$globalSecondaryIndexes;
                }

                @Override
                public Object getLocalSecondaryIndexes() {
                    return this.$localSecondaryIndexes;
                }

                @Override
                public Object getPointInTimeRecoverySpecification() {
                    return this.$pointInTimeRecoverySpecification;
                }

                @Override
                public Object getProvisionedThroughput() {
                    return this.$provisionedThroughput;
                }

                @Override
                public Object getSseSpecification() {
                    return this.$sseSpecification;
                }

                @Override
                public Object getStreamSpecification() {
                    return this.$streamSpecification;
                }

                @Override
                public String getTableName() {
                    return this.$tableName;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                @Override
                public Object getTimeToLiveSpecification() {
                    return this.$timeToLiveSpecification;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("keySchema", om.valueToTree(this.getKeySchema()));
                    if (this.getAttributeDefinitions() != null) {
                        obj.set("attributeDefinitions", om.valueToTree(this.getAttributeDefinitions()));
                    }
                    if (this.getBillingMode() != null) {
                        obj.set("billingMode", om.valueToTree((Object)this.getBillingMode()));
                    }
                    if (this.getGlobalSecondaryIndexes() != null) {
                        obj.set("globalSecondaryIndexes", om.valueToTree(this.getGlobalSecondaryIndexes()));
                    }
                    if (this.getLocalSecondaryIndexes() != null) {
                        obj.set("localSecondaryIndexes", om.valueToTree(this.getLocalSecondaryIndexes()));
                    }
                    if (this.getPointInTimeRecoverySpecification() != null) {
                        obj.set("pointInTimeRecoverySpecification", om.valueToTree(this.getPointInTimeRecoverySpecification()));
                    }
                    if (this.getProvisionedThroughput() != null) {
                        obj.set("provisionedThroughput", om.valueToTree(this.getProvisionedThroughput()));
                    }
                    if (this.getSseSpecification() != null) {
                        obj.set("sseSpecification", om.valueToTree(this.getSseSpecification()));
                    }
                    if (this.getStreamSpecification() != null) {
                        obj.set("streamSpecification", om.valueToTree(this.getStreamSpecification()));
                    }
                    if (this.getTableName() != null) {
                        obj.set("tableName", om.valueToTree((Object)this.getTableName()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    if (this.getTimeToLiveSpecification() != null) {
                        obj.set("timeToLiveSpecification", om.valueToTree(this.getTimeToLiveSpecification()));
                    }
                    return obj;
                }
            };
        }
    }
}

