/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.applicationautoscaling.BaseTargetTrackingProps;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface UtilizationScalingProps
extends JsiiSerializable,
BaseTargetTrackingProps {
    public Number getTargetUtilizationPercent();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Number _targetUtilizationPercent;
        @Nullable
        private Boolean _disableScaleIn;
        @Nullable
        private String _policyName;
        @Nullable
        private Number _scaleInCooldownSec;
        @Nullable
        private Number _scaleOutCooldownSec;

        public Builder withTargetUtilizationPercent(Number value) {
            this._targetUtilizationPercent = Objects.requireNonNull(value, "targetUtilizationPercent is required");
            return this;
        }

        public Builder withDisableScaleIn(@Nullable Boolean value) {
            this._disableScaleIn = value;
            return this;
        }

        public Builder withPolicyName(@Nullable String value) {
            this._policyName = value;
            return this;
        }

        public Builder withScaleInCooldownSec(@Nullable Number value) {
            this._scaleInCooldownSec = value;
            return this;
        }

        public Builder withScaleOutCooldownSec(@Nullable Number value) {
            this._scaleOutCooldownSec = value;
            return this;
        }

        public UtilizationScalingProps build() {
            return new UtilizationScalingProps(){
                private final Number $targetUtilizationPercent;
                @Nullable
                private final Boolean $disableScaleIn;
                @Nullable
                private final String $policyName;
                @Nullable
                private final Number $scaleInCooldownSec;
                @Nullable
                private final Number $scaleOutCooldownSec;
                {
                    this.$targetUtilizationPercent = Objects.requireNonNull(_targetUtilizationPercent, "targetUtilizationPercent is required");
                    this.$disableScaleIn = _disableScaleIn;
                    this.$policyName = _policyName;
                    this.$scaleInCooldownSec = _scaleInCooldownSec;
                    this.$scaleOutCooldownSec = _scaleOutCooldownSec;
                }

                @Override
                public Number getTargetUtilizationPercent() {
                    return this.$targetUtilizationPercent;
                }

                public Boolean getDisableScaleIn() {
                    return this.$disableScaleIn;
                }

                public String getPolicyName() {
                    return this.$policyName;
                }

                public Number getScaleInCooldownSec() {
                    return this.$scaleInCooldownSec;
                }

                public Number getScaleOutCooldownSec() {
                    return this.$scaleOutCooldownSec;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("targetUtilizationPercent", om.valueToTree((Object)this.getTargetUtilizationPercent()));
                    if (this.getDisableScaleIn() != null) {
                        obj.set("disableScaleIn", om.valueToTree((Object)this.getDisableScaleIn()));
                    }
                    if (this.getPolicyName() != null) {
                        obj.set("policyName", om.valueToTree((Object)this.getPolicyName()));
                    }
                    if (this.getScaleInCooldownSec() != null) {
                        obj.set("scaleInCooldownSec", om.valueToTree((Object)this.getScaleInCooldownSec()));
                    }
                    if (this.getScaleOutCooldownSec() != null) {
                        obj.set("scaleOutCooldownSec", om.valueToTree((Object)this.getScaleOutCooldownSec()));
                    }
                    return obj;
                }
            };
        }
    }
}

