/**
 * <h2>Amazon DynamoDB Construct Library</h2>
 * <!-- raw HTML omitted -->
 * <hr />
 * <p><img src="https://img.shields.io/badge/stability-Experimental-important.svg?style=for-the-badge" alt="Stability: Experimental" /></p>
 * <blockquote>
 * <p><strong>This is a <em>developer preview</em> (public beta) module. Releases might lack important features and might have
 * future breaking changes.</strong></p>
 * <p>This API is still under active development and subject to non-backward
 * compatible changes or removal in any future version. Use of the API is not recommended in production
 * environments. Experimental APIs are not subject to the Semantic Versioning model.</p>
 * </blockquote>
 * <hr />
 * <!-- raw HTML omitted -->
 * <p>Here is a minimal deployable DynamoDB table definition:</p>
 * <pre><code class="language-ts">import dynamodb = require('@aws-cdk/aws-dynamodb');
 * 
 * const table = new dynamodb.Table(this, 'Table', {
 *   partitionKey: { name: 'id', type: dynamodb.AttributeType.String }
 * });
 * </code></pre>
 * <h3>Keys</h3>
 * <p>When a table is defined, you must define it's schema using the <code>partitionKey</code>
 * (required) and <code>sortKey</code> (optional) properties.</p>
 * <h3>Billing Mode</h3>
 * <p>DynamoDB supports two billing modes:</p>
 * <ul>
 * <li>PROVISIONED - the default mode where the table and global secondary indexes have configured read and write capacity.</li>
 * <li>PAY_PER_REQUEST - on-demand pricing and scaling. You only pay for what you use and there is no read and write capacity for the table or its global secondary indexes.</li>
 * </ul>
 * <pre><code class="language-ts">import dynamodb = require('@aws-cdk/aws-dynamodb');
 * 
 * const table = new dynamodb.Table(this, 'Table', {
 *   partitionKey: { name: 'id', type: dynamodb.AttributeType.String },
 *   billingMode: dynamodb.BillingMode.PayPerRequest
 * });
 * </code></pre>
 * <p>Further reading:
 * https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.</p>
 * <h3>Configure AutoScaling for your table</h3>
 * <p>You can have DynamoDB automatically raise and lower the read and write capacities
 * of your table by setting up autoscaling. You can use this to either keep your
 * tables at a desired utilization level, or by scaling up and down at preconfigured
 * times of the day:</p>
 * <p>Auto-scaling is only relevant for tables with the billing mode, PROVISIONED.</p>
 * <pre><code class="language-ts">const readScaling = table.autoScaleReadCapacity({ minCapacity: 1, maxCapacity: 50 });
 * 
 * readScaling.scaleOnUtilization({
 *   targetUtilizationPercent: 50
 * });
 * 
 * readScaling.scaleOnSchedule('ScaleUpInTheMorning', {
 *   schedule: appscaling.Schedule.cron({ hour: '8', minute: '0' }),
 *   minCapacity: 20,
 * });
 * 
 * readScaling.scaleOnSchedule('ScaleDownAtNight', {
 *   schedule: appscaling.Schedule.cron({ hour: '20', minute: '0' }),
 *   maxCapacity: 20
 * });
 * </code></pre>
 * <p>Further reading:
 * https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/AutoScaling.html
 * https://aws.amazon.com/blogs/database/how-to-use-aws-cloudformation-to-configure-auto-scaling-for-amazon-dynamodb-tables-and-indexes/</p>
 * <h3>Amazon DynamoDB Global Tables</h3>
 * <p>Please see the <code>@aws-cdk/aws-dynamodb-global</code> package <a href="../aws-dynamodb-global/">here</a>.</p>
 * 
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.dynamodb;
