/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.dynamodb.Attribute;
import software.amazon.awscdk.services.dynamodb.BillingMode;
import software.amazon.awscdk.services.dynamodb.StreamViewType;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface TableOptions
extends JsiiSerializable {
    public Attribute getPartitionKey();

    public BillingMode getBillingMode();

    public Boolean getPointInTimeRecovery();

    public Number getReadCapacity();

    public Boolean getServerSideEncryption();

    public Attribute getSortKey();

    public StreamViewType getStream();

    public String getTimeToLiveAttribute();

    public Number getWriteCapacity();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Attribute _partitionKey;
        @Nullable
        private BillingMode _billingMode;
        @Nullable
        private Boolean _pointInTimeRecovery;
        @Nullable
        private Number _readCapacity;
        @Nullable
        private Boolean _serverSideEncryption;
        @Nullable
        private Attribute _sortKey;
        @Nullable
        private StreamViewType _stream;
        @Nullable
        private String _timeToLiveAttribute;
        @Nullable
        private Number _writeCapacity;

        public Builder withPartitionKey(Attribute value) {
            this._partitionKey = Objects.requireNonNull(value, "partitionKey is required");
            return this;
        }

        public Builder withBillingMode(@Nullable BillingMode value) {
            this._billingMode = value;
            return this;
        }

        public Builder withPointInTimeRecovery(@Nullable Boolean value) {
            this._pointInTimeRecovery = value;
            return this;
        }

        public Builder withReadCapacity(@Nullable Number value) {
            this._readCapacity = value;
            return this;
        }

        public Builder withServerSideEncryption(@Nullable Boolean value) {
            this._serverSideEncryption = value;
            return this;
        }

        public Builder withSortKey(@Nullable Attribute value) {
            this._sortKey = value;
            return this;
        }

        public Builder withStream(@Nullable StreamViewType value) {
            this._stream = value;
            return this;
        }

        public Builder withTimeToLiveAttribute(@Nullable String value) {
            this._timeToLiveAttribute = value;
            return this;
        }

        public Builder withWriteCapacity(@Nullable Number value) {
            this._writeCapacity = value;
            return this;
        }

        public TableOptions build() {
            return new TableOptions(){
                private final Attribute $partitionKey;
                @Nullable
                private final BillingMode $billingMode;
                @Nullable
                private final Boolean $pointInTimeRecovery;
                @Nullable
                private final Number $readCapacity;
                @Nullable
                private final Boolean $serverSideEncryption;
                @Nullable
                private final Attribute $sortKey;
                @Nullable
                private final StreamViewType $stream;
                @Nullable
                private final String $timeToLiveAttribute;
                @Nullable
                private final Number $writeCapacity;
                {
                    this.$partitionKey = Objects.requireNonNull(_partitionKey, "partitionKey is required");
                    this.$billingMode = _billingMode;
                    this.$pointInTimeRecovery = _pointInTimeRecovery;
                    this.$readCapacity = _readCapacity;
                    this.$serverSideEncryption = _serverSideEncryption;
                    this.$sortKey = _sortKey;
                    this.$stream = _stream;
                    this.$timeToLiveAttribute = _timeToLiveAttribute;
                    this.$writeCapacity = _writeCapacity;
                }

                @Override
                public Attribute getPartitionKey() {
                    return this.$partitionKey;
                }

                @Override
                public BillingMode getBillingMode() {
                    return this.$billingMode;
                }

                @Override
                public Boolean getPointInTimeRecovery() {
                    return this.$pointInTimeRecovery;
                }

                @Override
                public Number getReadCapacity() {
                    return this.$readCapacity;
                }

                @Override
                public Boolean getServerSideEncryption() {
                    return this.$serverSideEncryption;
                }

                @Override
                public Attribute getSortKey() {
                    return this.$sortKey;
                }

                @Override
                public StreamViewType getStream() {
                    return this.$stream;
                }

                @Override
                public String getTimeToLiveAttribute() {
                    return this.$timeToLiveAttribute;
                }

                @Override
                public Number getWriteCapacity() {
                    return this.$writeCapacity;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("partitionKey", om.valueToTree((Object)this.getPartitionKey()));
                    if (this.getBillingMode() != null) {
                        obj.set("billingMode", om.valueToTree((Object)this.getBillingMode()));
                    }
                    if (this.getPointInTimeRecovery() != null) {
                        obj.set("pointInTimeRecovery", om.valueToTree((Object)this.getPointInTimeRecovery()));
                    }
                    if (this.getReadCapacity() != null) {
                        obj.set("readCapacity", om.valueToTree((Object)this.getReadCapacity()));
                    }
                    if (this.getServerSideEncryption() != null) {
                        obj.set("serverSideEncryption", om.valueToTree((Object)this.getServerSideEncryption()));
                    }
                    if (this.getSortKey() != null) {
                        obj.set("sortKey", om.valueToTree((Object)this.getSortKey()));
                    }
                    if (this.getStream() != null) {
                        obj.set("stream", om.valueToTree((Object)this.getStream()));
                    }
                    if (this.getTimeToLiveAttribute() != null) {
                        obj.set("timeToLiveAttribute", om.valueToTree((Object)this.getTimeToLiveAttribute()));
                    }
                    if (this.getWriteCapacity() != null) {
                        obj.set("writeCapacity", om.valueToTree((Object)this.getWriteCapacity()));
                    }
                    return obj;
                }
            };
        }
    }
}

