package software.amazon.awscdk.services.dynamodb.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.cloudformation.TableResource")
public class TableResource extends software.amazon.awscdk.Resource {
    protected TableResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::DynamoDB::Table``.
     * @param parent the ``cdk.Construct`` this ``TableResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``TableResource``
     */
    public TableResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.dynamodb.cloudformation.TableResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute Arn
     */
    public software.amazon.awscdk.services.dynamodb.TableArn getTableArn() {
        return this.jsiiGet("tableArn", software.amazon.awscdk.services.dynamodb.TableArn.class);
    }
    /**
     * @cloudformation_attribute StreamArn
     */
    public software.amazon.awscdk.services.dynamodb.TableStreamArn getTableStreamArn() {
        return this.jsiiGet("tableStreamArn", software.amazon.awscdk.services.dynamodb.TableStreamArn.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html
     */
    public static interface AttributeDefinitionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.AttributeDefinitionProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
         */
        java.lang.Object getAttributeName();
        /**
         * ``TableResource.AttributeDefinitionProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
         */
        void setAttributeName(final java.lang.String value);
        /**
         * ``TableResource.AttributeDefinitionProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
         */
        void setAttributeName(final software.amazon.awscdk.Token value);
        /**
         * ``TableResource.AttributeDefinitionProperty.AttributeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
         */
        java.lang.Object getAttributeType();
        /**
         * ``TableResource.AttributeDefinitionProperty.AttributeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
         */
        void setAttributeType(final java.lang.String value);
        /**
         * ``TableResource.AttributeDefinitionProperty.AttributeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
         */
        void setAttributeType(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link AttributeDefinitionProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``TableResource.AttributeDefinitionProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
             */
            public AttributeTypeStep withAttributeName(final java.lang.String value) {
                return new FullBuilder().withAttributeName(value);
            }
            /**
             * ``TableResource.AttributeDefinitionProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
             */
            public AttributeTypeStep withAttributeName(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withAttributeName(value);
            }

            public interface AttributeTypeStep {
                /**
                 * ``TableResource.AttributeDefinitionProperty.AttributeType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
                 */
                Build withAttributeType(final java.lang.String value);
                /**
                 * ``TableResource.AttributeDefinitionProperty.AttributeType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
                 */
                Build withAttributeType(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link AttributeDefinitionProperty} object, initialized with the values set on this builder.
                 */
                AttributeDefinitionProperty build();
            }

            final class FullBuilder implements AttributeTypeStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``TableResource.AttributeDefinitionProperty.AttributeName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
                 */
                public AttributeTypeStep withAttributeName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "AttributeDefinitionProperty#attributeName is required");
                    this.instance._attributeName = value;
                    return this;
                }
                /**
                 * ``TableResource.AttributeDefinitionProperty.AttributeName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
                 */
                public AttributeTypeStep withAttributeName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "AttributeDefinitionProperty#attributeName is required");
                    this.instance._attributeName = value;
                    return this;
                }
                /**
                 * ``TableResource.AttributeDefinitionProperty.AttributeType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
                 */
                public Build withAttributeType(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "AttributeDefinitionProperty#attributeType is required");
                    this.instance._attributeType = value;
                    return this;
                }
                /**
                 * ``TableResource.AttributeDefinitionProperty.AttributeType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
                 */
                public Build withAttributeType(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "AttributeDefinitionProperty#attributeType is required");
                    this.instance._attributeType = value;
                    return this;
                }
                public AttributeDefinitionProperty build() {
                    AttributeDefinitionProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link AttributeDefinitionProperty}.
         */
        final class Jsii$Pojo implements AttributeDefinitionProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _attributeName;

            public java.lang.Object getAttributeName() {
                return this._attributeName;
            }
            public void setAttributeName(final java.lang.String value) {
                this._attributeName = value;
            }
            public void setAttributeName(final software.amazon.awscdk.Token value) {
                this._attributeName = value;
            }

            protected java.lang.Object _attributeType;

            public java.lang.Object getAttributeType() {
                return this._attributeType;
            }
            public void setAttributeType(final java.lang.String value) {
                this._attributeType = value;
            }
            public void setAttributeType(final software.amazon.awscdk.Token value) {
                this._attributeType = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.AttributeDefinitionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``TableResource.AttributeDefinitionProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
             */
            public java.lang.Object getAttributeName() {
                return this.jsiiGet("attributeName", java.lang.Object.class);
            }
            /**
             * ``TableResource.AttributeDefinitionProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
             */
            public void setAttributeName(final java.lang.String value) {
                this.jsiiSet("attributeName", java.util.Objects.requireNonNull(value, "attributeName is required"));
            }
            /**
             * ``TableResource.AttributeDefinitionProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
             */
            public void setAttributeName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("attributeName", java.util.Objects.requireNonNull(value, "attributeName is required"));
            }
            /**
             * ``TableResource.AttributeDefinitionProperty.AttributeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
             */
            public java.lang.Object getAttributeType() {
                return this.jsiiGet("attributeType", java.lang.Object.class);
            }
            /**
             * ``TableResource.AttributeDefinitionProperty.AttributeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
             */
            public void setAttributeType(final java.lang.String value) {
                this.jsiiSet("attributeType", java.util.Objects.requireNonNull(value, "attributeType is required"));
            }
            /**
             * ``TableResource.AttributeDefinitionProperty.AttributeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
             */
            public void setAttributeType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("attributeType", java.util.Objects.requireNonNull(value, "attributeType is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html
     */
    public static interface GlobalSecondaryIndexProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.IndexName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
         */
        java.lang.Object getIndexName();
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.IndexName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
         */
        void setIndexName(final java.lang.String value);
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.IndexName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
         */
        void setIndexName(final software.amazon.awscdk.Token value);
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
         */
        java.lang.Object getKeySchema();
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
         */
        void setKeySchema(final software.amazon.awscdk.Token value);
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
         */
        void setKeySchema(final java.util.List<java.lang.Object> value);
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
         */
        java.lang.Object getProjection();
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
         */
        void setProjection(final software.amazon.awscdk.Token value);
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
         */
        void setProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value);
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
         */
        java.lang.Object getProvisionedThroughput();
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
         */
        void setProvisionedThroughput(final software.amazon.awscdk.Token value);
        /**
         * ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
         */
        void setProvisionedThroughput(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProvisionedThroughputProperty value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link GlobalSecondaryIndexProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``TableResource.GlobalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
             */
            public KeySchemaStep withIndexName(final java.lang.String value) {
                return new FullBuilder().withIndexName(value);
            }
            /**
             * ``TableResource.GlobalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
             */
            public KeySchemaStep withIndexName(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withIndexName(value);
            }

            public interface KeySchemaStep {
                /**
                 * ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
                 */
                ProjectionStep withKeySchema(final software.amazon.awscdk.Token value);
                /**
                 * ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
                 */
                ProjectionStep withKeySchema(final java.util.List<java.lang.Object> value);
            }

            public interface ProjectionStep {
                /**
                 * ``TableResource.GlobalSecondaryIndexProperty.Projection``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
                 */
                ProvisionedThroughputStep withProjection(final software.amazon.awscdk.Token value);
                /**
                 * ``TableResource.GlobalSecondaryIndexProperty.Projection``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
                 */
                ProvisionedThroughputStep withProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value);
            }

            public interface ProvisionedThroughputStep {
                /**
                 * ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
                 */
                Build withProvisionedThroughput(final software.amazon.awscdk.Token value);
                /**
                 * ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
                 */
                Build withProvisionedThroughput(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProvisionedThroughputProperty value);
            }

            public interface Build {
                /**
                 * @return a new {@link GlobalSecondaryIndexProperty} object, initialized with the values set on this builder.
                 */
                GlobalSecondaryIndexProperty build();
            }

            final class FullBuilder implements KeySchemaStep, ProjectionStep, ProvisionedThroughputStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``TableResource.GlobalSecondaryIndexProperty.IndexName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
                 */
                public KeySchemaStep withIndexName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "GlobalSecondaryIndexProperty#indexName is required");
                    this.instance._indexName = value;
                    return this;
                }
                /**
                 * ``TableResource.GlobalSecondaryIndexProperty.IndexName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
                 */
                public KeySchemaStep withIndexName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "GlobalSecondaryIndexProperty#indexName is required");
                    this.instance._indexName = value;
                    return this;
                }
                /**
                 * ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
                 */
                public ProjectionStep withKeySchema(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "GlobalSecondaryIndexProperty#keySchema is required");
                    this.instance._keySchema = value;
                    return this;
                }
                /**
                 * ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
                 */
                public ProjectionStep withKeySchema(final java.util.List<java.lang.Object> value) {
                    java.util.Objects.requireNonNull(value, "GlobalSecondaryIndexProperty#keySchema is required");
                    this.instance._keySchema = value;
                    return this;
                }
                /**
                 * ``TableResource.GlobalSecondaryIndexProperty.Projection``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
                 */
                public ProvisionedThroughputStep withProjection(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "GlobalSecondaryIndexProperty#projection is required");
                    this.instance._projection = value;
                    return this;
                }
                /**
                 * ``TableResource.GlobalSecondaryIndexProperty.Projection``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
                 */
                public ProvisionedThroughputStep withProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value) {
                    java.util.Objects.requireNonNull(value, "GlobalSecondaryIndexProperty#projection is required");
                    this.instance._projection = value;
                    return this;
                }
                /**
                 * ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
                 */
                public Build withProvisionedThroughput(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "GlobalSecondaryIndexProperty#provisionedThroughput is required");
                    this.instance._provisionedThroughput = value;
                    return this;
                }
                /**
                 * ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
                 */
                public Build withProvisionedThroughput(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProvisionedThroughputProperty value) {
                    java.util.Objects.requireNonNull(value, "GlobalSecondaryIndexProperty#provisionedThroughput is required");
                    this.instance._provisionedThroughput = value;
                    return this;
                }
                public GlobalSecondaryIndexProperty build() {
                    GlobalSecondaryIndexProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link GlobalSecondaryIndexProperty}.
         */
        final class Jsii$Pojo implements GlobalSecondaryIndexProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _indexName;

            public java.lang.Object getIndexName() {
                return this._indexName;
            }
            public void setIndexName(final java.lang.String value) {
                this._indexName = value;
            }
            public void setIndexName(final software.amazon.awscdk.Token value) {
                this._indexName = value;
            }

            protected java.lang.Object _keySchema;

            public java.lang.Object getKeySchema() {
                return this._keySchema;
            }
            public void setKeySchema(final software.amazon.awscdk.Token value) {
                this._keySchema = value;
            }
            public void setKeySchema(final java.util.List<java.lang.Object> value) {
                this._keySchema = value;
            }

            protected java.lang.Object _projection;

            public java.lang.Object getProjection() {
                return this._projection;
            }
            public void setProjection(final software.amazon.awscdk.Token value) {
                this._projection = value;
            }
            public void setProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value) {
                this._projection = value;
            }

            protected java.lang.Object _provisionedThroughput;

            public java.lang.Object getProvisionedThroughput() {
                return this._provisionedThroughput;
            }
            public void setProvisionedThroughput(final software.amazon.awscdk.Token value) {
                this._provisionedThroughput = value;
            }
            public void setProvisionedThroughput(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProvisionedThroughputProperty value) {
                this._provisionedThroughput = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.GlobalSecondaryIndexProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``TableResource.GlobalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
             */
            public java.lang.Object getIndexName() {
                return this.jsiiGet("indexName", java.lang.Object.class);
            }
            /**
             * ``TableResource.GlobalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
             */
            public void setIndexName(final java.lang.String value) {
                this.jsiiSet("indexName", java.util.Objects.requireNonNull(value, "indexName is required"));
            }
            /**
             * ``TableResource.GlobalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
             */
            public void setIndexName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("indexName", java.util.Objects.requireNonNull(value, "indexName is required"));
            }
            /**
             * ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
             */
            public java.lang.Object getKeySchema() {
                return this.jsiiGet("keySchema", java.lang.Object.class);
            }
            /**
             * ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
             */
            public void setKeySchema(final software.amazon.awscdk.Token value) {
                this.jsiiSet("keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
            }
            /**
             * ``TableResource.GlobalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
             */
            public void setKeySchema(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
            }
            /**
             * ``TableResource.GlobalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
             */
            public java.lang.Object getProjection() {
                return this.jsiiGet("projection", java.lang.Object.class);
            }
            /**
             * ``TableResource.GlobalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
             */
            public void setProjection(final software.amazon.awscdk.Token value) {
                this.jsiiSet("projection", java.util.Objects.requireNonNull(value, "projection is required"));
            }
            /**
             * ``TableResource.GlobalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
             */
            public void setProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value) {
                this.jsiiSet("projection", java.util.Objects.requireNonNull(value, "projection is required"));
            }
            /**
             * ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
             */
            public java.lang.Object getProvisionedThroughput() {
                return this.jsiiGet("provisionedThroughput", java.lang.Object.class);
            }
            /**
             * ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
             */
            public void setProvisionedThroughput(final software.amazon.awscdk.Token value) {
                this.jsiiSet("provisionedThroughput", java.util.Objects.requireNonNull(value, "provisionedThroughput is required"));
            }
            /**
             * ``TableResource.GlobalSecondaryIndexProperty.ProvisionedThroughput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
             */
            public void setProvisionedThroughput(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProvisionedThroughputProperty value) {
                this.jsiiSet("provisionedThroughput", java.util.Objects.requireNonNull(value, "provisionedThroughput is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html
     */
    public static interface KeySchemaProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.KeySchemaProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
         */
        java.lang.Object getAttributeName();
        /**
         * ``TableResource.KeySchemaProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
         */
        void setAttributeName(final java.lang.String value);
        /**
         * ``TableResource.KeySchemaProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
         */
        void setAttributeName(final software.amazon.awscdk.Token value);
        /**
         * ``TableResource.KeySchemaProperty.KeyType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
         */
        java.lang.Object getKeyType();
        /**
         * ``TableResource.KeySchemaProperty.KeyType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
         */
        void setKeyType(final java.lang.String value);
        /**
         * ``TableResource.KeySchemaProperty.KeyType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
         */
        void setKeyType(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link KeySchemaProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``TableResource.KeySchemaProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
             */
            public KeyTypeStep withAttributeName(final java.lang.String value) {
                return new FullBuilder().withAttributeName(value);
            }
            /**
             * ``TableResource.KeySchemaProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
             */
            public KeyTypeStep withAttributeName(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withAttributeName(value);
            }

            public interface KeyTypeStep {
                /**
                 * ``TableResource.KeySchemaProperty.KeyType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
                 */
                Build withKeyType(final java.lang.String value);
                /**
                 * ``TableResource.KeySchemaProperty.KeyType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
                 */
                Build withKeyType(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link KeySchemaProperty} object, initialized with the values set on this builder.
                 */
                KeySchemaProperty build();
            }

            final class FullBuilder implements KeyTypeStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``TableResource.KeySchemaProperty.AttributeName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
                 */
                public KeyTypeStep withAttributeName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "KeySchemaProperty#attributeName is required");
                    this.instance._attributeName = value;
                    return this;
                }
                /**
                 * ``TableResource.KeySchemaProperty.AttributeName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
                 */
                public KeyTypeStep withAttributeName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "KeySchemaProperty#attributeName is required");
                    this.instance._attributeName = value;
                    return this;
                }
                /**
                 * ``TableResource.KeySchemaProperty.KeyType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
                 */
                public Build withKeyType(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "KeySchemaProperty#keyType is required");
                    this.instance._keyType = value;
                    return this;
                }
                /**
                 * ``TableResource.KeySchemaProperty.KeyType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
                 */
                public Build withKeyType(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "KeySchemaProperty#keyType is required");
                    this.instance._keyType = value;
                    return this;
                }
                public KeySchemaProperty build() {
                    KeySchemaProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link KeySchemaProperty}.
         */
        final class Jsii$Pojo implements KeySchemaProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _attributeName;

            public java.lang.Object getAttributeName() {
                return this._attributeName;
            }
            public void setAttributeName(final java.lang.String value) {
                this._attributeName = value;
            }
            public void setAttributeName(final software.amazon.awscdk.Token value) {
                this._attributeName = value;
            }

            protected java.lang.Object _keyType;

            public java.lang.Object getKeyType() {
                return this._keyType;
            }
            public void setKeyType(final java.lang.String value) {
                this._keyType = value;
            }
            public void setKeyType(final software.amazon.awscdk.Token value) {
                this._keyType = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.KeySchemaProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``TableResource.KeySchemaProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
             */
            public java.lang.Object getAttributeName() {
                return this.jsiiGet("attributeName", java.lang.Object.class);
            }
            /**
             * ``TableResource.KeySchemaProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
             */
            public void setAttributeName(final java.lang.String value) {
                this.jsiiSet("attributeName", java.util.Objects.requireNonNull(value, "attributeName is required"));
            }
            /**
             * ``TableResource.KeySchemaProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
             */
            public void setAttributeName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("attributeName", java.util.Objects.requireNonNull(value, "attributeName is required"));
            }
            /**
             * ``TableResource.KeySchemaProperty.KeyType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
             */
            public java.lang.Object getKeyType() {
                return this.jsiiGet("keyType", java.lang.Object.class);
            }
            /**
             * ``TableResource.KeySchemaProperty.KeyType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
             */
            public void setKeyType(final java.lang.String value) {
                this.jsiiSet("keyType", java.util.Objects.requireNonNull(value, "keyType is required"));
            }
            /**
             * ``TableResource.KeySchemaProperty.KeyType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
             */
            public void setKeyType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("keyType", java.util.Objects.requireNonNull(value, "keyType is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html
     */
    public static interface LocalSecondaryIndexProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.LocalSecondaryIndexProperty.IndexName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
         */
        java.lang.Object getIndexName();
        /**
         * ``TableResource.LocalSecondaryIndexProperty.IndexName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
         */
        void setIndexName(final java.lang.String value);
        /**
         * ``TableResource.LocalSecondaryIndexProperty.IndexName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
         */
        void setIndexName(final software.amazon.awscdk.Token value);
        /**
         * ``TableResource.LocalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
         */
        java.lang.Object getKeySchema();
        /**
         * ``TableResource.LocalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
         */
        void setKeySchema(final software.amazon.awscdk.Token value);
        /**
         * ``TableResource.LocalSecondaryIndexProperty.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
         */
        void setKeySchema(final java.util.List<java.lang.Object> value);
        /**
         * ``TableResource.LocalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
         */
        java.lang.Object getProjection();
        /**
         * ``TableResource.LocalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
         */
        void setProjection(final software.amazon.awscdk.Token value);
        /**
         * ``TableResource.LocalSecondaryIndexProperty.Projection``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
         */
        void setProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link LocalSecondaryIndexProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``TableResource.LocalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
             */
            public KeySchemaStep withIndexName(final java.lang.String value) {
                return new FullBuilder().withIndexName(value);
            }
            /**
             * ``TableResource.LocalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
             */
            public KeySchemaStep withIndexName(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withIndexName(value);
            }

            public interface KeySchemaStep {
                /**
                 * ``TableResource.LocalSecondaryIndexProperty.KeySchema``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
                 */
                ProjectionStep withKeySchema(final software.amazon.awscdk.Token value);
                /**
                 * ``TableResource.LocalSecondaryIndexProperty.KeySchema``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
                 */
                ProjectionStep withKeySchema(final java.util.List<java.lang.Object> value);
            }

            public interface ProjectionStep {
                /**
                 * ``TableResource.LocalSecondaryIndexProperty.Projection``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
                 */
                Build withProjection(final software.amazon.awscdk.Token value);
                /**
                 * ``TableResource.LocalSecondaryIndexProperty.Projection``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
                 */
                Build withProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value);
            }

            public interface Build {
                /**
                 * @return a new {@link LocalSecondaryIndexProperty} object, initialized with the values set on this builder.
                 */
                LocalSecondaryIndexProperty build();
            }

            final class FullBuilder implements KeySchemaStep, ProjectionStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``TableResource.LocalSecondaryIndexProperty.IndexName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
                 */
                public KeySchemaStep withIndexName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "LocalSecondaryIndexProperty#indexName is required");
                    this.instance._indexName = value;
                    return this;
                }
                /**
                 * ``TableResource.LocalSecondaryIndexProperty.IndexName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
                 */
                public KeySchemaStep withIndexName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "LocalSecondaryIndexProperty#indexName is required");
                    this.instance._indexName = value;
                    return this;
                }
                /**
                 * ``TableResource.LocalSecondaryIndexProperty.KeySchema``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
                 */
                public ProjectionStep withKeySchema(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "LocalSecondaryIndexProperty#keySchema is required");
                    this.instance._keySchema = value;
                    return this;
                }
                /**
                 * ``TableResource.LocalSecondaryIndexProperty.KeySchema``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
                 */
                public ProjectionStep withKeySchema(final java.util.List<java.lang.Object> value) {
                    java.util.Objects.requireNonNull(value, "LocalSecondaryIndexProperty#keySchema is required");
                    this.instance._keySchema = value;
                    return this;
                }
                /**
                 * ``TableResource.LocalSecondaryIndexProperty.Projection``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
                 */
                public Build withProjection(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "LocalSecondaryIndexProperty#projection is required");
                    this.instance._projection = value;
                    return this;
                }
                /**
                 * ``TableResource.LocalSecondaryIndexProperty.Projection``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
                 */
                public Build withProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value) {
                    java.util.Objects.requireNonNull(value, "LocalSecondaryIndexProperty#projection is required");
                    this.instance._projection = value;
                    return this;
                }
                public LocalSecondaryIndexProperty build() {
                    LocalSecondaryIndexProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link LocalSecondaryIndexProperty}.
         */
        final class Jsii$Pojo implements LocalSecondaryIndexProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _indexName;

            public java.lang.Object getIndexName() {
                return this._indexName;
            }
            public void setIndexName(final java.lang.String value) {
                this._indexName = value;
            }
            public void setIndexName(final software.amazon.awscdk.Token value) {
                this._indexName = value;
            }

            protected java.lang.Object _keySchema;

            public java.lang.Object getKeySchema() {
                return this._keySchema;
            }
            public void setKeySchema(final software.amazon.awscdk.Token value) {
                this._keySchema = value;
            }
            public void setKeySchema(final java.util.List<java.lang.Object> value) {
                this._keySchema = value;
            }

            protected java.lang.Object _projection;

            public java.lang.Object getProjection() {
                return this._projection;
            }
            public void setProjection(final software.amazon.awscdk.Token value) {
                this._projection = value;
            }
            public void setProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value) {
                this._projection = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.LocalSecondaryIndexProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``TableResource.LocalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
             */
            public java.lang.Object getIndexName() {
                return this.jsiiGet("indexName", java.lang.Object.class);
            }
            /**
             * ``TableResource.LocalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
             */
            public void setIndexName(final java.lang.String value) {
                this.jsiiSet("indexName", java.util.Objects.requireNonNull(value, "indexName is required"));
            }
            /**
             * ``TableResource.LocalSecondaryIndexProperty.IndexName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
             */
            public void setIndexName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("indexName", java.util.Objects.requireNonNull(value, "indexName is required"));
            }
            /**
             * ``TableResource.LocalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
             */
            public java.lang.Object getKeySchema() {
                return this.jsiiGet("keySchema", java.lang.Object.class);
            }
            /**
             * ``TableResource.LocalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
             */
            public void setKeySchema(final software.amazon.awscdk.Token value) {
                this.jsiiSet("keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
            }
            /**
             * ``TableResource.LocalSecondaryIndexProperty.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
             */
            public void setKeySchema(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
            }
            /**
             * ``TableResource.LocalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
             */
            public java.lang.Object getProjection() {
                return this.jsiiGet("projection", java.lang.Object.class);
            }
            /**
             * ``TableResource.LocalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
             */
            public void setProjection(final software.amazon.awscdk.Token value) {
                this.jsiiSet("projection", java.util.Objects.requireNonNull(value, "projection is required"));
            }
            /**
             * ``TableResource.LocalSecondaryIndexProperty.Projection``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
             */
            public void setProjection(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty value) {
                this.jsiiSet("projection", java.util.Objects.requireNonNull(value, "projection is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html
     */
    public static interface PointInTimeRecoverySpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
         */
        java.lang.Object getPointInTimeRecoveryEnabled();
        /**
         * ``TableResource.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
         */
        void setPointInTimeRecoveryEnabled(final java.lang.Boolean value);
        /**
         * ``TableResource.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
         */
        void setPointInTimeRecoveryEnabled(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link PointInTimeRecoverySpecificationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``TableResource.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
             */
            public Builder withPointInTimeRecoveryEnabled(final java.lang.Boolean value) {
                this.instance._pointInTimeRecoveryEnabled = value;
                return this;
            }
            /**
             * ``TableResource.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
             */
            public Builder withPointInTimeRecoveryEnabled(final software.amazon.awscdk.Token value) {
                this.instance._pointInTimeRecoveryEnabled = value;
                return this;
            }
            public PointInTimeRecoverySpecificationProperty build() {
                PointInTimeRecoverySpecificationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link PointInTimeRecoverySpecificationProperty}.
         */
        final class Jsii$Pojo implements PointInTimeRecoverySpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _pointInTimeRecoveryEnabled;

            public java.lang.Object getPointInTimeRecoveryEnabled() {
                return this._pointInTimeRecoveryEnabled;
            }
            public void setPointInTimeRecoveryEnabled(final java.lang.Boolean value) {
                this._pointInTimeRecoveryEnabled = value;
            }
            public void setPointInTimeRecoveryEnabled(final software.amazon.awscdk.Token value) {
                this._pointInTimeRecoveryEnabled = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.PointInTimeRecoverySpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``TableResource.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getPointInTimeRecoveryEnabled() {
                return this.jsiiGet("pointInTimeRecoveryEnabled", java.lang.Object.class);
            }
            /**
             * ``TableResource.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
             */
            public void setPointInTimeRecoveryEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("pointInTimeRecoveryEnabled", value);
            }
            /**
             * ``TableResource.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
             */
            public void setPointInTimeRecoveryEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("pointInTimeRecoveryEnabled", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html
     */
    public static interface ProjectionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.ProjectionProperty.NonKeyAttributes``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
         */
        java.lang.Object getNonKeyAttributes();
        /**
         * ``TableResource.ProjectionProperty.NonKeyAttributes``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
         */
        void setNonKeyAttributes(final software.amazon.awscdk.Token value);
        /**
         * ``TableResource.ProjectionProperty.NonKeyAttributes``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
         */
        void setNonKeyAttributes(final java.util.List<java.lang.Object> value);
        /**
         * ``TableResource.ProjectionProperty.ProjectionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
         */
        java.lang.Object getProjectionType();
        /**
         * ``TableResource.ProjectionProperty.ProjectionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
         */
        void setProjectionType(final java.lang.String value);
        /**
         * ``TableResource.ProjectionProperty.ProjectionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
         */
        void setProjectionType(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link ProjectionProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``TableResource.ProjectionProperty.NonKeyAttributes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
             */
            public Builder withNonKeyAttributes(final software.amazon.awscdk.Token value) {
                this.instance._nonKeyAttributes = value;
                return this;
            }
            /**
             * ``TableResource.ProjectionProperty.NonKeyAttributes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
             */
            public Builder withNonKeyAttributes(final java.util.List<java.lang.Object> value) {
                this.instance._nonKeyAttributes = value;
                return this;
            }
            /**
             * ``TableResource.ProjectionProperty.ProjectionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
             */
            public Builder withProjectionType(final java.lang.String value) {
                this.instance._projectionType = value;
                return this;
            }
            /**
             * ``TableResource.ProjectionProperty.ProjectionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
             */
            public Builder withProjectionType(final software.amazon.awscdk.Token value) {
                this.instance._projectionType = value;
                return this;
            }
            public ProjectionProperty build() {
                ProjectionProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ProjectionProperty}.
         */
        final class Jsii$Pojo implements ProjectionProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _nonKeyAttributes;

            public java.lang.Object getNonKeyAttributes() {
                return this._nonKeyAttributes;
            }
            public void setNonKeyAttributes(final software.amazon.awscdk.Token value) {
                this._nonKeyAttributes = value;
            }
            public void setNonKeyAttributes(final java.util.List<java.lang.Object> value) {
                this._nonKeyAttributes = value;
            }

            protected java.lang.Object _projectionType;

            public java.lang.Object getProjectionType() {
                return this._projectionType;
            }
            public void setProjectionType(final java.lang.String value) {
                this._projectionType = value;
            }
            public void setProjectionType(final software.amazon.awscdk.Token value) {
                this._projectionType = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProjectionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``TableResource.ProjectionProperty.NonKeyAttributes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
             */
            @javax.annotation.Nullable
            public java.lang.Object getNonKeyAttributes() {
                return this.jsiiGet("nonKeyAttributes", java.lang.Object.class);
            }
            /**
             * ``TableResource.ProjectionProperty.NonKeyAttributes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
             */
            public void setNonKeyAttributes(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("nonKeyAttributes", value);
            }
            /**
             * ``TableResource.ProjectionProperty.NonKeyAttributes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
             */
            public void setNonKeyAttributes(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("nonKeyAttributes", value);
            }
            /**
             * ``TableResource.ProjectionProperty.ProjectionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
             */
            @javax.annotation.Nullable
            public java.lang.Object getProjectionType() {
                return this.jsiiGet("projectionType", java.lang.Object.class);
            }
            /**
             * ``TableResource.ProjectionProperty.ProjectionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
             */
            public void setProjectionType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("projectionType", value);
            }
            /**
             * ``TableResource.ProjectionProperty.ProjectionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
             */
            public void setProjectionType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("projectionType", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     */
    public static interface ProvisionedThroughputProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
         */
        java.lang.Object getReadCapacityUnits();
        /**
         * ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
         */
        void setReadCapacityUnits(final java.lang.Number value);
        /**
         * ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
         */
        void setReadCapacityUnits(final software.amazon.awscdk.Token value);
        /**
         * ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
         */
        java.lang.Object getWriteCapacityUnits();
        /**
         * ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
         */
        void setWriteCapacityUnits(final java.lang.Number value);
        /**
         * ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
         */
        void setWriteCapacityUnits(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link ProvisionedThroughputProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
             */
            public WriteCapacityUnitsStep withReadCapacityUnits(final java.lang.Number value) {
                return new FullBuilder().withReadCapacityUnits(value);
            }
            /**
             * ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
             */
            public WriteCapacityUnitsStep withReadCapacityUnits(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withReadCapacityUnits(value);
            }

            public interface WriteCapacityUnitsStep {
                /**
                 * ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
                 */
                Build withWriteCapacityUnits(final java.lang.Number value);
                /**
                 * ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
                 */
                Build withWriteCapacityUnits(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link ProvisionedThroughputProperty} object, initialized with the values set on this builder.
                 */
                ProvisionedThroughputProperty build();
            }

            final class FullBuilder implements WriteCapacityUnitsStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
                 */
                public WriteCapacityUnitsStep withReadCapacityUnits(final java.lang.Number value) {
                    java.util.Objects.requireNonNull(value, "ProvisionedThroughputProperty#readCapacityUnits is required");
                    this.instance._readCapacityUnits = value;
                    return this;
                }
                /**
                 * ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
                 */
                public WriteCapacityUnitsStep withReadCapacityUnits(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ProvisionedThroughputProperty#readCapacityUnits is required");
                    this.instance._readCapacityUnits = value;
                    return this;
                }
                /**
                 * ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
                 */
                public Build withWriteCapacityUnits(final java.lang.Number value) {
                    java.util.Objects.requireNonNull(value, "ProvisionedThroughputProperty#writeCapacityUnits is required");
                    this.instance._writeCapacityUnits = value;
                    return this;
                }
                /**
                 * ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
                 */
                public Build withWriteCapacityUnits(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ProvisionedThroughputProperty#writeCapacityUnits is required");
                    this.instance._writeCapacityUnits = value;
                    return this;
                }
                public ProvisionedThroughputProperty build() {
                    ProvisionedThroughputProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ProvisionedThroughputProperty}.
         */
        final class Jsii$Pojo implements ProvisionedThroughputProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _readCapacityUnits;

            public java.lang.Object getReadCapacityUnits() {
                return this._readCapacityUnits;
            }
            public void setReadCapacityUnits(final java.lang.Number value) {
                this._readCapacityUnits = value;
            }
            public void setReadCapacityUnits(final software.amazon.awscdk.Token value) {
                this._readCapacityUnits = value;
            }

            protected java.lang.Object _writeCapacityUnits;

            public java.lang.Object getWriteCapacityUnits() {
                return this._writeCapacityUnits;
            }
            public void setWriteCapacityUnits(final java.lang.Number value) {
                this._writeCapacityUnits = value;
            }
            public void setWriteCapacityUnits(final software.amazon.awscdk.Token value) {
                this._writeCapacityUnits = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProvisionedThroughputProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
             */
            public java.lang.Object getReadCapacityUnits() {
                return this.jsiiGet("readCapacityUnits", java.lang.Object.class);
            }
            /**
             * ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
             */
            public void setReadCapacityUnits(final java.lang.Number value) {
                this.jsiiSet("readCapacityUnits", java.util.Objects.requireNonNull(value, "readCapacityUnits is required"));
            }
            /**
             * ``TableResource.ProvisionedThroughputProperty.ReadCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
             */
            public void setReadCapacityUnits(final software.amazon.awscdk.Token value) {
                this.jsiiSet("readCapacityUnits", java.util.Objects.requireNonNull(value, "readCapacityUnits is required"));
            }
            /**
             * ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
             */
            public java.lang.Object getWriteCapacityUnits() {
                return this.jsiiGet("writeCapacityUnits", java.lang.Object.class);
            }
            /**
             * ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
             */
            public void setWriteCapacityUnits(final java.lang.Number value) {
                this.jsiiSet("writeCapacityUnits", java.util.Objects.requireNonNull(value, "writeCapacityUnits is required"));
            }
            /**
             * ``TableResource.ProvisionedThroughputProperty.WriteCapacityUnits``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
             */
            public void setWriteCapacityUnits(final software.amazon.awscdk.Token value) {
                this.jsiiSet("writeCapacityUnits", java.util.Objects.requireNonNull(value, "writeCapacityUnits is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html
     */
    public static interface SSESpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.SSESpecificationProperty.SSEEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
         */
        java.lang.Object getSseEnabled();
        /**
         * ``TableResource.SSESpecificationProperty.SSEEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
         */
        void setSseEnabled(final java.lang.Boolean value);
        /**
         * ``TableResource.SSESpecificationProperty.SSEEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
         */
        void setSseEnabled(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link SSESpecificationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``TableResource.SSESpecificationProperty.SSEEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
             */
            public Build withSseEnabled(final java.lang.Boolean value) {
                return new FullBuilder().withSseEnabled(value);
            }
            /**
             * ``TableResource.SSESpecificationProperty.SSEEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
             */
            public Build withSseEnabled(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withSseEnabled(value);
            }

            public interface Build {
                /**
                 * @return a new {@link SSESpecificationProperty} object, initialized with the values set on this builder.
                 */
                SSESpecificationProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``TableResource.SSESpecificationProperty.SSEEnabled``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
                 */
                public Build withSseEnabled(final java.lang.Boolean value) {
                    java.util.Objects.requireNonNull(value, "SSESpecificationProperty#sseEnabled is required");
                    this.instance._sseEnabled = value;
                    return this;
                }
                /**
                 * ``TableResource.SSESpecificationProperty.SSEEnabled``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
                 */
                public Build withSseEnabled(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "SSESpecificationProperty#sseEnabled is required");
                    this.instance._sseEnabled = value;
                    return this;
                }
                public SSESpecificationProperty build() {
                    SSESpecificationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link SSESpecificationProperty}.
         */
        final class Jsii$Pojo implements SSESpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _sseEnabled;

            public java.lang.Object getSseEnabled() {
                return this._sseEnabled;
            }
            public void setSseEnabled(final java.lang.Boolean value) {
                this._sseEnabled = value;
            }
            public void setSseEnabled(final software.amazon.awscdk.Token value) {
                this._sseEnabled = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.SSESpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``TableResource.SSESpecificationProperty.SSEEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
             */
            public java.lang.Object getSseEnabled() {
                return this.jsiiGet("sseEnabled", java.lang.Object.class);
            }
            /**
             * ``TableResource.SSESpecificationProperty.SSEEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
             */
            public void setSseEnabled(final java.lang.Boolean value) {
                this.jsiiSet("sseEnabled", java.util.Objects.requireNonNull(value, "sseEnabled is required"));
            }
            /**
             * ``TableResource.SSESpecificationProperty.SSEEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
             */
            public void setSseEnabled(final software.amazon.awscdk.Token value) {
                this.jsiiSet("sseEnabled", java.util.Objects.requireNonNull(value, "sseEnabled is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html
     */
    public static interface StreamSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.StreamSpecificationProperty.StreamViewType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
         */
        java.lang.Object getStreamViewType();
        /**
         * ``TableResource.StreamSpecificationProperty.StreamViewType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
         */
        void setStreamViewType(final java.lang.String value);
        /**
         * ``TableResource.StreamSpecificationProperty.StreamViewType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
         */
        void setStreamViewType(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link StreamSpecificationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``TableResource.StreamSpecificationProperty.StreamViewType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
             */
            public Build withStreamViewType(final java.lang.String value) {
                return new FullBuilder().withStreamViewType(value);
            }
            /**
             * ``TableResource.StreamSpecificationProperty.StreamViewType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
             */
            public Build withStreamViewType(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withStreamViewType(value);
            }

            public interface Build {
                /**
                 * @return a new {@link StreamSpecificationProperty} object, initialized with the values set on this builder.
                 */
                StreamSpecificationProperty build();
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``TableResource.StreamSpecificationProperty.StreamViewType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
                 */
                public Build withStreamViewType(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "StreamSpecificationProperty#streamViewType is required");
                    this.instance._streamViewType = value;
                    return this;
                }
                /**
                 * ``TableResource.StreamSpecificationProperty.StreamViewType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
                 */
                public Build withStreamViewType(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "StreamSpecificationProperty#streamViewType is required");
                    this.instance._streamViewType = value;
                    return this;
                }
                public StreamSpecificationProperty build() {
                    StreamSpecificationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link StreamSpecificationProperty}.
         */
        final class Jsii$Pojo implements StreamSpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _streamViewType;

            public java.lang.Object getStreamViewType() {
                return this._streamViewType;
            }
            public void setStreamViewType(final java.lang.String value) {
                this._streamViewType = value;
            }
            public void setStreamViewType(final software.amazon.awscdk.Token value) {
                this._streamViewType = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.StreamSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``TableResource.StreamSpecificationProperty.StreamViewType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
             */
            public java.lang.Object getStreamViewType() {
                return this.jsiiGet("streamViewType", java.lang.Object.class);
            }
            /**
             * ``TableResource.StreamSpecificationProperty.StreamViewType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
             */
            public void setStreamViewType(final java.lang.String value) {
                this.jsiiSet("streamViewType", java.util.Objects.requireNonNull(value, "streamViewType is required"));
            }
            /**
             * ``TableResource.StreamSpecificationProperty.StreamViewType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
             */
            public void setStreamViewType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("streamViewType", java.util.Objects.requireNonNull(value, "streamViewType is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html
     */
    public static interface TimeToLiveSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
         */
        java.lang.Object getAttributeName();
        /**
         * ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
         */
        void setAttributeName(final java.lang.String value);
        /**
         * ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
         */
        void setAttributeName(final software.amazon.awscdk.Token value);
        /**
         * ``TableResource.TimeToLiveSpecificationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``TableResource.TimeToLiveSpecificationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``TableResource.TimeToLiveSpecificationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link TimeToLiveSpecificationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
             */
            public EnabledStep withAttributeName(final java.lang.String value) {
                return new FullBuilder().withAttributeName(value);
            }
            /**
             * ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
             */
            public EnabledStep withAttributeName(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withAttributeName(value);
            }

            public interface EnabledStep {
                /**
                 * ``TableResource.TimeToLiveSpecificationProperty.Enabled``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
                 */
                Build withEnabled(final java.lang.Boolean value);
                /**
                 * ``TableResource.TimeToLiveSpecificationProperty.Enabled``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
                 */
                Build withEnabled(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link TimeToLiveSpecificationProperty} object, initialized with the values set on this builder.
                 */
                TimeToLiveSpecificationProperty build();
            }

            final class FullBuilder implements EnabledStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
                 */
                public EnabledStep withAttributeName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "TimeToLiveSpecificationProperty#attributeName is required");
                    this.instance._attributeName = value;
                    return this;
                }
                /**
                 * ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
                 */
                public EnabledStep withAttributeName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "TimeToLiveSpecificationProperty#attributeName is required");
                    this.instance._attributeName = value;
                    return this;
                }
                /**
                 * ``TableResource.TimeToLiveSpecificationProperty.Enabled``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
                 */
                public Build withEnabled(final java.lang.Boolean value) {
                    java.util.Objects.requireNonNull(value, "TimeToLiveSpecificationProperty#enabled is required");
                    this.instance._enabled = value;
                    return this;
                }
                /**
                 * ``TableResource.TimeToLiveSpecificationProperty.Enabled``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
                 */
                public Build withEnabled(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "TimeToLiveSpecificationProperty#enabled is required");
                    this.instance._enabled = value;
                    return this;
                }
                public TimeToLiveSpecificationProperty build() {
                    TimeToLiveSpecificationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link TimeToLiveSpecificationProperty}.
         */
        final class Jsii$Pojo implements TimeToLiveSpecificationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _attributeName;

            public java.lang.Object getAttributeName() {
                return this._attributeName;
            }
            public void setAttributeName(final java.lang.String value) {
                this._attributeName = value;
            }
            public void setAttributeName(final software.amazon.awscdk.Token value) {
                this._attributeName = value;
            }

            protected java.lang.Object _enabled;

            public java.lang.Object getEnabled() {
                return this._enabled;
            }
            public void setEnabled(final java.lang.Boolean value) {
                this._enabled = value;
            }
            public void setEnabled(final software.amazon.awscdk.Token value) {
                this._enabled = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.TimeToLiveSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
             */
            public java.lang.Object getAttributeName() {
                return this.jsiiGet("attributeName", java.lang.Object.class);
            }
            /**
             * ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
             */
            public void setAttributeName(final java.lang.String value) {
                this.jsiiSet("attributeName", java.util.Objects.requireNonNull(value, "attributeName is required"));
            }
            /**
             * ``TableResource.TimeToLiveSpecificationProperty.AttributeName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
             */
            public void setAttributeName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("attributeName", java.util.Objects.requireNonNull(value, "attributeName is required"));
            }
            /**
             * ``TableResource.TimeToLiveSpecificationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
             */
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
            /**
             * ``TableResource.TimeToLiveSpecificationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
             */
            public void setEnabled(final java.lang.Boolean value) {
                this.jsiiSet("enabled", java.util.Objects.requireNonNull(value, "enabled is required"));
            }
            /**
             * ``TableResource.TimeToLiveSpecificationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
             */
            public void setEnabled(final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", java.util.Objects.requireNonNull(value, "enabled is required"));
            }
        }
    }
}
