package software.amazon.awscdk.services.dynamodb;
public interface TableProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The read capacity for the table. Careful if you add Global Secondary Indexes, as
     * those will share the table's provisioned throughput.
     * @default 5
     */
    java.lang.Number getReadCapacity();
    /**
     * The read capacity for the table. Careful if you add Global Secondary Indexes, as
     * those will share the table's provisioned throughput.
     * @default 5
     */
    void setReadCapacity(final java.lang.Number value);
    /**
     * The write capacity for the table. Careful if you add Global Secondary Indexes, as
     * those will share the table's provisioned throughput.
     * @default 5
     */
    java.lang.Number getWriteCapacity();
    /**
     * The write capacity for the table. Careful if you add Global Secondary Indexes, as
     * those will share the table's provisioned throughput.
     * @default 5
     */
    void setWriteCapacity(final java.lang.Number value);
    /**
     * Enforces a particular physical table name.
     * @default <generated>
     */
    java.lang.String getTableName();
    /**
     * Enforces a particular physical table name.
     * @default <generated>
     */
    void setTableName(final java.lang.String value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }

    /**
     * A fluent builder class for {@link TableProps}.
     */
    public static final class Builder {
        private Jsii$Pojo instance = new Jsii$Pojo();

        /**
         * The read capacity for the table. Careful if you add Global Secondary Indexes, as
         * those will share the table's provisioned throughput.
         * @default 5
         */
        public Builder withReadCapacity(final java.lang.Number value) {
            this.instance._readCapacity = value;
            return this;
        }
        /**
         * The write capacity for the table. Careful if you add Global Secondary Indexes, as
         * those will share the table's provisioned throughput.
         * @default 5
         */
        public Builder withWriteCapacity(final java.lang.Number value) {
            this.instance._writeCapacity = value;
            return this;
        }
        /**
         * Enforces a particular physical table name.
         * @default <generated>
         */
        public Builder withTableName(final java.lang.String value) {
            this.instance._tableName = value;
            return this;
        }
        public TableProps build() {
            TableProps result = this.instance;
            this.instance = new Jsii$Pojo();
            return result;
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link TableProps}.
     */
    final class Jsii$Pojo implements TableProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Number _readCapacity;

        public java.lang.Number getReadCapacity() {
            return this._readCapacity;
        }
        public void setReadCapacity(final java.lang.Number value) {
            this._readCapacity = value;
        }

        protected java.lang.Number _writeCapacity;

        public java.lang.Number getWriteCapacity() {
            return this._writeCapacity;
        }
        public void setWriteCapacity(final java.lang.Number value) {
            this._writeCapacity = value;
        }

        protected java.lang.String _tableName;

        public java.lang.String getTableName() {
            return this._tableName;
        }
        public void setTableName(final java.lang.String value) {
            this._tableName = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.TableProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The read capacity for the table. Careful if you add Global Secondary Indexes, as
         * those will share the table's provisioned throughput.
         * @default 5
         */
        @javax.annotation.Nullable
        public java.lang.Number getReadCapacity() {
            return this.jsiiGet("readCapacity", java.lang.Number.class);
        }
        /**
         * The read capacity for the table. Careful if you add Global Secondary Indexes, as
         * those will share the table's provisioned throughput.
         * @default 5
         */
        public void setReadCapacity(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("readCapacity", value);
        }
        /**
         * The write capacity for the table. Careful if you add Global Secondary Indexes, as
         * those will share the table's provisioned throughput.
         * @default 5
         */
        @javax.annotation.Nullable
        public java.lang.Number getWriteCapacity() {
            return this.jsiiGet("writeCapacity", java.lang.Number.class);
        }
        /**
         * The write capacity for the table. Careful if you add Global Secondary Indexes, as
         * those will share the table's provisioned throughput.
         * @default 5
         */
        public void setWriteCapacity(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("writeCapacity", value);
        }
        /**
         * Enforces a particular physical table name.
         * @default <generated>
         */
        @javax.annotation.Nullable
        public java.lang.String getTableName() {
            return this.jsiiGet("tableName", java.lang.String.class);
        }
        /**
         * Enforces a particular physical table name.
         * @default <generated>
         */
        public void setTableName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("tableName", value);
        }
    }
}
