package software.amazon.awscdk.services.dynamodb.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
public interface TableResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::DynamoDB::Table.KeySchema``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
     */
    java.lang.Object getKeySchema();
    /**
     * ``AWS::DynamoDB::Table.KeySchema``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
     */
    void setKeySchema(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::DynamoDB::Table.KeySchema``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
     */
    void setKeySchema(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::DynamoDB::Table.ProvisionedThroughput``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
     */
    java.lang.Object getProvisionedThroughput();
    /**
     * ``AWS::DynamoDB::Table.ProvisionedThroughput``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
     */
    void setProvisionedThroughput(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::DynamoDB::Table.ProvisionedThroughput``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
     */
    void setProvisionedThroughput(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProvisionedThroughputProperty value);
    /**
     * ``AWS::DynamoDB::Table.AttributeDefinitions``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
     */
    java.lang.Object getAttributeDefinitions();
    /**
     * ``AWS::DynamoDB::Table.AttributeDefinitions``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
     */
    void setAttributeDefinitions(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::DynamoDB::Table.AttributeDefinitions``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
     */
    void setAttributeDefinitions(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::DynamoDB::Table.GlobalSecondaryIndexes``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
     */
    java.lang.Object getGlobalSecondaryIndexes();
    /**
     * ``AWS::DynamoDB::Table.GlobalSecondaryIndexes``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
     */
    void setGlobalSecondaryIndexes(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::DynamoDB::Table.GlobalSecondaryIndexes``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
     */
    void setGlobalSecondaryIndexes(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::DynamoDB::Table.LocalSecondaryIndexes``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
     */
    java.lang.Object getLocalSecondaryIndexes();
    /**
     * ``AWS::DynamoDB::Table.LocalSecondaryIndexes``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
     */
    void setLocalSecondaryIndexes(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::DynamoDB::Table.LocalSecondaryIndexes``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
     */
    void setLocalSecondaryIndexes(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::DynamoDB::Table.PointInTimeRecoverySpecification``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
     */
    java.lang.Object getPointInTimeRecoverySpecification();
    /**
     * ``AWS::DynamoDB::Table.PointInTimeRecoverySpecification``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
     */
    void setPointInTimeRecoverySpecification(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::DynamoDB::Table.PointInTimeRecoverySpecification``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
     */
    void setPointInTimeRecoverySpecification(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.PointInTimeRecoverySpecificationProperty value);
    /**
     * ``AWS::DynamoDB::Table.SSESpecification``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
     */
    java.lang.Object getSseSpecification();
    /**
     * ``AWS::DynamoDB::Table.SSESpecification``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
     */
    void setSseSpecification(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::DynamoDB::Table.SSESpecification``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
     */
    void setSseSpecification(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.SSESpecificationProperty value);
    /**
     * ``AWS::DynamoDB::Table.StreamSpecification``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
     */
    java.lang.Object getStreamSpecification();
    /**
     * ``AWS::DynamoDB::Table.StreamSpecification``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
     */
    void setStreamSpecification(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::DynamoDB::Table.StreamSpecification``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
     */
    void setStreamSpecification(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.StreamSpecificationProperty value);
    /**
     * ``AWS::DynamoDB::Table.TableName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
     */
    java.lang.Object getTableName();
    /**
     * ``AWS::DynamoDB::Table.TableName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
     */
    void setTableName(final java.lang.String value);
    /**
     * ``AWS::DynamoDB::Table.TableName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
     */
    void setTableName(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::DynamoDB::Table.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
     */
    java.lang.Object getTags();
    /**
     * ``AWS::DynamoDB::Table.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
     */
    void setTags(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::DynamoDB::Table.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
     */
    void setTags(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::DynamoDB::Table.TimeToLiveSpecification``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
     */
    java.lang.Object getTimeToLiveSpecification();
    /**
     * ``AWS::DynamoDB::Table.TimeToLiveSpecification``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
     */
    void setTimeToLiveSpecification(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::DynamoDB::Table.TimeToLiveSpecification``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
     */
    void setTimeToLiveSpecification(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.TimeToLiveSpecificationProperty value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link TableResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::DynamoDB::Table.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
         */
        public ProvisionedThroughputStep withKeySchema(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withKeySchema(value);
        }
        /**
         * ``AWS::DynamoDB::Table.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
         */
        public ProvisionedThroughputStep withKeySchema(final java.util.List<java.lang.Object> value) {
            return new FullBuilder().withKeySchema(value);
        }

        public interface ProvisionedThroughputStep {
            /**
             * ``AWS::DynamoDB::Table.ProvisionedThroughput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
             */
            Build withProvisionedThroughput(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::DynamoDB::Table.ProvisionedThroughput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
             */
            Build withProvisionedThroughput(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProvisionedThroughputProperty value);
        }

        public interface Build {
            /**
             * @return a new {@link TableResourceProps} object, initialized with the values set on this builder.
             */
            TableResourceProps build();
            /**
             * ``AWS::DynamoDB::Table.AttributeDefinitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
             */
            Build withAttributeDefinitions(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::DynamoDB::Table.AttributeDefinitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
             */
            Build withAttributeDefinitions(final java.util.List<java.lang.Object> value);
            /**
             * ``AWS::DynamoDB::Table.GlobalSecondaryIndexes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
             */
            Build withGlobalSecondaryIndexes(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::DynamoDB::Table.GlobalSecondaryIndexes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
             */
            Build withGlobalSecondaryIndexes(final java.util.List<java.lang.Object> value);
            /**
             * ``AWS::DynamoDB::Table.LocalSecondaryIndexes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
             */
            Build withLocalSecondaryIndexes(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::DynamoDB::Table.LocalSecondaryIndexes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
             */
            Build withLocalSecondaryIndexes(final java.util.List<java.lang.Object> value);
            /**
             * ``AWS::DynamoDB::Table.PointInTimeRecoverySpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
             */
            Build withPointInTimeRecoverySpecification(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::DynamoDB::Table.PointInTimeRecoverySpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
             */
            Build withPointInTimeRecoverySpecification(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.PointInTimeRecoverySpecificationProperty value);
            /**
             * ``AWS::DynamoDB::Table.SSESpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
             */
            Build withSseSpecification(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::DynamoDB::Table.SSESpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
             */
            Build withSseSpecification(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.SSESpecificationProperty value);
            /**
             * ``AWS::DynamoDB::Table.StreamSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
             */
            Build withStreamSpecification(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::DynamoDB::Table.StreamSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
             */
            Build withStreamSpecification(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.StreamSpecificationProperty value);
            /**
             * ``AWS::DynamoDB::Table.TableName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
             */
            Build withTableName(final java.lang.String value);
            /**
             * ``AWS::DynamoDB::Table.TableName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
             */
            Build withTableName(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::DynamoDB::Table.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
             */
            Build withTags(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::DynamoDB::Table.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
             */
            Build withTags(final java.util.List<java.lang.Object> value);
            /**
             * ``AWS::DynamoDB::Table.TimeToLiveSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
             */
            Build withTimeToLiveSpecification(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::DynamoDB::Table.TimeToLiveSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
             */
            Build withTimeToLiveSpecification(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.TimeToLiveSpecificationProperty value);
        }

        final class FullBuilder implements ProvisionedThroughputStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::DynamoDB::Table.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
             */
            public ProvisionedThroughputStep withKeySchema(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "TableResourceProps#keySchema is required");
                this.instance._keySchema = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.KeySchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
             */
            public ProvisionedThroughputStep withKeySchema(final java.util.List<java.lang.Object> value) {
                java.util.Objects.requireNonNull(value, "TableResourceProps#keySchema is required");
                this.instance._keySchema = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.ProvisionedThroughput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
             */
            public Build withProvisionedThroughput(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "TableResourceProps#provisionedThroughput is required");
                this.instance._provisionedThroughput = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.ProvisionedThroughput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
             */
            public Build withProvisionedThroughput(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProvisionedThroughputProperty value) {
                java.util.Objects.requireNonNull(value, "TableResourceProps#provisionedThroughput is required");
                this.instance._provisionedThroughput = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.AttributeDefinitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
             */
            public Build withAttributeDefinitions(final software.amazon.awscdk.Token value) {
                this.instance._attributeDefinitions = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.AttributeDefinitions``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
             */
            public Build withAttributeDefinitions(final java.util.List<java.lang.Object> value) {
                this.instance._attributeDefinitions = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.GlobalSecondaryIndexes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
             */
            public Build withGlobalSecondaryIndexes(final software.amazon.awscdk.Token value) {
                this.instance._globalSecondaryIndexes = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.GlobalSecondaryIndexes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
             */
            public Build withGlobalSecondaryIndexes(final java.util.List<java.lang.Object> value) {
                this.instance._globalSecondaryIndexes = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.LocalSecondaryIndexes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
             */
            public Build withLocalSecondaryIndexes(final software.amazon.awscdk.Token value) {
                this.instance._localSecondaryIndexes = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.LocalSecondaryIndexes``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
             */
            public Build withLocalSecondaryIndexes(final java.util.List<java.lang.Object> value) {
                this.instance._localSecondaryIndexes = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.PointInTimeRecoverySpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
             */
            public Build withPointInTimeRecoverySpecification(final software.amazon.awscdk.Token value) {
                this.instance._pointInTimeRecoverySpecification = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.PointInTimeRecoverySpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
             */
            public Build withPointInTimeRecoverySpecification(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.PointInTimeRecoverySpecificationProperty value) {
                this.instance._pointInTimeRecoverySpecification = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.SSESpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
             */
            public Build withSseSpecification(final software.amazon.awscdk.Token value) {
                this.instance._sseSpecification = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.SSESpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
             */
            public Build withSseSpecification(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.SSESpecificationProperty value) {
                this.instance._sseSpecification = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.StreamSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
             */
            public Build withStreamSpecification(final software.amazon.awscdk.Token value) {
                this.instance._streamSpecification = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.StreamSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
             */
            public Build withStreamSpecification(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.StreamSpecificationProperty value) {
                this.instance._streamSpecification = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.TableName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
             */
            public Build withTableName(final java.lang.String value) {
                this.instance._tableName = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.TableName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
             */
            public Build withTableName(final software.amazon.awscdk.Token value) {
                this.instance._tableName = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
             */
            public Build withTags(final software.amazon.awscdk.Token value) {
                this.instance._tags = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
             */
            public Build withTags(final java.util.List<java.lang.Object> value) {
                this.instance._tags = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.TimeToLiveSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
             */
            public Build withTimeToLiveSpecification(final software.amazon.awscdk.Token value) {
                this.instance._timeToLiveSpecification = value;
                return this;
            }
            /**
             * ``AWS::DynamoDB::Table.TimeToLiveSpecification``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
             */
            public Build withTimeToLiveSpecification(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.TimeToLiveSpecificationProperty value) {
                this.instance._timeToLiveSpecification = value;
                return this;
            }
            public TableResourceProps build() {
                TableResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link TableResourceProps}.
     */
    final class Jsii$Pojo implements TableResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _keySchema;

        public java.lang.Object getKeySchema() {
            return this._keySchema;
        }
        public void setKeySchema(final software.amazon.awscdk.Token value) {
            this._keySchema = value;
        }
        public void setKeySchema(final java.util.List<java.lang.Object> value) {
            this._keySchema = value;
        }

        protected java.lang.Object _provisionedThroughput;

        public java.lang.Object getProvisionedThroughput() {
            return this._provisionedThroughput;
        }
        public void setProvisionedThroughput(final software.amazon.awscdk.Token value) {
            this._provisionedThroughput = value;
        }
        public void setProvisionedThroughput(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProvisionedThroughputProperty value) {
            this._provisionedThroughput = value;
        }

        protected java.lang.Object _attributeDefinitions;

        public java.lang.Object getAttributeDefinitions() {
            return this._attributeDefinitions;
        }
        public void setAttributeDefinitions(final software.amazon.awscdk.Token value) {
            this._attributeDefinitions = value;
        }
        public void setAttributeDefinitions(final java.util.List<java.lang.Object> value) {
            this._attributeDefinitions = value;
        }

        protected java.lang.Object _globalSecondaryIndexes;

        public java.lang.Object getGlobalSecondaryIndexes() {
            return this._globalSecondaryIndexes;
        }
        public void setGlobalSecondaryIndexes(final software.amazon.awscdk.Token value) {
            this._globalSecondaryIndexes = value;
        }
        public void setGlobalSecondaryIndexes(final java.util.List<java.lang.Object> value) {
            this._globalSecondaryIndexes = value;
        }

        protected java.lang.Object _localSecondaryIndexes;

        public java.lang.Object getLocalSecondaryIndexes() {
            return this._localSecondaryIndexes;
        }
        public void setLocalSecondaryIndexes(final software.amazon.awscdk.Token value) {
            this._localSecondaryIndexes = value;
        }
        public void setLocalSecondaryIndexes(final java.util.List<java.lang.Object> value) {
            this._localSecondaryIndexes = value;
        }

        protected java.lang.Object _pointInTimeRecoverySpecification;

        public java.lang.Object getPointInTimeRecoverySpecification() {
            return this._pointInTimeRecoverySpecification;
        }
        public void setPointInTimeRecoverySpecification(final software.amazon.awscdk.Token value) {
            this._pointInTimeRecoverySpecification = value;
        }
        public void setPointInTimeRecoverySpecification(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.PointInTimeRecoverySpecificationProperty value) {
            this._pointInTimeRecoverySpecification = value;
        }

        protected java.lang.Object _sseSpecification;

        public java.lang.Object getSseSpecification() {
            return this._sseSpecification;
        }
        public void setSseSpecification(final software.amazon.awscdk.Token value) {
            this._sseSpecification = value;
        }
        public void setSseSpecification(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.SSESpecificationProperty value) {
            this._sseSpecification = value;
        }

        protected java.lang.Object _streamSpecification;

        public java.lang.Object getStreamSpecification() {
            return this._streamSpecification;
        }
        public void setStreamSpecification(final software.amazon.awscdk.Token value) {
            this._streamSpecification = value;
        }
        public void setStreamSpecification(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.StreamSpecificationProperty value) {
            this._streamSpecification = value;
        }

        protected java.lang.Object _tableName;

        public java.lang.Object getTableName() {
            return this._tableName;
        }
        public void setTableName(final java.lang.String value) {
            this._tableName = value;
        }
        public void setTableName(final software.amazon.awscdk.Token value) {
            this._tableName = value;
        }

        protected java.lang.Object _tags;

        public java.lang.Object getTags() {
            return this._tags;
        }
        public void setTags(final software.amazon.awscdk.Token value) {
            this._tags = value;
        }
        public void setTags(final java.util.List<java.lang.Object> value) {
            this._tags = value;
        }

        protected java.lang.Object _timeToLiveSpecification;

        public java.lang.Object getTimeToLiveSpecification() {
            return this._timeToLiveSpecification;
        }
        public void setTimeToLiveSpecification(final software.amazon.awscdk.Token value) {
            this._timeToLiveSpecification = value;
        }
        public void setTimeToLiveSpecification(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.TimeToLiveSpecificationProperty value) {
            this._timeToLiveSpecification = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.cloudformation.TableResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::DynamoDB::Table.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
         */
        public java.lang.Object getKeySchema() {
            return this.jsiiGet("keySchema", java.lang.Object.class);
        }
        /**
         * ``AWS::DynamoDB::Table.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
         */
        public void setKeySchema(final software.amazon.awscdk.Token value) {
            this.jsiiSet("keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
        }
        /**
         * ``AWS::DynamoDB::Table.KeySchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
         */
        public void setKeySchema(final java.util.List<java.lang.Object> value) {
            this.jsiiSet("keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
        }
        /**
         * ``AWS::DynamoDB::Table.ProvisionedThroughput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
         */
        public java.lang.Object getProvisionedThroughput() {
            return this.jsiiGet("provisionedThroughput", java.lang.Object.class);
        }
        /**
         * ``AWS::DynamoDB::Table.ProvisionedThroughput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
         */
        public void setProvisionedThroughput(final software.amazon.awscdk.Token value) {
            this.jsiiSet("provisionedThroughput", java.util.Objects.requireNonNull(value, "provisionedThroughput is required"));
        }
        /**
         * ``AWS::DynamoDB::Table.ProvisionedThroughput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
         */
        public void setProvisionedThroughput(final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.ProvisionedThroughputProperty value) {
            this.jsiiSet("provisionedThroughput", java.util.Objects.requireNonNull(value, "provisionedThroughput is required"));
        }
        /**
         * ``AWS::DynamoDB::Table.AttributeDefinitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
         */
        @javax.annotation.Nullable
        public java.lang.Object getAttributeDefinitions() {
            return this.jsiiGet("attributeDefinitions", java.lang.Object.class);
        }
        /**
         * ``AWS::DynamoDB::Table.AttributeDefinitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
         */
        public void setAttributeDefinitions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("attributeDefinitions", value);
        }
        /**
         * ``AWS::DynamoDB::Table.AttributeDefinitions``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
         */
        public void setAttributeDefinitions(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("attributeDefinitions", value);
        }
        /**
         * ``AWS::DynamoDB::Table.GlobalSecondaryIndexes``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
         */
        @javax.annotation.Nullable
        public java.lang.Object getGlobalSecondaryIndexes() {
            return this.jsiiGet("globalSecondaryIndexes", java.lang.Object.class);
        }
        /**
         * ``AWS::DynamoDB::Table.GlobalSecondaryIndexes``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
         */
        public void setGlobalSecondaryIndexes(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("globalSecondaryIndexes", value);
        }
        /**
         * ``AWS::DynamoDB::Table.GlobalSecondaryIndexes``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
         */
        public void setGlobalSecondaryIndexes(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("globalSecondaryIndexes", value);
        }
        /**
         * ``AWS::DynamoDB::Table.LocalSecondaryIndexes``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
         */
        @javax.annotation.Nullable
        public java.lang.Object getLocalSecondaryIndexes() {
            return this.jsiiGet("localSecondaryIndexes", java.lang.Object.class);
        }
        /**
         * ``AWS::DynamoDB::Table.LocalSecondaryIndexes``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
         */
        public void setLocalSecondaryIndexes(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("localSecondaryIndexes", value);
        }
        /**
         * ``AWS::DynamoDB::Table.LocalSecondaryIndexes``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
         */
        public void setLocalSecondaryIndexes(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("localSecondaryIndexes", value);
        }
        /**
         * ``AWS::DynamoDB::Table.PointInTimeRecoverySpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
         */
        @javax.annotation.Nullable
        public java.lang.Object getPointInTimeRecoverySpecification() {
            return this.jsiiGet("pointInTimeRecoverySpecification", java.lang.Object.class);
        }
        /**
         * ``AWS::DynamoDB::Table.PointInTimeRecoverySpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
         */
        public void setPointInTimeRecoverySpecification(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("pointInTimeRecoverySpecification", value);
        }
        /**
         * ``AWS::DynamoDB::Table.PointInTimeRecoverySpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
         */
        public void setPointInTimeRecoverySpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.PointInTimeRecoverySpecificationProperty value) {
            this.jsiiSet("pointInTimeRecoverySpecification", value);
        }
        /**
         * ``AWS::DynamoDB::Table.SSESpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
         */
        @javax.annotation.Nullable
        public java.lang.Object getSseSpecification() {
            return this.jsiiGet("sseSpecification", java.lang.Object.class);
        }
        /**
         * ``AWS::DynamoDB::Table.SSESpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
         */
        public void setSseSpecification(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("sseSpecification", value);
        }
        /**
         * ``AWS::DynamoDB::Table.SSESpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
         */
        public void setSseSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.SSESpecificationProperty value) {
            this.jsiiSet("sseSpecification", value);
        }
        /**
         * ``AWS::DynamoDB::Table.StreamSpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
         */
        @javax.annotation.Nullable
        public java.lang.Object getStreamSpecification() {
            return this.jsiiGet("streamSpecification", java.lang.Object.class);
        }
        /**
         * ``AWS::DynamoDB::Table.StreamSpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
         */
        public void setStreamSpecification(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("streamSpecification", value);
        }
        /**
         * ``AWS::DynamoDB::Table.StreamSpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
         */
        public void setStreamSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.StreamSpecificationProperty value) {
            this.jsiiSet("streamSpecification", value);
        }
        /**
         * ``AWS::DynamoDB::Table.TableName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
         */
        @javax.annotation.Nullable
        public java.lang.Object getTableName() {
            return this.jsiiGet("tableName", java.lang.Object.class);
        }
        /**
         * ``AWS::DynamoDB::Table.TableName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
         */
        public void setTableName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("tableName", value);
        }
        /**
         * ``AWS::DynamoDB::Table.TableName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
         */
        public void setTableName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("tableName", value);
        }
        /**
         * ``AWS::DynamoDB::Table.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
         */
        @javax.annotation.Nullable
        public java.lang.Object getTags() {
            return this.jsiiGet("tags", java.lang.Object.class);
        }
        /**
         * ``AWS::DynamoDB::Table.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
         */
        public void setTags(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("tags", value);
        }
        /**
         * ``AWS::DynamoDB::Table.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
         */
        public void setTags(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("tags", value);
        }
        /**
         * ``AWS::DynamoDB::Table.TimeToLiveSpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
         */
        @javax.annotation.Nullable
        public java.lang.Object getTimeToLiveSpecification() {
            return this.jsiiGet("timeToLiveSpecification", java.lang.Object.class);
        }
        /**
         * ``AWS::DynamoDB::Table.TimeToLiveSpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
         */
        public void setTimeToLiveSpecification(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("timeToLiveSpecification", value);
        }
        /**
         * ``AWS::DynamoDB::Table.TimeToLiveSpecification``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
         */
        public void setTimeToLiveSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.cloudformation.TableResource.TimeToLiveSpecificationProperty value) {
            this.jsiiSet("timeToLiveSpecification", value);
        }
    }
}
