package software.amazon.awscdk.services.dynamodb;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.4 (build e80a889)", date = "2018-09-11T09:56:31.772Z")
public interface AutoScalingProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The maximum value that Application Auto Scaling can use to scale a target during a scaling activity.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-maxcapacity
     */
    java.lang.Number getMaxCapacity();
    /**
     * The maximum value that Application Auto Scaling can use to scale a target during a scaling activity.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-maxcapacity
     */
    void setMaxCapacity(final java.lang.Number value);
    /**
     * The minimum value that Application Auto Scaling can use to scale a target during a scaling activity.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-mincapacity
     */
    java.lang.Number getMinCapacity();
    /**
     * The minimum value that Application Auto Scaling can use to scale a target during a scaling activity.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-mincapacity
     */
    void setMinCapacity(final java.lang.Number value);
    /**
     * The amount of time, in seconds, after a scale in activity completes before another scale in activity can start.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-scaleincooldown
     */
    java.lang.Number getScaleInCooldown();
    /**
     * The amount of time, in seconds, after a scale in activity completes before another scale in activity can start.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-scaleincooldown
     */
    void setScaleInCooldown(final java.lang.Number value);
    /**
     * The amount of time, in seconds, after a scale out activity completes before another scale out activity can start.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-scaleoutcooldown
     */
    java.lang.Number getScaleOutCooldown();
    /**
     * The amount of time, in seconds, after a scale out activity completes before another scale out activity can start.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-scaleoutcooldown
     */
    void setScaleOutCooldown(final java.lang.Number value);
    /**
     * Application Auto Scaling ensures that the ratio of consumed capacity to provisioned capacity stays at or near this value. You define TargetValue as a percentage.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-targetvalue
     */
    java.lang.Number getTargetValue();
    /**
     * Application Auto Scaling ensures that the ratio of consumed capacity to provisioned capacity stays at or near this value. You define TargetValue as a percentage.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-targetvalue
     */
    void setTargetValue(final java.lang.Number value);
    /**
     * A name for the scaling policy.
     * @default {TableName}[ReadCapacity|WriteCapacity]ScalingPolicy
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policyname
     */
    java.lang.String getScalingPolicyName();
    /**
     * A name for the scaling policy.
     * @default {TableName}[ReadCapacity|WriteCapacity]ScalingPolicy
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policyname
     */
    void setScalingPolicyName(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link AutoScalingProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AutoScalingProps}
     */
    final class Builder {
        private java.lang.Number _maxCapacity;
        private java.lang.Number _minCapacity;
        private java.lang.Number _scaleInCooldown;
        private java.lang.Number _scaleOutCooldown;
        private java.lang.Number _targetValue;
        @javax.annotation.Nullable
        private java.lang.String _scalingPolicyName;

        /**
         * Sets the value of MaxCapacity
         * @param value The maximum value that Application Auto Scaling can use to scale a target during a scaling activity.
         * @return {@code this}
         */
        public Builder withMaxCapacity(final java.lang.Number value) {
            this._maxCapacity = java.util.Objects.requireNonNull(value, "maxCapacity is required");
            return this;
        }
        /**
         * Sets the value of MinCapacity
         * @param value The minimum value that Application Auto Scaling can use to scale a target during a scaling activity.
         * @return {@code this}
         */
        public Builder withMinCapacity(final java.lang.Number value) {
            this._minCapacity = java.util.Objects.requireNonNull(value, "minCapacity is required");
            return this;
        }
        /**
         * Sets the value of ScaleInCooldown
         * @param value The amount of time, in seconds, after a scale in activity completes before another scale in activity can start.
         * @return {@code this}
         */
        public Builder withScaleInCooldown(final java.lang.Number value) {
            this._scaleInCooldown = java.util.Objects.requireNonNull(value, "scaleInCooldown is required");
            return this;
        }
        /**
         * Sets the value of ScaleOutCooldown
         * @param value The amount of time, in seconds, after a scale out activity completes before another scale out activity can start.
         * @return {@code this}
         */
        public Builder withScaleOutCooldown(final java.lang.Number value) {
            this._scaleOutCooldown = java.util.Objects.requireNonNull(value, "scaleOutCooldown is required");
            return this;
        }
        /**
         * Sets the value of TargetValue
         * @param value Application Auto Scaling ensures that the ratio of consumed capacity to provisioned capacity stays at or near this value. You define TargetValue as a percentage.
         * @return {@code this}
         */
        public Builder withTargetValue(final java.lang.Number value) {
            this._targetValue = java.util.Objects.requireNonNull(value, "targetValue is required");
            return this;
        }
        /**
         * Sets the value of ScalingPolicyName
         * @param value A name for the scaling policy.
         * @return {@code this}
         */
        public Builder withScalingPolicyName(@javax.annotation.Nullable final java.lang.String value) {
            this._scalingPolicyName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AutoScalingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public AutoScalingProps build() {
            return new AutoScalingProps() {
                private java.lang.Number $maxCapacity = java.util.Objects.requireNonNull(_maxCapacity, "maxCapacity is required");
                private java.lang.Number $minCapacity = java.util.Objects.requireNonNull(_minCapacity, "minCapacity is required");
                private java.lang.Number $scaleInCooldown = java.util.Objects.requireNonNull(_scaleInCooldown, "scaleInCooldown is required");
                private java.lang.Number $scaleOutCooldown = java.util.Objects.requireNonNull(_scaleOutCooldown, "scaleOutCooldown is required");
                private java.lang.Number $targetValue = java.util.Objects.requireNonNull(_targetValue, "targetValue is required");
                @javax.annotation.Nullable
                private java.lang.String $scalingPolicyName = _scalingPolicyName;

                @Override
                public java.lang.Number getMaxCapacity() {
                    return this.$maxCapacity;
                }

                @Override
                public void setMaxCapacity(final java.lang.Number value) {
                    this.$maxCapacity = java.util.Objects.requireNonNull(value, "maxCapacity is required");
                }

                @Override
                public java.lang.Number getMinCapacity() {
                    return this.$minCapacity;
                }

                @Override
                public void setMinCapacity(final java.lang.Number value) {
                    this.$minCapacity = java.util.Objects.requireNonNull(value, "minCapacity is required");
                }

                @Override
                public java.lang.Number getScaleInCooldown() {
                    return this.$scaleInCooldown;
                }

                @Override
                public void setScaleInCooldown(final java.lang.Number value) {
                    this.$scaleInCooldown = java.util.Objects.requireNonNull(value, "scaleInCooldown is required");
                }

                @Override
                public java.lang.Number getScaleOutCooldown() {
                    return this.$scaleOutCooldown;
                }

                @Override
                public void setScaleOutCooldown(final java.lang.Number value) {
                    this.$scaleOutCooldown = java.util.Objects.requireNonNull(value, "scaleOutCooldown is required");
                }

                @Override
                public java.lang.Number getTargetValue() {
                    return this.$targetValue;
                }

                @Override
                public void setTargetValue(final java.lang.Number value) {
                    this.$targetValue = java.util.Objects.requireNonNull(value, "targetValue is required");
                }

                @Override
                public java.lang.String getScalingPolicyName() {
                    return this.$scalingPolicyName;
                }

                @Override
                public void setScalingPolicyName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$scalingPolicyName = value;
                }

            };
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.AutoScalingProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The maximum value that Application Auto Scaling can use to scale a target during a scaling activity.
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-maxcapacity
         */
        @Override
        public java.lang.Number getMaxCapacity() {
            return this.jsiiGet("maxCapacity", java.lang.Number.class);
        }

        /**
         * The maximum value that Application Auto Scaling can use to scale a target during a scaling activity.
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-maxcapacity
         */
        @Override
        public void setMaxCapacity(final java.lang.Number value) {
            this.jsiiSet("maxCapacity", java.util.Objects.requireNonNull(value, "maxCapacity is required"));
        }

        /**
         * The minimum value that Application Auto Scaling can use to scale a target during a scaling activity.
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-mincapacity
         */
        @Override
        public java.lang.Number getMinCapacity() {
            return this.jsiiGet("minCapacity", java.lang.Number.class);
        }

        /**
         * The minimum value that Application Auto Scaling can use to scale a target during a scaling activity.
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-mincapacity
         */
        @Override
        public void setMinCapacity(final java.lang.Number value) {
            this.jsiiSet("minCapacity", java.util.Objects.requireNonNull(value, "minCapacity is required"));
        }

        /**
         * The amount of time, in seconds, after a scale in activity completes before another scale in activity can start.
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-scaleincooldown
         */
        @Override
        public java.lang.Number getScaleInCooldown() {
            return this.jsiiGet("scaleInCooldown", java.lang.Number.class);
        }

        /**
         * The amount of time, in seconds, after a scale in activity completes before another scale in activity can start.
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-scaleincooldown
         */
        @Override
        public void setScaleInCooldown(final java.lang.Number value) {
            this.jsiiSet("scaleInCooldown", java.util.Objects.requireNonNull(value, "scaleInCooldown is required"));
        }

        /**
         * The amount of time, in seconds, after a scale out activity completes before another scale out activity can start.
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-scaleoutcooldown
         */
        @Override
        public java.lang.Number getScaleOutCooldown() {
            return this.jsiiGet("scaleOutCooldown", java.lang.Number.class);
        }

        /**
         * The amount of time, in seconds, after a scale out activity completes before another scale out activity can start.
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-scaleoutcooldown
         */
        @Override
        public void setScaleOutCooldown(final java.lang.Number value) {
            this.jsiiSet("scaleOutCooldown", java.util.Objects.requireNonNull(value, "scaleOutCooldown is required"));
        }

        /**
         * Application Auto Scaling ensures that the ratio of consumed capacity to provisioned capacity stays at or near this value. You define TargetValue as a percentage.
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-targetvalue
         */
        @Override
        public java.lang.Number getTargetValue() {
            return this.jsiiGet("targetValue", java.lang.Number.class);
        }

        /**
         * Application Auto Scaling ensures that the ratio of consumed capacity to provisioned capacity stays at or near this value. You define TargetValue as a percentage.
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-targetvalue
         */
        @Override
        public void setTargetValue(final java.lang.Number value) {
            this.jsiiSet("targetValue", java.util.Objects.requireNonNull(value, "targetValue is required"));
        }

        /**
         * A name for the scaling policy.
         * @default {TableName}[ReadCapacity|WriteCapacity]ScalingPolicy
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policyname
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getScalingPolicyName() {
            return this.jsiiGet("scalingPolicyName", java.lang.String.class);
        }

        /**
         * A name for the scaling policy.
         * @default {TableName}[ReadCapacity|WriteCapacity]ScalingPolicy
         * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policyname
         */
        @Override
        public void setScalingPolicyName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("scalingPolicyName", value);
        }
    }
}
