package software.amazon.awscdk.services.dynamodb;

/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-30T08:33:49.108Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.CfnTable")
public class CfnTable extends software.amazon.awscdk.core.CfnResource {

    protected CfnTable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dynamodb.CfnTable.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::DynamoDB::Table`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnTable(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.dynamodb.CfnTableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrArn() {
        return this.jsiiGet("attrArn", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrStreamArn() {
        return this.jsiiGet("attrStreamArn", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::DynamoDB::Table.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::DynamoDB::Table.KeySchema`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getKeySchema() {
        return this.jsiiGet("keySchema", java.lang.Object.class);
    }

    /**
     * `AWS::DynamoDB::Table.KeySchema`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setKeySchema(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
    }

    /**
     * `AWS::DynamoDB::Table.KeySchema`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setKeySchema(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
    }

    /**
     * `AWS::DynamoDB::Table.AttributeDefinitions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getAttributeDefinitions() {
        return this.jsiiGet("attributeDefinitions", java.lang.Object.class);
    }

    /**
     * `AWS::DynamoDB::Table.AttributeDefinitions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAttributeDefinitions(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("attributeDefinitions", value);
    }

    /**
     * `AWS::DynamoDB::Table.AttributeDefinitions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAttributeDefinitions(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("attributeDefinitions", value);
    }

    /**
     * `AWS::DynamoDB::Table.BillingMode`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-billingmode
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getBillingMode() {
        return this.jsiiGet("billingMode", java.lang.String.class);
    }

    /**
     * `AWS::DynamoDB::Table.BillingMode`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-billingmode
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setBillingMode(final java.lang.String value) {
        this.jsiiSet("billingMode", value);
    }

    /**
     * `AWS::DynamoDB::Table.GlobalSecondaryIndexes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getGlobalSecondaryIndexes() {
        return this.jsiiGet("globalSecondaryIndexes", java.lang.Object.class);
    }

    /**
     * `AWS::DynamoDB::Table.GlobalSecondaryIndexes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setGlobalSecondaryIndexes(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("globalSecondaryIndexes", value);
    }

    /**
     * `AWS::DynamoDB::Table.GlobalSecondaryIndexes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setGlobalSecondaryIndexes(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("globalSecondaryIndexes", value);
    }

    /**
     * `AWS::DynamoDB::Table.LocalSecondaryIndexes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getLocalSecondaryIndexes() {
        return this.jsiiGet("localSecondaryIndexes", java.lang.Object.class);
    }

    /**
     * `AWS::DynamoDB::Table.LocalSecondaryIndexes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLocalSecondaryIndexes(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("localSecondaryIndexes", value);
    }

    /**
     * `AWS::DynamoDB::Table.LocalSecondaryIndexes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLocalSecondaryIndexes(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("localSecondaryIndexes", value);
    }

    /**
     * `AWS::DynamoDB::Table.PointInTimeRecoverySpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getPointInTimeRecoverySpecification() {
        return this.jsiiGet("pointInTimeRecoverySpecification", java.lang.Object.class);
    }

    /**
     * `AWS::DynamoDB::Table.PointInTimeRecoverySpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPointInTimeRecoverySpecification(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("pointInTimeRecoverySpecification", value);
    }

    /**
     * `AWS::DynamoDB::Table.PointInTimeRecoverySpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPointInTimeRecoverySpecification(final software.amazon.awscdk.services.dynamodb.CfnTable.PointInTimeRecoverySpecificationProperty value) {
        this.jsiiSet("pointInTimeRecoverySpecification", value);
    }

    /**
     * `AWS::DynamoDB::Table.ProvisionedThroughput`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getProvisionedThroughput() {
        return this.jsiiGet("provisionedThroughput", java.lang.Object.class);
    }

    /**
     * `AWS::DynamoDB::Table.ProvisionedThroughput`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setProvisionedThroughput(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("provisionedThroughput", value);
    }

    /**
     * `AWS::DynamoDB::Table.ProvisionedThroughput`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setProvisionedThroughput(final software.amazon.awscdk.services.dynamodb.CfnTable.ProvisionedThroughputProperty value) {
        this.jsiiSet("provisionedThroughput", value);
    }

    /**
     * `AWS::DynamoDB::Table.SSESpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getSseSpecification() {
        return this.jsiiGet("sseSpecification", java.lang.Object.class);
    }

    /**
     * `AWS::DynamoDB::Table.SSESpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSseSpecification(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("sseSpecification", value);
    }

    /**
     * `AWS::DynamoDB::Table.SSESpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSseSpecification(final software.amazon.awscdk.services.dynamodb.CfnTable.SSESpecificationProperty value) {
        this.jsiiSet("sseSpecification", value);
    }

    /**
     * `AWS::DynamoDB::Table.StreamSpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getStreamSpecification() {
        return this.jsiiGet("streamSpecification", java.lang.Object.class);
    }

    /**
     * `AWS::DynamoDB::Table.StreamSpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setStreamSpecification(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("streamSpecification", value);
    }

    /**
     * `AWS::DynamoDB::Table.StreamSpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setStreamSpecification(final software.amazon.awscdk.services.dynamodb.CfnTable.StreamSpecificationProperty value) {
        this.jsiiSet("streamSpecification", value);
    }

    /**
     * `AWS::DynamoDB::Table.TableName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getTableName() {
        return this.jsiiGet("tableName", java.lang.String.class);
    }

    /**
     * `AWS::DynamoDB::Table.TableName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTableName(final java.lang.String value) {
        this.jsiiSet("tableName", value);
    }

    /**
     * `AWS::DynamoDB::Table.TimeToLiveSpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getTimeToLiveSpecification() {
        return this.jsiiGet("timeToLiveSpecification", java.lang.Object.class);
    }

    /**
     * `AWS::DynamoDB::Table.TimeToLiveSpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTimeToLiveSpecification(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("timeToLiveSpecification", value);
    }

    /**
     * `AWS::DynamoDB::Table.TimeToLiveSpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTimeToLiveSpecification(final software.amazon.awscdk.services.dynamodb.CfnTable.TimeToLiveSpecificationProperty value) {
        this.jsiiSet("timeToLiveSpecification", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AttributeDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTable.AttributeDefinitionProperty.AttributeName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAttributeName();

        /**
         * `CfnTable.AttributeDefinitionProperty.AttributeType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAttributeType();

        /**
         * @return a {@link Builder} of {@link AttributeDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AttributeDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String attributeName;
            private java.lang.String attributeType;

            /**
             * Sets the value of AttributeName
             * @param attributeName `CfnTable.AttributeDefinitionProperty.AttributeName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder attributeName(java.lang.String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            /**
             * Sets the value of AttributeType
             * @param attributeType `CfnTable.AttributeDefinitionProperty.AttributeType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder attributeType(java.lang.String attributeType) {
                this.attributeType = attributeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributeDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AttributeDefinitionProperty build() {
                return new Jsii$Proxy(attributeName, attributeType);
            }
        }

        /**
         * An implementation for {@link AttributeDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributeDefinitionProperty {
            private final java.lang.String attributeName;
            private final java.lang.String attributeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.attributeName = this.jsiiGet("attributeName", java.lang.String.class);
                this.attributeType = this.jsiiGet("attributeType", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String attributeName, java.lang.String attributeType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeName = java.util.Objects.requireNonNull(attributeName, "attributeName is required");
                this.attributeType = java.util.Objects.requireNonNull(attributeType, "attributeType is required");
            }

            @Override
            public java.lang.String getAttributeName() {
                return this.attributeName;
            }

            @Override
            public java.lang.String getAttributeType() {
                return this.attributeType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("attributeName", om.valueToTree(this.getAttributeName()));
                obj.set("attributeType", om.valueToTree(this.getAttributeType()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AttributeDefinitionProperty.Jsii$Proxy that = (AttributeDefinitionProperty.Jsii$Proxy) o;

                if (!attributeName.equals(that.attributeName)) return false;
                return this.attributeType.equals(that.attributeType);
            }

            @Override
            public int hashCode() {
                int result = this.attributeName.hashCode();
                result = 31 * result + (this.attributeType.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface GlobalSecondaryIndexProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTable.GlobalSecondaryIndexProperty.IndexName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getIndexName();

        /**
         * `CfnTable.GlobalSecondaryIndexProperty.KeySchema`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getKeySchema();

        /**
         * `CfnTable.GlobalSecondaryIndexProperty.Projection`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getProjection();

        /**
         * `CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getProvisionedThroughput();

        /**
         * @return a {@link Builder} of {@link GlobalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GlobalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String indexName;
            private java.lang.Object keySchema;
            private java.lang.Object projection;
            private java.lang.Object provisionedThroughput;

            /**
             * Sets the value of IndexName
             * @param indexName `CfnTable.GlobalSecondaryIndexProperty.IndexName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder indexName(java.lang.String indexName) {
                this.indexName = indexName;
                return this;
            }

            /**
             * Sets the value of KeySchema
             * @param keySchema `CfnTable.GlobalSecondaryIndexProperty.KeySchema`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder keySchema(software.amazon.awscdk.core.IResolvable keySchema) {
                this.keySchema = keySchema;
                return this;
            }

            /**
             * Sets the value of KeySchema
             * @param keySchema `CfnTable.GlobalSecondaryIndexProperty.KeySchema`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder keySchema(java.util.List<java.lang.Object> keySchema) {
                this.keySchema = keySchema;
                return this;
            }

            /**
             * Sets the value of Projection
             * @param projection `CfnTable.GlobalSecondaryIndexProperty.Projection`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder projection(software.amazon.awscdk.core.IResolvable projection) {
                this.projection = projection;
                return this;
            }

            /**
             * Sets the value of Projection
             * @param projection `CfnTable.GlobalSecondaryIndexProperty.Projection`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder projection(software.amazon.awscdk.services.dynamodb.CfnTable.ProjectionProperty projection) {
                this.projection = projection;
                return this;
            }

            /**
             * Sets the value of ProvisionedThroughput
             * @param provisionedThroughput `CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder provisionedThroughput(software.amazon.awscdk.core.IResolvable provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            /**
             * Sets the value of ProvisionedThroughput
             * @param provisionedThroughput `CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder provisionedThroughput(software.amazon.awscdk.services.dynamodb.CfnTable.ProvisionedThroughputProperty provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlobalSecondaryIndexProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public GlobalSecondaryIndexProperty build() {
                return new Jsii$Proxy(indexName, keySchema, projection, provisionedThroughput);
            }
        }

        /**
         * An implementation for {@link GlobalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlobalSecondaryIndexProperty {
            private final java.lang.String indexName;
            private final java.lang.Object keySchema;
            private final java.lang.Object projection;
            private final java.lang.Object provisionedThroughput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.indexName = this.jsiiGet("indexName", java.lang.String.class);
                this.keySchema = this.jsiiGet("keySchema", java.lang.Object.class);
                this.projection = this.jsiiGet("projection", java.lang.Object.class);
                this.provisionedThroughput = this.jsiiGet("provisionedThroughput", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String indexName, java.lang.Object keySchema, java.lang.Object projection, java.lang.Object provisionedThroughput) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.indexName = java.util.Objects.requireNonNull(indexName, "indexName is required");
                this.keySchema = java.util.Objects.requireNonNull(keySchema, "keySchema is required");
                this.projection = java.util.Objects.requireNonNull(projection, "projection is required");
                this.provisionedThroughput = provisionedThroughput;
            }

            @Override
            public java.lang.String getIndexName() {
                return this.indexName;
            }

            @Override
            public java.lang.Object getKeySchema() {
                return this.keySchema;
            }

            @Override
            public java.lang.Object getProjection() {
                return this.projection;
            }

            @Override
            public java.lang.Object getProvisionedThroughput() {
                return this.provisionedThroughput;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("indexName", om.valueToTree(this.getIndexName()));
                obj.set("keySchema", om.valueToTree(this.getKeySchema()));
                obj.set("projection", om.valueToTree(this.getProjection()));
                if (this.getProvisionedThroughput() != null) {
                    obj.set("provisionedThroughput", om.valueToTree(this.getProvisionedThroughput()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GlobalSecondaryIndexProperty.Jsii$Proxy that = (GlobalSecondaryIndexProperty.Jsii$Proxy) o;

                if (!indexName.equals(that.indexName)) return false;
                if (!keySchema.equals(that.keySchema)) return false;
                if (!projection.equals(that.projection)) return false;
                return this.provisionedThroughput != null ? this.provisionedThroughput.equals(that.provisionedThroughput) : that.provisionedThroughput == null;
            }

            @Override
            public int hashCode() {
                int result = this.indexName.hashCode();
                result = 31 * result + (this.keySchema.hashCode());
                result = 31 * result + (this.projection.hashCode());
                result = 31 * result + (this.provisionedThroughput != null ? this.provisionedThroughput.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface KeySchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTable.KeySchemaProperty.AttributeName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAttributeName();

        /**
         * `CfnTable.KeySchemaProperty.KeyType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKeyType();

        /**
         * @return a {@link Builder} of {@link KeySchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeySchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String attributeName;
            private java.lang.String keyType;

            /**
             * Sets the value of AttributeName
             * @param attributeName `CfnTable.KeySchemaProperty.AttributeName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder attributeName(java.lang.String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            /**
             * Sets the value of KeyType
             * @param keyType `CfnTable.KeySchemaProperty.KeyType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder keyType(java.lang.String keyType) {
                this.keyType = keyType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeySchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public KeySchemaProperty build() {
                return new Jsii$Proxy(attributeName, keyType);
            }
        }

        /**
         * An implementation for {@link KeySchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeySchemaProperty {
            private final java.lang.String attributeName;
            private final java.lang.String keyType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.attributeName = this.jsiiGet("attributeName", java.lang.String.class);
                this.keyType = this.jsiiGet("keyType", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String attributeName, java.lang.String keyType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeName = java.util.Objects.requireNonNull(attributeName, "attributeName is required");
                this.keyType = java.util.Objects.requireNonNull(keyType, "keyType is required");
            }

            @Override
            public java.lang.String getAttributeName() {
                return this.attributeName;
            }

            @Override
            public java.lang.String getKeyType() {
                return this.keyType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("attributeName", om.valueToTree(this.getAttributeName()));
                obj.set("keyType", om.valueToTree(this.getKeyType()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeySchemaProperty.Jsii$Proxy that = (KeySchemaProperty.Jsii$Proxy) o;

                if (!attributeName.equals(that.attributeName)) return false;
                return this.keyType.equals(that.keyType);
            }

            @Override
            public int hashCode() {
                int result = this.attributeName.hashCode();
                result = 31 * result + (this.keyType.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LocalSecondaryIndexProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTable.LocalSecondaryIndexProperty.IndexName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getIndexName();

        /**
         * `CfnTable.LocalSecondaryIndexProperty.KeySchema`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getKeySchema();

        /**
         * `CfnTable.LocalSecondaryIndexProperty.Projection`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getProjection();

        /**
         * @return a {@link Builder} of {@link LocalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String indexName;
            private java.lang.Object keySchema;
            private java.lang.Object projection;

            /**
             * Sets the value of IndexName
             * @param indexName `CfnTable.LocalSecondaryIndexProperty.IndexName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder indexName(java.lang.String indexName) {
                this.indexName = indexName;
                return this;
            }

            /**
             * Sets the value of KeySchema
             * @param keySchema `CfnTable.LocalSecondaryIndexProperty.KeySchema`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder keySchema(software.amazon.awscdk.core.IResolvable keySchema) {
                this.keySchema = keySchema;
                return this;
            }

            /**
             * Sets the value of KeySchema
             * @param keySchema `CfnTable.LocalSecondaryIndexProperty.KeySchema`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder keySchema(java.util.List<java.lang.Object> keySchema) {
                this.keySchema = keySchema;
                return this;
            }

            /**
             * Sets the value of Projection
             * @param projection `CfnTable.LocalSecondaryIndexProperty.Projection`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder projection(software.amazon.awscdk.core.IResolvable projection) {
                this.projection = projection;
                return this;
            }

            /**
             * Sets the value of Projection
             * @param projection `CfnTable.LocalSecondaryIndexProperty.Projection`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder projection(software.amazon.awscdk.services.dynamodb.CfnTable.ProjectionProperty projection) {
                this.projection = projection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocalSecondaryIndexProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LocalSecondaryIndexProperty build() {
                return new Jsii$Proxy(indexName, keySchema, projection);
            }
        }

        /**
         * An implementation for {@link LocalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocalSecondaryIndexProperty {
            private final java.lang.String indexName;
            private final java.lang.Object keySchema;
            private final java.lang.Object projection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.indexName = this.jsiiGet("indexName", java.lang.String.class);
                this.keySchema = this.jsiiGet("keySchema", java.lang.Object.class);
                this.projection = this.jsiiGet("projection", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String indexName, java.lang.Object keySchema, java.lang.Object projection) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.indexName = java.util.Objects.requireNonNull(indexName, "indexName is required");
                this.keySchema = java.util.Objects.requireNonNull(keySchema, "keySchema is required");
                this.projection = java.util.Objects.requireNonNull(projection, "projection is required");
            }

            @Override
            public java.lang.String getIndexName() {
                return this.indexName;
            }

            @Override
            public java.lang.Object getKeySchema() {
                return this.keySchema;
            }

            @Override
            public java.lang.Object getProjection() {
                return this.projection;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("indexName", om.valueToTree(this.getIndexName()));
                obj.set("keySchema", om.valueToTree(this.getKeySchema()));
                obj.set("projection", om.valueToTree(this.getProjection()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocalSecondaryIndexProperty.Jsii$Proxy that = (LocalSecondaryIndexProperty.Jsii$Proxy) o;

                if (!indexName.equals(that.indexName)) return false;
                if (!keySchema.equals(that.keySchema)) return false;
                return this.projection.equals(that.projection);
            }

            @Override
            public int hashCode() {
                int result = this.indexName.hashCode();
                result = 31 * result + (this.keySchema.hashCode());
                result = 31 * result + (this.projection.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface PointInTimeRecoverySpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getPointInTimeRecoveryEnabled();

        /**
         * @return a {@link Builder} of {@link PointInTimeRecoverySpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PointInTimeRecoverySpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object pointInTimeRecoveryEnabled;

            /**
             * Sets the value of PointInTimeRecoveryEnabled
             * @param pointInTimeRecoveryEnabled `CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder pointInTimeRecoveryEnabled(java.lang.Boolean pointInTimeRecoveryEnabled) {
                this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
                return this;
            }

            /**
             * Sets the value of PointInTimeRecoveryEnabled
             * @param pointInTimeRecoveryEnabled `CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder pointInTimeRecoveryEnabled(software.amazon.awscdk.core.IResolvable pointInTimeRecoveryEnabled) {
                this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PointInTimeRecoverySpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public PointInTimeRecoverySpecificationProperty build() {
                return new Jsii$Proxy(pointInTimeRecoveryEnabled);
            }
        }

        /**
         * An implementation for {@link PointInTimeRecoverySpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PointInTimeRecoverySpecificationProperty {
            private final java.lang.Object pointInTimeRecoveryEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.pointInTimeRecoveryEnabled = this.jsiiGet("pointInTimeRecoveryEnabled", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object pointInTimeRecoveryEnabled) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
            }

            @Override
            public java.lang.Object getPointInTimeRecoveryEnabled() {
                return this.pointInTimeRecoveryEnabled;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getPointInTimeRecoveryEnabled() != null) {
                    obj.set("pointInTimeRecoveryEnabled", om.valueToTree(this.getPointInTimeRecoveryEnabled()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PointInTimeRecoverySpecificationProperty.Jsii$Proxy that = (PointInTimeRecoverySpecificationProperty.Jsii$Proxy) o;

                return this.pointInTimeRecoveryEnabled != null ? this.pointInTimeRecoveryEnabled.equals(that.pointInTimeRecoveryEnabled) : that.pointInTimeRecoveryEnabled == null;
            }

            @Override
            public int hashCode() {
                int result = this.pointInTimeRecoveryEnabled != null ? this.pointInTimeRecoveryEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ProjectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTable.ProjectionProperty.NonKeyAttributes`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getNonKeyAttributes();

        /**
         * `CfnTable.ProjectionProperty.ProjectionType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getProjectionType();

        /**
         * @return a {@link Builder} of {@link ProjectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.util.List<java.lang.String> nonKeyAttributes;
            private java.lang.String projectionType;

            /**
             * Sets the value of NonKeyAttributes
             * @param nonKeyAttributes `CfnTable.ProjectionProperty.NonKeyAttributes`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder nonKeyAttributes(java.util.List<java.lang.String> nonKeyAttributes) {
                this.nonKeyAttributes = nonKeyAttributes;
                return this;
            }

            /**
             * Sets the value of ProjectionType
             * @param projectionType `CfnTable.ProjectionProperty.ProjectionType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder projectionType(java.lang.String projectionType) {
                this.projectionType = projectionType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ProjectionProperty build() {
                return new Jsii$Proxy(nonKeyAttributes, projectionType);
            }
        }

        /**
         * An implementation for {@link ProjectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectionProperty {
            private final java.util.List<java.lang.String> nonKeyAttributes;
            private final java.lang.String projectionType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.nonKeyAttributes = this.jsiiGet("nonKeyAttributes", java.util.List.class);
                this.projectionType = this.jsiiGet("projectionType", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.util.List<java.lang.String> nonKeyAttributes, java.lang.String projectionType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nonKeyAttributes = nonKeyAttributes;
                this.projectionType = projectionType;
            }

            @Override
            public java.util.List<java.lang.String> getNonKeyAttributes() {
                return this.nonKeyAttributes;
            }

            @Override
            public java.lang.String getProjectionType() {
                return this.projectionType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getNonKeyAttributes() != null) {
                    obj.set("nonKeyAttributes", om.valueToTree(this.getNonKeyAttributes()));
                }
                if (this.getProjectionType() != null) {
                    obj.set("projectionType", om.valueToTree(this.getProjectionType()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectionProperty.Jsii$Proxy that = (ProjectionProperty.Jsii$Proxy) o;

                if (this.nonKeyAttributes != null ? !this.nonKeyAttributes.equals(that.nonKeyAttributes) : that.nonKeyAttributes != null) return false;
                return this.projectionType != null ? this.projectionType.equals(that.projectionType) : that.projectionType == null;
            }

            @Override
            public int hashCode() {
                int result = this.nonKeyAttributes != null ? this.nonKeyAttributes.hashCode() : 0;
                result = 31 * result + (this.projectionType != null ? this.projectionType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ProvisionedThroughputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getReadCapacityUnits();

        /**
         * `CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getWriteCapacityUnits();

        /**
         * @return a {@link Builder} of {@link ProvisionedThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProvisionedThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Number readCapacityUnits;
            private java.lang.Number writeCapacityUnits;

            /**
             * Sets the value of ReadCapacityUnits
             * @param readCapacityUnits `CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder readCapacityUnits(java.lang.Number readCapacityUnits) {
                this.readCapacityUnits = readCapacityUnits;
                return this;
            }

            /**
             * Sets the value of WriteCapacityUnits
             * @param writeCapacityUnits `CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder writeCapacityUnits(java.lang.Number writeCapacityUnits) {
                this.writeCapacityUnits = writeCapacityUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisionedThroughputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ProvisionedThroughputProperty build() {
                return new Jsii$Proxy(readCapacityUnits, writeCapacityUnits);
            }
        }

        /**
         * An implementation for {@link ProvisionedThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisionedThroughputProperty {
            private final java.lang.Number readCapacityUnits;
            private final java.lang.Number writeCapacityUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.readCapacityUnits = this.jsiiGet("readCapacityUnits", java.lang.Number.class);
                this.writeCapacityUnits = this.jsiiGet("writeCapacityUnits", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Number readCapacityUnits, java.lang.Number writeCapacityUnits) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.readCapacityUnits = java.util.Objects.requireNonNull(readCapacityUnits, "readCapacityUnits is required");
                this.writeCapacityUnits = java.util.Objects.requireNonNull(writeCapacityUnits, "writeCapacityUnits is required");
            }

            @Override
            public java.lang.Number getReadCapacityUnits() {
                return this.readCapacityUnits;
            }

            @Override
            public java.lang.Number getWriteCapacityUnits() {
                return this.writeCapacityUnits;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("readCapacityUnits", om.valueToTree(this.getReadCapacityUnits()));
                obj.set("writeCapacityUnits", om.valueToTree(this.getWriteCapacityUnits()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProvisionedThroughputProperty.Jsii$Proxy that = (ProvisionedThroughputProperty.Jsii$Proxy) o;

                if (!readCapacityUnits.equals(that.readCapacityUnits)) return false;
                return this.writeCapacityUnits.equals(that.writeCapacityUnits);
            }

            @Override
            public int hashCode() {
                int result = this.readCapacityUnits.hashCode();
                result = 31 * result + (this.writeCapacityUnits.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SSESpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTable.SSESpecificationProperty.SSEEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSseEnabled();

        /**
         * `CfnTable.SSESpecificationProperty.KMSMasterKeyId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-kmsmasterkeyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKmsMasterKeyId();

        /**
         * `CfnTable.SSESpecificationProperty.SSEType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-ssetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSseType();

        /**
         * @return a {@link Builder} of {@link SSESpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SSESpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object sseEnabled;
            private java.lang.String kmsMasterKeyId;
            private java.lang.String sseType;

            /**
             * Sets the value of SseEnabled
             * @param sseEnabled `CfnTable.SSESpecificationProperty.SSEEnabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sseEnabled(java.lang.Boolean sseEnabled) {
                this.sseEnabled = sseEnabled;
                return this;
            }

            /**
             * Sets the value of SseEnabled
             * @param sseEnabled `CfnTable.SSESpecificationProperty.SSEEnabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sseEnabled(software.amazon.awscdk.core.IResolvable sseEnabled) {
                this.sseEnabled = sseEnabled;
                return this;
            }

            /**
             * Sets the value of KmsMasterKeyId
             * @param kmsMasterKeyId `CfnTable.SSESpecificationProperty.KMSMasterKeyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kmsMasterKeyId(java.lang.String kmsMasterKeyId) {
                this.kmsMasterKeyId = kmsMasterKeyId;
                return this;
            }

            /**
             * Sets the value of SseType
             * @param sseType `CfnTable.SSESpecificationProperty.SSEType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sseType(java.lang.String sseType) {
                this.sseType = sseType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SSESpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SSESpecificationProperty build() {
                return new Jsii$Proxy(sseEnabled, kmsMasterKeyId, sseType);
            }
        }

        /**
         * An implementation for {@link SSESpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SSESpecificationProperty {
            private final java.lang.Object sseEnabled;
            private final java.lang.String kmsMasterKeyId;
            private final java.lang.String sseType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.sseEnabled = this.jsiiGet("sseEnabled", java.lang.Object.class);
                this.kmsMasterKeyId = this.jsiiGet("kmsMasterKeyId", java.lang.String.class);
                this.sseType = this.jsiiGet("sseType", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object sseEnabled, java.lang.String kmsMasterKeyId, java.lang.String sseType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sseEnabled = java.util.Objects.requireNonNull(sseEnabled, "sseEnabled is required");
                this.kmsMasterKeyId = kmsMasterKeyId;
                this.sseType = sseType;
            }

            @Override
            public java.lang.Object getSseEnabled() {
                return this.sseEnabled;
            }

            @Override
            public java.lang.String getKmsMasterKeyId() {
                return this.kmsMasterKeyId;
            }

            @Override
            public java.lang.String getSseType() {
                return this.sseType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("sseEnabled", om.valueToTree(this.getSseEnabled()));
                if (this.getKmsMasterKeyId() != null) {
                    obj.set("kmsMasterKeyId", om.valueToTree(this.getKmsMasterKeyId()));
                }
                if (this.getSseType() != null) {
                    obj.set("sseType", om.valueToTree(this.getSseType()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SSESpecificationProperty.Jsii$Proxy that = (SSESpecificationProperty.Jsii$Proxy) o;

                if (!sseEnabled.equals(that.sseEnabled)) return false;
                if (this.kmsMasterKeyId != null ? !this.kmsMasterKeyId.equals(that.kmsMasterKeyId) : that.kmsMasterKeyId != null) return false;
                return this.sseType != null ? this.sseType.equals(that.sseType) : that.sseType == null;
            }

            @Override
            public int hashCode() {
                int result = this.sseEnabled.hashCode();
                result = 31 * result + (this.kmsMasterKeyId != null ? this.kmsMasterKeyId.hashCode() : 0);
                result = 31 * result + (this.sseType != null ? this.sseType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface StreamSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTable.StreamSpecificationProperty.StreamViewType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStreamViewType();

        /**
         * @return a {@link Builder} of {@link StreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String streamViewType;

            /**
             * Sets the value of StreamViewType
             * @param streamViewType `CfnTable.StreamSpecificationProperty.StreamViewType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder streamViewType(java.lang.String streamViewType) {
                this.streamViewType = streamViewType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public StreamSpecificationProperty build() {
                return new Jsii$Proxy(streamViewType);
            }
        }

        /**
         * An implementation for {@link StreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamSpecificationProperty {
            private final java.lang.String streamViewType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.streamViewType = this.jsiiGet("streamViewType", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String streamViewType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.streamViewType = java.util.Objects.requireNonNull(streamViewType, "streamViewType is required");
            }

            @Override
            public java.lang.String getStreamViewType() {
                return this.streamViewType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("streamViewType", om.valueToTree(this.getStreamViewType()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamSpecificationProperty.Jsii$Proxy that = (StreamSpecificationProperty.Jsii$Proxy) o;

                return this.streamViewType.equals(that.streamViewType);
            }

            @Override
            public int hashCode() {
                int result = this.streamViewType.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TimeToLiveSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTable.TimeToLiveSpecificationProperty.AttributeName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAttributeName();

        /**
         * `CfnTable.TimeToLiveSpecificationProperty.Enabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link TimeToLiveSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeToLiveSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String attributeName;
            private java.lang.Object enabled;

            /**
             * Sets the value of AttributeName
             * @param attributeName `CfnTable.TimeToLiveSpecificationProperty.AttributeName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder attributeName(java.lang.String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnTable.TimeToLiveSpecificationProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnTable.TimeToLiveSpecificationProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeToLiveSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TimeToLiveSpecificationProperty build() {
                return new Jsii$Proxy(attributeName, enabled);
            }
        }

        /**
         * An implementation for {@link TimeToLiveSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeToLiveSpecificationProperty {
            private final java.lang.String attributeName;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.attributeName = this.jsiiGet("attributeName", java.lang.String.class);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String attributeName, java.lang.Object enabled) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeName = java.util.Objects.requireNonNull(attributeName, "attributeName is required");
                this.enabled = java.util.Objects.requireNonNull(enabled, "enabled is required");
            }

            @Override
            public java.lang.String getAttributeName() {
                return this.attributeName;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("attributeName", om.valueToTree(this.getAttributeName()));
                obj.set("enabled", om.valueToTree(this.getEnabled()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeToLiveSpecificationProperty.Jsii$Proxy that = (TimeToLiveSpecificationProperty.Jsii$Proxy) o;

                if (!attributeName.equals(that.attributeName)) return false;
                return this.enabled.equals(that.enabled);
            }

            @Override
            public int hashCode() {
                int result = this.attributeName.hashCode();
                result = 31 * result + (this.enabled.hashCode());
                return result;
            }
        }
    }
}
