package software.amazon.awscdk.services.dynamodb;

/**
 * Reference to a dynamodb table.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-06-11T15:14:55.734Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.TableAttributes")
@software.amazon.jsii.Jsii.Proxy(TableAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TableAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * KMS encryption key, if this table uses a customer-managed encryption key.
     * <p>
     * Default: - no key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * The name of the global indexes set for this Table.
     * <p>
     * Note that you need to set either this property,
     * or {&#64;link localIndexes},
     * if you want methods like grantReadData()
     * to grant permissions for indexes as well as the table itself.
     * <p>
     * Default: - no global indexes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGlobalIndexes() {
        return null;
    }

    /**
     * The name of the local indexes set for this Table.
     * <p>
     * Note that you need to set either this property,
     * or {&#64;link globalIndexes},
     * if you want methods like grantReadData()
     * to grant permissions for indexes as well as the table itself.
     * <p>
     * Default: - no local indexes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLocalIndexes() {
        return null;
    }

    /**
     * The ARN of the dynamodb table.
     * <p>
     * One of this, or {&#64;link tableName}, is required.
     * <p>
     * Default: - no table arn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableArn() {
        return null;
    }

    /**
     * The table name of the dynamodb table.
     * <p>
     * One of this, or {&#64;link tableArn}, is required.
     * <p>
     * Default: - no table name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return null;
    }

    /**
     * The ARN of the table's stream.
     * <p>
     * Default: - no table stream
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableStreamArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TableAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TableAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TableAttributes> {
        private software.amazon.awscdk.services.kms.IKey encryptionKey;
        private java.util.List<java.lang.String> globalIndexes;
        private java.util.List<java.lang.String> localIndexes;
        private java.lang.String tableArn;
        private java.lang.String tableName;
        private java.lang.String tableStreamArn;

        /**
         * Sets the value of {@link TableAttributes#getEncryptionKey}
         * @param encryptionKey KMS encryption key, if this table uses a customer-managed encryption key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributes#getGlobalIndexes}
         * @param globalIndexes The name of the global indexes set for this Table.
         *                      Note that you need to set either this property,
         *                      or {&#64;link localIndexes},
         *                      if you want methods like grantReadData()
         *                      to grant permissions for indexes as well as the table itself.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalIndexes(java.util.List<java.lang.String> globalIndexes) {
            this.globalIndexes = globalIndexes;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributes#getLocalIndexes}
         * @param localIndexes The name of the local indexes set for this Table.
         *                     Note that you need to set either this property,
         *                     or {&#64;link globalIndexes},
         *                     if you want methods like grantReadData()
         *                     to grant permissions for indexes as well as the table itself.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localIndexes(java.util.List<java.lang.String> localIndexes) {
            this.localIndexes = localIndexes;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributes#getTableArn}
         * @param tableArn The ARN of the dynamodb table.
         *                 One of this, or {&#64;link tableName}, is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableArn(java.lang.String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributes#getTableName}
         * @param tableName The table name of the dynamodb table.
         *                  One of this, or {&#64;link tableArn}, is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributes#getTableStreamArn}
         * @param tableStreamArn The ARN of the table's stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableStreamArn(java.lang.String tableStreamArn) {
            this.tableStreamArn = tableStreamArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TableAttributes build() {
            return new Jsii$Proxy(encryptionKey, globalIndexes, localIndexes, tableArn, tableName, tableStreamArn);
        }
    }

    /**
     * An implementation for {@link TableAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableAttributes {
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.util.List<java.lang.String> globalIndexes;
        private final java.util.List<java.lang.String> localIndexes;
        private final java.lang.String tableArn;
        private final java.lang.String tableName;
        private final java.lang.String tableStreamArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.globalIndexes = software.amazon.jsii.Kernel.get(this, "globalIndexes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.localIndexes = software.amazon.jsii.Kernel.get(this, "localIndexes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tableArn = software.amazon.jsii.Kernel.get(this, "tableArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableStreamArn = software.amazon.jsii.Kernel.get(this, "tableStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.kms.IKey encryptionKey, final java.util.List<java.lang.String> globalIndexes, final java.util.List<java.lang.String> localIndexes, final java.lang.String tableArn, final java.lang.String tableName, final java.lang.String tableStreamArn) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.encryptionKey = encryptionKey;
            this.globalIndexes = globalIndexes;
            this.localIndexes = localIndexes;
            this.tableArn = tableArn;
            this.tableName = tableName;
            this.tableStreamArn = tableStreamArn;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.util.List<java.lang.String> getGlobalIndexes() {
            return this.globalIndexes;
        }

        @Override
        public final java.util.List<java.lang.String> getLocalIndexes() {
            return this.localIndexes;
        }

        @Override
        public final java.lang.String getTableArn() {
            return this.tableArn;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public final java.lang.String getTableStreamArn() {
            return this.tableStreamArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getGlobalIndexes() != null) {
                data.set("globalIndexes", om.valueToTree(this.getGlobalIndexes()));
            }
            if (this.getLocalIndexes() != null) {
                data.set("localIndexes", om.valueToTree(this.getLocalIndexes()));
            }
            if (this.getTableArn() != null) {
                data.set("tableArn", om.valueToTree(this.getTableArn()));
            }
            if (this.getTableName() != null) {
                data.set("tableName", om.valueToTree(this.getTableName()));
            }
            if (this.getTableStreamArn() != null) {
                data.set("tableStreamArn", om.valueToTree(this.getTableStreamArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-dynamodb.TableAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableAttributes.Jsii$Proxy that = (TableAttributes.Jsii$Proxy) o;

            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.globalIndexes != null ? !this.globalIndexes.equals(that.globalIndexes) : that.globalIndexes != null) return false;
            if (this.localIndexes != null ? !this.localIndexes.equals(that.localIndexes) : that.localIndexes != null) return false;
            if (this.tableArn != null ? !this.tableArn.equals(that.tableArn) : that.tableArn != null) return false;
            if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
            return this.tableStreamArn != null ? this.tableStreamArn.equals(that.tableStreamArn) : that.tableStreamArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.encryptionKey != null ? this.encryptionKey.hashCode() : 0;
            result = 31 * result + (this.globalIndexes != null ? this.globalIndexes.hashCode() : 0);
            result = 31 * result + (this.localIndexes != null ? this.localIndexes.hashCode() : 0);
            result = 31 * result + (this.tableArn != null ? this.tableArn.hashCode() : 0);
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = 31 * result + (this.tableStreamArn != null ? this.tableStreamArn.hashCode() : 0);
            return result;
        }
    }
}
