/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.dynamodb.;
import software.amazon.awscdk.services.dynamodb.Attribute;
import software.amazon.awscdk.services.dynamodb.BillingMode;
import software.amazon.awscdk.services.dynamodb.StreamViewType;
import software.amazon.awscdk.services.dynamodb.TableEncryption;
import software.amazon.awscdk.services.dynamodb.TableOptions;
import software.amazon.awscdk.services.dynamodb.TableProps;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-dynamodb.TableProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface TableProps
extends JsiiSerializable,
TableOptions {
    @Nullable
    default public String getTableName() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<TableProps> {
        private String tableName;
        private BillingMode billingMode;
        private Boolean contributorInsightsEnabled;
        private TableEncryption encryption;
        private IKey encryptionKey;
        private Boolean pointInTimeRecovery;
        private Number readCapacity;
        private RemovalPolicy removalPolicy;
        private List<String> replicationRegions;
        private Duration replicationTimeout;
        private Boolean serverSideEncryption;
        private StreamViewType stream;
        private String timeToLiveAttribute;
        private Number writeCapacity;
        private Attribute partitionKey;
        private Attribute sortKey;

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder billingMode(BillingMode billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        public Builder contributorInsightsEnabled(Boolean contributorInsightsEnabled) {
            this.contributorInsightsEnabled = contributorInsightsEnabled;
            return this;
        }

        public Builder encryption(TableEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public Builder pointInTimeRecovery(Boolean pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery;
            return this;
        }

        public Builder readCapacity(Number readCapacity) {
            this.readCapacity = readCapacity;
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        public Builder replicationRegions(List<String> replicationRegions) {
            this.replicationRegions = replicationRegions;
            return this;
        }

        public Builder replicationTimeout(Duration replicationTimeout) {
            this.replicationTimeout = replicationTimeout;
            return this;
        }

        @Deprecated
        public Builder serverSideEncryption(Boolean serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        public Builder stream(StreamViewType stream) {
            this.stream = stream;
            return this;
        }

        public Builder timeToLiveAttribute(String timeToLiveAttribute) {
            this.timeToLiveAttribute = timeToLiveAttribute;
            return this;
        }

        public Builder writeCapacity(Number writeCapacity) {
            this.writeCapacity = writeCapacity;
            return this;
        }

        public Builder partitionKey(Attribute partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public Builder sortKey(Attribute sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        public TableProps build() {
            return new Jsii.Proxy(this.tableName, this.billingMode, this.contributorInsightsEnabled, this.encryption, this.encryptionKey, this.pointInTimeRecovery, this.readCapacity, this.removalPolicy, this.replicationRegions, this.replicationTimeout, this.serverSideEncryption, this.stream, this.timeToLiveAttribute, this.writeCapacity, this.partitionKey, this.sortKey);
        }
    }
}

