/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.dynamodb.Attribute;
import software.amazon.awscdk.services.dynamodb.BillingMode;
import software.amazon.awscdk.services.dynamodb.StreamViewType;
import software.amazon.awscdk.services.dynamodb.TableOptions;
import software.amazon.jsii.JsiiSerializable;

public interface TableOptions
extends JsiiSerializable {
    public Attribute getPartitionKey();

    public BillingMode getBillingMode();

    public Boolean getPointInTimeRecovery();

    public Number getReadCapacity();

    public RemovalPolicy getRemovalPolicy();

    public Boolean getServerSideEncryption();

    public Attribute getSortKey();

    public StreamViewType getStream();

    public String getTimeToLiveAttribute();

    public Number getWriteCapacity();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Attribute partitionKey;
        private BillingMode billingMode;
        private Boolean pointInTimeRecovery;
        private Number readCapacity;
        private RemovalPolicy removalPolicy;
        private Boolean serverSideEncryption;
        private Attribute sortKey;
        private StreamViewType stream;
        private String timeToLiveAttribute;
        private Number writeCapacity;

        public Builder partitionKey(Attribute partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public Builder billingMode(BillingMode billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        public Builder pointInTimeRecovery(Boolean pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery;
            return this;
        }

        public Builder readCapacity(Number readCapacity) {
            this.readCapacity = readCapacity;
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        public Builder serverSideEncryption(Boolean serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        public Builder sortKey(Attribute sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        public Builder stream(StreamViewType stream) {
            this.stream = stream;
            return this;
        }

        public Builder timeToLiveAttribute(String timeToLiveAttribute) {
            this.timeToLiveAttribute = timeToLiveAttribute;
            return this;
        }

        public Builder writeCapacity(Number writeCapacity) {
            this.writeCapacity = writeCapacity;
            return this;
        }

        public TableOptions build() {
            return new Jsii.Proxy(this.partitionKey, this.billingMode, this.pointInTimeRecovery, this.readCapacity, this.removalPolicy, this.serverSideEncryption, this.sortKey, this.stream, this.timeToLiveAttribute, this.writeCapacity, null);
        }
    }
}

