package software.amazon.awscdk.services.dynamodb;

/**
 * What kind of server-side encryption to apply to this table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Table table = Table.Builder.create(this, "MyTable")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .encryption(TableEncryption.CUSTOMER_MANAGED)
 *         .build();
 * // You can access the CMK that was added to the stack on your behalf by the Table construct via:
 * IKey tableEncryptionKey = table.getEncryptionKey();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.50.0 (build d1830a4)", date = "2022-01-07T14:33:54.441Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.TableEncryption")
public enum TableEncryption {
    /**
     * Server-side KMS encryption with a master key owned by AWS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEFAULT,
    /**
     * Server-side KMS encryption with a customer master key managed by customer.
     * <p>
     * If <code>encryptionKey</code> is specified, this key will be used, otherwise, one will be defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CUSTOMER_MANAGED,
    /**
     * Server-side KMS encryption with a master key managed by AWS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_MANAGED,
}
