/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.dynamodb.;
import software.amazon.awscdk.services.dynamodb.CfnTable;
import software.amazon.awscdk.services.dynamodb.CfnTableProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-dynamodb.CfnTable")
public class CfnTable
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnTable.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnTable(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTable(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnTable(Construct scope, String id, CfnTableProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    public String getAttrStreamArn() {
        return (String)this.jsiiGet("attrStreamArn", String.class);
    }

    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", Map.class));
    }

    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    public Object getKeySchema() {
        return this.jsiiGet("keySchema", Object.class);
    }

    public void setKeySchema(IResolvable value) {
        this.jsiiSet("keySchema", Objects.requireNonNull(value, "keySchema is required"));
    }

    public void setKeySchema(List<Object> value) {
        this.jsiiSet("keySchema", Objects.requireNonNull(value, "keySchema is required"));
    }

    public Object getAttributeDefinitions() {
        return this.jsiiGet("attributeDefinitions", Object.class);
    }

    public void setAttributeDefinitions(IResolvable value) {
        this.jsiiSet("attributeDefinitions", value);
    }

    public void setAttributeDefinitions(List<Object> value) {
        this.jsiiSet("attributeDefinitions", value);
    }

    public String getBillingMode() {
        return (String)this.jsiiGet("billingMode", String.class);
    }

    public void setBillingMode(String value) {
        this.jsiiSet("billingMode", value);
    }

    public Object getGlobalSecondaryIndexes() {
        return this.jsiiGet("globalSecondaryIndexes", Object.class);
    }

    public void setGlobalSecondaryIndexes(IResolvable value) {
        this.jsiiSet("globalSecondaryIndexes", value);
    }

    public void setGlobalSecondaryIndexes(List<Object> value) {
        this.jsiiSet("globalSecondaryIndexes", value);
    }

    public Object getLocalSecondaryIndexes() {
        return this.jsiiGet("localSecondaryIndexes", Object.class);
    }

    public void setLocalSecondaryIndexes(IResolvable value) {
        this.jsiiSet("localSecondaryIndexes", value);
    }

    public void setLocalSecondaryIndexes(List<Object> value) {
        this.jsiiSet("localSecondaryIndexes", value);
    }

    public Object getPointInTimeRecoverySpecification() {
        return this.jsiiGet("pointInTimeRecoverySpecification", Object.class);
    }

    public void setPointInTimeRecoverySpecification(IResolvable value) {
        this.jsiiSet("pointInTimeRecoverySpecification", value);
    }

    public void setPointInTimeRecoverySpecification(PointInTimeRecoverySpecificationProperty value) {
        this.jsiiSet("pointInTimeRecoverySpecification", value);
    }

    public Object getProvisionedThroughput() {
        return this.jsiiGet("provisionedThroughput", Object.class);
    }

    public void setProvisionedThroughput(IResolvable value) {
        this.jsiiSet("provisionedThroughput", value);
    }

    public void setProvisionedThroughput(ProvisionedThroughputProperty value) {
        this.jsiiSet("provisionedThroughput", value);
    }

    public Object getSseSpecification() {
        return this.jsiiGet("sseSpecification", Object.class);
    }

    public void setSseSpecification(IResolvable value) {
        this.jsiiSet("sseSpecification", value);
    }

    public void setSseSpecification(SSESpecificationProperty value) {
        this.jsiiSet("sseSpecification", value);
    }

    public Object getStreamSpecification() {
        return this.jsiiGet("streamSpecification", Object.class);
    }

    public void setStreamSpecification(IResolvable value) {
        this.jsiiSet("streamSpecification", value);
    }

    public void setStreamSpecification(StreamSpecificationProperty value) {
        this.jsiiSet("streamSpecification", value);
    }

    public String getTableName() {
        return (String)this.jsiiGet("tableName", String.class);
    }

    public void setTableName(String value) {
        this.jsiiSet("tableName", value);
    }

    public Object getTimeToLiveSpecification() {
        return this.jsiiGet("timeToLiveSpecification", Object.class);
    }

    public void setTimeToLiveSpecification(IResolvable value) {
        this.jsiiSet("timeToLiveSpecification", value);
    }

    public void setTimeToLiveSpecification(TimeToLiveSpecificationProperty value) {
        this.jsiiSet("timeToLiveSpecification", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnTableProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnTableProps.Builder();
        }

        public Builder keySchema(IResolvable keySchema) {
            this.props.keySchema(keySchema);
            return this;
        }

        public Builder keySchema(List<Object> keySchema) {
            this.props.keySchema(keySchema);
            return this;
        }

        public Builder attributeDefinitions(IResolvable attributeDefinitions) {
            this.props.attributeDefinitions(attributeDefinitions);
            return this;
        }

        public Builder attributeDefinitions(List<Object> attributeDefinitions) {
            this.props.attributeDefinitions(attributeDefinitions);
            return this;
        }

        public Builder billingMode(String billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }

        public Builder globalSecondaryIndexes(IResolvable globalSecondaryIndexes) {
            this.props.globalSecondaryIndexes(globalSecondaryIndexes);
            return this;
        }

        public Builder globalSecondaryIndexes(List<Object> globalSecondaryIndexes) {
            this.props.globalSecondaryIndexes(globalSecondaryIndexes);
            return this;
        }

        public Builder localSecondaryIndexes(IResolvable localSecondaryIndexes) {
            this.props.localSecondaryIndexes(localSecondaryIndexes);
            return this;
        }

        public Builder localSecondaryIndexes(List<Object> localSecondaryIndexes) {
            this.props.localSecondaryIndexes(localSecondaryIndexes);
            return this;
        }

        public Builder pointInTimeRecoverySpecification(IResolvable pointInTimeRecoverySpecification) {
            this.props.pointInTimeRecoverySpecification(pointInTimeRecoverySpecification);
            return this;
        }

        public Builder pointInTimeRecoverySpecification(PointInTimeRecoverySpecificationProperty pointInTimeRecoverySpecification) {
            this.props.pointInTimeRecoverySpecification(pointInTimeRecoverySpecification);
            return this;
        }

        public Builder provisionedThroughput(IResolvable provisionedThroughput) {
            this.props.provisionedThroughput(provisionedThroughput);
            return this;
        }

        public Builder provisionedThroughput(ProvisionedThroughputProperty provisionedThroughput) {
            this.props.provisionedThroughput(provisionedThroughput);
            return this;
        }

        public Builder sseSpecification(IResolvable sseSpecification) {
            this.props.sseSpecification(sseSpecification);
            return this;
        }

        public Builder sseSpecification(SSESpecificationProperty sseSpecification) {
            this.props.sseSpecification(sseSpecification);
            return this;
        }

        public Builder streamSpecification(IResolvable streamSpecification) {
            this.props.streamSpecification(streamSpecification);
            return this;
        }

        public Builder streamSpecification(StreamSpecificationProperty streamSpecification) {
            this.props.streamSpecification(streamSpecification);
            return this;
        }

        public Builder tableName(String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder timeToLiveSpecification(IResolvable timeToLiveSpecification) {
            this.props.timeToLiveSpecification(timeToLiveSpecification);
            return this;
        }

        public Builder timeToLiveSpecification(TimeToLiveSpecificationProperty timeToLiveSpecification) {
            this.props.timeToLiveSpecification(timeToLiveSpecification);
            return this;
        }

        public CfnTable build() {
            return new CfnTable(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-dynamodb.CfnTable.TimeToLiveSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimeToLiveSpecificationProperty
    extends JsiiSerializable {
        public String getAttributeName();

        public Object getEnabled();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String attributeName;
            private Object enabled;

            public Builder attributeName(String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public TimeToLiveSpecificationProperty build() {
                return new Jsii.Proxy(this.attributeName, this.enabled, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-dynamodb.CfnTable.StreamSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StreamSpecificationProperty
    extends JsiiSerializable {
        public String getStreamViewType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String streamViewType;

            public Builder streamViewType(String streamViewType) {
                this.streamViewType = streamViewType;
                return this;
            }

            public StreamSpecificationProperty build() {
                return new Jsii.Proxy(this.streamViewType, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-dynamodb.CfnTable.SSESpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SSESpecificationProperty
    extends JsiiSerializable {
        public Object getSseEnabled();

        default public String getKmsMasterKeyId() {
            return null;
        }

        default public String getSseType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object sseEnabled;
            private String kmsMasterKeyId;
            private String sseType;

            public Builder sseEnabled(Boolean sseEnabled) {
                this.sseEnabled = sseEnabled;
                return this;
            }

            public Builder sseEnabled(IResolvable sseEnabled) {
                this.sseEnabled = sseEnabled;
                return this;
            }

            public Builder kmsMasterKeyId(String kmsMasterKeyId) {
                this.kmsMasterKeyId = kmsMasterKeyId;
                return this;
            }

            public Builder sseType(String sseType) {
                this.sseType = sseType;
                return this;
            }

            public SSESpecificationProperty build() {
                return new Jsii.Proxy(this.sseEnabled, this.kmsMasterKeyId, this.sseType, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-dynamodb.CfnTable.ProvisionedThroughputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProvisionedThroughputProperty
    extends JsiiSerializable {
        public Number getReadCapacityUnits();

        public Number getWriteCapacityUnits();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number readCapacityUnits;
            private Number writeCapacityUnits;

            public Builder readCapacityUnits(Number readCapacityUnits) {
                this.readCapacityUnits = readCapacityUnits;
                return this;
            }

            public Builder writeCapacityUnits(Number writeCapacityUnits) {
                this.writeCapacityUnits = writeCapacityUnits;
                return this;
            }

            public ProvisionedThroughputProperty build() {
                return new Jsii.Proxy(this.readCapacityUnits, this.writeCapacityUnits, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-dynamodb.CfnTable.ProjectionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProjectionProperty
    extends JsiiSerializable {
        default public List<String> getNonKeyAttributes() {
            return null;
        }

        default public String getProjectionType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> nonKeyAttributes;
            private String projectionType;

            public Builder nonKeyAttributes(List<String> nonKeyAttributes) {
                this.nonKeyAttributes = nonKeyAttributes;
                return this;
            }

            public Builder projectionType(String projectionType) {
                this.projectionType = projectionType;
                return this;
            }

            public ProjectionProperty build() {
                return new Jsii.Proxy(this.nonKeyAttributes, this.projectionType, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-dynamodb.CfnTable.PointInTimeRecoverySpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PointInTimeRecoverySpecificationProperty
    extends JsiiSerializable {
        default public Object getPointInTimeRecoveryEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object pointInTimeRecoveryEnabled;

            public Builder pointInTimeRecoveryEnabled(Boolean pointInTimeRecoveryEnabled) {
                this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
                return this;
            }

            public Builder pointInTimeRecoveryEnabled(IResolvable pointInTimeRecoveryEnabled) {
                this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
                return this;
            }

            public PointInTimeRecoverySpecificationProperty build() {
                return new Jsii.Proxy(this.pointInTimeRecoveryEnabled, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-dynamodb.CfnTable.LocalSecondaryIndexProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LocalSecondaryIndexProperty
    extends JsiiSerializable {
        public String getIndexName();

        public Object getKeySchema();

        public Object getProjection();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String indexName;
            private Object keySchema;
            private Object projection;

            public Builder indexName(String indexName) {
                this.indexName = indexName;
                return this;
            }

            public Builder keySchema(IResolvable keySchema) {
                this.keySchema = keySchema;
                return this;
            }

            public Builder keySchema(List<Object> keySchema) {
                this.keySchema = keySchema;
                return this;
            }

            public Builder projection(IResolvable projection) {
                this.projection = projection;
                return this;
            }

            public Builder projection(ProjectionProperty projection) {
                this.projection = projection;
                return this;
            }

            public LocalSecondaryIndexProperty build() {
                return new Jsii.Proxy(this.indexName, this.keySchema, this.projection, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-dynamodb.CfnTable.KeySchemaProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KeySchemaProperty
    extends JsiiSerializable {
        public String getAttributeName();

        public String getKeyType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String attributeName;
            private String keyType;

            public Builder attributeName(String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            public Builder keyType(String keyType) {
                this.keyType = keyType;
                return this;
            }

            public KeySchemaProperty build() {
                return new Jsii.Proxy(this.attributeName, this.keyType, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-dynamodb.CfnTable.GlobalSecondaryIndexProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GlobalSecondaryIndexProperty
    extends JsiiSerializable {
        public String getIndexName();

        public Object getKeySchema();

        public Object getProjection();

        default public Object getProvisionedThroughput() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String indexName;
            private Object keySchema;
            private Object projection;
            private Object provisionedThroughput;

            public Builder indexName(String indexName) {
                this.indexName = indexName;
                return this;
            }

            public Builder keySchema(IResolvable keySchema) {
                this.keySchema = keySchema;
                return this;
            }

            public Builder keySchema(List<Object> keySchema) {
                this.keySchema = keySchema;
                return this;
            }

            public Builder projection(IResolvable projection) {
                this.projection = projection;
                return this;
            }

            public Builder projection(ProjectionProperty projection) {
                this.projection = projection;
                return this;
            }

            public Builder provisionedThroughput(IResolvable provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            public Builder provisionedThroughput(ProvisionedThroughputProperty provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            public GlobalSecondaryIndexProperty build() {
                return new Jsii.Proxy(this.indexName, this.keySchema, this.projection, this.provisionedThroughput, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-dynamodb.CfnTable.AttributeDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AttributeDefinitionProperty
    extends JsiiSerializable {
        public String getAttributeName();

        public String getAttributeType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String attributeName;
            private String attributeType;

            public Builder attributeName(String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            public Builder attributeType(String attributeType) {
                this.attributeType = attributeType;
                return this;
            }

            public AttributeDefinitionProperty build() {
                return new Jsii.Proxy(this.attributeName, this.attributeType, null);
            }
        }
    }
}

