package software.amazon.awscdk.services.dynamodb;

/**
 * Data types for attributes within a table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Table globalTable = Table.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .replicationRegions(List.of("us-east-1", "us-east-2", "us-west-2"))
 *         .billingMode(BillingMode.PROVISIONED)
 *         .build();
 * globalTable.autoScaleWriteCapacity(EnableScalingProps.builder()
 *         .minCapacity(1)
 *         .maxCapacity(10)
 *         .build()).scaleOnUtilization(UtilizationScalingProps.builder().targetUtilizationPercent(75).build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-06-14T14:06:38.263Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.AttributeType")
public enum AttributeType {
    /**
     * Up to 400KiB of binary data (which must be encoded as base64 before sending to DynamoDB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BINARY,
    /**
     * Numeric values made of up to 38 digits (positive, negative or zero).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NUMBER,
    /**
     * Up to 400KiB of UTF-8 encoded text.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STRING,
}
