package software.amazon.awscdk.services.dynamodb;

/**
 * Properties for defining a `CfnTable`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dynamodb.*;
 * CfnTableProps cfnTableProps = CfnTableProps.builder()
 *         .keySchema(List.of(KeySchemaProperty.builder()
 *                 .attributeName("attributeName")
 *                 .keyType("keyType")
 *                 .build()))
 *         // the properties below are optional
 *         .attributeDefinitions(List.of(AttributeDefinitionProperty.builder()
 *                 .attributeName("attributeName")
 *                 .attributeType("attributeType")
 *                 .build()))
 *         .billingMode("billingMode")
 *         .contributorInsightsSpecification(ContributorInsightsSpecificationProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .globalSecondaryIndexes(List.of(GlobalSecondaryIndexProperty.builder()
 *                 .indexName("indexName")
 *                 .keySchema(List.of(KeySchemaProperty.builder()
 *                         .attributeName("attributeName")
 *                         .keyType("keyType")
 *                         .build()))
 *                 .projection(ProjectionProperty.builder()
 *                         .nonKeyAttributes(List.of("nonKeyAttributes"))
 *                         .projectionType("projectionType")
 *                         .build())
 *                 // the properties below are optional
 *                 .contributorInsightsSpecification(ContributorInsightsSpecificationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .provisionedThroughput(ProvisionedThroughputProperty.builder()
 *                         .readCapacityUnits(123)
 *                         .writeCapacityUnits(123)
 *                         .build())
 *                 .build()))
 *         .kinesisStreamSpecification(KinesisStreamSpecificationProperty.builder()
 *                 .streamArn("streamArn")
 *                 .build())
 *         .localSecondaryIndexes(List.of(LocalSecondaryIndexProperty.builder()
 *                 .indexName("indexName")
 *                 .keySchema(List.of(KeySchemaProperty.builder()
 *                         .attributeName("attributeName")
 *                         .keyType("keyType")
 *                         .build()))
 *                 .projection(ProjectionProperty.builder()
 *                         .nonKeyAttributes(List.of("nonKeyAttributes"))
 *                         .projectionType("projectionType")
 *                         .build())
 *                 .build()))
 *         .pointInTimeRecoverySpecification(PointInTimeRecoverySpecificationProperty.builder()
 *                 .pointInTimeRecoveryEnabled(false)
 *                 .build())
 *         .provisionedThroughput(ProvisionedThroughputProperty.builder()
 *                 .readCapacityUnits(123)
 *                 .writeCapacityUnits(123)
 *                 .build())
 *         .sseSpecification(SSESpecificationProperty.builder()
 *                 .sseEnabled(false)
 *                 // the properties below are optional
 *                 .kmsMasterKeyId("kmsMasterKeyId")
 *                 .sseType("sseType")
 *                 .build())
 *         .streamSpecification(StreamSpecificationProperty.builder()
 *                 .streamViewType("streamViewType")
 *                 .build())
 *         .tableClass("tableClass")
 *         .tableName("tableName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeToLiveSpecification(TimeToLiveSpecificationProperty.builder()
 *                 .attributeName("attributeName")
 *                 .enabled(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-06-22T23:27:57.533Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.CfnTableProps")
@software.amazon.jsii.Jsii.Proxy(CfnTableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTableProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the attributes that make up the primary key for the table.
     * <p>
     * The attributes in the <code>KeySchema</code> property must also be defined in the <code>AttributeDefinitions</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getKeySchema();

    /**
     * A list of attributes that describe the key schema for the table and indexes.
     * <p>
     * This property is required to create a DynamoDB table.
     * <p>
     * Update requires: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">Some interruptions</a> . Replacement if you edit an existing AttributeDefinition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAttributeDefinitions() {
        return null;
    }

    /**
     * Specify how you are charged for read and write throughput and how you manage capacity.
     * <p>
     * Valid values include:
     * <p>
     * <ul>
     * <li><code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a> .</li>
     * <li><code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a> .</li>
     * </ul>
     * <p>
     * If not specified, the default is <code>PROVISIONED</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBillingMode() {
        return null;
    }

    /**
     * The settings used to enable or disable CloudWatch Contributor Insights for the specified table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContributorInsightsSpecification() {
        return null;
    }

    /**
     * Global secondary indexes to be created on the table. You can create up to 20 global secondary indexes.
     * <p>
     * <blockquote>
     * <p>
     * If you update a table to include a new global secondary index, AWS CloudFormation initiates the index creation and then proceeds with the stack update. AWS CloudFormation doesn't wait for the index to complete creation because the backfilling phase can take a long time, depending on the size of the table. You can't use the index or update the table until the index's status is <code>ACTIVE</code> . You can track its status by using the DynamoDB <a href="https://docs.aws.amazon.com/cli/latest/reference/dynamodb/describe-table.html">DescribeTable</a> command.
     * <p>
     * If you add or delete an index during an update, we recommend that you don't update any other resources. If your stack fails to update and is rolled back while adding a new index, you must manually delete the index.
     * <p>
     * Updates are not supported. The following are exceptions:
     * <p>
     * <ul>
     * <li>If you update either the contributor insights specification or the provisioned throughput values of global secondary indexes, you can update the table without interruption.</li>
     * <li>You can delete or add one global secondary index without interruption. If you do both in the same update (for example, by changing the index's logical ID), the update fails.</li>
     * </ul>
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGlobalSecondaryIndexes() {
        return null;
    }

    /**
     * The Kinesis Data Streams configuration for the specified table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisStreamSpecification() {
        return null;
    }

    /**
     * Local secondary indexes to be created on the table.
     * <p>
     * You can create up to 5 local secondary indexes. Each index is scoped to a given hash key value. The size of each hash key can be up to 10 gigabytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLocalSecondaryIndexes() {
        return null;
    }

    /**
     * The settings used to enable point in time recovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPointInTimeRecoverySpecification() {
        return null;
    }

    /**
     * Throughput for the specified table, which consists of values for `ReadCapacityUnits` and `WriteCapacityUnits` .
     * <p>
     * For more information about the contents of a provisioned throughput structure, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html">Amazon DynamoDB Table ProvisionedThroughput</a> .
     * <p>
     * If you set <code>BillingMode</code> as <code>PROVISIONED</code> , you must specify this property. If you set <code>BillingMode</code> as <code>PAY_PER_REQUEST</code> , you cannot specify this property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedThroughput() {
        return null;
    }

    /**
     * Specifies the settings to enable server-side encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSseSpecification() {
        return null;
    }

    /**
     * The settings for the DynamoDB table stream, which capture changes to items stored in the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStreamSpecification() {
        return null;
    }

    /**
     * The table class of the new table.
     * <p>
     * Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableClass() {
        return null;
    }

    /**
     * A name for the table.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the table name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * Specifies the Time to Live (TTL) settings for the table.
     * <p>
     * <blockquote>
     * <p>
     * For detailed information about the limits in DynamoDB, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits in Amazon DynamoDB</a> in the Amazon DynamoDB Developer Guide.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTimeToLiveSpecification() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTableProps> {
        java.lang.Object keySchema;
        java.lang.Object attributeDefinitions;
        java.lang.String billingMode;
        java.lang.Object contributorInsightsSpecification;
        java.lang.Object globalSecondaryIndexes;
        java.lang.Object kinesisStreamSpecification;
        java.lang.Object localSecondaryIndexes;
        java.lang.Object pointInTimeRecoverySpecification;
        java.lang.Object provisionedThroughput;
        java.lang.Object sseSpecification;
        java.lang.Object streamSpecification;
        java.lang.String tableClass;
        java.lang.String tableName;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.Object timeToLiveSpecification;

        /**
         * Sets the value of {@link CfnTableProps#getKeySchema}
         * @param keySchema Specifies the attributes that make up the primary key for the table. This parameter is required.
         *                  The attributes in the <code>KeySchema</code> property must also be defined in the <code>AttributeDefinitions</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySchema(software.amazon.awscdk.core.IResolvable keySchema) {
            this.keySchema = keySchema;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getKeySchema}
         * @param keySchema Specifies the attributes that make up the primary key for the table. This parameter is required.
         *                  The attributes in the <code>KeySchema</code> property must also be defined in the <code>AttributeDefinitions</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySchema(java.util.List<? extends java.lang.Object> keySchema) {
            this.keySchema = keySchema;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getAttributeDefinitions}
         * @param attributeDefinitions A list of attributes that describe the key schema for the table and indexes.
         *                             This property is required to create a DynamoDB table.
         *                             <p>
         *                             Update requires: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">Some interruptions</a> . Replacement if you edit an existing AttributeDefinition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeDefinitions(software.amazon.awscdk.core.IResolvable attributeDefinitions) {
            this.attributeDefinitions = attributeDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getAttributeDefinitions}
         * @param attributeDefinitions A list of attributes that describe the key schema for the table and indexes.
         *                             This property is required to create a DynamoDB table.
         *                             <p>
         *                             Update requires: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">Some interruptions</a> . Replacement if you edit an existing AttributeDefinition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeDefinitions(java.util.List<? extends java.lang.Object> attributeDefinitions) {
            this.attributeDefinitions = attributeDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getBillingMode}
         * @param billingMode Specify how you are charged for read and write throughput and how you manage capacity.
         *                    Valid values include:
         *                    <p>
         *                    <ul>
         *                    <li><code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a> .</li>
         *                    <li><code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a> .</li>
         *                    </ul>
         *                    <p>
         *                    If not specified, the default is <code>PROVISIONED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(java.lang.String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getContributorInsightsSpecification}
         * @param contributorInsightsSpecification The settings used to enable or disable CloudWatch Contributor Insights for the specified table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contributorInsightsSpecification(software.amazon.awscdk.core.IResolvable contributorInsightsSpecification) {
            this.contributorInsightsSpecification = contributorInsightsSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getContributorInsightsSpecification}
         * @param contributorInsightsSpecification The settings used to enable or disable CloudWatch Contributor Insights for the specified table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contributorInsightsSpecification(software.amazon.awscdk.services.dynamodb.CfnTable.ContributorInsightsSpecificationProperty contributorInsightsSpecification) {
            this.contributorInsightsSpecification = contributorInsightsSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getGlobalSecondaryIndexes}
         * @param globalSecondaryIndexes Global secondary indexes to be created on the table. You can create up to 20 global secondary indexes.
         *                               <blockquote>
         *                               <p>
         *                               If you update a table to include a new global secondary index, AWS CloudFormation initiates the index creation and then proceeds with the stack update. AWS CloudFormation doesn't wait for the index to complete creation because the backfilling phase can take a long time, depending on the size of the table. You can't use the index or update the table until the index's status is <code>ACTIVE</code> . You can track its status by using the DynamoDB <a href="https://docs.aws.amazon.com/cli/latest/reference/dynamodb/describe-table.html">DescribeTable</a> command.
         *                               <p>
         *                               If you add or delete an index during an update, we recommend that you don't update any other resources. If your stack fails to update and is rolled back while adding a new index, you must manually delete the index.
         *                               <p>
         *                               Updates are not supported. The following are exceptions:
         *                               <p>
         *                               <ul>
         *                               <li>If you update either the contributor insights specification or the provisioned throughput values of global secondary indexes, you can update the table without interruption.</li>
         *                               <li>You can delete or add one global secondary index without interruption. If you do both in the same update (for example, by changing the index's logical ID), the update fails.</li>
         *                               </ul>
         *                               <p>
         *                               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalSecondaryIndexes(software.amazon.awscdk.core.IResolvable globalSecondaryIndexes) {
            this.globalSecondaryIndexes = globalSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getGlobalSecondaryIndexes}
         * @param globalSecondaryIndexes Global secondary indexes to be created on the table. You can create up to 20 global secondary indexes.
         *                               <blockquote>
         *                               <p>
         *                               If you update a table to include a new global secondary index, AWS CloudFormation initiates the index creation and then proceeds with the stack update. AWS CloudFormation doesn't wait for the index to complete creation because the backfilling phase can take a long time, depending on the size of the table. You can't use the index or update the table until the index's status is <code>ACTIVE</code> . You can track its status by using the DynamoDB <a href="https://docs.aws.amazon.com/cli/latest/reference/dynamodb/describe-table.html">DescribeTable</a> command.
         *                               <p>
         *                               If you add or delete an index during an update, we recommend that you don't update any other resources. If your stack fails to update and is rolled back while adding a new index, you must manually delete the index.
         *                               <p>
         *                               Updates are not supported. The following are exceptions:
         *                               <p>
         *                               <ul>
         *                               <li>If you update either the contributor insights specification or the provisioned throughput values of global secondary indexes, you can update the table without interruption.</li>
         *                               <li>You can delete or add one global secondary index without interruption. If you do both in the same update (for example, by changing the index's logical ID), the update fails.</li>
         *                               </ul>
         *                               <p>
         *                               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalSecondaryIndexes(java.util.List<? extends java.lang.Object> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = globalSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getKinesisStreamSpecification}
         * @param kinesisStreamSpecification The Kinesis Data Streams configuration for the specified table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStreamSpecification(software.amazon.awscdk.core.IResolvable kinesisStreamSpecification) {
            this.kinesisStreamSpecification = kinesisStreamSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getKinesisStreamSpecification}
         * @param kinesisStreamSpecification The Kinesis Data Streams configuration for the specified table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStreamSpecification(software.amazon.awscdk.services.dynamodb.CfnTable.KinesisStreamSpecificationProperty kinesisStreamSpecification) {
            this.kinesisStreamSpecification = kinesisStreamSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getLocalSecondaryIndexes}
         * @param localSecondaryIndexes Local secondary indexes to be created on the table.
         *                              You can create up to 5 local secondary indexes. Each index is scoped to a given hash key value. The size of each hash key can be up to 10 gigabytes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localSecondaryIndexes(software.amazon.awscdk.core.IResolvable localSecondaryIndexes) {
            this.localSecondaryIndexes = localSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getLocalSecondaryIndexes}
         * @param localSecondaryIndexes Local secondary indexes to be created on the table.
         *                              You can create up to 5 local secondary indexes. Each index is scoped to a given hash key value. The size of each hash key can be up to 10 gigabytes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localSecondaryIndexes(java.util.List<? extends java.lang.Object> localSecondaryIndexes) {
            this.localSecondaryIndexes = localSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getPointInTimeRecoverySpecification}
         * @param pointInTimeRecoverySpecification The settings used to enable point in time recovery.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecoverySpecification(software.amazon.awscdk.core.IResolvable pointInTimeRecoverySpecification) {
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getPointInTimeRecoverySpecification}
         * @param pointInTimeRecoverySpecification The settings used to enable point in time recovery.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecoverySpecification(software.amazon.awscdk.services.dynamodb.CfnTable.PointInTimeRecoverySpecificationProperty pointInTimeRecoverySpecification) {
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getProvisionedThroughput}
         * @param provisionedThroughput Throughput for the specified table, which consists of values for `ReadCapacityUnits` and `WriteCapacityUnits` .
         *                              For more information about the contents of a provisioned throughput structure, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html">Amazon DynamoDB Table ProvisionedThroughput</a> .
         *                              <p>
         *                              If you set <code>BillingMode</code> as <code>PROVISIONED</code> , you must specify this property. If you set <code>BillingMode</code> as <code>PAY_PER_REQUEST</code> , you cannot specify this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedThroughput(software.amazon.awscdk.core.IResolvable provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getProvisionedThroughput}
         * @param provisionedThroughput Throughput for the specified table, which consists of values for `ReadCapacityUnits` and `WriteCapacityUnits` .
         *                              For more information about the contents of a provisioned throughput structure, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html">Amazon DynamoDB Table ProvisionedThroughput</a> .
         *                              <p>
         *                              If you set <code>BillingMode</code> as <code>PROVISIONED</code> , you must specify this property. If you set <code>BillingMode</code> as <code>PAY_PER_REQUEST</code> , you cannot specify this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedThroughput(software.amazon.awscdk.services.dynamodb.CfnTable.ProvisionedThroughputProperty provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getSseSpecification}
         * @param sseSpecification Specifies the settings to enable server-side encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseSpecification(software.amazon.awscdk.core.IResolvable sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getSseSpecification}
         * @param sseSpecification Specifies the settings to enable server-side encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseSpecification(software.amazon.awscdk.services.dynamodb.CfnTable.SSESpecificationProperty sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getStreamSpecification}
         * @param streamSpecification The settings for the DynamoDB table stream, which capture changes to items stored in the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamSpecification(software.amazon.awscdk.core.IResolvable streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getStreamSpecification}
         * @param streamSpecification The settings for the DynamoDB table stream, which capture changes to items stored in the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamSpecification(software.amazon.awscdk.services.dynamodb.CfnTable.StreamSpecificationProperty streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTableClass}
         * @param tableClass The table class of the new table.
         *                   Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableClass(java.lang.String tableClass) {
            this.tableClass = tableClass;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTableName}
         * @param tableName A name for the table.
         *                  If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the table name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         *                  <p>
         *                  <blockquote>
         *                  <p>
         *                  If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTimeToLiveSpecification}
         * @param timeToLiveSpecification Specifies the Time to Live (TTL) settings for the table.
         *                                <blockquote>
         *                                <p>
         *                                For detailed information about the limits in DynamoDB, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits in Amazon DynamoDB</a> in the Amazon DynamoDB Developer Guide.
         *                                <p>
         *                                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveSpecification(software.amazon.awscdk.core.IResolvable timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTimeToLiveSpecification}
         * @param timeToLiveSpecification Specifies the Time to Live (TTL) settings for the table.
         *                                <blockquote>
         *                                <p>
         *                                For detailed information about the limits in DynamoDB, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits in Amazon DynamoDB</a> in the Amazon DynamoDB Developer Guide.
         *                                <p>
         *                                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveSpecification(software.amazon.awscdk.services.dynamodb.CfnTable.TimeToLiveSpecificationProperty timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTableProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTableProps {
        private final java.lang.Object keySchema;
        private final java.lang.Object attributeDefinitions;
        private final java.lang.String billingMode;
        private final java.lang.Object contributorInsightsSpecification;
        private final java.lang.Object globalSecondaryIndexes;
        private final java.lang.Object kinesisStreamSpecification;
        private final java.lang.Object localSecondaryIndexes;
        private final java.lang.Object pointInTimeRecoverySpecification;
        private final java.lang.Object provisionedThroughput;
        private final java.lang.Object sseSpecification;
        private final java.lang.Object streamSpecification;
        private final java.lang.String tableClass;
        private final java.lang.String tableName;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Object timeToLiveSpecification;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.keySchema = software.amazon.jsii.Kernel.get(this, "keySchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.attributeDefinitions = software.amazon.jsii.Kernel.get(this, "attributeDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.billingMode = software.amazon.jsii.Kernel.get(this, "billingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contributorInsightsSpecification = software.amazon.jsii.Kernel.get(this, "contributorInsightsSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.globalSecondaryIndexes = software.amazon.jsii.Kernel.get(this, "globalSecondaryIndexes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kinesisStreamSpecification = software.amazon.jsii.Kernel.get(this, "kinesisStreamSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.localSecondaryIndexes = software.amazon.jsii.Kernel.get(this, "localSecondaryIndexes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.pointInTimeRecoverySpecification = software.amazon.jsii.Kernel.get(this, "pointInTimeRecoverySpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.provisionedThroughput = software.amazon.jsii.Kernel.get(this, "provisionedThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sseSpecification = software.amazon.jsii.Kernel.get(this, "sseSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.streamSpecification = software.amazon.jsii.Kernel.get(this, "streamSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tableClass = software.amazon.jsii.Kernel.get(this, "tableClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.timeToLiveSpecification = software.amazon.jsii.Kernel.get(this, "timeToLiveSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.keySchema = java.util.Objects.requireNonNull(builder.keySchema, "keySchema is required");
            this.attributeDefinitions = builder.attributeDefinitions;
            this.billingMode = builder.billingMode;
            this.contributorInsightsSpecification = builder.contributorInsightsSpecification;
            this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
            this.kinesisStreamSpecification = builder.kinesisStreamSpecification;
            this.localSecondaryIndexes = builder.localSecondaryIndexes;
            this.pointInTimeRecoverySpecification = builder.pointInTimeRecoverySpecification;
            this.provisionedThroughput = builder.provisionedThroughput;
            this.sseSpecification = builder.sseSpecification;
            this.streamSpecification = builder.streamSpecification;
            this.tableClass = builder.tableClass;
            this.tableName = builder.tableName;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.timeToLiveSpecification = builder.timeToLiveSpecification;
        }

        @Override
        public final java.lang.Object getKeySchema() {
            return this.keySchema;
        }

        @Override
        public final java.lang.Object getAttributeDefinitions() {
            return this.attributeDefinitions;
        }

        @Override
        public final java.lang.String getBillingMode() {
            return this.billingMode;
        }

        @Override
        public final java.lang.Object getContributorInsightsSpecification() {
            return this.contributorInsightsSpecification;
        }

        @Override
        public final java.lang.Object getGlobalSecondaryIndexes() {
            return this.globalSecondaryIndexes;
        }

        @Override
        public final java.lang.Object getKinesisStreamSpecification() {
            return this.kinesisStreamSpecification;
        }

        @Override
        public final java.lang.Object getLocalSecondaryIndexes() {
            return this.localSecondaryIndexes;
        }

        @Override
        public final java.lang.Object getPointInTimeRecoverySpecification() {
            return this.pointInTimeRecoverySpecification;
        }

        @Override
        public final java.lang.Object getProvisionedThroughput() {
            return this.provisionedThroughput;
        }

        @Override
        public final java.lang.Object getSseSpecification() {
            return this.sseSpecification;
        }

        @Override
        public final java.lang.Object getStreamSpecification() {
            return this.streamSpecification;
        }

        @Override
        public final java.lang.String getTableClass() {
            return this.tableClass;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTimeToLiveSpecification() {
            return this.timeToLiveSpecification;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("keySchema", om.valueToTree(this.getKeySchema()));
            if (this.getAttributeDefinitions() != null) {
                data.set("attributeDefinitions", om.valueToTree(this.getAttributeDefinitions()));
            }
            if (this.getBillingMode() != null) {
                data.set("billingMode", om.valueToTree(this.getBillingMode()));
            }
            if (this.getContributorInsightsSpecification() != null) {
                data.set("contributorInsightsSpecification", om.valueToTree(this.getContributorInsightsSpecification()));
            }
            if (this.getGlobalSecondaryIndexes() != null) {
                data.set("globalSecondaryIndexes", om.valueToTree(this.getGlobalSecondaryIndexes()));
            }
            if (this.getKinesisStreamSpecification() != null) {
                data.set("kinesisStreamSpecification", om.valueToTree(this.getKinesisStreamSpecification()));
            }
            if (this.getLocalSecondaryIndexes() != null) {
                data.set("localSecondaryIndexes", om.valueToTree(this.getLocalSecondaryIndexes()));
            }
            if (this.getPointInTimeRecoverySpecification() != null) {
                data.set("pointInTimeRecoverySpecification", om.valueToTree(this.getPointInTimeRecoverySpecification()));
            }
            if (this.getProvisionedThroughput() != null) {
                data.set("provisionedThroughput", om.valueToTree(this.getProvisionedThroughput()));
            }
            if (this.getSseSpecification() != null) {
                data.set("sseSpecification", om.valueToTree(this.getSseSpecification()));
            }
            if (this.getStreamSpecification() != null) {
                data.set("streamSpecification", om.valueToTree(this.getStreamSpecification()));
            }
            if (this.getTableClass() != null) {
                data.set("tableClass", om.valueToTree(this.getTableClass()));
            }
            if (this.getTableName() != null) {
                data.set("tableName", om.valueToTree(this.getTableName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTimeToLiveSpecification() != null) {
                data.set("timeToLiveSpecification", om.valueToTree(this.getTimeToLiveSpecification()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-dynamodb.CfnTableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTableProps.Jsii$Proxy that = (CfnTableProps.Jsii$Proxy) o;

            if (!keySchema.equals(that.keySchema)) return false;
            if (this.attributeDefinitions != null ? !this.attributeDefinitions.equals(that.attributeDefinitions) : that.attributeDefinitions != null) return false;
            if (this.billingMode != null ? !this.billingMode.equals(that.billingMode) : that.billingMode != null) return false;
            if (this.contributorInsightsSpecification != null ? !this.contributorInsightsSpecification.equals(that.contributorInsightsSpecification) : that.contributorInsightsSpecification != null) return false;
            if (this.globalSecondaryIndexes != null ? !this.globalSecondaryIndexes.equals(that.globalSecondaryIndexes) : that.globalSecondaryIndexes != null) return false;
            if (this.kinesisStreamSpecification != null ? !this.kinesisStreamSpecification.equals(that.kinesisStreamSpecification) : that.kinesisStreamSpecification != null) return false;
            if (this.localSecondaryIndexes != null ? !this.localSecondaryIndexes.equals(that.localSecondaryIndexes) : that.localSecondaryIndexes != null) return false;
            if (this.pointInTimeRecoverySpecification != null ? !this.pointInTimeRecoverySpecification.equals(that.pointInTimeRecoverySpecification) : that.pointInTimeRecoverySpecification != null) return false;
            if (this.provisionedThroughput != null ? !this.provisionedThroughput.equals(that.provisionedThroughput) : that.provisionedThroughput != null) return false;
            if (this.sseSpecification != null ? !this.sseSpecification.equals(that.sseSpecification) : that.sseSpecification != null) return false;
            if (this.streamSpecification != null ? !this.streamSpecification.equals(that.streamSpecification) : that.streamSpecification != null) return false;
            if (this.tableClass != null ? !this.tableClass.equals(that.tableClass) : that.tableClass != null) return false;
            if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.timeToLiveSpecification != null ? this.timeToLiveSpecification.equals(that.timeToLiveSpecification) : that.timeToLiveSpecification == null;
        }

        @Override
        public final int hashCode() {
            int result = this.keySchema.hashCode();
            result = 31 * result + (this.attributeDefinitions != null ? this.attributeDefinitions.hashCode() : 0);
            result = 31 * result + (this.billingMode != null ? this.billingMode.hashCode() : 0);
            result = 31 * result + (this.contributorInsightsSpecification != null ? this.contributorInsightsSpecification.hashCode() : 0);
            result = 31 * result + (this.globalSecondaryIndexes != null ? this.globalSecondaryIndexes.hashCode() : 0);
            result = 31 * result + (this.kinesisStreamSpecification != null ? this.kinesisStreamSpecification.hashCode() : 0);
            result = 31 * result + (this.localSecondaryIndexes != null ? this.localSecondaryIndexes.hashCode() : 0);
            result = 31 * result + (this.pointInTimeRecoverySpecification != null ? this.pointInTimeRecoverySpecification.hashCode() : 0);
            result = 31 * result + (this.provisionedThroughput != null ? this.provisionedThroughput.hashCode() : 0);
            result = 31 * result + (this.sseSpecification != null ? this.sseSpecification.hashCode() : 0);
            result = 31 * result + (this.streamSpecification != null ? this.streamSpecification.hashCode() : 0);
            result = 31 * result + (this.tableClass != null ? this.tableClass.hashCode() : 0);
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.timeToLiveSpecification != null ? this.timeToLiveSpecification.hashCode() : 0);
            return result;
        }
    }
}
