package software.amazon.awscdk.services.dynamodb;

/**
 * Properties for a DynamoDB Table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Table globalTable = Table.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .replicationRegions(List.of("us-east-1", "us-east-2", "us-west-2"))
 *         .billingMode(BillingMode.PROVISIONED)
 *         .build();
 * globalTable.autoScaleWriteCapacity(EnableScalingProps.builder()
 *         .minCapacity(1)
 *         .maxCapacity(10)
 *         .build()).scaleOnUtilization(UtilizationScalingProps.builder().targetUtilizationPercent(75).build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-13T22:11:56.461Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.TableProps")
@software.amazon.jsii.Jsii.Proxy(TableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TableProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.dynamodb.TableOptions {

    /**
     * Kinesis Data Stream to capture item-level changes for the table.
     * <p>
     * Default: - no Kinesis Data Stream
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.IStream getKinesisStream() {
        return null;
    }

    /**
     * Enforces a particular physical table name.
     * <p>
     * Default: <generated>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TableProps> {
        software.amazon.awscdk.services.kinesis.IStream kinesisStream;
        java.lang.String tableName;
        software.amazon.awscdk.services.dynamodb.BillingMode billingMode;
        java.lang.Boolean contributorInsightsEnabled;
        software.amazon.awscdk.services.dynamodb.TableEncryption encryption;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        java.lang.Boolean pointInTimeRecovery;
        java.lang.Number readCapacity;
        software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        java.util.List<java.lang.String> replicationRegions;
        software.amazon.awscdk.core.Duration replicationTimeout;
        java.lang.Boolean serverSideEncryption;
        software.amazon.awscdk.services.dynamodb.StreamViewType stream;
        software.amazon.awscdk.services.dynamodb.TableClass tableClass;
        java.lang.String timeToLiveAttribute;
        java.lang.Boolean waitForReplicationToFinish;
        java.lang.Number writeCapacity;
        software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        software.amazon.awscdk.services.dynamodb.Attribute sortKey;

        /**
         * Sets the value of {@link TableProps#getKinesisStream}
         * @param kinesisStream Kinesis Data Stream to capture item-level changes for the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStream(software.amazon.awscdk.services.kinesis.IStream kinesisStream) {
            this.kinesisStream = kinesisStream;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getTableName}
         * @param tableName Enforces a particular physical table name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getBillingMode}
         * @param billingMode Specify how you are charged for read and write throughput and how you manage capacity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(software.amazon.awscdk.services.dynamodb.BillingMode billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getContributorInsightsEnabled}
         * @param contributorInsightsEnabled Whether CloudWatch contributor insights is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contributorInsightsEnabled(java.lang.Boolean contributorInsightsEnabled) {
            this.contributorInsightsEnabled = contributorInsightsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getEncryption}
         * @param encryption Whether server-side encryption with an AWS managed customer master key is enabled.
         *                   This property cannot be set if <code>serverSideEncryption</code> is set.
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   <strong>NOTE</strong>: if you set this to <code>CUSTOMER_MANAGED</code> and <code>encryptionKey</code> is not
         *                   specified, the key that the Tablet generates for you will be created with
         *                   default permissions. If you are using CDKv2, these permissions will be
         *                   sufficient to enable the key for use with DynamoDB tables.  If you are
         *                   using CDKv1, make sure the feature flag
         *                   <code>&#64;aws-cdk/aws-kms:defaultKeyPolicies</code> is set to <code>true</code> in your <code>cdk.json</code>.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(software.amazon.awscdk.services.dynamodb.TableEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getEncryptionKey}
         * @param encryptionKey External KMS key to use for table encryption.
         *                      This property can only be set if <code>encryption</code> is set to <code>TableEncryption.CUSTOMER_MANAGED</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getPointInTimeRecovery}
         * @param pointInTimeRecovery Whether point-in-time recovery is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecovery(java.lang.Boolean pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getReadCapacity}
         * @param readCapacity The read capacity for the table.
         *                     Careful if you add Global Secondary Indexes, as
         *                     those will share the table's provisioned throughput.
         *                     <p>
         *                     Can only be provided if billingMode is Provisioned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readCapacity(java.lang.Number readCapacity) {
            this.readCapacity = readCapacity;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getRemovalPolicy}
         * @param removalPolicy The removal policy to apply to the DynamoDB Table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getReplicationRegions}
         * @param replicationRegions Regions where replica tables will be created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationRegions(java.util.List<java.lang.String> replicationRegions) {
            this.replicationRegions = replicationRegions;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getReplicationTimeout}
         * @param replicationTimeout The timeout for a table replication operation in a single region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationTimeout(software.amazon.awscdk.core.Duration replicationTimeout) {
            this.replicationTimeout = replicationTimeout;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getServerSideEncryption}
         * @param serverSideEncryption Whether server-side encryption with an AWS managed customer master key is enabled.
         *                             This property cannot be set if <code>encryption</code> and/or <code>encryptionKey</code> is set.
         * @return {@code this}
         * @deprecated This property is deprecated. In order to obtain the same behavior as
enabling this, set the `encryption` property to `TableEncryption.AWS_MANAGED` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder serverSideEncryption(java.lang.Boolean serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getStream}
         * @param stream When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stream(software.amazon.awscdk.services.dynamodb.StreamViewType stream) {
            this.stream = stream;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getTableClass}
         * @param tableClass Specify the table class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableClass(software.amazon.awscdk.services.dynamodb.TableClass tableClass) {
            this.tableClass = tableClass;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getTimeToLiveAttribute}
         * @param timeToLiveAttribute The name of TTL attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveAttribute(java.lang.String timeToLiveAttribute) {
            this.timeToLiveAttribute = timeToLiveAttribute;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getWaitForReplicationToFinish}
         * @param waitForReplicationToFinish Indicates whether CloudFormation stack waits for replication to finish.
         *                                   If set to false, the CloudFormation resource will mark the resource as
         *                                   created and replication will be completed asynchronously. This property is
         *                                   ignored if replicationRegions property is not set.
         *                                   <p>
         *                                   DO NOT UNSET this property if adding/removing multiple replicationRegions
         *                                   in one deployment, as CloudFormation only supports one region replication
         *                                   at a time. CDK overcomes this limitation by waiting for replication to
         *                                   finish before starting new replicationRegion.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder waitForReplicationToFinish(java.lang.Boolean waitForReplicationToFinish) {
            this.waitForReplicationToFinish = waitForReplicationToFinish;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getWriteCapacity}
         * @param writeCapacity The write capacity for the table.
         *                      Careful if you add Global Secondary Indexes, as
         *                      those will share the table's provisioned throughput.
         *                      <p>
         *                      Can only be provided if billingMode is Provisioned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeCapacity(java.lang.Number writeCapacity) {
            this.writeCapacity = writeCapacity;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getPartitionKey}
         * @param partitionKey Partition key attribute definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKey(software.amazon.awscdk.services.dynamodb.Attribute partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getSortKey}
         * @param sortKey Sort key attribute definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sortKey(software.amazon.awscdk.services.dynamodb.Attribute sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TableProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableProps {
        private final software.amazon.awscdk.services.kinesis.IStream kinesisStream;
        private final java.lang.String tableName;
        private final software.amazon.awscdk.services.dynamodb.BillingMode billingMode;
        private final java.lang.Boolean contributorInsightsEnabled;
        private final software.amazon.awscdk.services.dynamodb.TableEncryption encryption;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.Boolean pointInTimeRecovery;
        private final java.lang.Number readCapacity;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final java.util.List<java.lang.String> replicationRegions;
        private final software.amazon.awscdk.core.Duration replicationTimeout;
        private final java.lang.Boolean serverSideEncryption;
        private final software.amazon.awscdk.services.dynamodb.StreamViewType stream;
        private final software.amazon.awscdk.services.dynamodb.TableClass tableClass;
        private final java.lang.String timeToLiveAttribute;
        private final java.lang.Boolean waitForReplicationToFinish;
        private final java.lang.Number writeCapacity;
        private final software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        private final software.amazon.awscdk.services.dynamodb.Attribute sortKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.kinesisStream = software.amazon.jsii.Kernel.get(this, "kinesisStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.IStream.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.billingMode = software.amazon.jsii.Kernel.get(this, "billingMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.BillingMode.class));
            this.contributorInsightsEnabled = software.amazon.jsii.Kernel.get(this, "contributorInsightsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.TableEncryption.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.pointInTimeRecovery = software.amazon.jsii.Kernel.get(this, "pointInTimeRecovery", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.readCapacity = software.amazon.jsii.Kernel.get(this, "readCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
            this.replicationRegions = software.amazon.jsii.Kernel.get(this, "replicationRegions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.replicationTimeout = software.amazon.jsii.Kernel.get(this, "replicationTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.serverSideEncryption = software.amazon.jsii.Kernel.get(this, "serverSideEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.stream = software.amazon.jsii.Kernel.get(this, "stream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.StreamViewType.class));
            this.tableClass = software.amazon.jsii.Kernel.get(this, "tableClass", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.TableClass.class));
            this.timeToLiveAttribute = software.amazon.jsii.Kernel.get(this, "timeToLiveAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.waitForReplicationToFinish = software.amazon.jsii.Kernel.get(this, "waitForReplicationToFinish", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.writeCapacity = software.amazon.jsii.Kernel.get(this, "writeCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.partitionKey = software.amazon.jsii.Kernel.get(this, "partitionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class));
            this.sortKey = software.amazon.jsii.Kernel.get(this, "sortKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.kinesisStream = builder.kinesisStream;
            this.tableName = builder.tableName;
            this.billingMode = builder.billingMode;
            this.contributorInsightsEnabled = builder.contributorInsightsEnabled;
            this.encryption = builder.encryption;
            this.encryptionKey = builder.encryptionKey;
            this.pointInTimeRecovery = builder.pointInTimeRecovery;
            this.readCapacity = builder.readCapacity;
            this.removalPolicy = builder.removalPolicy;
            this.replicationRegions = builder.replicationRegions;
            this.replicationTimeout = builder.replicationTimeout;
            this.serverSideEncryption = builder.serverSideEncryption;
            this.stream = builder.stream;
            this.tableClass = builder.tableClass;
            this.timeToLiveAttribute = builder.timeToLiveAttribute;
            this.waitForReplicationToFinish = builder.waitForReplicationToFinish;
            this.writeCapacity = builder.writeCapacity;
            this.partitionKey = java.util.Objects.requireNonNull(builder.partitionKey, "partitionKey is required");
            this.sortKey = builder.sortKey;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.IStream getKinesisStream() {
            return this.kinesisStream;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.BillingMode getBillingMode() {
            return this.billingMode;
        }

        @Override
        public final java.lang.Boolean getContributorInsightsEnabled() {
            return this.contributorInsightsEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.TableEncryption getEncryption() {
            return this.encryption;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.Boolean getPointInTimeRecovery() {
            return this.pointInTimeRecovery;
        }

        @Override
        public final java.lang.Number getReadCapacity() {
            return this.readCapacity;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.util.List<java.lang.String> getReplicationRegions() {
            return this.replicationRegions;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getReplicationTimeout() {
            return this.replicationTimeout;
        }

        @Override
        public final java.lang.Boolean getServerSideEncryption() {
            return this.serverSideEncryption;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.StreamViewType getStream() {
            return this.stream;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.TableClass getTableClass() {
            return this.tableClass;
        }

        @Override
        public final java.lang.String getTimeToLiveAttribute() {
            return this.timeToLiveAttribute;
        }

        @Override
        public final java.lang.Boolean getWaitForReplicationToFinish() {
            return this.waitForReplicationToFinish;
        }

        @Override
        public final java.lang.Number getWriteCapacity() {
            return this.writeCapacity;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
            return this.sortKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getKinesisStream() != null) {
                data.set("kinesisStream", om.valueToTree(this.getKinesisStream()));
            }
            if (this.getTableName() != null) {
                data.set("tableName", om.valueToTree(this.getTableName()));
            }
            if (this.getBillingMode() != null) {
                data.set("billingMode", om.valueToTree(this.getBillingMode()));
            }
            if (this.getContributorInsightsEnabled() != null) {
                data.set("contributorInsightsEnabled", om.valueToTree(this.getContributorInsightsEnabled()));
            }
            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getPointInTimeRecovery() != null) {
                data.set("pointInTimeRecovery", om.valueToTree(this.getPointInTimeRecovery()));
            }
            if (this.getReadCapacity() != null) {
                data.set("readCapacity", om.valueToTree(this.getReadCapacity()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getReplicationRegions() != null) {
                data.set("replicationRegions", om.valueToTree(this.getReplicationRegions()));
            }
            if (this.getReplicationTimeout() != null) {
                data.set("replicationTimeout", om.valueToTree(this.getReplicationTimeout()));
            }
            if (this.getServerSideEncryption() != null) {
                data.set("serverSideEncryption", om.valueToTree(this.getServerSideEncryption()));
            }
            if (this.getStream() != null) {
                data.set("stream", om.valueToTree(this.getStream()));
            }
            if (this.getTableClass() != null) {
                data.set("tableClass", om.valueToTree(this.getTableClass()));
            }
            if (this.getTimeToLiveAttribute() != null) {
                data.set("timeToLiveAttribute", om.valueToTree(this.getTimeToLiveAttribute()));
            }
            if (this.getWaitForReplicationToFinish() != null) {
                data.set("waitForReplicationToFinish", om.valueToTree(this.getWaitForReplicationToFinish()));
            }
            if (this.getWriteCapacity() != null) {
                data.set("writeCapacity", om.valueToTree(this.getWriteCapacity()));
            }
            data.set("partitionKey", om.valueToTree(this.getPartitionKey()));
            if (this.getSortKey() != null) {
                data.set("sortKey", om.valueToTree(this.getSortKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-dynamodb.TableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableProps.Jsii$Proxy that = (TableProps.Jsii$Proxy) o;

            if (this.kinesisStream != null ? !this.kinesisStream.equals(that.kinesisStream) : that.kinesisStream != null) return false;
            if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
            if (this.billingMode != null ? !this.billingMode.equals(that.billingMode) : that.billingMode != null) return false;
            if (this.contributorInsightsEnabled != null ? !this.contributorInsightsEnabled.equals(that.contributorInsightsEnabled) : that.contributorInsightsEnabled != null) return false;
            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.pointInTimeRecovery != null ? !this.pointInTimeRecovery.equals(that.pointInTimeRecovery) : that.pointInTimeRecovery != null) return false;
            if (this.readCapacity != null ? !this.readCapacity.equals(that.readCapacity) : that.readCapacity != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.replicationRegions != null ? !this.replicationRegions.equals(that.replicationRegions) : that.replicationRegions != null) return false;
            if (this.replicationTimeout != null ? !this.replicationTimeout.equals(that.replicationTimeout) : that.replicationTimeout != null) return false;
            if (this.serverSideEncryption != null ? !this.serverSideEncryption.equals(that.serverSideEncryption) : that.serverSideEncryption != null) return false;
            if (this.stream != null ? !this.stream.equals(that.stream) : that.stream != null) return false;
            if (this.tableClass != null ? !this.tableClass.equals(that.tableClass) : that.tableClass != null) return false;
            if (this.timeToLiveAttribute != null ? !this.timeToLiveAttribute.equals(that.timeToLiveAttribute) : that.timeToLiveAttribute != null) return false;
            if (this.waitForReplicationToFinish != null ? !this.waitForReplicationToFinish.equals(that.waitForReplicationToFinish) : that.waitForReplicationToFinish != null) return false;
            if (this.writeCapacity != null ? !this.writeCapacity.equals(that.writeCapacity) : that.writeCapacity != null) return false;
            if (!partitionKey.equals(that.partitionKey)) return false;
            return this.sortKey != null ? this.sortKey.equals(that.sortKey) : that.sortKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.kinesisStream != null ? this.kinesisStream.hashCode() : 0;
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = 31 * result + (this.billingMode != null ? this.billingMode.hashCode() : 0);
            result = 31 * result + (this.contributorInsightsEnabled != null ? this.contributorInsightsEnabled.hashCode() : 0);
            result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.pointInTimeRecovery != null ? this.pointInTimeRecovery.hashCode() : 0);
            result = 31 * result + (this.readCapacity != null ? this.readCapacity.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.replicationRegions != null ? this.replicationRegions.hashCode() : 0);
            result = 31 * result + (this.replicationTimeout != null ? this.replicationTimeout.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryption != null ? this.serverSideEncryption.hashCode() : 0);
            result = 31 * result + (this.stream != null ? this.stream.hashCode() : 0);
            result = 31 * result + (this.tableClass != null ? this.tableClass.hashCode() : 0);
            result = 31 * result + (this.timeToLiveAttribute != null ? this.timeToLiveAttribute.hashCode() : 0);
            result = 31 * result + (this.waitForReplicationToFinish != null ? this.waitForReplicationToFinish.hashCode() : 0);
            result = 31 * result + (this.writeCapacity != null ? this.writeCapacity.hashCode() : 0);
            result = 31 * result + (this.partitionKey.hashCode());
            result = 31 * result + (this.sortKey != null ? this.sortKey.hashCode() : 0);
            return result;
        }
    }
}
