package software.amazon.awscdk.services.dynamodb;

/**
 * DynamoDB's Read/Write capacity modes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Table table = Table.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .billingMode(BillingMode.PAY_PER_REQUEST)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-10-06T13:25:04.530Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.BillingMode")
public enum BillingMode {
    /**
     * Pay only for what you use.
     * <p>
     * You don't configure Read/Write capacity units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PAY_PER_REQUEST,
    /**
     * Explicitly specified Read/Write capacity units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PROVISIONED,
}
