package software.amazon.awscdk.services.dynamodb;

/**
 * Properties for a local secondary index.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dynamodb.*;
 * LocalSecondaryIndexProps localSecondaryIndexProps = LocalSecondaryIndexProps.builder()
 *         .indexName("indexName")
 *         .sortKey(Attribute.builder()
 *                 .name("name")
 *                 .type(AttributeType.BINARY)
 *                 .build())
 *         // the properties below are optional
 *         .nonKeyAttributes(List.of("nonKeyAttributes"))
 *         .projectionType(ProjectionType.KEYS_ONLY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-10-13T20:01:05.505Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.LocalSecondaryIndexProps")
@software.amazon.jsii.Jsii.Proxy(LocalSecondaryIndexProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LocalSecondaryIndexProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.dynamodb.SecondaryIndexProps {

    /**
     * The attribute of a sort key for the local secondary index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.Attribute getSortKey();

    /**
     * @return a {@link Builder} of {@link LocalSecondaryIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LocalSecondaryIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LocalSecondaryIndexProps> {
        software.amazon.awscdk.services.dynamodb.Attribute sortKey;
        java.lang.String indexName;
        java.util.List<java.lang.String> nonKeyAttributes;
        software.amazon.awscdk.services.dynamodb.ProjectionType projectionType;

        /**
         * Sets the value of {@link LocalSecondaryIndexProps#getSortKey}
         * @param sortKey The attribute of a sort key for the local secondary index. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sortKey(software.amazon.awscdk.services.dynamodb.Attribute sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        /**
         * Sets the value of {@link LocalSecondaryIndexProps#getIndexName}
         * @param indexName The name of the secondary index. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexName(java.lang.String indexName) {
            this.indexName = indexName;
            return this;
        }

        /**
         * Sets the value of {@link LocalSecondaryIndexProps#getNonKeyAttributes}
         * @param nonKeyAttributes The non-key attributes that are projected into the secondary index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nonKeyAttributes(java.util.List<java.lang.String> nonKeyAttributes) {
            this.nonKeyAttributes = nonKeyAttributes;
            return this;
        }

        /**
         * Sets the value of {@link LocalSecondaryIndexProps#getProjectionType}
         * @param projectionType The set of attributes that are projected into the secondary index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectionType(software.amazon.awscdk.services.dynamodb.ProjectionType projectionType) {
            this.projectionType = projectionType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LocalSecondaryIndexProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LocalSecondaryIndexProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LocalSecondaryIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocalSecondaryIndexProps {
        private final software.amazon.awscdk.services.dynamodb.Attribute sortKey;
        private final java.lang.String indexName;
        private final java.util.List<java.lang.String> nonKeyAttributes;
        private final software.amazon.awscdk.services.dynamodb.ProjectionType projectionType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sortKey = software.amazon.jsii.Kernel.get(this, "sortKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class));
            this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nonKeyAttributes = software.amazon.jsii.Kernel.get(this, "nonKeyAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.projectionType = software.amazon.jsii.Kernel.get(this, "projectionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ProjectionType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sortKey = java.util.Objects.requireNonNull(builder.sortKey, "sortKey is required");
            this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
            this.nonKeyAttributes = builder.nonKeyAttributes;
            this.projectionType = builder.projectionType;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
            return this.sortKey;
        }

        @Override
        public final java.lang.String getIndexName() {
            return this.indexName;
        }

        @Override
        public final java.util.List<java.lang.String> getNonKeyAttributes() {
            return this.nonKeyAttributes;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.ProjectionType getProjectionType() {
            return this.projectionType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sortKey", om.valueToTree(this.getSortKey()));
            data.set("indexName", om.valueToTree(this.getIndexName()));
            if (this.getNonKeyAttributes() != null) {
                data.set("nonKeyAttributes", om.valueToTree(this.getNonKeyAttributes()));
            }
            if (this.getProjectionType() != null) {
                data.set("projectionType", om.valueToTree(this.getProjectionType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-dynamodb.LocalSecondaryIndexProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LocalSecondaryIndexProps.Jsii$Proxy that = (LocalSecondaryIndexProps.Jsii$Proxy) o;

            if (!sortKey.equals(that.sortKey)) return false;
            if (!indexName.equals(that.indexName)) return false;
            if (this.nonKeyAttributes != null ? !this.nonKeyAttributes.equals(that.nonKeyAttributes) : that.nonKeyAttributes != null) return false;
            return this.projectionType != null ? this.projectionType.equals(that.projectionType) : that.projectionType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.sortKey.hashCode();
            result = 31 * result + (this.indexName.hashCode());
            result = 31 * result + (this.nonKeyAttributes != null ? this.nonKeyAttributes.hashCode() : 0);
            result = 31 * result + (this.projectionType != null ? this.projectionType.hashCode() : 0);
            return result;
        }
    }
}
