package software.amazon.awscdk.services.dynamodb;

/**
 * When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
 * <p>
 * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_StreamSpecification.html">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_StreamSpecification.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-23T19:56:58.897Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.StreamViewType")
public enum StreamViewType {
    /**
     * The entire item, as it appears after it was modified, is written to the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NEW_IMAGE,
    /**
     * The entire item, as it appeared before it was modified, is written to the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OLD_IMAGE,
    /**
     * Both the new and the old item images of the item are written to the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NEW_AND_OLD_IMAGES,
    /**
     * Only the key attributes of the modified item are written to the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KEYS_ONLY,
}
