/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.dynamodb.;
import software.amazon.awscdk.services.dynamodb.Attribute;
import software.amazon.awscdk.services.dynamodb.BillingMode;
import software.amazon.awscdk.services.dynamodb.EnableScalingProps;
import software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexProps;
import software.amazon.awscdk.services.dynamodb.IScalableTableAttribute;
import software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps;
import software.amazon.awscdk.services.dynamodb.StreamViewType;
import software.amazon.awscdk.services.dynamodb.TableProps;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-dynamodb.Table")
public class Table
extends Resource {
    protected Table(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Table(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Table(Construct scope, String id, TableProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Deprecated
    public static Grant grantListStreams(IGrantable grantee) {
        return (Grant)JsiiObject.jsiiStaticCall(Table.class, (String)"grantListStreams", Grant.class, (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    public void addGlobalSecondaryIndex(GlobalSecondaryIndexProps props) {
        this.jsiiCall("addGlobalSecondaryIndex", Void.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public void addLocalSecondaryIndex(LocalSecondaryIndexProps props) {
        this.jsiiCall("addLocalSecondaryIndex", Void.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public IScalableTableAttribute autoScaleGlobalSecondaryIndexReadCapacity(String indexName, EnableScalingProps props) {
        return (IScalableTableAttribute)this.jsiiCall("autoScaleGlobalSecondaryIndexReadCapacity", IScalableTableAttribute.class, new Object[]{Objects.requireNonNull(indexName, "indexName is required"), Objects.requireNonNull(props, "props is required")});
    }

    public IScalableTableAttribute autoScaleGlobalSecondaryIndexWriteCapacity(String indexName, EnableScalingProps props) {
        return (IScalableTableAttribute)this.jsiiCall("autoScaleGlobalSecondaryIndexWriteCapacity", IScalableTableAttribute.class, new Object[]{Objects.requireNonNull(indexName, "indexName is required"), Objects.requireNonNull(props, "props is required")});
    }

    public IScalableTableAttribute autoScaleReadCapacity(EnableScalingProps props) {
        return (IScalableTableAttribute)this.jsiiCall("autoScaleReadCapacity", IScalableTableAttribute.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public IScalableTableAttribute autoScaleWriteCapacity(EnableScalingProps props) {
        return (IScalableTableAttribute)this.jsiiCall("autoScaleWriteCapacity", IScalableTableAttribute.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public Grant grant(IGrantable grantee, String ... actions) {
        return (Grant)this.jsiiCall("grant", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    public Grant grantFullAccess(IGrantable grantee) {
        return (Grant)this.jsiiCall("grantFullAccess", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    public Grant grantReadData(IGrantable grantee) {
        return (Grant)this.jsiiCall("grantReadData", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    public Grant grantReadWriteData(IGrantable grantee) {
        return (Grant)this.jsiiCall("grantReadWriteData", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    public Grant grantStream(IGrantable grantee, String ... actions) {
        return (Grant)this.jsiiCall("grantStream", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    public Grant grantStreamRead(IGrantable grantee) {
        return (Grant)this.jsiiCall("grantStreamRead", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    public Grant grantTableListStreams(IGrantable grantee) {
        return (Grant)this.jsiiCall("grantTableListStreams", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    public Grant grantWriteData(IGrantable grantee) {
        return (Grant)this.jsiiCall("grantWriteData", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    protected List<String> validate() {
        return Collections.unmodifiableList((List)this.jsiiCall("validate", List.class, new Object[0]));
    }

    public String getTableArn() {
        return (String)this.jsiiGet("tableArn", String.class);
    }

    public String getTableName() {
        return (String)this.jsiiGet("tableName", String.class);
    }

    public String getTableStreamArn() {
        return (String)this.jsiiGet("tableStreamArn", String.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final TableProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new TableProps.Builder();
        }

        public Builder partitionKey(Attribute partitionKey) {
            this.props.partitionKey(partitionKey);
            return this;
        }

        public Builder billingMode(BillingMode billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }

        public Builder pointInTimeRecovery(Boolean pointInTimeRecovery) {
            this.props.pointInTimeRecovery(pointInTimeRecovery);
            return this;
        }

        public Builder readCapacity(Number readCapacity) {
            this.props.readCapacity(readCapacity);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder serverSideEncryption(Boolean serverSideEncryption) {
            this.props.serverSideEncryption(serverSideEncryption);
            return this;
        }

        public Builder sortKey(Attribute sortKey) {
            this.props.sortKey(sortKey);
            return this;
        }

        public Builder stream(StreamViewType stream) {
            this.props.stream(stream);
            return this;
        }

        public Builder timeToLiveAttribute(String timeToLiveAttribute) {
            this.props.timeToLiveAttribute(timeToLiveAttribute);
            return this;
        }

        public Builder writeCapacity(Number writeCapacity) {
            this.props.writeCapacity(writeCapacity);
            return this;
        }

        public Builder tableName(String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        public Table build() {
            return new Table(this.scope, this.id, this.props.build());
        }
    }
}

