package software.amazon.awscdk.services.dynamodb;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-25T16:38:24.898Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TableOptions extends software.amazon.jsii.JsiiSerializable {
    /**
     * Partition key attribute definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey();
    /**
     * Specify how you are charged for read and write throughput and how you manage capacity.
     * 
     * Default: Provisioned
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.dynamodb.BillingMode getBillingMode();
    /**
     * Whether point-in-time recovery is enabled.
     * 
     * Default: - point-in-time recovery is disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getPointInTimeRecovery();
    /**
     * The read capacity for the table.
     * 
     * Careful if you add Global Secondary Indexes, as
     * those will share the table's provisioned throughput.
     * 
     * Can only be provided if billingMode is Provisioned.
     * 
     * Default: 5
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getReadCapacity();
    /**
     * The removal policy to apply to the DynamoDB Table.
     * 
     * Default: RemovalPolicy.RETAIN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy();
    /**
     * Whether server-side encryption with an AWS managed customer master key is enabled.
     * 
     * Default: - server-side encryption is enabled with an AWS owned customer master key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getServerSideEncryption();
    /**
     * Table sort key attribute definition.
     * 
     * Default: no sort key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.dynamodb.Attribute getSortKey();
    /**
     * When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
     * 
     * Default: undefined, streams are disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.dynamodb.StreamViewType getStream();
    /**
     * The name of TTL attribute.
     * 
     * Default: - TTL is disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getTimeToLiveAttribute();
    /**
     * The write capacity for the table.
     * 
     * Careful if you add Global Secondary Indexes, as
     * those will share the table's provisioned throughput.
     * 
     * Can only be provided if billingMode is Provisioned.
     * 
     * Default: 5
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getWriteCapacity();

    /**
     * @return a {@link Builder} of {@link TableOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link TableOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.dynamodb.Attribute _partitionKey;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.dynamodb.BillingMode _billingMode;
        @javax.annotation.Nullable
        private java.lang.Boolean _pointInTimeRecovery;
        @javax.annotation.Nullable
        private java.lang.Number _readCapacity;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.RemovalPolicy _removalPolicy;
        @javax.annotation.Nullable
        private java.lang.Boolean _serverSideEncryption;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.dynamodb.Attribute _sortKey;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.dynamodb.StreamViewType _stream;
        @javax.annotation.Nullable
        private java.lang.String _timeToLiveAttribute;
        @javax.annotation.Nullable
        private java.lang.Number _writeCapacity;

        /**
         * Sets the value of PartitionKey
         * @param value Partition key attribute definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPartitionKey(final software.amazon.awscdk.services.dynamodb.Attribute value) {
            this._partitionKey = java.util.Objects.requireNonNull(value, "partitionKey is required");
            return this;
        }
        /**
         * Sets the value of BillingMode
         * @param value Specify how you are charged for read and write throughput and how you manage capacity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withBillingMode(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.BillingMode value) {
            this._billingMode = value;
            return this;
        }
        /**
         * Sets the value of PointInTimeRecovery
         * @param value Whether point-in-time recovery is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPointInTimeRecovery(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._pointInTimeRecovery = value;
            return this;
        }
        /**
         * Sets the value of ReadCapacity
         * @param value The read capacity for the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withReadCapacity(@javax.annotation.Nullable final java.lang.Number value) {
            this._readCapacity = value;
            return this;
        }
        /**
         * Sets the value of RemovalPolicy
         * @param value The removal policy to apply to the DynamoDB Table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRemovalPolicy(@javax.annotation.Nullable final software.amazon.awscdk.core.RemovalPolicy value) {
            this._removalPolicy = value;
            return this;
        }
        /**
         * Sets the value of ServerSideEncryption
         * @param value Whether server-side encryption with an AWS managed customer master key is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withServerSideEncryption(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._serverSideEncryption = value;
            return this;
        }
        /**
         * Sets the value of SortKey
         * @param value Table sort key attribute definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSortKey(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.Attribute value) {
            this._sortKey = value;
            return this;
        }
        /**
         * Sets the value of Stream
         * @param value When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withStream(@javax.annotation.Nullable final software.amazon.awscdk.services.dynamodb.StreamViewType value) {
            this._stream = value;
            return this;
        }
        /**
         * Sets the value of TimeToLiveAttribute
         * @param value The name of TTL attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTimeToLiveAttribute(@javax.annotation.Nullable final java.lang.String value) {
            this._timeToLiveAttribute = value;
            return this;
        }
        /**
         * Sets the value of WriteCapacity
         * @param value The write capacity for the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withWriteCapacity(@javax.annotation.Nullable final java.lang.Number value) {
            this._writeCapacity = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public TableOptions build() {
            return new TableOptions() {
                private final software.amazon.awscdk.services.dynamodb.Attribute $partitionKey = java.util.Objects.requireNonNull(_partitionKey, "partitionKey is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.dynamodb.BillingMode $billingMode = _billingMode;
                @javax.annotation.Nullable
                private final java.lang.Boolean $pointInTimeRecovery = _pointInTimeRecovery;
                @javax.annotation.Nullable
                private final java.lang.Number $readCapacity = _readCapacity;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.RemovalPolicy $removalPolicy = _removalPolicy;
                @javax.annotation.Nullable
                private final java.lang.Boolean $serverSideEncryption = _serverSideEncryption;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.dynamodb.Attribute $sortKey = _sortKey;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.dynamodb.StreamViewType $stream = _stream;
                @javax.annotation.Nullable
                private final java.lang.String $timeToLiveAttribute = _timeToLiveAttribute;
                @javax.annotation.Nullable
                private final java.lang.Number $writeCapacity = _writeCapacity;

                @Override
                public software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey() {
                    return this.$partitionKey;
                }

                @Override
                public software.amazon.awscdk.services.dynamodb.BillingMode getBillingMode() {
                    return this.$billingMode;
                }

                @Override
                public java.lang.Boolean getPointInTimeRecovery() {
                    return this.$pointInTimeRecovery;
                }

                @Override
                public java.lang.Number getReadCapacity() {
                    return this.$readCapacity;
                }

                @Override
                public software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
                    return this.$removalPolicy;
                }

                @Override
                public java.lang.Boolean getServerSideEncryption() {
                    return this.$serverSideEncryption;
                }

                @Override
                public software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
                    return this.$sortKey;
                }

                @Override
                public software.amazon.awscdk.services.dynamodb.StreamViewType getStream() {
                    return this.$stream;
                }

                @Override
                public java.lang.String getTimeToLiveAttribute() {
                    return this.$timeToLiveAttribute;
                }

                @Override
                public java.lang.Number getWriteCapacity() {
                    return this.$writeCapacity;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("partitionKey", om.valueToTree(this.getPartitionKey()));
                    if (this.getBillingMode() != null) {
                        obj.set("billingMode", om.valueToTree(this.getBillingMode()));
                    }
                    if (this.getPointInTimeRecovery() != null) {
                        obj.set("pointInTimeRecovery", om.valueToTree(this.getPointInTimeRecovery()));
                    }
                    if (this.getReadCapacity() != null) {
                        obj.set("readCapacity", om.valueToTree(this.getReadCapacity()));
                    }
                    if (this.getRemovalPolicy() != null) {
                        obj.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
                    }
                    if (this.getServerSideEncryption() != null) {
                        obj.set("serverSideEncryption", om.valueToTree(this.getServerSideEncryption()));
                    }
                    if (this.getSortKey() != null) {
                        obj.set("sortKey", om.valueToTree(this.getSortKey()));
                    }
                    if (this.getStream() != null) {
                        obj.set("stream", om.valueToTree(this.getStream()));
                    }
                    if (this.getTimeToLiveAttribute() != null) {
                        obj.set("timeToLiveAttribute", om.valueToTree(this.getTimeToLiveAttribute()));
                    }
                    if (this.getWriteCapacity() != null) {
                        obj.set("writeCapacity", om.valueToTree(this.getWriteCapacity()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.TableOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Partition key attribute definition.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey() {
            return this.jsiiGet("partitionKey", software.amazon.awscdk.services.dynamodb.Attribute.class);
        }

        /**
         * Specify how you are charged for read and write throughput and how you manage capacity.
         * 
         * Default: Provisioned
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.dynamodb.BillingMode getBillingMode() {
            return this.jsiiGet("billingMode", software.amazon.awscdk.services.dynamodb.BillingMode.class);
        }

        /**
         * Whether point-in-time recovery is enabled.
         * 
         * Default: - point-in-time recovery is disabled
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getPointInTimeRecovery() {
            return this.jsiiGet("pointInTimeRecovery", java.lang.Boolean.class);
        }

        /**
         * The read capacity for the table.
         * 
         * Careful if you add Global Secondary Indexes, as
         * those will share the table's provisioned throughput.
         * 
         * Can only be provided if billingMode is Provisioned.
         * 
         * Default: 5
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getReadCapacity() {
            return this.jsiiGet("readCapacity", java.lang.Number.class);
        }

        /**
         * The removal policy to apply to the DynamoDB Table.
         * 
         * Default: RemovalPolicy.RETAIN
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.jsiiGet("removalPolicy", software.amazon.awscdk.core.RemovalPolicy.class);
        }

        /**
         * Whether server-side encryption with an AWS managed customer master key is enabled.
         * 
         * Default: - server-side encryption is enabled with an AWS owned customer master key
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getServerSideEncryption() {
            return this.jsiiGet("serverSideEncryption", java.lang.Boolean.class);
        }

        /**
         * Table sort key attribute definition.
         * 
         * Default: no sort key
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
            return this.jsiiGet("sortKey", software.amazon.awscdk.services.dynamodb.Attribute.class);
        }

        /**
         * When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
         * 
         * Default: undefined, streams are disabled
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.dynamodb.StreamViewType getStream() {
            return this.jsiiGet("stream", software.amazon.awscdk.services.dynamodb.StreamViewType.class);
        }

        /**
         * The name of TTL attribute.
         * 
         * Default: - TTL is disabled
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getTimeToLiveAttribute() {
            return this.jsiiGet("timeToLiveAttribute", java.lang.String.class);
        }

        /**
         * The write capacity for the table.
         * 
         * Careful if you add Global Secondary Indexes, as
         * those will share the table's provisioned throughput.
         * 
         * Can only be provided if billingMode is Provisioned.
         * 
         * Default: 5
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getWriteCapacity() {
            return this.jsiiGet("writeCapacity", java.lang.Number.class);
        }
    }
}
