/**
 * <h1>Amazon DynamoDB Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="End-of-Support" src="https://img.shields.io/badge/End--of--Support-critical.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * AWS CDK v1 has reached End-of-Support on 2023-06-01.
 * This package is no longer being updated, and users should migrate to AWS CDK v2.
 * <p>
 * For more information on how to migrate, see the <a href="https://docs.aws.amazon.com/cdk/v2/guide/migrating-v2.html"><em>Migrating to AWS CDK v2</em> guide</a>.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Here is a minimal deployable DynamoDB table definition:
 * <p>
 * <blockquote><pre>
 * Table table = Table.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Importing existing tables</h2>
 * <p>
 * To import an existing table into your CDK application, use the <code>Table.fromTableName</code>, <code>Table.fromTableArn</code> or <code>Table.fromTableAttributes</code>
 * factory method. This method accepts table name or table ARN which describes the properties of an already
 * existing table:
 * <p>
 * <blockquote><pre>
 * User user;
 * 
 * ITable table = Table.fromTableArn(this, "ImportedTable", "arn:aws:dynamodb:us-east-1:111111111:table/my-table");
 * // now you can just call methods on the table
 * table.grantReadWriteData(user);
 * </pre></blockquote>
 * <p>
 * If you intend to use the <code>tableStreamArn</code> (including indirectly, for example by creating an
 * <code>&#64;aws-cdk/aws-lambda-event-source.DynamoEventSource</code> on the imported table), you <em>must</em> use the
 * <code>Table.fromTableAttributes</code> method and the <code>tableStreamArn</code> property <em>must</em> be populated.
 * <p>
 * <h2>Keys</h2>
 * <p>
 * When a table is defined, you must define it's schema using the <code>partitionKey</code>
 * (required) and <code>sortKey</code> (optional) properties.
 * <p>
 * <h2>Billing Mode</h2>
 * <p>
 * DynamoDB supports two billing modes:
 * <p>
 * <ul>
 * <li>PROVISIONED - the default mode where the table and global secondary indexes have configured read and write capacity.</li>
 * <li>PAY_PER_REQUEST - on-demand pricing and scaling. You only pay for what you use and there is no read and write capacity for the table or its global secondary indexes.</li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * Table table = Table.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .billingMode(BillingMode.PAY_PER_REQUEST)
 *         .build();
 * </pre></blockquote>
 * <p>
 * Further reading:
 * https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.
 * <p>
 * <h2>Table Class</h2>
 * <p>
 * DynamoDB supports two table classes:
 * <p>
 * <ul>
 * <li>STANDARD - the default mode, and is recommended for the vast majority of workloads.</li>
 * <li>STANDARD_INFREQUENT_ACCESS - optimized for tables where storage is the dominant cost.</li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * Table table = Table.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .tableClass(TableClass.STANDARD_INFREQUENT_ACCESS)
 *         .build();
 * </pre></blockquote>
 * <p>
 * Further reading:
 * https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.TableClasses.html
 * <p>
 * <h2>Configure AutoScaling for your table</h2>
 * <p>
 * You can have DynamoDB automatically raise and lower the read and write capacities
 * of your table by setting up autoscaling. You can use this to either keep your
 * tables at a desired utilization level, or by scaling up and down at pre-configured
 * times of the day:
 * <p>
 * Auto-scaling is only relevant for tables with the billing mode, PROVISIONED.
 * <p>
 * <blockquote><pre>
 * IScalableTableAttribute readScaling = table.autoScaleReadCapacity(EnableScalingProps.builder().minCapacity(1).maxCapacity(50).build());
 * 
 * readScaling.scaleOnUtilization(UtilizationScalingProps.builder()
 *         .targetUtilizationPercent(50)
 *         .build());
 * 
 * readScaling.scaleOnSchedule("ScaleUpInTheMorning", ScalingSchedule.builder()
 *         .schedule(Schedule.cron(CronOptions.builder().hour("8").minute("0").build()))
 *         .minCapacity(20)
 *         .build());
 * 
 * readScaling.scaleOnSchedule("ScaleDownAtNight", ScalingSchedule.builder()
 *         .schedule(Schedule.cron(CronOptions.builder().hour("20").minute("0").build()))
 *         .maxCapacity(20)
 *         .build());
 * </pre></blockquote>
 * <p>
 * Further reading:
 * https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/AutoScaling.html
 * https://aws.amazon.com/blogs/database/how-to-use-aws-cloudformation-to-configure-auto-scaling-for-amazon-dynamodb-tables-and-indexes/
 * <p>
 * <h2>Amazon DynamoDB Global Tables</h2>
 * <p>
 * You can create DynamoDB Global Tables by setting the <code>replicationRegions</code> property on a <code>Table</code>:
 * <p>
 * <blockquote><pre>
 * Table globalTable = Table.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .replicationRegions(List.of("us-east-1", "us-east-2", "us-west-2"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * When doing so, a CloudFormation Custom Resource will be added to the stack in order to create the replica tables in the
 * selected regions.
 * <p>
 * The default billing mode for Global Tables is <code>PAY_PER_REQUEST</code>.
 * If you want to use <code>PROVISIONED</code>,
 * you have to make sure write auto-scaling is enabled for that Table:
 * <p>
 * <blockquote><pre>
 * Table globalTable = Table.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .replicationRegions(List.of("us-east-1", "us-east-2", "us-west-2"))
 *         .billingMode(BillingMode.PROVISIONED)
 *         .build();
 * 
 * globalTable.autoScaleWriteCapacity(EnableScalingProps.builder()
 *         .minCapacity(1)
 *         .maxCapacity(10)
 *         .build()).scaleOnUtilization(UtilizationScalingProps.builder().targetUtilizationPercent(75).build());
 * </pre></blockquote>
 * <p>
 * When adding a replica region for a large table, you might want to increase the
 * timeout for the replication operation:
 * <p>
 * <blockquote><pre>
 * Table globalTable = Table.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .replicationRegions(List.of("us-east-1", "us-east-2", "us-west-2"))
 *         .replicationTimeout(Duration.hours(2))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Encryption</h2>
 * <p>
 * All user data stored in Amazon DynamoDB is fully encrypted at rest. When creating a new table, you can choose to encrypt using the following customer master keys (CMK) to encrypt your table:
 * <p>
 * <ul>
 * <li>AWS owned CMK - By default, all tables are encrypted under an AWS owned customer master key (CMK) in the DynamoDB service account (no additional charges apply).</li>
 * <li>AWS managed CMK - AWS KMS keys (one per region) are created in your account, managed, and used on your behalf by AWS DynamoDB (AWS KMS charges apply).</li>
 * <li>Customer managed CMK - You have full control over the KMS key used to encrypt the DynamoDB Table (AWS KMS charges apply).</li>
 * </ul>
 * <p>
 * Creating a Table encrypted with a customer managed CMK:
 * <p>
 * <blockquote><pre>
 * Table table = Table.Builder.create(this, "MyTable")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .encryption(TableEncryption.CUSTOMER_MANAGED)
 *         .build();
 * 
 * // You can access the CMK that was added to the stack on your behalf by the Table construct via:
 * IKey tableEncryptionKey = table.getEncryptionKey();
 * </pre></blockquote>
 * <p>
 * You can also supply your own key:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kms.*;
 * 
 * 
 * Key encryptionKey = Key.Builder.create(this, "Key")
 *         .enableKeyRotation(true)
 *         .build();
 * Table table = Table.Builder.create(this, "MyTable")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .encryption(TableEncryption.CUSTOMER_MANAGED)
 *         .encryptionKey(encryptionKey)
 *         .build();
 * </pre></blockquote>
 * <p>
 * In order to use the AWS managed CMK instead, change the code to:
 * <p>
 * <blockquote><pre>
 * Table table = Table.Builder.create(this, "MyTable")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .encryption(TableEncryption.AWS_MANAGED)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Get schema of table or secondary indexes</h2>
 * <p>
 * To get the partition key and sort key of the table or indexes you have configured:
 * <p>
 * <blockquote><pre>
 * Table table;
 * 
 * SchemaOptions schema = table.schema();
 * Attribute partitionKey = schema.getPartitionKey();
 * Attribute sortKey = schema.getSortKey();
 * </pre></blockquote>
 * <p>
 * <h2>Kinesis Stream</h2>
 * <p>
 * A Kinesis Data Stream can be configured on the DynamoDB table to capture item-level changes.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesis.*;
 * 
 * 
 * Stream stream = new Stream(this, "Stream");
 * 
 * Table table = Table.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .kinesisStream(stream)
 *         .build();
 * </pre></blockquote>
 *
 * Deprecated: AWS CDK v1 has reached End-of-Support on 2023-06-01.
This package is no longer being updated, and users should migrate to AWS CDK v2.

For more information on how to migrate, see https://docs.aws.amazon.com/cdk/v2/guide/migrating-v2.html
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@Deprecated
package software.amazon.awscdk.services.dynamodb;
