package software.amazon.awscdk.services.dynamodb;

/**
 * An interface that represents a DynamoDB Table - either created with the CDK, or an existing one.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.2 (build 4370756)", date = "2020-01-23T18:16:46.440Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.ITable")
@software.amazon.jsii.Jsii.Proxy(ITable.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ITable extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource {

    /**
     * Arn of the dynamodb table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getTableArn();

    /**
     * Table name of the dynamodb table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getTableName();

    /**
     * Permits an IAM principal all data read operations from this table: BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.iam.Grant grantReadData(final software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Permits an IAM principal to all data read/write operations to this table.
     * <p>
     * BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan,
     * BatchWriteItem, PutItem, UpdateItem, DeleteItem
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.iam.Grant grantReadWriteData(final software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Permits an IAM principal all stream data read operations for this table's stream: DescribeStream, GetRecords, GetShardIterator, ListStreams.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.iam.Grant grantStreamRead(final software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Permits an IAM Principal to list streams attached to current dynamodb table.
     * <p>
     * @param grantee The principal (no-op if undefined). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.iam.Grant grantTableListStreams(final software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Permits an IAM principal all data write operations to this table: BatchWriteItem, PutItem, UpdateItem, DeleteItem.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.iam.Grant grantWriteData(final software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.ITable {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Arn of the dynamodb table.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getTableArn() {
            return this.jsiiGet("tableArn", java.lang.String.class);
        }

        /**
         * Table name of the dynamodb table.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getTableName() {
            return this.jsiiGet("tableName", java.lang.String.class);
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct node in the tree.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Permits an IAM principal all data read operations from this table: BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan.
         * <p>
         * @param grantee The principal to grant access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.Grant grantReadData(final software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantReadData", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Permits an IAM principal to all data read/write operations to this table.
         * <p>
         * BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan,
         * BatchWriteItem, PutItem, UpdateItem, DeleteItem
         * <p>
         * @param grantee The principal to grant access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.Grant grantReadWriteData(final software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantReadWriteData", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Permits an IAM principal all stream data read operations for this table's stream: DescribeStream, GetRecords, GetShardIterator, ListStreams.
         * <p>
         * @param grantee The principal to grant access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.Grant grantStreamRead(final software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantStreamRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Permits an IAM Principal to list streams attached to current dynamodb table.
         * <p>
         * @param grantee The principal (no-op if undefined). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.Grant grantTableListStreams(final software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantTableListStreams", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Permits an IAM principal all data write operations to this table: BatchWriteItem, PutItem, UpdateItem, DeleteItem.
         * <p>
         * @param grantee The principal to grant access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.Grant grantWriteData(final software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantWriteData", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }
    }
}
