package software.amazon.awscdk.services.dynamodb;

/**
 * Provides a DynamoDB table.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.2 (build 4370756)", date = "2020-01-23T18:16:46.441Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.Table")
public class Table extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.dynamodb.ITable {

    protected Table(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Table(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Table(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.dynamodb.TableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a Table construct that represents an external table via table arn.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param tableArn The table's ARN. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.dynamodb.ITable fromTableArn(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String tableArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.Table.class, "fromTableArn", software.amazon.awscdk.services.dynamodb.ITable.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(tableArn, "tableArn is required") });
    }

    /**
     * Creates a Table construct that represents an external table.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param attrs A `TableAttributes` object. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.dynamodb.ITable fromTableAttributes(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.dynamodb.TableAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.Table.class, "fromTableAttributes", software.amazon.awscdk.services.dynamodb.ITable.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Creates a Table construct that represents an external table via table name.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param tableName The table's name. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.dynamodb.ITable fromTableName(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String tableName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.Table.class, "fromTableName", software.amazon.awscdk.services.dynamodb.ITable.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(tableName, "tableName is required") });
    }

    /**
     * Permits an IAM Principal to list all DynamoDB Streams.
     * <p>
     * @deprecated Use {@link #grantTableListStreams} for more granular permission
     * @param grantee The principal (no-op if undefined). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static software.amazon.awscdk.services.iam.Grant grantListStreams(final software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.Table.class, "grantListStreams", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Add a global secondary index of table.
     * <p>
     * @param props the property of global secondary index. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addGlobalSecondaryIndex(final software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexProps props) {
        this.jsiiCall("addGlobalSecondaryIndex", Void.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a local secondary index of table.
     * <p>
     * @param props the property of local secondary index. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLocalSecondaryIndex(final software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps props) {
        this.jsiiCall("addLocalSecondaryIndex", Void.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Enable read capacity scaling for the given GSI.
     * <p>
     * @return An object to configure additional AutoScaling settings for this attribute
     * @param indexName This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.dynamodb.IScalableTableAttribute autoScaleGlobalSecondaryIndexReadCapacity(final java.lang.String indexName, final software.amazon.awscdk.services.dynamodb.EnableScalingProps props) {
        return this.jsiiCall("autoScaleGlobalSecondaryIndexReadCapacity", software.amazon.awscdk.services.dynamodb.IScalableTableAttribute.class, new Object[] { java.util.Objects.requireNonNull(indexName, "indexName is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Enable write capacity scaling for the given GSI.
     * <p>
     * @return An object to configure additional AutoScaling settings for this attribute
     * @param indexName This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.dynamodb.IScalableTableAttribute autoScaleGlobalSecondaryIndexWriteCapacity(final java.lang.String indexName, final software.amazon.awscdk.services.dynamodb.EnableScalingProps props) {
        return this.jsiiCall("autoScaleGlobalSecondaryIndexWriteCapacity", software.amazon.awscdk.services.dynamodb.IScalableTableAttribute.class, new Object[] { java.util.Objects.requireNonNull(indexName, "indexName is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Enable read capacity scaling for this table.
     * <p>
     * @return An object to configure additional AutoScaling settings
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.dynamodb.IScalableTableAttribute autoScaleReadCapacity(final software.amazon.awscdk.services.dynamodb.EnableScalingProps props) {
        return this.jsiiCall("autoScaleReadCapacity", software.amazon.awscdk.services.dynamodb.IScalableTableAttribute.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Enable write capacity scaling for this table.
     * <p>
     * @return An object to configure additional AutoScaling settings for this attribute
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.dynamodb.IScalableTableAttribute autoScaleWriteCapacity(final software.amazon.awscdk.services.dynamodb.EnableScalingProps props) {
        return this.jsiiCall("autoScaleWriteCapacity", software.amazon.awscdk.services.dynamodb.IScalableTableAttribute.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds an IAM policy statement associated with this table to an IAM principal's policy.
     * <p>
     * @param grantee The principal (no-op if undefined). This parameter is required.
     * @param actions The set of actions to allow (i.e. "dynamodb:PutItem", "dynamodb:GetItem", ...). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.Grant grant(final software.amazon.awscdk.services.iam.IGrantable grantee, final java.lang.String... actions) {
        return this.jsiiCall("grant", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Permits all DynamoDB operations ("dynamodb:*") to an IAM principal.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.Grant grantFullAccess(final software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantFullAccess", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits an IAM principal all data read operations from this table: BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantReadData(final software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantReadData", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits an IAM principal to all data read/write operations to this table.
     * <p>
     * BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan,
     * BatchWriteItem, PutItem, UpdateItem, DeleteItem
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantReadWriteData(final software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantReadWriteData", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Adds an IAM policy statement associated with this table's stream to an IAM principal's policy.
     * <p>
     * @param grantee The principal (no-op if undefined). This parameter is required.
     * @param actions The set of actions to allow (i.e. "dynamodb:DescribeStream", "dynamodb:GetRecords", ...). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.Grant grantStream(final software.amazon.awscdk.services.iam.IGrantable grantee, final java.lang.String... actions) {
        return this.jsiiCall("grantStream", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Permits an IAM principal all stream data read operations for this table's stream: DescribeStream, GetRecords, GetShardIterator, ListStreams.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantStreamRead(final software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantStreamRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits an IAM Principal to list streams attached to current dynamodb table.
     * <p>
     * @param grantee The principal (no-op if undefined). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantTableListStreams(final software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantTableListStreams", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits an IAM principal all data write operations to this table: BatchWriteItem, PutItem, UpdateItem, DeleteItem.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.iam.Grant grantWriteData(final software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantWriteData", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Validate the table construct.
     * <p>
     * @return an array of validation error message
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(this.jsiiCall("validate", java.util.List.class));
    }

    /**
     * Whether this table has indexes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.lang.Boolean getHasIndex() {
        return this.jsiiGet("hasIndex", java.lang.Boolean.class);
    }

    /**
     * Arn of the dynamodb table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getTableArn() {
        return this.jsiiGet("tableArn", java.lang.String.class);
    }

    /**
     * Table name of the dynamodb table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getTableName() {
        return this.jsiiGet("tableName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getTableStreamArn() {
        return this.jsiiGet("tableStreamArn", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dynamodb.Table}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.dynamodb.TableProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.dynamodb.TableProps.Builder();
        }

        /**
         * Partition key attribute definition.
         * <p>
         * @return {@code this}
         * @param partitionKey Partition key attribute definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKey(final software.amazon.awscdk.services.dynamodb.Attribute partitionKey) {
            this.props.partitionKey(partitionKey);
            return this;
        }

        /**
         * Specify how you are charged for read and write throughput and how you manage capacity.
         * <p>
         * Default: Provisioned
         * <p>
         * @return {@code this}
         * @param billingMode Specify how you are charged for read and write throughput and how you manage capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(final software.amazon.awscdk.services.dynamodb.BillingMode billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }

        /**
         * Whether point-in-time recovery is enabled.
         * <p>
         * Default: - point-in-time recovery is disabled
         * <p>
         * @return {@code this}
         * @param pointInTimeRecovery Whether point-in-time recovery is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecovery(final java.lang.Boolean pointInTimeRecovery) {
            this.props.pointInTimeRecovery(pointInTimeRecovery);
            return this;
        }

        /**
         * The read capacity for the table.
         * <p>
         * Careful if you add Global Secondary Indexes, as
         * those will share the table's provisioned throughput.
         * <p>
         * Can only be provided if billingMode is Provisioned.
         * <p>
         * Default: 5
         * <p>
         * @return {@code this}
         * @param readCapacity The read capacity for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readCapacity(final java.lang.Number readCapacity) {
            this.props.readCapacity(readCapacity);
            return this;
        }

        /**
         * The removal policy to apply to the DynamoDB Table.
         * <p>
         * Default: RemovalPolicy.RETAIN
         * <p>
         * @return {@code this}
         * @param removalPolicy The removal policy to apply to the DynamoDB Table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * Whether server-side encryption with an AWS managed customer master key is enabled.
         * <p>
         * Default: - server-side encryption is enabled with an AWS owned customer master key
         * <p>
         * @return {@code this}
         * @param serverSideEncryption Whether server-side encryption with an AWS managed customer master key is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryption(final java.lang.Boolean serverSideEncryption) {
            this.props.serverSideEncryption(serverSideEncryption);
            return this;
        }

        /**
         * Table sort key attribute definition.
         * <p>
         * Default: no sort key
         * <p>
         * @return {@code this}
         * @param sortKey Table sort key attribute definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sortKey(final software.amazon.awscdk.services.dynamodb.Attribute sortKey) {
            this.props.sortKey(sortKey);
            return this;
        }

        /**
         * When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
         * <p>
         * Default: - streams are disabled
         * <p>
         * @return {@code this}
         * @param stream When an item in the table is modified, StreamViewType determines what information is written to the stream for this table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stream(final software.amazon.awscdk.services.dynamodb.StreamViewType stream) {
            this.props.stream(stream);
            return this;
        }

        /**
         * The name of TTL attribute.
         * <p>
         * Default: - TTL is disabled
         * <p>
         * @return {@code this}
         * @param timeToLiveAttribute The name of TTL attribute. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveAttribute(final java.lang.String timeToLiveAttribute) {
            this.props.timeToLiveAttribute(timeToLiveAttribute);
            return this;
        }

        /**
         * The write capacity for the table.
         * <p>
         * Careful if you add Global Secondary Indexes, as
         * those will share the table's provisioned throughput.
         * <p>
         * Can only be provided if billingMode is Provisioned.
         * <p>
         * Default: 5
         * <p>
         * @return {@code this}
         * @param writeCapacity The write capacity for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeCapacity(final java.lang.Number writeCapacity) {
            this.props.writeCapacity(writeCapacity);
            return this;
        }

        /**
         * Enforces a particular physical table name.
         * <p>
         * Default: <generated>
         * <p>
         * @return {@code this}
         * @param tableName Enforces a particular physical table name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(final java.lang.String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.dynamodb.Table}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.dynamodb.Table build() {
            return new software.amazon.awscdk.services.dynamodb.Table(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
