/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.dynamodb.$Module;
import software.amazon.awscdk.services.dynamodb.Attribute;
import software.amazon.awscdk.services.dynamodb.BillingMode;
import software.amazon.awscdk.services.dynamodb.EnableScalingProps;
import software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexProps;
import software.amazon.awscdk.services.dynamodb.IScalableTableAttribute;
import software.amazon.awscdk.services.dynamodb.ITable;
import software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps;
import software.amazon.awscdk.services.dynamodb.StreamViewType;
import software.amazon.awscdk.services.dynamodb.TableAttributes;
import software.amazon.awscdk.services.dynamodb.TableProps;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-dynamodb.Table")
public class Table
extends Resource
implements ITable {
    protected Table(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Table(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Table(@NotNull Construct scope, @NotNull String id, @NotNull TableProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ITable fromTableArn(@NotNull Construct scope, @NotNull String id, @NotNull String tableArn) {
        return (ITable)JsiiObject.jsiiStaticCall(Table.class, (String)"fromTableArn", ITable.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(tableArn, "tableArn is required")});
    }

    @NotNull
    public static ITable fromTableAttributes(@NotNull Construct scope, @NotNull String id, @NotNull TableAttributes attrs) {
        return (ITable)JsiiObject.jsiiStaticCall(Table.class, (String)"fromTableAttributes", ITable.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static ITable fromTableName(@NotNull Construct scope, @NotNull String id, @NotNull String tableName) {
        return (ITable)JsiiObject.jsiiStaticCall(Table.class, (String)"fromTableName", ITable.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(tableName, "tableName is required")});
    }

    @Deprecated
    @NotNull
    public static Grant grantListStreams(@NotNull IGrantable grantee) {
        return (Grant)JsiiObject.jsiiStaticCall(Table.class, (String)"grantListStreams", Grant.class, (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    public void addGlobalSecondaryIndex(@NotNull GlobalSecondaryIndexProps props) {
        this.jsiiCall("addGlobalSecondaryIndex", NativeType.VOID, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public void addLocalSecondaryIndex(@NotNull LocalSecondaryIndexProps props) {
        this.jsiiCall("addLocalSecondaryIndex", NativeType.VOID, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IScalableTableAttribute autoScaleGlobalSecondaryIndexReadCapacity(@NotNull String indexName, @NotNull EnableScalingProps props) {
        return (IScalableTableAttribute)this.jsiiCall("autoScaleGlobalSecondaryIndexReadCapacity", IScalableTableAttribute.class, new Object[]{Objects.requireNonNull(indexName, "indexName is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IScalableTableAttribute autoScaleGlobalSecondaryIndexWriteCapacity(@NotNull String indexName, @NotNull EnableScalingProps props) {
        return (IScalableTableAttribute)this.jsiiCall("autoScaleGlobalSecondaryIndexWriteCapacity", IScalableTableAttribute.class, new Object[]{Objects.requireNonNull(indexName, "indexName is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IScalableTableAttribute autoScaleReadCapacity(@NotNull EnableScalingProps props) {
        return (IScalableTableAttribute)this.jsiiCall("autoScaleReadCapacity", IScalableTableAttribute.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public IScalableTableAttribute autoScaleWriteCapacity(@NotNull EnableScalingProps props) {
        return (IScalableTableAttribute)this.jsiiCall("autoScaleWriteCapacity", IScalableTableAttribute.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public Grant grant(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)this.jsiiCall("grant", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    @NotNull
    public Grant grantFullAccess(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantFullAccess", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantReadData(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantReadData", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantReadWriteData(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantReadWriteData", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @NotNull
    public Grant grantStream(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)this.jsiiCall("grantStream", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public Grant grantStreamRead(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantStreamRead", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantTableListStreams(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantTableListStreams", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantWriteData(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantWriteData", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metric", Metric.class, new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)this.jsiiCall("metric", Metric.class, new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Override
    @NotNull
    public Metric metricConditionalCheckFailedRequests(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricConditionalCheckFailedRequests", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricConditionalCheckFailedRequests() {
        return (Metric)this.jsiiCall("metricConditionalCheckFailedRequests", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricConsumedReadCapacityUnits(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricConsumedReadCapacityUnits", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricConsumedReadCapacityUnits() {
        return (Metric)this.jsiiCall("metricConsumedReadCapacityUnits", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricConsumedWriteCapacityUnits(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricConsumedWriteCapacityUnits", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricConsumedWriteCapacityUnits() {
        return (Metric)this.jsiiCall("metricConsumedWriteCapacityUnits", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricSuccessfulRequestLatency(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricSuccessfulRequestLatency", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricSuccessfulRequestLatency() {
        return (Metric)this.jsiiCall("metricSuccessfulRequestLatency", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricSystemErrors(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricSystemErrors", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricSystemErrors() {
        return (Metric)this.jsiiCall("metricSystemErrors", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricUserErrors(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricUserErrors", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricUserErrors() {
        return (Metric)this.jsiiCall("metricUserErrors", Metric.class, new Object[0]);
    }

    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)this.jsiiCall("validate", NativeType.listOf((NativeType)NativeType.forClass(String.class)), new Object[0]));
    }

    @NotNull
    protected Boolean getHasIndex() {
        return (Boolean)this.jsiiGet("hasIndex", Boolean.class);
    }

    @Override
    @NotNull
    public String getTableArn() {
        return (String)this.jsiiGet("tableArn", String.class);
    }

    @Override
    @NotNull
    public String getTableName() {
        return (String)this.jsiiGet("tableName", String.class);
    }

    @Nullable
    public String getTableStreamArn() {
        return (String)this.jsiiGet("tableStreamArn", String.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final TableProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new TableProps.Builder();
        }

        public Builder partitionKey(Attribute partitionKey) {
            this.props.partitionKey(partitionKey);
            return this;
        }

        public Builder billingMode(BillingMode billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }

        public Builder pointInTimeRecovery(Boolean pointInTimeRecovery) {
            this.props.pointInTimeRecovery(pointInTimeRecovery);
            return this;
        }

        public Builder readCapacity(Number readCapacity) {
            this.props.readCapacity(readCapacity);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder replicationRegions(List<String> replicationRegions) {
            this.props.replicationRegions(replicationRegions);
            return this;
        }

        public Builder serverSideEncryption(Boolean serverSideEncryption) {
            this.props.serverSideEncryption(serverSideEncryption);
            return this;
        }

        public Builder sortKey(Attribute sortKey) {
            this.props.sortKey(sortKey);
            return this;
        }

        public Builder stream(StreamViewType stream) {
            this.props.stream(stream);
            return this;
        }

        public Builder timeToLiveAttribute(String timeToLiveAttribute) {
            this.props.timeToLiveAttribute(timeToLiveAttribute);
            return this;
        }

        public Builder writeCapacity(Number writeCapacity) {
            this.props.writeCapacity(writeCapacity);
            return this;
        }

        public Builder tableName(String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        public Table build() {
            return new Table(this.scope, this.id, this.props.build());
        }
    }
}

