package software.amazon.awscdk.services.dynamodb;

/**
 * An interface that represents a DynamoDB Table - either created with the CDK, or an existing one.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-03-03T11:43:33.501Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.ITable")
@software.amazon.jsii.Jsii.Proxy(ITable.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ITable extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource {

    /**
     * Arn of the dynamodb table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getTableArn();

    /**
     * Table name of the dynamodb table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getTableName();

    /**
     * Permits an IAM principal all data read operations from this table: BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.iam.Grant grantReadData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Permits an IAM principal to all data read/write operations to this table.
     * <p>
     * BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan,
     * BatchWriteItem, PutItem, UpdateItem, DeleteItem
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.iam.Grant grantReadWriteData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Permits an IAM principal all stream data read operations for this table's stream: DescribeStream, GetRecords, GetShardIterator, ListStreams.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.iam.Grant grantStreamRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Permits an IAM Principal to list streams attached to current dynamodb table.
     * <p>
     * @param grantee The principal (no-op if undefined). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.iam.Grant grantTableListStreams(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Permits an IAM principal all data write operations to this table: BatchWriteItem, PutItem, UpdateItem, DeleteItem.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.iam.Grant grantWriteData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Metric for the number of Errors executing all Lambdas.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * Metric for the number of Errors executing all Lambdas.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName);

    /**
     * Metric for the conditional check failed requests.
     * <p>
     * @param props properties of a metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.cloudwatch.Metric metricConditionalCheckFailedRequests(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * Metric for the conditional check failed requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.cloudwatch.Metric metricConditionalCheckFailedRequests();

    /**
     * Metric for the consumed read capacity units.
     * <p>
     * @param props properties of a metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.cloudwatch.Metric metricConsumedReadCapacityUnits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * Metric for the consumed read capacity units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.cloudwatch.Metric metricConsumedReadCapacityUnits();

    /**
     * Metric for the consumed write capacity units.
     * <p>
     * @param props properties of a metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.cloudwatch.Metric metricConsumedWriteCapacityUnits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * Metric for the consumed write capacity units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.cloudwatch.Metric metricConsumedWriteCapacityUnits();

    /**
     * Metric for the successful request latency.
     * <p>
     * @param props properties of a metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.cloudwatch.Metric metricSuccessfulRequestLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * Metric for the successful request latency.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.cloudwatch.Metric metricSuccessfulRequestLatency();

    /**
     * Metric for the system errors.
     * <p>
     * @param props properties of a metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.cloudwatch.Metric metricSystemErrors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * Metric for the system errors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.cloudwatch.Metric metricSystemErrors();

    /**
     * Metric for the user errors.
     * <p>
     * @param props properties of a metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.cloudwatch.Metric metricUserErrors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * Metric for the user errors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.cloudwatch.Metric metricUserErrors();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.ITable {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Arn of the dynamodb table.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getTableArn() {
            return this.jsiiGet("tableArn", java.lang.String.class);
        }

        /**
         * Table name of the dynamodb table.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getTableName() {
            return this.jsiiGet("tableName", java.lang.String.class);
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct node in the tree.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Permits an IAM principal all data read operations from this table: BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan.
         * <p>
         * @param grantee The principal to grant access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantReadData", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Permits an IAM principal to all data read/write operations to this table.
         * <p>
         * BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan,
         * BatchWriteItem, PutItem, UpdateItem, DeleteItem
         * <p>
         * @param grantee The principal to grant access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWriteData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantReadWriteData", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Permits an IAM principal all stream data read operations for this table's stream: DescribeStream, GetRecords, GetShardIterator, ListStreams.
         * <p>
         * @param grantee The principal to grant access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantStreamRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantStreamRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Permits an IAM Principal to list streams attached to current dynamodb table.
         * <p>
         * @param grantee The principal (no-op if undefined). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantTableListStreams(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantTableListStreams", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Permits an IAM principal all data write operations to this table: BatchWriteItem, PutItem, UpdateItem, DeleteItem.
         * <p>
         * @param grantee The principal to grant access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWriteData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantWriteData", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Metric for the number of Errors executing all Lambdas.
         * <p>
         * @param metricName This parameter is required.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
        }

        /**
         * Metric for the number of Errors executing all Lambdas.
         * <p>
         * @param metricName This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
            return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
        }

        /**
         * Metric for the conditional check failed requests.
         * <p>
         * @param props properties of a metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConditionalCheckFailedRequests(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metricConditionalCheckFailedRequests", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
        }

        /**
         * Metric for the conditional check failed requests.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConditionalCheckFailedRequests() {
            return this.jsiiCall("metricConditionalCheckFailedRequests", software.amazon.awscdk.services.cloudwatch.Metric.class);
        }

        /**
         * Metric for the consumed read capacity units.
         * <p>
         * @param props properties of a metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedReadCapacityUnits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metricConsumedReadCapacityUnits", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
        }

        /**
         * Metric for the consumed read capacity units.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedReadCapacityUnits() {
            return this.jsiiCall("metricConsumedReadCapacityUnits", software.amazon.awscdk.services.cloudwatch.Metric.class);
        }

        /**
         * Metric for the consumed write capacity units.
         * <p>
         * @param props properties of a metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedWriteCapacityUnits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metricConsumedWriteCapacityUnits", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
        }

        /**
         * Metric for the consumed write capacity units.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedWriteCapacityUnits() {
            return this.jsiiCall("metricConsumedWriteCapacityUnits", software.amazon.awscdk.services.cloudwatch.Metric.class);
        }

        /**
         * Metric for the successful request latency.
         * <p>
         * @param props properties of a metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSuccessfulRequestLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metricSuccessfulRequestLatency", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
        }

        /**
         * Metric for the successful request latency.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSuccessfulRequestLatency() {
            return this.jsiiCall("metricSuccessfulRequestLatency", software.amazon.awscdk.services.cloudwatch.Metric.class);
        }

        /**
         * Metric for the system errors.
         * <p>
         * @param props properties of a metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSystemErrors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metricSystemErrors", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
        }

        /**
         * Metric for the system errors.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSystemErrors() {
            return this.jsiiCall("metricSystemErrors", software.amazon.awscdk.services.cloudwatch.Metric.class);
        }

        /**
         * Metric for the user errors.
         * <p>
         * @param props properties of a metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUserErrors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return this.jsiiCall("metricUserErrors", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
        }

        /**
         * Metric for the user errors.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUserErrors() {
            return this.jsiiCall("metricUserErrors", software.amazon.awscdk.services.cloudwatch.Metric.class);
        }
    }
}
