package software.amazon.awscdk.services.dynamodb;

/**
 * Reference to a dynamodb table.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-03-03T11:43:33.513Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.TableAttributes")
@software.amazon.jsii.Jsii.Proxy(TableAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TableAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the dynamodb table.
     * <p>
     * One of this, or {&#64;link tabeName}, is required.
     * <p>
     * Default: no table arn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getTableArn() {
        return null;
    }

    /**
     * The table name of the dynamodb table.
     * <p>
     * One of this, or {&#64;link tabeArn}, is required.
     * <p>
     * Default: no table name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getTableName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TableAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TableAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String tableArn;
        private java.lang.String tableName;

        /**
         * Sets the value of {@link TableAttributes#getTableArn}
         * @param tableArn The ARN of the dynamodb table.
         *                 One of this, or {&#64;link tabeName}, is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableArn(java.lang.String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributes#getTableName}
         * @param tableName The table name of the dynamodb table.
         *                  One of this, or {&#64;link tabeArn}, is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public TableAttributes build() {
            return new Jsii$Proxy(tableArn, tableName);
        }
    }

    /**
     * An implementation for {@link TableAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableAttributes {
        private final java.lang.String tableArn;
        private final java.lang.String tableName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.tableArn = this.jsiiGet("tableArn", java.lang.String.class);
            this.tableName = this.jsiiGet("tableName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String tableArn, final java.lang.String tableName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.tableArn = tableArn;
            this.tableName = tableName;
        }

        @Override
        public java.lang.String getTableArn() {
            return this.tableArn;
        }

        @Override
        public java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getTableArn() != null) {
                data.set("tableArn", om.valueToTree(this.getTableArn()));
            }
            if (this.getTableName() != null) {
                data.set("tableName", om.valueToTree(this.getTableName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-dynamodb.TableAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableAttributes.Jsii$Proxy that = (TableAttributes.Jsii$Proxy) o;

            if (this.tableArn != null ? !this.tableArn.equals(that.tableArn) : that.tableArn != null) return false;
            return this.tableName != null ? this.tableName.equals(that.tableName) : that.tableName == null;
        }

        @Override
        public int hashCode() {
            int result = this.tableArn != null ? this.tableArn.hashCode() : 0;
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            return result;
        }
    }
}
