/**
 * <h2>Amazon DynamoDB Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="Stability: Stable" src="https://img.shields.io/badge/stability-Stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Here is a minimal deployable DynamoDB table definition:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.dynamodb.*;
 * 
 * Table table = new Table(this, "Table", new TableProps()
 *         .partitionKey(new Attribute().name("id").type(dynamodb.AttributeType.getSTRING())));
 * </pre></blockquote>
 * <p>
 * <h3>Importing existing tables</h3>
 * <p>
 * To import an existing table into your CDK application, use the <code>Table.fromTableName</code>, <code>Table.fromTableArn</code> or <code>Table.fromTableAttributes</code>
 * factory method. This method accepts table name or table ARN which describes the properties of an already
 * existing table:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var table = Table.fromTableArn(this, "ImportedTable", "arn:aws:dynamodb:us-east-1:111111111:table/my-table");
 * // now you can just call methods on the table
 * table.grantReadWriteData(user);
 * </pre></blockquote>
 * <p>
 * If you intend to use the <code>tableStreamArn</code> (including indirectly, for example by creating an
 * <code>&#64;aws-cdk/aws-lambda-event-source.DynamoEventSource</code> on the imported table), you <em>must</em> use the
 * <code>Table.fromTableAttributes</code> method and the <code>tableStreamArn</code> property <em>must</em> be populated.
 * <p>
 * <h3>Keys</h3>
 * <p>
 * When a table is defined, you must define it's schema using the <code>partitionKey</code>
 * (required) and <code>sortKey</code> (optional) properties.
 * <p>
 * <h3>Billing Mode</h3>
 * <p>
 * DynamoDB supports two billing modes:
 * <p>
 * <ul>
 * <li>PROVISIONED - the default mode where the table and global secondary indexes have configured read and write capacity.</li>
 * <li>PAY_PER_REQUEST - on-demand pricing and scaling. You only pay for what you use and there is no read and write capacity for the table or its global secondary indexes.</li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.dynamodb.*;
 * 
 * Table table = new Table(this, "Table", new TableProps()
 *         .partitionKey(new Attribute().name("id").type(dynamodb.AttributeType.getSTRING()))
 *         .billingMode(dynamodb.BillingMode.getPAY_PER_REQUEST()));
 * </pre></blockquote>
 * <p>
 * Further reading:
 * https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.
 * <p>
 * <h3>Configure AutoScaling for your table</h3>
 * <p>
 * You can have DynamoDB automatically raise and lower the read and write capacities
 * of your table by setting up autoscaling. You can use this to either keep your
 * tables at a desired utilization level, or by scaling up and down at preconfigured
 * times of the day:
 * <p>
 * Auto-scaling is only relevant for tables with the billing mode, PROVISIONED.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * IScalableTableAttribute readScaling = table.autoScaleReadCapacity(new EnableScalingProps().minCapacity(1).maxCapacity(50));
 * 
 * readScaling.scaleOnUtilization(new UtilizationScalingProps()
 *         .targetUtilizationPercent(50));
 * 
 * readScaling.scaleOnSchedule("ScaleUpInTheMorning", new ScalingSchedule()
 *         .schedule(appscaling.Schedule.cron(new CronOptions().hour("8").minute("0")))
 *         .minCapacity(20));
 * 
 * readScaling.scaleOnSchedule("ScaleDownAtNight", new ScalingSchedule()
 *         .schedule(appscaling.Schedule.cron(new CronOptions().hour("20").minute("0")))
 *         .maxCapacity(20));
 * </pre></blockquote>
 * <p>
 * Further reading:
 * https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/AutoScaling.html
 * https://aws.amazon.com/blogs/database/how-to-use-aws-cloudformation-to-configure-auto-scaling-for-amazon-dynamodb-tables-and-indexes/
 * <p>
 * <h3>Amazon DynamoDB Global Tables</h3>
 * <p>
 * You can create DynamoDB Global Tables by setting the <code>replicationRegions</code> property on a <code>Table</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.dynamodb.*;
 * 
 * Table globalTable = new Table(this, "Table", new TableProps()
 *         .partitionKey(new Attribute().name("id").type(dynamodb.AttributeType.getSTRING()))
 *         .replicationRegions(asList("us-east-1", "us-east-2", "us-west-2")));
 * </pre></blockquote>
 * <p>
 * When doing so, a CloudFormation Custom Resource will be added to the stack in order to create the replica tables in the
 * selected regions.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.dynamodb;
