package software.amazon.awscdk.services.dynamodb;

/**
 * Reference to a dynamodb table.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-05-05T15:28:12.142Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.TableAttributes")
@software.amazon.jsii.Jsii.Proxy(TableAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TableAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the dynamodb table.
     * <p>
     * One of this, or {&#64;link tabeName}, is required.
     * <p>
     * Default: - no table arn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableArn() {
        return null;
    }

    /**
     * The table name of the dynamodb table.
     * <p>
     * One of this, or {&#64;link tabeArn}, is required.
     * <p>
     * Default: - no table name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return null;
    }

    /**
     * The ARN of the table's stream.
     * <p>
     * Default: - no table stream
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableStreamArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TableAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TableAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String tableArn;
        private java.lang.String tableName;
        private java.lang.String tableStreamArn;

        /**
         * Sets the value of {@link TableAttributes#getTableArn}
         * @param tableArn The ARN of the dynamodb table.
         *                 One of this, or {&#64;link tabeName}, is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableArn(java.lang.String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributes#getTableName}
         * @param tableName The table name of the dynamodb table.
         *                  One of this, or {&#64;link tabeArn}, is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributes#getTableStreamArn}
         * @param tableStreamArn The ARN of the table's stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableStreamArn(java.lang.String tableStreamArn) {
            this.tableStreamArn = tableStreamArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public TableAttributes build() {
            return new Jsii$Proxy(tableArn, tableName, tableStreamArn);
        }
    }

    /**
     * An implementation for {@link TableAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableAttributes {
        private final java.lang.String tableArn;
        private final java.lang.String tableName;
        private final java.lang.String tableStreamArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.tableArn = this.jsiiGet("tableArn", java.lang.String.class);
            this.tableName = this.jsiiGet("tableName", java.lang.String.class);
            this.tableStreamArn = this.jsiiGet("tableStreamArn", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String tableArn, final java.lang.String tableName, final java.lang.String tableStreamArn) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.tableArn = tableArn;
            this.tableName = tableName;
            this.tableStreamArn = tableStreamArn;
        }

        @Override
        public java.lang.String getTableArn() {
            return this.tableArn;
        }

        @Override
        public java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public java.lang.String getTableStreamArn() {
            return this.tableStreamArn;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getTableArn() != null) {
                data.set("tableArn", om.valueToTree(this.getTableArn()));
            }
            if (this.getTableName() != null) {
                data.set("tableName", om.valueToTree(this.getTableName()));
            }
            if (this.getTableStreamArn() != null) {
                data.set("tableStreamArn", om.valueToTree(this.getTableStreamArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-dynamodb.TableAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableAttributes.Jsii$Proxy that = (TableAttributes.Jsii$Proxy) o;

            if (this.tableArn != null ? !this.tableArn.equals(that.tableArn) : that.tableArn != null) return false;
            if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
            return this.tableStreamArn != null ? this.tableStreamArn.equals(that.tableStreamArn) : that.tableStreamArn == null;
        }

        @Override
        public int hashCode() {
            int result = this.tableArn != null ? this.tableArn.hashCode() : 0;
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = 31 * result + (this.tableStreamArn != null ? this.tableStreamArn.hashCode() : 0);
            return result;
        }
    }
}
