package software.amazon.awscdk.services.dynamodb;

/**
 * Properties for defining a `AWS::DynamoDB::Table`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-08T05:31:28.649Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.CfnTableProps")
@software.amazon.jsii.Jsii.Proxy(CfnTableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnTableProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::DynamoDB::Table.KeySchema`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @org.jetbrains.annotations.NotNull java.lang.Object getKeySchema();

    /**
     * `AWS::DynamoDB::Table.AttributeDefinitions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAttributeDefinitions() {
        return null;
    }

    /**
     * `AWS::DynamoDB::Table.BillingMode`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-billingmode
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.String getBillingMode() {
        return null;
    }

    /**
     * `AWS::DynamoDB::Table.GlobalSecondaryIndexes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGlobalSecondaryIndexes() {
        return null;
    }

    /**
     * `AWS::DynamoDB::Table.LocalSecondaryIndexes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLocalSecondaryIndexes() {
        return null;
    }

    /**
     * `AWS::DynamoDB::Table.PointInTimeRecoverySpecification`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPointInTimeRecoverySpecification() {
        return null;
    }

    /**
     * `AWS::DynamoDB::Table.ProvisionedThroughput`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedThroughput() {
        return null;
    }

    /**
     * `AWS::DynamoDB::Table.SSESpecification`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSseSpecification() {
        return null;
    }

    /**
     * `AWS::DynamoDB::Table.StreamSpecification`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStreamSpecification() {
        return null;
    }

    /**
     * `AWS::DynamoDB::Table.TableName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return null;
    }

    /**
     * `AWS::DynamoDB::Table.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * `AWS::DynamoDB::Table.TimeToLiveSpecification`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTimeToLiveSpecification() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.Object keySchema;
        private java.lang.Object attributeDefinitions;
        private java.lang.String billingMode;
        private java.lang.Object globalSecondaryIndexes;
        private java.lang.Object localSecondaryIndexes;
        private java.lang.Object pointInTimeRecoverySpecification;
        private java.lang.Object provisionedThroughput;
        private java.lang.Object sseSpecification;
        private java.lang.Object streamSpecification;
        private java.lang.String tableName;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private java.lang.Object timeToLiveSpecification;

        /**
         * Sets the value of {@link CfnTableProps#getKeySchema}
         * @param keySchema `AWS::DynamoDB::Table.KeySchema`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder keySchema(software.amazon.awscdk.core.IResolvable keySchema) {
            this.keySchema = keySchema;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getKeySchema}
         * @param keySchema `AWS::DynamoDB::Table.KeySchema`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder keySchema(java.util.List<java.lang.Object> keySchema) {
            this.keySchema = keySchema;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getAttributeDefinitions}
         * @param attributeDefinitions `AWS::DynamoDB::Table.AttributeDefinitions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder attributeDefinitions(software.amazon.awscdk.core.IResolvable attributeDefinitions) {
            this.attributeDefinitions = attributeDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getAttributeDefinitions}
         * @param attributeDefinitions `AWS::DynamoDB::Table.AttributeDefinitions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder attributeDefinitions(java.util.List<java.lang.Object> attributeDefinitions) {
            this.attributeDefinitions = attributeDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getBillingMode}
         * @param billingMode `AWS::DynamoDB::Table.BillingMode`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder billingMode(java.lang.String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getGlobalSecondaryIndexes}
         * @param globalSecondaryIndexes `AWS::DynamoDB::Table.GlobalSecondaryIndexes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder globalSecondaryIndexes(software.amazon.awscdk.core.IResolvable globalSecondaryIndexes) {
            this.globalSecondaryIndexes = globalSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getGlobalSecondaryIndexes}
         * @param globalSecondaryIndexes `AWS::DynamoDB::Table.GlobalSecondaryIndexes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder globalSecondaryIndexes(java.util.List<java.lang.Object> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = globalSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getLocalSecondaryIndexes}
         * @param localSecondaryIndexes `AWS::DynamoDB::Table.LocalSecondaryIndexes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder localSecondaryIndexes(software.amazon.awscdk.core.IResolvable localSecondaryIndexes) {
            this.localSecondaryIndexes = localSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getLocalSecondaryIndexes}
         * @param localSecondaryIndexes `AWS::DynamoDB::Table.LocalSecondaryIndexes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder localSecondaryIndexes(java.util.List<java.lang.Object> localSecondaryIndexes) {
            this.localSecondaryIndexes = localSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getPointInTimeRecoverySpecification}
         * @param pointInTimeRecoverySpecification `AWS::DynamoDB::Table.PointInTimeRecoverySpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder pointInTimeRecoverySpecification(software.amazon.awscdk.core.IResolvable pointInTimeRecoverySpecification) {
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getPointInTimeRecoverySpecification}
         * @param pointInTimeRecoverySpecification `AWS::DynamoDB::Table.PointInTimeRecoverySpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder pointInTimeRecoverySpecification(software.amazon.awscdk.services.dynamodb.CfnTable.PointInTimeRecoverySpecificationProperty pointInTimeRecoverySpecification) {
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getProvisionedThroughput}
         * @param provisionedThroughput `AWS::DynamoDB::Table.ProvisionedThroughput`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder provisionedThroughput(software.amazon.awscdk.core.IResolvable provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getProvisionedThroughput}
         * @param provisionedThroughput `AWS::DynamoDB::Table.ProvisionedThroughput`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder provisionedThroughput(software.amazon.awscdk.services.dynamodb.CfnTable.ProvisionedThroughputProperty provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getSseSpecification}
         * @param sseSpecification `AWS::DynamoDB::Table.SSESpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sseSpecification(software.amazon.awscdk.core.IResolvable sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getSseSpecification}
         * @param sseSpecification `AWS::DynamoDB::Table.SSESpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sseSpecification(software.amazon.awscdk.services.dynamodb.CfnTable.SSESpecificationProperty sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getStreamSpecification}
         * @param streamSpecification `AWS::DynamoDB::Table.StreamSpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder streamSpecification(software.amazon.awscdk.core.IResolvable streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getStreamSpecification}
         * @param streamSpecification `AWS::DynamoDB::Table.StreamSpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder streamSpecification(software.amazon.awscdk.services.dynamodb.CfnTable.StreamSpecificationProperty streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTableName}
         * @param tableName `AWS::DynamoDB::Table.TableName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTags}
         * @param tags `AWS::DynamoDB::Table.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTimeToLiveSpecification}
         * @param timeToLiveSpecification `AWS::DynamoDB::Table.TimeToLiveSpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder timeToLiveSpecification(software.amazon.awscdk.core.IResolvable timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTimeToLiveSpecification}
         * @param timeToLiveSpecification `AWS::DynamoDB::Table.TimeToLiveSpecification`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder timeToLiveSpecification(software.amazon.awscdk.services.dynamodb.CfnTable.TimeToLiveSpecificationProperty timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnTableProps build() {
            return new Jsii$Proxy(keySchema, attributeDefinitions, billingMode, globalSecondaryIndexes, localSecondaryIndexes, pointInTimeRecoverySpecification, provisionedThroughput, sseSpecification, streamSpecification, tableName, tags, timeToLiveSpecification);
        }
    }

    /**
     * An implementation for {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTableProps {
        private final java.lang.Object keySchema;
        private final java.lang.Object attributeDefinitions;
        private final java.lang.String billingMode;
        private final java.lang.Object globalSecondaryIndexes;
        private final java.lang.Object localSecondaryIndexes;
        private final java.lang.Object pointInTimeRecoverySpecification;
        private final java.lang.Object provisionedThroughput;
        private final java.lang.Object sseSpecification;
        private final java.lang.Object streamSpecification;
        private final java.lang.String tableName;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Object timeToLiveSpecification;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.keySchema = this.jsiiGet("keySchema", java.lang.Object.class);
            this.attributeDefinitions = this.jsiiGet("attributeDefinitions", java.lang.Object.class);
            this.billingMode = this.jsiiGet("billingMode", java.lang.String.class);
            this.globalSecondaryIndexes = this.jsiiGet("globalSecondaryIndexes", java.lang.Object.class);
            this.localSecondaryIndexes = this.jsiiGet("localSecondaryIndexes", java.lang.Object.class);
            this.pointInTimeRecoverySpecification = this.jsiiGet("pointInTimeRecoverySpecification", java.lang.Object.class);
            this.provisionedThroughput = this.jsiiGet("provisionedThroughput", java.lang.Object.class);
            this.sseSpecification = this.jsiiGet("sseSpecification", java.lang.Object.class);
            this.streamSpecification = this.jsiiGet("streamSpecification", java.lang.Object.class);
            this.tableName = this.jsiiGet("tableName", java.lang.String.class);
            this.tags = this.jsiiGet("tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.timeToLiveSpecification = this.jsiiGet("timeToLiveSpecification", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Object keySchema, final java.lang.Object attributeDefinitions, final java.lang.String billingMode, final java.lang.Object globalSecondaryIndexes, final java.lang.Object localSecondaryIndexes, final java.lang.Object pointInTimeRecoverySpecification, final java.lang.Object provisionedThroughput, final java.lang.Object sseSpecification, final java.lang.Object streamSpecification, final java.lang.String tableName, final java.util.List<software.amazon.awscdk.core.CfnTag> tags, final java.lang.Object timeToLiveSpecification) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.keySchema = java.util.Objects.requireNonNull(keySchema, "keySchema is required");
            this.attributeDefinitions = attributeDefinitions;
            this.billingMode = billingMode;
            this.globalSecondaryIndexes = globalSecondaryIndexes;
            this.localSecondaryIndexes = localSecondaryIndexes;
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
            this.provisionedThroughput = provisionedThroughput;
            this.sseSpecification = sseSpecification;
            this.streamSpecification = streamSpecification;
            this.tableName = tableName;
            this.tags = tags;
            this.timeToLiveSpecification = timeToLiveSpecification;
        }

        @Override
        public java.lang.Object getKeySchema() {
            return this.keySchema;
        }

        @Override
        public java.lang.Object getAttributeDefinitions() {
            return this.attributeDefinitions;
        }

        @Override
        public java.lang.String getBillingMode() {
            return this.billingMode;
        }

        @Override
        public java.lang.Object getGlobalSecondaryIndexes() {
            return this.globalSecondaryIndexes;
        }

        @Override
        public java.lang.Object getLocalSecondaryIndexes() {
            return this.localSecondaryIndexes;
        }

        @Override
        public java.lang.Object getPointInTimeRecoverySpecification() {
            return this.pointInTimeRecoverySpecification;
        }

        @Override
        public java.lang.Object getProvisionedThroughput() {
            return this.provisionedThroughput;
        }

        @Override
        public java.lang.Object getSseSpecification() {
            return this.sseSpecification;
        }

        @Override
        public java.lang.Object getStreamSpecification() {
            return this.streamSpecification;
        }

        @Override
        public java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public java.lang.Object getTimeToLiveSpecification() {
            return this.timeToLiveSpecification;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("keySchema", om.valueToTree(this.getKeySchema()));
            if (this.getAttributeDefinitions() != null) {
                data.set("attributeDefinitions", om.valueToTree(this.getAttributeDefinitions()));
            }
            if (this.getBillingMode() != null) {
                data.set("billingMode", om.valueToTree(this.getBillingMode()));
            }
            if (this.getGlobalSecondaryIndexes() != null) {
                data.set("globalSecondaryIndexes", om.valueToTree(this.getGlobalSecondaryIndexes()));
            }
            if (this.getLocalSecondaryIndexes() != null) {
                data.set("localSecondaryIndexes", om.valueToTree(this.getLocalSecondaryIndexes()));
            }
            if (this.getPointInTimeRecoverySpecification() != null) {
                data.set("pointInTimeRecoverySpecification", om.valueToTree(this.getPointInTimeRecoverySpecification()));
            }
            if (this.getProvisionedThroughput() != null) {
                data.set("provisionedThroughput", om.valueToTree(this.getProvisionedThroughput()));
            }
            if (this.getSseSpecification() != null) {
                data.set("sseSpecification", om.valueToTree(this.getSseSpecification()));
            }
            if (this.getStreamSpecification() != null) {
                data.set("streamSpecification", om.valueToTree(this.getStreamSpecification()));
            }
            if (this.getTableName() != null) {
                data.set("tableName", om.valueToTree(this.getTableName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTimeToLiveSpecification() != null) {
                data.set("timeToLiveSpecification", om.valueToTree(this.getTimeToLiveSpecification()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-dynamodb.CfnTableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTableProps.Jsii$Proxy that = (CfnTableProps.Jsii$Proxy) o;

            if (!keySchema.equals(that.keySchema)) return false;
            if (this.attributeDefinitions != null ? !this.attributeDefinitions.equals(that.attributeDefinitions) : that.attributeDefinitions != null) return false;
            if (this.billingMode != null ? !this.billingMode.equals(that.billingMode) : that.billingMode != null) return false;
            if (this.globalSecondaryIndexes != null ? !this.globalSecondaryIndexes.equals(that.globalSecondaryIndexes) : that.globalSecondaryIndexes != null) return false;
            if (this.localSecondaryIndexes != null ? !this.localSecondaryIndexes.equals(that.localSecondaryIndexes) : that.localSecondaryIndexes != null) return false;
            if (this.pointInTimeRecoverySpecification != null ? !this.pointInTimeRecoverySpecification.equals(that.pointInTimeRecoverySpecification) : that.pointInTimeRecoverySpecification != null) return false;
            if (this.provisionedThroughput != null ? !this.provisionedThroughput.equals(that.provisionedThroughput) : that.provisionedThroughput != null) return false;
            if (this.sseSpecification != null ? !this.sseSpecification.equals(that.sseSpecification) : that.sseSpecification != null) return false;
            if (this.streamSpecification != null ? !this.streamSpecification.equals(that.streamSpecification) : that.streamSpecification != null) return false;
            if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.timeToLiveSpecification != null ? this.timeToLiveSpecification.equals(that.timeToLiveSpecification) : that.timeToLiveSpecification == null;
        }

        @Override
        public int hashCode() {
            int result = this.keySchema.hashCode();
            result = 31 * result + (this.attributeDefinitions != null ? this.attributeDefinitions.hashCode() : 0);
            result = 31 * result + (this.billingMode != null ? this.billingMode.hashCode() : 0);
            result = 31 * result + (this.globalSecondaryIndexes != null ? this.globalSecondaryIndexes.hashCode() : 0);
            result = 31 * result + (this.localSecondaryIndexes != null ? this.localSecondaryIndexes.hashCode() : 0);
            result = 31 * result + (this.pointInTimeRecoverySpecification != null ? this.pointInTimeRecoverySpecification.hashCode() : 0);
            result = 31 * result + (this.provisionedThroughput != null ? this.provisionedThroughput.hashCode() : 0);
            result = 31 * result + (this.sseSpecification != null ? this.sseSpecification.hashCode() : 0);
            result = 31 * result + (this.streamSpecification != null ? this.streamSpecification.hashCode() : 0);
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.timeToLiveSpecification != null ? this.timeToLiveSpecification.hashCode() : 0);
            return result;
        }
    }
}
