package software.amazon.awscdk.services.dynamodb;

/**
 * Properties for enabling DynamoDB capacity scaling.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:20:03.146Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EnableScalingProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Maximum capacity to scale to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getMaxCapacity();
    /**
     * Minimum capacity to scale to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getMinCapacity();

    /**
     * @return a {@link Builder} of {@link EnableScalingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link EnableScalingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.Number _maxCapacity;
        private java.lang.Number _minCapacity;

        /**
         * Sets the value of MaxCapacity
         * @param value Maximum capacity to scale to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withMaxCapacity(final java.lang.Number value) {
            this._maxCapacity = java.util.Objects.requireNonNull(value, "maxCapacity is required");
            return this;
        }
        /**
         * Sets the value of MinCapacity
         * @param value Minimum capacity to scale to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withMinCapacity(final java.lang.Number value) {
            this._minCapacity = java.util.Objects.requireNonNull(value, "minCapacity is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EnableScalingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public EnableScalingProps build() {
            return new EnableScalingProps() {
                private final java.lang.Number $maxCapacity = java.util.Objects.requireNonNull(_maxCapacity, "maxCapacity is required");
                private final java.lang.Number $minCapacity = java.util.Objects.requireNonNull(_minCapacity, "minCapacity is required");

                @Override
                public java.lang.Number getMaxCapacity() {
                    return this.$maxCapacity;
                }

                @Override
                public java.lang.Number getMinCapacity() {
                    return this.$minCapacity;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
                    obj.set("minCapacity", om.valueToTree(this.getMinCapacity()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.EnableScalingProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Maximum capacity to scale to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.Number getMaxCapacity() {
            return this.jsiiGet("maxCapacity", java.lang.Number.class);
        }

        /**
         * Minimum capacity to scale to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.Number getMinCapacity() {
            return this.jsiiGet("minCapacity", java.lang.Number.class);
        }
    }
}
