package software.amazon.awscdk.services.dynamodb;

/**
 * Properties for enabling DynamoDB utilization tracking.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:20:03.156Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UtilizationScalingProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.applicationautoscaling.BaseTargetTrackingProps {
    /**
     * Target utilization percentage for the attribute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getTargetUtilizationPercent();

    /**
     * @return a {@link Builder} of {@link UtilizationScalingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link UtilizationScalingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.Number _targetUtilizationPercent;
        @javax.annotation.Nullable
        private java.lang.Boolean _disableScaleIn;
        @javax.annotation.Nullable
        private java.lang.String _policyName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _scaleInCooldown;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _scaleOutCooldown;

        /**
         * Sets the value of TargetUtilizationPercent
         * @param value Target utilization percentage for the attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTargetUtilizationPercent(final java.lang.Number value) {
            this._targetUtilizationPercent = java.util.Objects.requireNonNull(value, "targetUtilizationPercent is required");
            return this;
        }
        /**
         * Sets the value of DisableScaleIn
         * @param value Indicates whether scale in by the target tracking policy is disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDisableScaleIn(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._disableScaleIn = value;
            return this;
        }
        /**
         * Sets the value of PolicyName
         * @param value A name for the scaling policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPolicyName(@javax.annotation.Nullable final java.lang.String value) {
            this._policyName = value;
            return this;
        }
        /**
         * Sets the value of ScaleInCooldown
         * @param value Period after a scale in activity completes before another scale in activity can start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withScaleInCooldown(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._scaleInCooldown = value;
            return this;
        }
        /**
         * Sets the value of ScaleOutCooldown
         * @param value Period after a scale out activity completes before another scale out activity can start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withScaleOutCooldown(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._scaleOutCooldown = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UtilizationScalingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public UtilizationScalingProps build() {
            return new UtilizationScalingProps() {
                private final java.lang.Number $targetUtilizationPercent = java.util.Objects.requireNonNull(_targetUtilizationPercent, "targetUtilizationPercent is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $disableScaleIn = _disableScaleIn;
                @javax.annotation.Nullable
                private final java.lang.String $policyName = _policyName;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $scaleInCooldown = _scaleInCooldown;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $scaleOutCooldown = _scaleOutCooldown;

                @Override
                public java.lang.Number getTargetUtilizationPercent() {
                    return this.$targetUtilizationPercent;
                }

                @Override
                public java.lang.Boolean getDisableScaleIn() {
                    return this.$disableScaleIn;
                }

                @Override
                public java.lang.String getPolicyName() {
                    return this.$policyName;
                }

                @Override
                public software.amazon.awscdk.core.Duration getScaleInCooldown() {
                    return this.$scaleInCooldown;
                }

                @Override
                public software.amazon.awscdk.core.Duration getScaleOutCooldown() {
                    return this.$scaleOutCooldown;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("targetUtilizationPercent", om.valueToTree(this.getTargetUtilizationPercent()));
                    if (this.getDisableScaleIn() != null) {
                        obj.set("disableScaleIn", om.valueToTree(this.getDisableScaleIn()));
                    }
                    if (this.getPolicyName() != null) {
                        obj.set("policyName", om.valueToTree(this.getPolicyName()));
                    }
                    if (this.getScaleInCooldown() != null) {
                        obj.set("scaleInCooldown", om.valueToTree(this.getScaleInCooldown()));
                    }
                    if (this.getScaleOutCooldown() != null) {
                        obj.set("scaleOutCooldown", om.valueToTree(this.getScaleOutCooldown()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.dynamodb.UtilizationScalingProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Target utilization percentage for the attribute.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.Number getTargetUtilizationPercent() {
            return this.jsiiGet("targetUtilizationPercent", java.lang.Number.class);
        }

        /**
         * Indicates whether scale in by the target tracking policy is disabled.
         * 
         * If the value is true, scale in is disabled and the target tracking policy
         * won't remove capacity from the scalable resource. Otherwise, scale in is
         * enabled and the target tracking policy can remove capacity from the
         * scalable resource.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getDisableScaleIn() {
            return this.jsiiGet("disableScaleIn", java.lang.Boolean.class);
        }

        /**
         * A name for the scaling policy.
         * 
         * Default: - Automatically generated name.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getPolicyName() {
            return this.jsiiGet("policyName", java.lang.String.class);
        }

        /**
         * Period after a scale in activity completes before another scale in activity can start.
         * 
         * Default: - No scale in cooldown.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getScaleInCooldown() {
            return this.jsiiGet("scaleInCooldown", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Period after a scale out activity completes before another scale out activity can start.
         * 
         * Default: - No scale out cooldown.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getScaleOutCooldown() {
            return this.jsiiGet("scaleOutCooldown", software.amazon.awscdk.core.Duration.class);
        }
    }
}
