package software.amazon.awscdk.services.dynamodb;

/**
 * Properties for enabling DynamoDB utilization tracking.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-07-01T08:46:46.920Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.dynamodb.$Module.class, fqn = "@aws-cdk/aws-dynamodb.UtilizationScalingProps")
@software.amazon.jsii.Jsii.Proxy(UtilizationScalingProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UtilizationScalingProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.applicationautoscaling.BaseTargetTrackingProps {

    /**
     * Target utilization percentage for the attribute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getTargetUtilizationPercent();

    /**
     * @return a {@link Builder} of {@link UtilizationScalingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UtilizationScalingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UtilizationScalingProps> {
        private java.lang.Number targetUtilizationPercent;
        private java.lang.Boolean disableScaleIn;
        private java.lang.String policyName;
        private software.amazon.awscdk.core.Duration scaleInCooldown;
        private software.amazon.awscdk.core.Duration scaleOutCooldown;

        /**
         * Sets the value of {@link UtilizationScalingProps#getTargetUtilizationPercent}
         * @param targetUtilizationPercent Target utilization percentage for the attribute. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetUtilizationPercent(java.lang.Number targetUtilizationPercent) {
            this.targetUtilizationPercent = targetUtilizationPercent;
            return this;
        }

        /**
         * Sets the value of {@link UtilizationScalingProps#getDisableScaleIn}
         * @param disableScaleIn Indicates whether scale in by the target tracking policy is disabled.
         *                       If the value is true, scale in is disabled and the target tracking policy
         *                       won't remove capacity from the scalable resource. Otherwise, scale in is
         *                       enabled and the target tracking policy can remove capacity from the
         *                       scalable resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableScaleIn(java.lang.Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        /**
         * Sets the value of {@link UtilizationScalingProps#getPolicyName}
         * @param policyName A name for the scaling policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(java.lang.String policyName) {
            this.policyName = policyName;
            return this;
        }

        /**
         * Sets the value of {@link UtilizationScalingProps#getScaleInCooldown}
         * @param scaleInCooldown Period after a scale in activity completes before another scale in activity can start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleInCooldown(software.amazon.awscdk.core.Duration scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
            return this;
        }

        /**
         * Sets the value of {@link UtilizationScalingProps#getScaleOutCooldown}
         * @param scaleOutCooldown Period after a scale out activity completes before another scale out activity can start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleOutCooldown(software.amazon.awscdk.core.Duration scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UtilizationScalingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UtilizationScalingProps build() {
            return new Jsii$Proxy(targetUtilizationPercent, disableScaleIn, policyName, scaleInCooldown, scaleOutCooldown);
        }
    }

    /**
     * An implementation for {@link UtilizationScalingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UtilizationScalingProps {
        private final java.lang.Number targetUtilizationPercent;
        private final java.lang.Boolean disableScaleIn;
        private final java.lang.String policyName;
        private final software.amazon.awscdk.core.Duration scaleInCooldown;
        private final software.amazon.awscdk.core.Duration scaleOutCooldown;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.targetUtilizationPercent = this.jsiiGet("targetUtilizationPercent", java.lang.Number.class);
            this.disableScaleIn = this.jsiiGet("disableScaleIn", java.lang.Boolean.class);
            this.policyName = this.jsiiGet("policyName", java.lang.String.class);
            this.scaleInCooldown = this.jsiiGet("scaleInCooldown", software.amazon.awscdk.core.Duration.class);
            this.scaleOutCooldown = this.jsiiGet("scaleOutCooldown", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number targetUtilizationPercent, final java.lang.Boolean disableScaleIn, final java.lang.String policyName, final software.amazon.awscdk.core.Duration scaleInCooldown, final software.amazon.awscdk.core.Duration scaleOutCooldown) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.targetUtilizationPercent = java.util.Objects.requireNonNull(targetUtilizationPercent, "targetUtilizationPercent is required");
            this.disableScaleIn = disableScaleIn;
            this.policyName = policyName;
            this.scaleInCooldown = scaleInCooldown;
            this.scaleOutCooldown = scaleOutCooldown;
        }

        @Override
        public java.lang.Number getTargetUtilizationPercent() {
            return this.targetUtilizationPercent;
        }

        @Override
        public java.lang.Boolean getDisableScaleIn() {
            return this.disableScaleIn;
        }

        @Override
        public java.lang.String getPolicyName() {
            return this.policyName;
        }

        @Override
        public software.amazon.awscdk.core.Duration getScaleInCooldown() {
            return this.scaleInCooldown;
        }

        @Override
        public software.amazon.awscdk.core.Duration getScaleOutCooldown() {
            return this.scaleOutCooldown;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("targetUtilizationPercent", om.valueToTree(this.getTargetUtilizationPercent()));
            if (this.getDisableScaleIn() != null) {
                data.set("disableScaleIn", om.valueToTree(this.getDisableScaleIn()));
            }
            if (this.getPolicyName() != null) {
                data.set("policyName", om.valueToTree(this.getPolicyName()));
            }
            if (this.getScaleInCooldown() != null) {
                data.set("scaleInCooldown", om.valueToTree(this.getScaleInCooldown()));
            }
            if (this.getScaleOutCooldown() != null) {
                data.set("scaleOutCooldown", om.valueToTree(this.getScaleOutCooldown()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-dynamodb.UtilizationScalingProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UtilizationScalingProps.Jsii$Proxy that = (UtilizationScalingProps.Jsii$Proxy) o;

            if (!targetUtilizationPercent.equals(that.targetUtilizationPercent)) return false;
            if (this.disableScaleIn != null ? !this.disableScaleIn.equals(that.disableScaleIn) : that.disableScaleIn != null) return false;
            if (this.policyName != null ? !this.policyName.equals(that.policyName) : that.policyName != null) return false;
            if (this.scaleInCooldown != null ? !this.scaleInCooldown.equals(that.scaleInCooldown) : that.scaleInCooldown != null) return false;
            return this.scaleOutCooldown != null ? this.scaleOutCooldown.equals(that.scaleOutCooldown) : that.scaleOutCooldown == null;
        }

        @Override
        public int hashCode() {
            int result = this.targetUtilizationPercent.hashCode();
            result = 31 * result + (this.disableScaleIn != null ? this.disableScaleIn.hashCode() : 0);
            result = 31 * result + (this.policyName != null ? this.policyName.hashCode() : 0);
            result = 31 * result + (this.scaleInCooldown != null ? this.scaleInCooldown.hashCode() : 0);
            result = 31 * result + (this.scaleOutCooldown != null ? this.scaleOutCooldown.hashCode() : 0);
            return result;
        }
    }
}
